//
// File: Cego.cc
// This code was produced by the dragon parser generator
//
#include "Cego.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

Cego::ScannerStateEntry::ScannerStateEntry()
{
}

Cego::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

Cego::ScannerStateEntry& Cego::ScannerStateEntry::operator = (const Cego::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool Cego::ScannerStateEntry::operator == (const Cego::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

Cego::ScannerStateType Cego::ScannerStateEntry::getType()
{
   return _type;
}
int Cego::ScannerStateEntry::getState()
{
   return _state;
}


Cego::ScannerTransEntry::ScannerTransEntry()
{
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

Cego::ScannerTransEntry& Cego::ScannerTransEntry::operator = (const Cego::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool Cego::ScannerTransEntry::operator == (const Cego::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int Cego::ScannerTransEntry::getFState()
{
   return _fstate;
}


Cego::Scanner::Scanner()
{
}


Cego::Scanner::Scanner(Token t)
{
   _token = t;
}

Cego::Token Cego::Scanner::getToken()
{
   return _token;
}

void Cego::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void Cego::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool Cego::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
Cego::StackEntry::StackEntry()
{
   _symbol = NONE;
}

Cego::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

Cego::StackEntry& Cego::StackEntry::operator = (const Cego::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int Cego::StackEntry::getState()
{
   return _state;
}
Cego::Symbol Cego::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& Cego::StackEntry::getTval()
{
   return _tval;
}

Cego::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

Cego::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool Cego::ActionEntry::operator == (const Cego::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

Cego::ActionEntry& Cego::ActionEntry::operator = (const Cego::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

Cego::Action Cego::ActionEntry::getAction()
{
   return _action;
}

int Cego::ActionEntry::getNum()
{
   return _num;
}

Cego::ProdEntry::ProdEntry()
{
}

Cego::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

Cego::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool Cego::ProdEntry::operator == (const Cego::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

Cego::ProdEntry& Cego::ProdEntry::operator = (const Cego::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int Cego::ProdEntry::getId()
{
   return _id;
}

Cego::Production Cego::ProdEntry::getProd()
{
   return _prod;
}

int Cego::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void Cego::loadScanner()
{
   Scanner s0(ADD);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s0);

   Scanner s1(AND);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ALL);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(ALTER);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s3);

   Scanner s4(APPEND);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s4);

   Scanner s5(AS);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,FINAL));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s5);

   Scanner s6(ASC);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s6);

   Scanner s7(AUTHORIZE);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(9 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s7.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s7.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s7.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s7);

   Scanner s8(AUTOCOMMIT);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(10 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s8.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s8.addTransition(ScannerTransEntry(7 ,'m' ,8));
   s8.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s8.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s8);

   Scanner s9(AVG);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s9);

   Scanner s10(BEGIN);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s10);

   Scanner s11(BETWEEN);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(7 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'w' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s11.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s11);

   Scanner s12(BIGINT);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s12);

   Scanner s13(BITAND);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s13);

   Scanner s14(BITOR);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s14);

   Scanner s15(BITXOR);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(6 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'x' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s15.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s15);

   Scanner s16(BLOB);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s16);

   Scanner s17(BOOL);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s17);

   Scanner s18(BTREE);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s18);

   Scanner s19(BY);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,FINAL));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s19.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s19);

   Scanner s20(CALL);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s20);

   Scanner s21(CASE);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s21);

   Scanner s22(CHECK);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s22);

   Scanner s23(CLOSE);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s23);

   Scanner s24(COMMIT);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(6 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s24.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s24.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s24);

   Scanner s25(COLUMN);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(6 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s25.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s25);

   Scanner s26(CONSTRAINT);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(10 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s26.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s26.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s26.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s26.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s26.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s26.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s26);

   Scanner s27(COUNT);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s27);

   Scanner s28(COUNTER);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(7 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s28.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s28);

   Scanner s29(CREATE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(6 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s29.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s29.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s29);

   Scanner s30(CURSOR);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(6 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s30.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s30);

   Scanner s31(DATE);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s31);

   Scanner s32(DATE2STR);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s32);

   Scanner s33(DATE2INT);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(8 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s33.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s33.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s33.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s33);

   Scanner s34(DATETIME);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s34);

   Scanner s35(DECIMAL);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(7 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s35.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s35.addTransition(ScannerTransEntry(6 ,'l' ,7));
   _scannerList.Insert(s35);

   Scanner s36(DEFAULT);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(7 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s36.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s36);

   Scanner s37(DELETETOK);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s37);

   Scanner s38(DESC);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s38);

   Scanner s39(DISTINCT);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s39);

   Scanner s40(DIV);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s40);

   Scanner s41(DOUBLE);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s41);

   Scanner s42(DROP);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s42);

   Scanner s43(ELSE);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s43);

   Scanner s44(ELSIF);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'f' ,5));
   _scannerList.Insert(s44);

   Scanner s45(END_TOKEN);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s45);

   Scanner s46(EXCEPTION);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(9 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'p' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s46.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s46.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s46.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s46);

   Scanner s47(EXISTS);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s47);

   Scanner s48(FALSEVAL);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s48);

   Scanner s49(FETCH);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'h' ,5));
   _scannerList.Insert(s49);

   Scanner s50(FIXED);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(5 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s50.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s50);

   Scanner s51(FLOAT);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s51);

   Scanner s52(FOR);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s52);

   Scanner s53(FOREIGN);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(7 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s53.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s53);

   Scanner s54(FROM);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s54);

   Scanner s55(GETPOS);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(6 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'p' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s55.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s55);

   Scanner s56(GROUP);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'p' ,5));
   _scannerList.Insert(s56);

   Scanner s57(HAVING);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(6 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s57.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s57.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s57);

   Scanner s58(IDENTIFIED);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(10 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s58.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s58.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s58);

   Scanner s59(IF);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,FINAL));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s59.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s59);

   Scanner s60(INTOK);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,FINAL));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s60.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s60);

   Scanner s61(INDEX);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'x' ,5));
   _scannerList.Insert(s61);

   Scanner s62(INNER);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s62);

   Scanner s63(INT);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s63);

   Scanner s64(INTO);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'o' ,4));
   _scannerList.Insert(s64);

   Scanner s65(INT2DATE);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(8 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s65.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s65);

   Scanner s66(INSERT);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(6 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s66.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s66.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s66);

   Scanner s67(IS);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,FINAL));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s67.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s67);

   Scanner s68(ISOLATION);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(9 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s68.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s68.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s68.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s68);

   Scanner s69(JDBC);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s69);

   Scanner s70(JOIN);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s70);

   Scanner s71(KEY);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'y' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'k' ,0));
   _scannerList.Insert(s71);

   Scanner s72(LEFT);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s72);

   Scanner s73(LENGTH);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(6 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s73.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s73);

   Scanner s74(LIKE);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'k' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s74);

   Scanner s75(LIST);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s75);

   Scanner s76(LOAD);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s76);

   Scanner s77(LOCKS);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(5 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s77.addTransition(ScannerTransEntry(4 ,'s' ,5));
   _scannerList.Insert(s77);

   Scanner s78(LONG);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'g' ,4));
   _scannerList.Insert(s78);

   Scanner s79(LOWER);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s79);

   Scanner s80(LTRIM);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s80);

   Scanner s81(MIN);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s81);

   Scanner s82(MAX);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s82);

   Scanner s83(MOD);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s83);

   Scanner s84(MODIFY);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s84);

   Scanner s85(NEXTCOUNT);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(9 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s85.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s85.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s85.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s85.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s85.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s85);

   Scanner s86(NOOP);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s86);

   Scanner s87(NOT);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'n' ,0));
   _scannerList.Insert(s87);

   Scanner s88(NULLTOKEN);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s88);

   Scanner s89(OFF);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s89);

   Scanner s90(ON);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,FINAL));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s90.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s90);

   Scanner s91(OUTTOK);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s91);

   Scanner s92(OUTER);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(5 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s92.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s92);

   Scanner s93(OR);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,FINAL));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s93.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s93);

   Scanner s94(ORDER);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(5 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s94.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s94);

   Scanner s95(PLAN);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s95);

   Scanner s96(POOL);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s96);

   Scanner s97(POWER);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s97);

   Scanner s98(PRIMARY);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(7 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s98.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s98.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s98);

   Scanner s99(PRINT);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s99);

   Scanner s100(PROCEDURE);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(9 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s100.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s100.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s100.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s100.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s100);

   Scanner s101(QUERYCACHE);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(10 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s101.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s101.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s101.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s101.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s101.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s101.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s101);

   Scanner s102(QUIT);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s102);

   Scanner s103(RANDSTR);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(7 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s103.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s103);

   Scanner s104(RANDINT);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(7 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s104.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s104);

   Scanner s105(RBSEG);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'g' ,5));
   _scannerList.Insert(s105);

   Scanner s106(REFERENCES);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(10 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s106.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s106.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s106.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s106.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s106.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s106.addTransition(ScannerTransEntry(9 ,'s' ,10));
   _scannerList.Insert(s106);

   Scanner s107(RENAME);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(6 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s107.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s107.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s107);

   Scanner s108(REORGANIZE);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(10 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s108.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s108.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s108.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s108.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s108.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s108.addTransition(ScannerTransEntry(8 ,'z' ,9));
   s108.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s108);

   Scanner s109(RETURNTOKEN);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(6 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s109.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s109.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s109.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s109);

   Scanner s110(REMOVE);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(6 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s110.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s110.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s110.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s110);

   Scanner s111(REPLACE);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(7 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s111.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s111.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s111.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s111.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s111.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s111.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s111);

   Scanner s112(RIGHT);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(5 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s112.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s112);

   Scanner s113(ROLLBACK);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(8 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s113.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s113.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s113.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s113.addTransition(ScannerTransEntry(7 ,'k' ,8));
   _scannerList.Insert(s113);

   Scanner s114(ROUND);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(5 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s114.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s114);

   Scanner s115(ROWLIMIT);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(8 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s115.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s115.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s115.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s115.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s115);

   Scanner s116(RTRIM);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(5 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s116.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s116);

   Scanner s117(SELECT);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(6 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s117.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s117.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s117);

   Scanner s118(SET);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s118);

   Scanner s119(SETCOUNT);
   s119.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(2 ,START));
   s119.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(8 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s119.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s119.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s119.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s119.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s119.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s119.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s119);

   Scanner s120(SHOW);
   s120.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(2 ,START));
   s120.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(4 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s120.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s120.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s120);

   Scanner s121(SMALLINT);
   s121.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(2 ,START));
   s121.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(8 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s121.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s121.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s121.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s121.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s121.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s121.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s121.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s121);

   Scanner s122(START_TOKEN);
   s122.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(2 ,START));
   s122.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(5 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s122.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s122.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s122.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s122);

   Scanner s123(STRING);
   s123.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(2 ,START));
   s123.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(6 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s123.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s123.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s123.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s123.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s123);

   Scanner s124(SUBSTR);
   s124.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(2 ,START));
   s124.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(6 ,FINAL));
   s124.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s124.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s124.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s124.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s124.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s124.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s124);

   Scanner s125(SUM);
   s125.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(2 ,START));
   s125.addState(ScannerStateEntry(3 ,FINAL));
   s125.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s125.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s125.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s125);

   Scanner s126(SYNC);
   s126.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(2 ,START));
   s126.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(4 ,FINAL));
   s126.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s126.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s126.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s126.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s126);

   Scanner s127(SYSDATE);
   s127.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(2 ,START));
   s127.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(7 ,FINAL));
   s127.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s127.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s127.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s127.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s127.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s127.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s127.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s127);

   Scanner s128(SYSTEMSPACE);
   s128.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(2 ,START));
   s128.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(11 ,FINAL));
   s128.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s128.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s128.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s128.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s128.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s128.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s128.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s128.addTransition(ScannerTransEntry(7 ,'p' ,8));
   s128.addTransition(ScannerTransEntry(8 ,'a' ,9));
   s128.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s128.addTransition(ScannerTransEntry(10 ,'e' ,11));
   _scannerList.Insert(s128);

   Scanner s129(SYSOBJ);
   s129.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(2 ,START));
   s129.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(6 ,FINAL));
   s129.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s129.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s129.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s129.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s129.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s129.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s129);

   Scanner s130(TABLEINFO);
   s130.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(2 ,START));
   s130.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(9 ,FINAL));
   s130.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s130.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s130.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s130.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s130.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s130.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s130.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s130.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s130.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s130);

   Scanner s131(TABLE);
   s131.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(2 ,START));
   s131.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(5 ,FINAL));
   s131.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s131.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s131.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s131.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s131.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s131);

   Scanner s132(TABLESET);
   s132.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(2 ,START));
   s132.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(8 ,FINAL));
   s132.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s132.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s132.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s132.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s132.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s132.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s132.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s132.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s132);

   Scanner s133(THEN);
   s133.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(2 ,START));
   s133.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(4 ,FINAL));
   s133.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s133.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s133.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s133.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s133);

   Scanner s134(TINYINT);
   s134.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(2 ,START));
   s134.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(7 ,FINAL));
   s134.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s134.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s134.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s134.addTransition(ScannerTransEntry(3 ,'y' ,4));
   s134.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s134.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s134.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s134);

   Scanner s135(TMPOBJ);
   s135.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(2 ,START));
   s135.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(6 ,FINAL));
   s135.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s135.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s135.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s135.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s135.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s135.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s135);

   Scanner s136(TRANSACTION);
   s136.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(2 ,START));
   s136.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(11 ,FINAL));
   s136.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s136.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s136.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s136.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s136.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s136.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s136.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s136.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s136.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s136.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s136.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s136);

   Scanner s137(STR2INT);
   s137.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(2 ,START));
   s137.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(7 ,FINAL));
   s137.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s137.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s137.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s137.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s137.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s137.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s137.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s137);

   Scanner s138(STR2LONG);
   s138.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(2 ,START));
   s138.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(8 ,FINAL));
   s138.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s138.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s138.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s138.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s138.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s138.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s138.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s138.addTransition(ScannerTransEntry(7 ,'g' ,8));
   _scannerList.Insert(s138);

   Scanner s139(STR2DATE);
   s139.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(2 ,START));
   s139.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(8 ,FINAL));
   s139.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s139.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s139.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s139.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s139.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s139.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s139.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s139.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s139);

   Scanner s140(TO);
   s140.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(1 ,FINAL));
   s140.addState(ScannerStateEntry(2 ,START));
   s140.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s140.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s140);

   Scanner s141(TRIM);
   s141.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(2 ,START));
   s141.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(4 ,FINAL));
   s141.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s141.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s141.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s141.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s141);

   Scanner s142(TRUEVAL);
   s142.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(2 ,START));
   s142.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(4 ,FINAL));
   s142.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s142.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s142.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s142.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s142);

   Scanner s143(TRUNC);
   s143.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(2 ,START));
   s143.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(5 ,FINAL));
   s143.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s143.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s143.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s143.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s143.addTransition(ScannerTransEntry(4 ,'c' ,5));
   _scannerList.Insert(s143);

   Scanner s144(UNION);
   s144.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(2 ,START));
   s144.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(5 ,FINAL));
   s144.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s144.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s144.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s144.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s144.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s144);

   Scanner s145(UNIQUE);
   s145.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(2 ,START));
   s145.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(6 ,FINAL));
   s145.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s145.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s145.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s145.addTransition(ScannerTransEntry(3 ,'q' ,4));
   s145.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s145.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s145);

   Scanner s146(UPDATE);
   s146.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(2 ,START));
   s146.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(6 ,FINAL));
   s146.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s146.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s146.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s146.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s146.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s146.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s146);

   Scanner s147(UPPER);
   s147.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(2 ,START));
   s147.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(5 ,FINAL));
   s147.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s147.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s147.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s147.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s147.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s147);

   Scanner s148(VAR);
   s148.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(2 ,START));
   s148.addState(ScannerStateEntry(3 ,FINAL));
   s148.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s148.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s148.addTransition(ScannerTransEntry(2 ,'v' ,0));
   _scannerList.Insert(s148);

   Scanner s149(VALUES);
   s149.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(2 ,START));
   s149.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(6 ,FINAL));
   s149.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s149.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s149.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s149.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s149.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s149.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s149);

   Scanner s150(VIEW);
   s150.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(2 ,START));
   s150.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(4 ,FINAL));
   s150.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s150.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s150.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s150.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s150);

   Scanner s151(WHEN);
   s151.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(2 ,START));
   s151.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(4 ,FINAL));
   s151.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s151.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s151.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s151.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s151);

   Scanner s152(WHERE);
   s152.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(2 ,START));
   s152.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(5 ,FINAL));
   s152.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s152.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s152.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s152.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s152.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s152);

   Scanner s153(WHILE);
   s153.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(2 ,START));
   s153.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(5 ,FINAL));
   s153.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s153.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s153.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s153.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s153.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s153);

   Scanner s154(CONCAT);
   s154.addState(ScannerStateEntry(0 ,START));
   s154.addState(ScannerStateEntry(1 ,FINAL));
   s154.addTransition(ScannerTransEntry(0 ,'|' ,1));
   _scannerList.Insert(s154);

   Scanner s155(EQU);
   s155.addState(ScannerStateEntry(0 ,START));
   s155.addState(ScannerStateEntry(1 ,FINAL));
   s155.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s155);

   Scanner s156(KSEP);
   s156.addState(ScannerStateEntry(0 ,START));
   s156.addState(ScannerStateEntry(1 ,FINAL));
   s156.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s156);

   Scanner s157(LB);
   s157.addState(ScannerStateEntry(0 ,START));
   s157.addState(ScannerStateEntry(1 ,FINAL));
   s157.addTransition(ScannerTransEntry(0 ,'(' ,1));
   _scannerList.Insert(s157);

   Scanner s158(LT);
   s158.addState(ScannerStateEntry(0 ,START));
   s158.addState(ScannerStateEntry(1 ,FINAL));
   s158.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s158);

   Scanner s159(MT);
   s159.addState(ScannerStateEntry(0 ,START));
   s159.addState(ScannerStateEntry(1 ,FINAL));
   s159.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s159);

   Scanner s160(NEGATION);
   s160.addState(ScannerStateEntry(0 ,START));
   s160.addState(ScannerStateEntry(1 ,FINAL));
   s160.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s160);

   Scanner s161(RB);
   s161.addState(ScannerStateEntry(0 ,START));
   s161.addState(ScannerStateEntry(1 ,FINAL));
   s161.addTransition(ScannerTransEntry(0 ,')' ,1));
   _scannerList.Insert(s161);

   Scanner s162(LAB);
   s162.addState(ScannerStateEntry(0 ,START));
   s162.addState(ScannerStateEntry(1 ,FINAL));
   s162.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s162);

   Scanner s163(RAB);
   s163.addState(ScannerStateEntry(0 ,START));
   s163.addState(ScannerStateEntry(1 ,FINAL));
   s163.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s163);

   Scanner s164(SEMICOLON);
   s164.addState(ScannerStateEntry(0 ,START));
   s164.addState(ScannerStateEntry(1 ,FINAL));
   s164.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s164);

   Scanner s165(STAR);
   s165.addState(ScannerStateEntry(0 ,START));
   s165.addState(ScannerStateEntry(1 ,FINAL));
   s165.addTransition(ScannerTransEntry(0 ,'*' ,1));
   _scannerList.Insert(s165);

   Scanner s166(DIVISION);
   s166.addState(ScannerStateEntry(0 ,START));
   s166.addState(ScannerStateEntry(1 ,FINAL));
   s166.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s166);

   Scanner s167(MINUS);
   s167.addState(ScannerStateEntry(0 ,START));
   s167.addState(ScannerStateEntry(1 ,FINAL));
   s167.addTransition(ScannerTransEntry(0 ,'-' ,1));
   _scannerList.Insert(s167);

   Scanner s168(PLUS);
   s168.addState(ScannerStateEntry(0 ,START));
   s168.addState(ScannerStateEntry(1 ,FINAL));
   s168.addTransition(ScannerTransEntry(0 ,'+' ,1));
   _scannerList.Insert(s168);

   Scanner s169(INTVAL);
   s169.addState(ScannerStateEntry(0 ,START));
   s169.addState(ScannerStateEntry(1 ,FINAL));
   s169.addState(ScannerStateEntry(2 ,FINAL));
   s169.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s169.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s169);

   Scanner s170(FLOATVAL);
   s170.addState(ScannerStateEntry(0 ,START));
   s170.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(3 ,FINAL));
   s170.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s170.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'.' ,3));
   s170.addTransition(ScannerTransEntry(2 ,'.' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s170.addTransition(ScannerTransEntry(3 ,'9' ,3));
   _scannerList.Insert(s170);

   Scanner s171(IDENTIFIER);
   s171.addState(ScannerStateEntry(0 ,START));
   s171.addState(ScannerStateEntry(1 ,FINAL));
   s171.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s171);

   Scanner s172(VARREF);
   s172.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(1 ,FINAL));
   s172.addState(ScannerStateEntry(2 ,START));
   s172.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s172.addTransition(ScannerTransEntry(2 ,':' ,0));
   _scannerList.Insert(s172);

   Scanner s173(QUALIFIEDOBJ);
   s173.addState(ScannerStateEntry(0 ,START));
   s173.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(3 ,FINAL));
   s173.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'.' ,2));
   s173.addTransition(ScannerTransEntry(2 ,'$' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s173.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s173);

   Scanner s174(QUALIFIEDPRE);
   s174.addState(ScannerStateEntry(0 ,START));
   s174.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(2 ,FINAL));
   s174.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'.' ,2));
   _scannerList.Insert(s174);

   Scanner s175(QUALIFIEDTS);
   s175.addState(ScannerStateEntry(0 ,START));
   s175.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(3 ,FINAL));
   s175.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'@' ,2));
   s175.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s175.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s175);

}
void Cego::loadParser0()
{
   _actionMap[830][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[829][RB] = ActionEntry(SHIFT, 830);
   _actionMap[828][IDENTIFIER] = ActionEntry(SHIFT, 712);
   _jumpMap[828][SimpleAttr] = 711;
   _jumpMap[828][SimpleAttrList] = 829;
   _actionMap[825][LB] = ActionEntry(SHIFT, 828);
   _actionMap[826][ROWLIMIT] = ActionEntry(REDUCE, 236);
   _actionMap[826][UNION] = ActionEntry(REDUCE, 236);
   _actionMap[826][ENDTOKEN] = ActionEntry(REDUCE, 236);
   _actionMap[826][RB] = ActionEntry(REDUCE, 236);
   _actionMap[826][SEMICOLON] = ActionEntry(REDUCE, 236);
   _actionMap[826][KSEP] = ActionEntry(REDUCE, 236);
   _actionMap[827][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[827][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[827][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[827][ORDER] = ActionEntry(REDUCE, 230);
   _actionMap[827][ROWLIMIT] = ActionEntry(REDUCE, 230);
   _actionMap[827][UNION] = ActionEntry(REDUCE, 230);
   _actionMap[827][ENDTOKEN] = ActionEntry(REDUCE, 230);
   _actionMap[827][RB] = ActionEntry(REDUCE, 230);
   _actionMap[827][SEMICOLON] = ActionEntry(REDUCE, 230);
   _actionMap[821][IDENTIFIER] = ActionEntry(SHIFT, 825);
   _actionMap[822][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[822][RB] = ActionEntry(REDUCE, 79);
   _actionMap[823][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[823][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[823][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[823][ASC] = ActionEntry(SHIFT, 814);
   _actionMap[823][ROWLIMIT] = ActionEntry(REDUCE, 241);
   _actionMap[823][DESC] = ActionEntry(SHIFT, 815);
   _actionMap[823][UNION] = ActionEntry(REDUCE, 241);
   _actionMap[823][ENDTOKEN] = ActionEntry(REDUCE, 241);
   _actionMap[823][RB] = ActionEntry(REDUCE, 241);
   _actionMap[823][SEMICOLON] = ActionEntry(REDUCE, 241);
   _actionMap[823][KSEP] = ActionEntry(REDUCE, 241);
   _jumpMap[823][DefaultOrderOpt] = 813;
   _jumpMap[823][OrderingOpt] = 826;
   _actionMap[824][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[824][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[824][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[824][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[824][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[824][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[824][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[824][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[824][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[824][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[824][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[824][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[824][LEFT] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser1()
{
   _actionMap[824][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[824][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[824][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[824][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[824][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[824][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[824][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[824][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[824][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[824][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[824][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[824][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[824][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[824][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[824][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[824][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[824][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[824][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[824][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[824][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[824][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[824][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[824][LB] = ActionEntry(SHIFT, 142);
   _actionMap[824][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[824][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[824][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[824][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[824][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[824][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[824][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[824][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[824][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[824][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[824][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[824][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[824][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[824][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[824][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[824][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[824][ObjSpec] = 99;
   _jumpMap[824][Constant] = 98;
   _jumpMap[824][SignedFloat] = 97;
   _jumpMap[824][SignedInt] = 96;
   _jumpMap[824][Attribute] = 95;
   _jumpMap[824][Function] = 94;
   _jumpMap[824][CasePrepare] = 93;
   _jumpMap[824][CaseClause] = 92;
   _jumpMap[824][Factor] = 91;
   _jumpMap[824][Term] = 90;
   _jumpMap[824][Expr] = 827;
}
void Cego::loadParser2()
{
   _actionMap[809][REFERENCES] = ActionEntry(SHIFT, 821);
   _actionMap[810][ELSE] = ActionEntry(REDUCE, 115);
   _actionMap[810][ELSIF] = ActionEntry(REDUCE, 115);
   _actionMap[810][EXCEPTION] = ActionEntry(REDUCE, 115);
   _actionMap[810][END_TOKEN] = ActionEntry(REDUCE, 115);
   _actionMap[810][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[810][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[810][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[810][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[810][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[810][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[810][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[810][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[810][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[810][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[810][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[810][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[810][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[810][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[810][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[810][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[810][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[810][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[810][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[810][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[810][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[810][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[810][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[810][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[810][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[810][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[810][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[810][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[810][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[810][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[810][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[810][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[810][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[810][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[810][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[810][LB] = ActionEntry(SHIFT, 142);
   _actionMap[810][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[810][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[810][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[810][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[810][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[810][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[810][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[810][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[810][CASE] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser3()
{
   _actionMap[810][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[810][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[810][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[810][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[810][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[810][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[810][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[810][IF] = ActionEntry(SHIFT, 338);
   _actionMap[810][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[810][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[810][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[810][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[810][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[810][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[810][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[810][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[810][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[810][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[810][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[810][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[810][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[810][ObjSpec] = 99;
   _jumpMap[810][Constant] = 98;
   _jumpMap[810][SignedFloat] = 97;
   _jumpMap[810][SignedInt] = 96;
   _jumpMap[810][Attribute] = 95;
   _jumpMap[810][Function] = 94;
   _jumpMap[810][DeleteStatement] = 334;
   _jumpMap[810][UpdateStatement] = 333;
   _jumpMap[810][InsertStatement] = 332;
   _jumpMap[810][RollbackStatement] = 331;
   _jumpMap[810][CommitStatement] = 330;
   _jumpMap[810][StartStatement] = 329;
   _jumpMap[810][CasePrepare] = 93;
   _jumpMap[810][CaseClause] = 92;
   _jumpMap[810][Factor] = 91;
   _jumpMap[810][Term] = 90;
   _jumpMap[810][Expr] = 328;
   _jumpMap[810][ProcStatement] = 458;
   _jumpMap[810][ProcIfPart] = 326;
   _jumpMap[810][ProcBlockStart] = 325;
   _actionMap[811][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[811][SelectStatement] = 822;
   _actionMap[812][ROWLIMIT] = ActionEntry(REDUCE, 237);
   _actionMap[812][UNION] = ActionEntry(REDUCE, 237);
   _actionMap[812][ENDTOKEN] = ActionEntry(REDUCE, 237);
   _actionMap[812][RB] = ActionEntry(REDUCE, 237);
   _actionMap[812][SEMICOLON] = ActionEntry(REDUCE, 237);
   _actionMap[812][KSEP] = ActionEntry(REDUCE, 237);
   _actionMap[813][ROWLIMIT] = ActionEntry(REDUCE, 238);
}
void Cego::loadParser4()
{
   _actionMap[813][UNION] = ActionEntry(REDUCE, 238);
   _actionMap[813][ENDTOKEN] = ActionEntry(REDUCE, 238);
   _actionMap[813][RB] = ActionEntry(REDUCE, 238);
   _actionMap[813][SEMICOLON] = ActionEntry(REDUCE, 238);
   _actionMap[813][KSEP] = ActionEntry(REDUCE, 238);
   _actionMap[814][ROWLIMIT] = ActionEntry(REDUCE, 240);
   _actionMap[814][UNION] = ActionEntry(REDUCE, 240);
   _actionMap[814][ENDTOKEN] = ActionEntry(REDUCE, 240);
   _actionMap[814][RB] = ActionEntry(REDUCE, 240);
   _actionMap[814][SEMICOLON] = ActionEntry(REDUCE, 240);
   _actionMap[814][KSEP] = ActionEntry(REDUCE, 240);
   _actionMap[815][ROWLIMIT] = ActionEntry(REDUCE, 239);
   _actionMap[815][UNION] = ActionEntry(REDUCE, 239);
   _actionMap[815][ENDTOKEN] = ActionEntry(REDUCE, 239);
   _actionMap[815][RB] = ActionEntry(REDUCE, 239);
   _actionMap[815][SEMICOLON] = ActionEntry(REDUCE, 239);
   _actionMap[815][KSEP] = ActionEntry(REDUCE, 239);
   _actionMap[816][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[816][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[816][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[816][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[816][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[816][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[816][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[816][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[816][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[816][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[816][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[816][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[816][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[816][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[816][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[816][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[816][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[816][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[816][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[816][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[816][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[816][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[816][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[816][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[816][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[816][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[816][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[816][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[816][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[816][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[816][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[816][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[816][IDENTIFIER] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser5()
{
   _actionMap[816][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[816][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[816][LB] = ActionEntry(SHIFT, 142);
   _actionMap[816][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[816][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[816][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[816][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[816][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[816][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[816][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[816][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[816][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[816][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[816][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[816][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[816][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[816][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[816][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[816][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[816][ObjSpec] = 99;
   _jumpMap[816][Constant] = 98;
   _jumpMap[816][SignedFloat] = 97;
   _jumpMap[816][SignedInt] = 96;
   _jumpMap[816][Attribute] = 95;
   _jumpMap[816][Function] = 94;
   _jumpMap[816][CasePrepare] = 93;
   _jumpMap[816][CaseClause] = 92;
   _jumpMap[816][Factor] = 91;
   _jumpMap[816][Term] = 90;
   _jumpMap[816][Expr] = 823;
   _actionMap[817][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[817][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[817][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[817][EQU] = ActionEntry(SHIFT, 503);
   _actionMap[817][NEGATION] = ActionEntry(SHIFT, 506);
   _actionMap[817][LT] = ActionEntry(SHIFT, 504);
   _actionMap[817][MT] = ActionEntry(SHIFT, 505);
   _jumpMap[817][Comparison] = 824;
   _actionMap[818][KSEP] = ActionEntry(REDUCE, 228);
   _actionMap[818][HAVING] = ActionEntry(REDUCE, 228);
   _actionMap[818][ORDER] = ActionEntry(REDUCE, 228);
   _actionMap[818][ROWLIMIT] = ActionEntry(REDUCE, 228);
   _actionMap[818][UNION] = ActionEntry(REDUCE, 228);
   _actionMap[818][ENDTOKEN] = ActionEntry(REDUCE, 228);
   _actionMap[818][RB] = ActionEntry(REDUCE, 228);
   _actionMap[818][SEMICOLON] = ActionEntry(REDUCE, 228);
   _actionMap[819][AND] = ActionEntry(SHIFT, 507);
   _actionMap[819][OR] = ActionEntry(SHIFT, 508);
   _actionMap[819][LEFT] = ActionEntry(REDUCE, 213);
   _actionMap[819][RIGHT] = ActionEntry(REDUCE, 213);
}
void Cego::loadParser6()
{
   _actionMap[819][INNER] = ActionEntry(REDUCE, 213);
   _actionMap[819][JOIN] = ActionEntry(REDUCE, 213);
   _actionMap[819][RETURNTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[819][SEMICOLON] = ActionEntry(REDUCE, 213);
   _actionMap[819][RB] = ActionEntry(REDUCE, 213);
   _actionMap[819][ENDTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[819][UNION] = ActionEntry(REDUCE, 213);
   _actionMap[819][ROWLIMIT] = ActionEntry(REDUCE, 213);
   _actionMap[819][ORDER] = ActionEntry(REDUCE, 213);
   _actionMap[819][GROUP] = ActionEntry(REDUCE, 213);
   _actionMap[819][WHERE] = ActionEntry(REDUCE, 213);
   _actionMap[820][AND] = ActionEntry(SHIFT, 507);
   _actionMap[820][OR] = ActionEntry(SHIFT, 508);
   _actionMap[820][LEFT] = ActionEntry(REDUCE, 214);
   _actionMap[820][RIGHT] = ActionEntry(REDUCE, 214);
   _actionMap[820][INNER] = ActionEntry(REDUCE, 214);
   _actionMap[820][JOIN] = ActionEntry(REDUCE, 214);
   _actionMap[820][RETURNTOKEN] = ActionEntry(REDUCE, 214);
   _actionMap[820][SEMICOLON] = ActionEntry(REDUCE, 214);
   _actionMap[820][RB] = ActionEntry(REDUCE, 214);
   _actionMap[820][ENDTOKEN] = ActionEntry(REDUCE, 214);
   _actionMap[820][UNION] = ActionEntry(REDUCE, 214);
   _actionMap[820][ROWLIMIT] = ActionEntry(REDUCE, 214);
   _actionMap[820][ORDER] = ActionEntry(REDUCE, 214);
   _actionMap[820][GROUP] = ActionEntry(REDUCE, 214);
   _actionMap[820][WHERE] = ActionEntry(REDUCE, 214);
   _actionMap[786][RB] = ActionEntry(SHIFT, 809);
   _actionMap[787][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[787][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[787][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[787][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[787][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[787][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[787][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[787][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[787][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[787][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[787][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[787][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[787][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[787][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[787][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[787][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[787][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[787][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[787][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[787][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[787][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[787][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[787][RANDSTR] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser7()
{
   _actionMap[787][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[787][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[787][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[787][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[787][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[787][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[787][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[787][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[787][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[787][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[787][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[787][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[787][LB] = ActionEntry(SHIFT, 142);
   _actionMap[787][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[787][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[787][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[787][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[787][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[787][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[787][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[787][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[787][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[787][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[787][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[787][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[787][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[787][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[787][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[787][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[787][IF] = ActionEntry(SHIFT, 338);
   _actionMap[787][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[787][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[787][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[787][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[787][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[787][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[787][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[787][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[787][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[787][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[787][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[787][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[787][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[787][ObjSpec] = 99;
   _jumpMap[787][Constant] = 98;
   _jumpMap[787][SignedFloat] = 97;
   _jumpMap[787][SignedInt] = 96;
   _jumpMap[787][Attribute] = 95;
   _jumpMap[787][Function] = 94;
   _jumpMap[787][DeleteStatement] = 334;
}
void Cego::loadParser8()
{
   _jumpMap[787][UpdateStatement] = 333;
   _jumpMap[787][InsertStatement] = 332;
   _jumpMap[787][RollbackStatement] = 331;
   _jumpMap[787][CommitStatement] = 330;
   _jumpMap[787][StartStatement] = 329;
   _jumpMap[787][CasePrepare] = 93;
   _jumpMap[787][CaseClause] = 92;
   _jumpMap[787][Factor] = 91;
   _jumpMap[787][Term] = 90;
   _jumpMap[787][Expr] = 328;
   _jumpMap[787][ProcStatement] = 327;
   _jumpMap[787][ProcIfPart] = 326;
   _jumpMap[787][ProcBlockStart] = 325;
   _jumpMap[787][ProcStatementList] = 810;
   _actionMap[788][BEGIN] = ActionEntry(REDUCE, 327);
   _actionMap[788][DEFAULT] = ActionEntry(REDUCE, 327);
   _actionMap[788][NULLTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[788][NOT] = ActionEntry(REDUCE, 327);
   _actionMap[788][KSEP] = ActionEntry(REDUCE, 327);
   _actionMap[788][RB] = ActionEntry(REDUCE, 327);
   _actionMap[788][EQU] = ActionEntry(REDUCE, 327);
   _actionMap[788][SEMICOLON] = ActionEntry(REDUCE, 327);
   _actionMap[789][BEGIN] = ActionEntry(REDUCE, 332);
   _actionMap[789][DEFAULT] = ActionEntry(REDUCE, 332);
   _actionMap[789][NULLTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[789][NOT] = ActionEntry(REDUCE, 332);
   _actionMap[789][KSEP] = ActionEntry(REDUCE, 332);
   _actionMap[789][RB] = ActionEntry(REDUCE, 332);
   _actionMap[789][EQU] = ActionEntry(REDUCE, 332);
   _actionMap[789][SEMICOLON] = ActionEntry(REDUCE, 332);
   _actionMap[790][BEGIN] = ActionEntry(REDUCE, 333);
   _actionMap[790][DEFAULT] = ActionEntry(REDUCE, 333);
   _actionMap[790][NULLTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[790][NOT] = ActionEntry(REDUCE, 333);
   _actionMap[790][KSEP] = ActionEntry(REDUCE, 333);
   _actionMap[790][RB] = ActionEntry(REDUCE, 333);
   _actionMap[790][EQU] = ActionEntry(REDUCE, 333);
   _actionMap[790][SEMICOLON] = ActionEntry(REDUCE, 333);
   _actionMap[791][BEGIN] = ActionEntry(REDUCE, 324);
   _actionMap[791][DEFAULT] = ActionEntry(REDUCE, 324);
   _actionMap[791][NULLTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[791][NOT] = ActionEntry(REDUCE, 324);
   _actionMap[791][KSEP] = ActionEntry(REDUCE, 324);
   _actionMap[791][RB] = ActionEntry(REDUCE, 324);
   _actionMap[791][EQU] = ActionEntry(REDUCE, 324);
   _actionMap[791][SEMICOLON] = ActionEntry(REDUCE, 324);
   _actionMap[792][SEMICOLON] = ActionEntry(REDUCE, 57);
   _actionMap[793][RB] = ActionEntry(REDUCE, 180);
   _actionMap[794][SEMICOLON] = ActionEntry(REDUCE, 174);
   _actionMap[794][KSEP] = ActionEntry(REDUCE, 174);
}
void Cego::loadParser9()
{
   _actionMap[794][RB] = ActionEntry(REDUCE, 174);
   _actionMap[795][LEFT] = ActionEntry(REDUCE, 313);
   _actionMap[795][RIGHT] = ActionEntry(REDUCE, 313);
   _actionMap[795][INNER] = ActionEntry(REDUCE, 313);
   _actionMap[795][JOIN] = ActionEntry(REDUCE, 313);
   _actionMap[795][RETURNTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[795][SEMICOLON] = ActionEntry(REDUCE, 313);
   _actionMap[795][ENDTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[795][UNION] = ActionEntry(REDUCE, 313);
   _actionMap[795][ROWLIMIT] = ActionEntry(REDUCE, 313);
   _actionMap[795][ORDER] = ActionEntry(REDUCE, 313);
   _actionMap[795][GROUP] = ActionEntry(REDUCE, 313);
   _actionMap[795][WHERE] = ActionEntry(REDUCE, 313);
   _actionMap[795][THEN] = ActionEntry(REDUCE, 313);
   _actionMap[795][AND] = ActionEntry(REDUCE, 313);
   _actionMap[795][OR] = ActionEntry(REDUCE, 313);
   _actionMap[795][RB] = ActionEntry(REDUCE, 313);
   _actionMap[796][SEMICOLON] = ActionEntry(REDUCE, 202);
   _actionMap[796][RB] = ActionEntry(REDUCE, 202);
   _actionMap[797][ALL] = ActionEntry(SHIFT, 811);
   _actionMap[798][UNION] = ActionEntry(REDUCE, 244);
   _actionMap[798][ENDTOKEN] = ActionEntry(REDUCE, 244);
   _actionMap[798][RB] = ActionEntry(REDUCE, 244);
   _actionMap[798][SEMICOLON] = ActionEntry(REDUCE, 244);
   _actionMap[799][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[799][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[799][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[799][ASC] = ActionEntry(SHIFT, 814);
   _actionMap[799][ROWLIMIT] = ActionEntry(REDUCE, 241);
   _actionMap[799][DESC] = ActionEntry(SHIFT, 815);
   _actionMap[799][UNION] = ActionEntry(REDUCE, 241);
   _actionMap[799][ENDTOKEN] = ActionEntry(REDUCE, 241);
   _actionMap[799][RB] = ActionEntry(REDUCE, 241);
   _actionMap[799][SEMICOLON] = ActionEntry(REDUCE, 241);
   _actionMap[799][KSEP] = ActionEntry(REDUCE, 241);
   _jumpMap[799][DefaultOrderOpt] = 813;
   _jumpMap[799][OrderingOpt] = 812;
   _actionMap[800][KSEP] = ActionEntry(SHIFT, 816);
   _actionMap[800][ROWLIMIT] = ActionEntry(REDUCE, 233);
   _actionMap[800][UNION] = ActionEntry(REDUCE, 233);
   _actionMap[800][ENDTOKEN] = ActionEntry(REDUCE, 233);
   _actionMap[800][RB] = ActionEntry(REDUCE, 233);
   _actionMap[800][SEMICOLON] = ActionEntry(REDUCE, 233);
   _actionMap[801][ORDER] = ActionEntry(REDUCE, 225);
   _actionMap[801][ROWLIMIT] = ActionEntry(REDUCE, 225);
   _actionMap[801][UNION] = ActionEntry(REDUCE, 225);
   _actionMap[801][ENDTOKEN] = ActionEntry(REDUCE, 225);
   _actionMap[801][RB] = ActionEntry(REDUCE, 225);
   _actionMap[801][SEMICOLON] = ActionEntry(REDUCE, 225);
   _actionMap[802][ORDER] = ActionEntry(REDUCE, 231);
}
void Cego::loadParser10()
{
   _actionMap[802][ROWLIMIT] = ActionEntry(REDUCE, 231);
   _actionMap[802][UNION] = ActionEntry(REDUCE, 231);
   _actionMap[802][ENDTOKEN] = ActionEntry(REDUCE, 231);
   _actionMap[802][RB] = ActionEntry(REDUCE, 231);
   _actionMap[802][SEMICOLON] = ActionEntry(REDUCE, 231);
   _actionMap[803][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[803][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[803][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[803][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[803][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[803][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[803][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[803][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[803][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[803][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[803][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[803][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[803][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[803][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[803][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[803][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[803][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[803][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[803][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[803][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[803][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[803][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[803][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[803][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[803][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[803][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[803][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[803][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[803][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[803][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[803][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[803][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[803][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[803][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[803][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[803][LB] = ActionEntry(SHIFT, 142);
   _actionMap[803][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[803][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[803][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[803][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[803][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[803][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[803][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[803][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[803][CASE] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser11()
{
   _actionMap[803][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[803][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[803][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[803][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[803][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[803][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[803][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[803][ObjSpec] = 99;
   _jumpMap[803][Constant] = 98;
   _jumpMap[803][SignedFloat] = 97;
   _jumpMap[803][SignedInt] = 96;
   _jumpMap[803][Attribute] = 95;
   _jumpMap[803][Function] = 94;
   _jumpMap[803][CasePrepare] = 93;
   _jumpMap[803][CaseClause] = 92;
   _jumpMap[803][Factor] = 91;
   _jumpMap[803][Term] = 90;
   _jumpMap[803][Expr] = 817;
   _actionMap[804][IDENTIFIER] = ActionEntry(SHIFT, 779);
   _actionMap[804][QUALIFIEDOBJ] = ActionEntry(SHIFT, 780);
   _actionMap[804][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _jumpMap[804][Attribute] = 818;
   _actionMap[805][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[805][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[805][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[805][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[805][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[805][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[805][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[805][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[805][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[805][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[805][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[805][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[805][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[805][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[805][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[805][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[805][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[805][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[805][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[805][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[805][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[805][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[805][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[805][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[805][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[805][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[805][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[805][BITAND] = ActionEntry(SHIFT, 102);
}
void Cego::loadParser12()
{
   _actionMap[805][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[805][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[805][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[805][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[805][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[805][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[805][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[805][LB] = ActionEntry(SHIFT, 373);
   _actionMap[805][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[805][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[805][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[805][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[805][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[805][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[805][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[805][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[805][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[805][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[805][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[805][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[805][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[805][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[805][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[805][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[805][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[805][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[805][ObjSpec] = 99;
   _jumpMap[805][Constant] = 98;
   _jumpMap[805][SignedFloat] = 97;
   _jumpMap[805][SignedInt] = 96;
   _jumpMap[805][Attribute] = 95;
   _jumpMap[805][QueryPredicate] = 370;
   _jumpMap[805][QueryCondition] = 819;
   _jumpMap[805][Function] = 94;
   _jumpMap[805][CasePrepare] = 93;
   _jumpMap[805][CaseClause] = 92;
   _jumpMap[805][Factor] = 91;
   _jumpMap[805][Term] = 90;
   _jumpMap[805][Expr] = 368;
   _actionMap[806][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[806][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[806][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[806][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[806][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[806][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[806][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[806][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[806][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[806][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[806][LOWER] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser13()
{
   _actionMap[806][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[806][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[806][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[806][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[806][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[806][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[806][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[806][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[806][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[806][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[806][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[806][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[806][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[806][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[806][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[806][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[806][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[806][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[806][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[806][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[806][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[806][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[806][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[806][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[806][LB] = ActionEntry(SHIFT, 373);
   _actionMap[806][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[806][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[806][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[806][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[806][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[806][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[806][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[806][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[806][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[806][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[806][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[806][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[806][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[806][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[806][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[806][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[806][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[806][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[806][ObjSpec] = 99;
   _jumpMap[806][Constant] = 98;
   _jumpMap[806][SignedFloat] = 97;
   _jumpMap[806][SignedInt] = 96;
   _jumpMap[806][Attribute] = 95;
   _jumpMap[806][QueryPredicate] = 370;
   _jumpMap[806][QueryCondition] = 820;
}
void Cego::loadParser14()
{
   _jumpMap[806][Function] = 94;
   _jumpMap[806][CasePrepare] = 93;
   _jumpMap[806][CaseClause] = 92;
   _jumpMap[806][Factor] = 91;
   _jumpMap[806][Term] = 90;
   _jumpMap[806][Expr] = 368;
   _actionMap[807][SEMICOLON] = ActionEntry(REDUCE, 253);
   _actionMap[807][KSEP] = ActionEntry(REDUCE, 253);
   _actionMap[808][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[808][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[808][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[808][SEMICOLON] = ActionEntry(REDUCE, 255);
   _actionMap[808][KSEP] = ActionEntry(REDUCE, 255);
   _actionMap[746][AND] = ActionEntry(SHIFT, 507);
   _actionMap[746][OR] = ActionEntry(SHIFT, 508);
   _actionMap[746][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[747][IDENTIFIER] = ActionEntry(SHIFT, 712);
   _jumpMap[747][SimpleAttr] = 711;
   _jumpMap[747][SimpleAttrList] = 786;
   _actionMap[748][SEMICOLON] = ActionEntry(REDUCE, 265);
   _actionMap[748][KSEP] = ActionEntry(REDUCE, 265);
   _actionMap[749][THEN] = ActionEntry(SHIFT, 787);
   _actionMap[750][THEN] = ActionEntry(REDUCE, 120);
   _actionMap[751][END_TOKEN] = ActionEntry(REDUCE, 125);
   _actionMap[751][ELSE] = ActionEntry(REDUCE, 125);
   _actionMap[751][ELSIF] = ActionEntry(REDUCE, 125);
   _actionMap[752][BEGIN] = ActionEntry(REDUCE, 139);
   _actionMap[752][THEN] = ActionEntry(REDUCE, 139);
   _actionMap[752][OR] = ActionEntry(REDUCE, 139);
   _actionMap[752][AND] = ActionEntry(REDUCE, 139);
   _actionMap[752][RB] = ActionEntry(REDUCE, 139);
   _actionMap[753][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[753][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[753][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[753][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[754][RB] = ActionEntry(SHIFT, 788);
   _actionMap[755][RB] = ActionEntry(SHIFT, 789);
   _actionMap[756][RB] = ActionEntry(SHIFT, 790);
   _actionMap[757][RB] = ActionEntry(SHIFT, 791);
   _actionMap[758][SEMICOLON] = ActionEntry(REDUCE, 131);
   _actionMap[759][RB] = ActionEntry(SHIFT, 792);
   _actionMap[760][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[761][IDENTIFIER] = ActionEntry(SHIFT, 712);
   _jumpMap[761][SimpleAttr] = 711;
   _jumpMap[761][SimpleAttrList] = 793;
   _actionMap[762][SEMICOLON] = ActionEntry(REDUCE, 172);
   _actionMap[762][KSEP] = ActionEntry(REDUCE, 172);
   _actionMap[762][RB] = ActionEntry(REDUCE, 172);
   _actionMap[763][SEMICOLON] = ActionEntry(REDUCE, 175);
   _actionMap[763][KSEP] = ActionEntry(REDUCE, 175);
}
void Cego::loadParser15()
{
   _actionMap[763][RB] = ActionEntry(REDUCE, 175);
   _actionMap[764][NULLTOKEN] = ActionEntry(SHIFT, 794);
   _actionMap[765][SEMICOLON] = ActionEntry(REDUCE, 173);
   _actionMap[765][KSEP] = ActionEntry(REDUCE, 173);
   _actionMap[765][RB] = ActionEntry(REDUCE, 173);
   _actionMap[766][NULLTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[766][NOT] = ActionEntry(REDUCE, 177);
   _actionMap[766][KSEP] = ActionEntry(REDUCE, 177);
   _actionMap[766][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[766][RB] = ActionEntry(REDUCE, 177);
   _actionMap[767][LONG] = ActionEntry(SHIFT, 275);
   _actionMap[767][BIGINT] = ActionEntry(SHIFT, 271);
   _actionMap[767][SMALLINT] = ActionEntry(SHIFT, 276);
   _actionMap[767][TINYINT] = ActionEntry(SHIFT, 277);
   _actionMap[767][DOUBLE] = ActionEntry(SHIFT, 273);
   _actionMap[767][DECIMAL] = ActionEntry(SHIFT, 272);
   _actionMap[767][FIXED] = ActionEntry(SHIFT, 274);
   _actionMap[768][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[768][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[768][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[768][KSEP] = ActionEntry(REDUCE, 200);
   _actionMap[768][RB] = ActionEntry(REDUCE, 200);
   _actionMap[769][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[769][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[769][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[769][LEFT] = ActionEntry(REDUCE, 315);
   _actionMap[769][RIGHT] = ActionEntry(REDUCE, 315);
   _actionMap[769][INNER] = ActionEntry(REDUCE, 315);
   _actionMap[769][JOIN] = ActionEntry(REDUCE, 315);
   _actionMap[769][RETURNTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[769][SEMICOLON] = ActionEntry(REDUCE, 315);
   _actionMap[769][ENDTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[769][UNION] = ActionEntry(REDUCE, 315);
   _actionMap[769][ROWLIMIT] = ActionEntry(REDUCE, 315);
   _actionMap[769][ORDER] = ActionEntry(REDUCE, 315);
   _actionMap[769][GROUP] = ActionEntry(REDUCE, 315);
   _actionMap[769][WHERE] = ActionEntry(REDUCE, 315);
   _actionMap[769][THEN] = ActionEntry(REDUCE, 315);
   _actionMap[769][AND] = ActionEntry(REDUCE, 315);
   _actionMap[769][OR] = ActionEntry(REDUCE, 315);
   _actionMap[769][RB] = ActionEntry(REDUCE, 315);
   _actionMap[770][LEFT] = ActionEntry(REDUCE, 312);
   _actionMap[770][RIGHT] = ActionEntry(REDUCE, 312);
   _actionMap[770][INNER] = ActionEntry(REDUCE, 312);
   _actionMap[770][JOIN] = ActionEntry(REDUCE, 312);
   _actionMap[770][RETURNTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[770][SEMICOLON] = ActionEntry(REDUCE, 312);
   _actionMap[770][ENDTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[770][UNION] = ActionEntry(REDUCE, 312);
   _actionMap[770][ROWLIMIT] = ActionEntry(REDUCE, 312);
}
void Cego::loadParser16()
{
   _actionMap[770][ORDER] = ActionEntry(REDUCE, 312);
   _actionMap[770][GROUP] = ActionEntry(REDUCE, 312);
   _actionMap[770][WHERE] = ActionEntry(REDUCE, 312);
   _actionMap[770][THEN] = ActionEntry(REDUCE, 312);
   _actionMap[770][AND] = ActionEntry(REDUCE, 312);
   _actionMap[770][OR] = ActionEntry(REDUCE, 312);
   _actionMap[770][RB] = ActionEntry(REDUCE, 312);
   _actionMap[771][RB] = ActionEntry(SHIFT, 795);
   _actionMap[772][KSEP] = ActionEntry(REDUCE, 166);
   _actionMap[772][RB] = ActionEntry(REDUCE, 166);
   _actionMap[773][UNION] = ActionEntry(SHIFT, 797);
   _actionMap[773][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[773][RB] = ActionEntry(REDUCE, 80);
   _jumpMap[773][UnionAllOpt] = 796;
   _actionMap[774][UNION] = ActionEntry(REDUCE, 245);
   _actionMap[774][ENDTOKEN] = ActionEntry(REDUCE, 245);
   _actionMap[774][RB] = ActionEntry(REDUCE, 245);
   _actionMap[774][SEMICOLON] = ActionEntry(REDUCE, 245);
   _actionMap[775][INTVAL] = ActionEntry(SHIFT, 798);
   _actionMap[776][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[776][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[776][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[776][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[776][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[776][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[776][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[776][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[776][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[776][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[776][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[776][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[776][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[776][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[776][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[776][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[776][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[776][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[776][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[776][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[776][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[776][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[776][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[776][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[776][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[776][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[776][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[776][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[776][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[776][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[776][NEXTCOUNT] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser17()
{
   _actionMap[776][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[776][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[776][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[776][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[776][LB] = ActionEntry(SHIFT, 142);
   _actionMap[776][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[776][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[776][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[776][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[776][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[776][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[776][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[776][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[776][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[776][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[776][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[776][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[776][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[776][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[776][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[776][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[776][ObjSpec] = 99;
   _jumpMap[776][Constant] = 98;
   _jumpMap[776][SignedFloat] = 97;
   _jumpMap[776][SignedInt] = 96;
   _jumpMap[776][Attribute] = 95;
   _jumpMap[776][Function] = 94;
   _jumpMap[776][OrderingList] = 800;
   _jumpMap[776][CasePrepare] = 93;
   _jumpMap[776][CaseClause] = 92;
   _jumpMap[776][Factor] = 91;
   _jumpMap[776][Term] = 90;
   _jumpMap[776][Expr] = 799;
   _actionMap[777][KSEP] = ActionEntry(SHIFT, 804);
   _actionMap[777][ORDER] = ActionEntry(REDUCE, 232);
   _actionMap[777][HAVING] = ActionEntry(SHIFT, 803);
   _actionMap[777][ROWLIMIT] = ActionEntry(REDUCE, 232);
   _actionMap[777][UNION] = ActionEntry(REDUCE, 232);
   _actionMap[777][ENDTOKEN] = ActionEntry(REDUCE, 232);
   _actionMap[777][RB] = ActionEntry(REDUCE, 232);
   _actionMap[777][SEMICOLON] = ActionEntry(REDUCE, 232);
   _jumpMap[777][NoHaving] = 802;
   _jumpMap[777][HavingClause] = 801;
   _actionMap[778][KSEP] = ActionEntry(REDUCE, 229);
   _actionMap[778][HAVING] = ActionEntry(REDUCE, 229);
   _actionMap[778][ORDER] = ActionEntry(REDUCE, 229);
   _actionMap[778][ROWLIMIT] = ActionEntry(REDUCE, 229);
   _actionMap[778][UNION] = ActionEntry(REDUCE, 229);
   _actionMap[778][ENDTOKEN] = ActionEntry(REDUCE, 229);
   _actionMap[778][RB] = ActionEntry(REDUCE, 229);
}
void Cego::loadParser18()
{
   _actionMap[778][SEMICOLON] = ActionEntry(REDUCE, 229);
   _actionMap[779][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[779][HAVING] = ActionEntry(REDUCE, 341);
   _actionMap[779][ORDER] = ActionEntry(REDUCE, 341);
   _actionMap[779][ROWLIMIT] = ActionEntry(REDUCE, 341);
   _actionMap[779][UNION] = ActionEntry(REDUCE, 341);
   _actionMap[779][ENDTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[779][RB] = ActionEntry(REDUCE, 341);
   _actionMap[779][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[780][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[780][HAVING] = ActionEntry(REDUCE, 342);
   _actionMap[780][ORDER] = ActionEntry(REDUCE, 342);
   _actionMap[780][ROWLIMIT] = ActionEntry(REDUCE, 342);
   _actionMap[780][UNION] = ActionEntry(REDUCE, 342);
   _actionMap[780][ENDTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[780][RB] = ActionEntry(REDUCE, 342);
   _actionMap[780][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[781][AND] = ActionEntry(SHIFT, 507);
   _actionMap[781][OR] = ActionEntry(SHIFT, 508);
   _actionMap[781][LEFT] = ActionEntry(REDUCE, 212);
   _actionMap[781][RIGHT] = ActionEntry(REDUCE, 212);
   _actionMap[781][INNER] = ActionEntry(REDUCE, 212);
   _actionMap[781][JOIN] = ActionEntry(REDUCE, 212);
   _actionMap[781][RETURNTOKEN] = ActionEntry(REDUCE, 212);
   _actionMap[781][SEMICOLON] = ActionEntry(REDUCE, 212);
   _actionMap[781][RB] = ActionEntry(REDUCE, 212);
   _actionMap[781][ENDTOKEN] = ActionEntry(REDUCE, 212);
   _actionMap[781][UNION] = ActionEntry(REDUCE, 212);
   _actionMap[781][ROWLIMIT] = ActionEntry(REDUCE, 212);
   _actionMap[781][ORDER] = ActionEntry(REDUCE, 212);
   _actionMap[781][GROUP] = ActionEntry(REDUCE, 212);
   _actionMap[781][WHERE] = ActionEntry(REDUCE, 212);
   _actionMap[782][ON] = ActionEntry(SHIFT, 740);
   _jumpMap[782][JoinTableOn] = 805;
   _actionMap[783][ON] = ActionEntry(SHIFT, 740);
   _jumpMap[783][JoinTableOn] = 806;
   _actionMap[784][VARREF] = ActionEntry(SHIFT, 745);
   _jumpMap[784][ReturnVar] = 807;
   _actionMap[785][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[785][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[785][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[785][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[785][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[785][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[785][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[785][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[785][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[785][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[785][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[785][UPPER] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser19()
{
   _actionMap[785][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[785][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[785][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[785][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[785][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[785][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[785][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[785][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[785][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[785][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[785][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[785][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[785][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[785][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[785][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[785][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[785][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[785][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[785][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[785][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[785][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[785][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[785][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[785][LB] = ActionEntry(SHIFT, 142);
   _actionMap[785][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[785][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[785][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[785][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[785][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[785][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[785][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[785][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[785][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[785][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[785][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[785][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[785][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[785][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[785][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[785][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[785][ObjSpec] = 99;
   _jumpMap[785][Constant] = 98;
   _jumpMap[785][SignedFloat] = 97;
   _jumpMap[785][SignedInt] = 96;
   _jumpMap[785][Attribute] = 95;
   _jumpMap[785][Function] = 94;
   _jumpMap[785][CasePrepare] = 93;
   _jumpMap[785][CaseClause] = 92;
   _jumpMap[785][Factor] = 91;
   _jumpMap[785][Term] = 90;
}
void Cego::loadParser20()
{
   _jumpMap[785][Expr] = 808;
   _actionMap[686][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[686][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[686][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[686][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[686][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[686][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[686][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[686][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[686][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[686][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[686][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[686][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[686][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[686][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[686][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[686][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[686][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[686][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[686][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[686][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[686][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[686][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[686][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[686][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[686][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[686][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[686][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[686][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[686][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[686][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[686][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[686][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[686][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[686][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[686][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[686][LB] = ActionEntry(SHIFT, 373);
   _actionMap[686][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[686][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[686][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[686][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[686][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[686][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[686][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[686][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[686][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[686][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[686][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[686][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[686][SUM] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser21()
{
   _actionMap[686][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[686][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[686][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[686][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[686][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[686][ObjSpec] = 99;
   _jumpMap[686][Constant] = 98;
   _jumpMap[686][SignedFloat] = 97;
   _jumpMap[686][SignedInt] = 96;
   _jumpMap[686][Attribute] = 95;
   _jumpMap[686][QueryPredicate] = 370;
   _jumpMap[686][QueryCondition] = 746;
   _jumpMap[686][Function] = 94;
   _jumpMap[686][CasePrepare] = 93;
   _jumpMap[686][CaseClause] = 92;
   _jumpMap[686][Factor] = 91;
   _jumpMap[686][Term] = 90;
   _jumpMap[686][Expr] = 368;
   _actionMap[687][LB] = ActionEntry(SHIFT, 747);
   _actionMap[688][IDENTIFIER] = ActionEntry(SHIFT, 748);
   _actionMap[689][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[690][IDENTIFIER] = ActionEntry(SHIFT, 750);
   _jumpMap[690][ProcExceptionType] = 749;
   _actionMap[691][END_TOKEN] = ActionEntry(REDUCE, 126);
   _actionMap[692][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[692][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[692][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[692][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[692][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[692][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[692][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[692][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[692][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[692][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[692][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[692][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[692][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[692][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[692][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[692][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[692][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[692][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[692][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[692][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[692][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[692][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[692][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[692][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[692][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[692][DIV] = ActionEntry(SHIFT, 110);
}
void Cego::loadParser22()
{
   _actionMap[692][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[692][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[692][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[692][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[692][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[692][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[692][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[692][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[692][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[692][LB] = ActionEntry(SHIFT, 142);
   _actionMap[692][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[692][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[692][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[692][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[692][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[692][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[692][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[692][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[692][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[692][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[692][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[692][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[692][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[692][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[692][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[692][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[692][IF] = ActionEntry(SHIFT, 338);
   _actionMap[692][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[692][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[692][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[692][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[692][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[692][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[692][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[692][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[692][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[692][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[692][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[692][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[692][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[692][ObjSpec] = 99;
   _jumpMap[692][Constant] = 98;
   _jumpMap[692][SignedFloat] = 97;
   _jumpMap[692][SignedInt] = 96;
   _jumpMap[692][Attribute] = 95;
   _jumpMap[692][Function] = 94;
   _jumpMap[692][DeleteStatement] = 334;
   _jumpMap[692][UpdateStatement] = 333;
   _jumpMap[692][InsertStatement] = 332;
   _jumpMap[692][RollbackStatement] = 331;
}
void Cego::loadParser23()
{
   _jumpMap[692][CommitStatement] = 330;
   _jumpMap[692][StartStatement] = 329;
   _jumpMap[692][CasePrepare] = 93;
   _jumpMap[692][CaseClause] = 92;
   _jumpMap[692][Factor] = 91;
   _jumpMap[692][Term] = 90;
   _jumpMap[692][Expr] = 328;
   _jumpMap[692][ProcStatement] = 327;
   _jumpMap[692][ProcIfPart] = 326;
   _jumpMap[692][ProcBlockStart] = 325;
   _jumpMap[692][ProcStatementList] = 324;
   _jumpMap[692][ProcStmtBlock] = 751;
   _actionMap[693][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[694][END_TOKEN] = ActionEntry(REDUCE, 122);
   _actionMap[694][ELSE] = ActionEntry(REDUCE, 122);
   _actionMap[694][ELSIF] = ActionEntry(REDUCE, 122);
   _actionMap[695][BEGIN] = ActionEntry(REDUCE, 134);
   _actionMap[695][RB] = ActionEntry(REDUCE, 134);
   _actionMap[695][AND] = ActionEntry(REDUCE, 134);
   _actionMap[695][OR] = ActionEntry(REDUCE, 134);
   _actionMap[695][THEN] = ActionEntry(REDUCE, 134);
   _actionMap[696][BEGIN] = ActionEntry(REDUCE, 133);
   _actionMap[696][RB] = ActionEntry(REDUCE, 133);
   _actionMap[696][AND] = ActionEntry(REDUCE, 133);
   _actionMap[696][OR] = ActionEntry(REDUCE, 133);
   _actionMap[696][THEN] = ActionEntry(REDUCE, 133);
   _actionMap[697][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[697][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[697][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[697][BEGIN] = ActionEntry(REDUCE, 137);
   _actionMap[697][THEN] = ActionEntry(REDUCE, 137);
   _actionMap[697][OR] = ActionEntry(REDUCE, 137);
   _actionMap[697][AND] = ActionEntry(REDUCE, 137);
   _actionMap[697][RB] = ActionEntry(REDUCE, 137);
   _actionMap[698][NULLTOKEN] = ActionEntry(SHIFT, 752);
   _actionMap[699][BEGIN] = ActionEntry(REDUCE, 138);
   _actionMap[699][THEN] = ActionEntry(REDUCE, 138);
   _actionMap[699][OR] = ActionEntry(REDUCE, 138);
   _actionMap[699][AND] = ActionEntry(REDUCE, 138);
   _actionMap[699][RB] = ActionEntry(REDUCE, 138);
   _actionMap[700][BEGIN] = ActionEntry(REDUCE, 136);
   _actionMap[700][RB] = ActionEntry(REDUCE, 136);
   _actionMap[700][AND] = ActionEntry(REDUCE, 136);
   _actionMap[700][OR] = ActionEntry(REDUCE, 136);
   _actionMap[700][THEN] = ActionEntry(REDUCE, 136);
   _actionMap[701][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[702][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[703][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[703][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[703][INTVAL] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser24()
{
   _actionMap[703][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[703][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[703][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[703][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[703][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[703][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[703][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[703][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[703][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[703][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[703][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[703][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[703][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[703][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[703][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[703][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[703][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[703][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[703][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[703][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[703][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[703][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[703][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[703][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[703][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[703][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[703][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[703][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[703][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[703][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[703][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[703][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[703][LB] = ActionEntry(SHIFT, 142);
   _actionMap[703][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[703][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[703][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[703][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[703][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[703][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[703][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[703][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[703][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[703][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[703][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[703][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[703][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[703][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[703][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[703][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[703][ObjSpec] = 99;
}
void Cego::loadParser25()
{
   _jumpMap[703][Constant] = 98;
   _jumpMap[703][SignedFloat] = 97;
   _jumpMap[703][SignedInt] = 96;
   _jumpMap[703][Attribute] = 95;
   _jumpMap[703][Function] = 94;
   _jumpMap[703][CasePrepare] = 93;
   _jumpMap[703][CaseClause] = 92;
   _jumpMap[703][Factor] = 91;
   _jumpMap[703][Term] = 90;
   _jumpMap[703][Expr] = 753;
   _actionMap[704][INTVAL] = ActionEntry(SHIFT, 754);
   _actionMap[705][INTVAL] = ActionEntry(SHIFT, 755);
   _actionMap[706][INTVAL] = ActionEntry(SHIFT, 756);
   _actionMap[707][INTVAL] = ActionEntry(SHIFT, 757);
   _actionMap[708][END_TOKEN] = ActionEntry(SHIFT, 758);
   _actionMap[709][IDENTIFIER] = ActionEntry(SHIFT, 712);
   _jumpMap[709][SimpleAttr] = 711;
   _jumpMap[709][SimpleAttrList] = 759;
   _actionMap[710][RB] = ActionEntry(SHIFT, 760);
   _actionMap[711][KSEP] = ActionEntry(SHIFT, 761);
   _actionMap[711][RB] = ActionEntry(REDUCE, 181);
   _actionMap[712][RB] = ActionEntry(REDUCE, 182);
   _actionMap[712][KSEP] = ActionEntry(REDUCE, 182);
   _actionMap[713][KSEP] = ActionEntry(REDUCE, 87);
   _actionMap[713][RB] = ActionEntry(REDUCE, 87);
   _actionMap[714][BEGIN] = ActionEntry(REDUCE, 83);
   _actionMap[715][KSEP] = ActionEntry(REDUCE, 89);
   _actionMap[715][RB] = ActionEntry(REDUCE, 89);
   _actionMap[716][KSEP] = ActionEntry(REDUCE, 90);
   _actionMap[716][RB] = ActionEntry(REDUCE, 90);
   _actionMap[717][KSEP] = ActionEntry(REDUCE, 168);
   _actionMap[717][RB] = ActionEntry(REDUCE, 168);
   _actionMap[718][SEMICOLON] = ActionEntry(REDUCE, 176);
   _actionMap[718][NULLTOKEN] = ActionEntry(SHIFT, 765);
   _actionMap[718][NOT] = ActionEntry(SHIFT, 764);
   _actionMap[718][KSEP] = ActionEntry(REDUCE, 176);
   _actionMap[718][RB] = ActionEntry(REDUCE, 176);
   _jumpMap[718][DefaultNullOpt] = 763;
   _jumpMap[718][NullOpt] = 762;
   _actionMap[719][NULLTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[719][NOT] = ActionEntry(REDUCE, 178);
   _actionMap[719][KSEP] = ActionEntry(REDUCE, 178);
   _actionMap[719][SEMICOLON] = ActionEntry(REDUCE, 178);
   _actionMap[719][RB] = ActionEntry(REDUCE, 178);
   _actionMap[720][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[720][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[720][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[720][LB] = ActionEntry(SHIFT, 767);
   _actionMap[720][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[720][DATE] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser26()
{
   _actionMap[720][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[720][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[720][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[720][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[720][LAB] = ActionEntry(SHIFT, 143);
   _jumpMap[720][Constant] = 766;
   _jumpMap[720][SignedFloat] = 97;
   _jumpMap[720][SignedInt] = 96;
   _actionMap[721][SEMICOLON] = ActionEntry(REDUCE, 195);
   _actionMap[721][KSEP] = ActionEntry(REDUCE, 195);
   _actionMap[722][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[722][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[722][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[722][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[722][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[722][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[722][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[722][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[722][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[722][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[722][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[722][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[722][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[722][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[722][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[722][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[722][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[722][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[722][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[722][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[722][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[722][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[722][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[722][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[722][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[722][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[722][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[722][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[722][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[722][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[722][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[722][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[722][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[722][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[722][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[722][LB] = ActionEntry(SHIFT, 142);
   _actionMap[722][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[722][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[722][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[722][NULLTOKEN] = ActionEntry(SHIFT, 123);
}
void Cego::loadParser27()
{
   _actionMap[722][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[722][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[722][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[722][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[722][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[722][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[722][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[722][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[722][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[722][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[722][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[722][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[722][ObjSpec] = 99;
   _jumpMap[722][Constant] = 98;
   _jumpMap[722][SignedFloat] = 97;
   _jumpMap[722][SignedInt] = 96;
   _jumpMap[722][Attribute] = 95;
   _jumpMap[722][Function] = 94;
   _jumpMap[722][CasePrepare] = 93;
   _jumpMap[722][CaseClause] = 92;
   _jumpMap[722][Factor] = 91;
   _jumpMap[722][Term] = 90;
   _jumpMap[722][Expr] = 768;
   _actionMap[723][SEMICOLON] = ActionEntry(REDUCE, 197);
   _actionMap[723][KSEP] = ActionEntry(REDUCE, 197);
   _actionMap[724][KSEP] = ActionEntry(REDUCE, 198);
   _actionMap[724][RB] = ActionEntry(REDUCE, 198);
   _actionMap[725][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[725][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[725][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[725][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[725][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[725][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[725][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[725][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[725][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[725][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[725][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[725][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[725][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[725][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[725][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[725][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[725][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[725][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[725][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[725][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[725][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[725][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[725][RANDSTR] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser28()
{
   _actionMap[725][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[725][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[725][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[725][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[725][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[725][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[725][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[725][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[725][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[725][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[725][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[725][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[725][LB] = ActionEntry(SHIFT, 142);
   _actionMap[725][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[725][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[725][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[725][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[725][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[725][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[725][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[725][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[725][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[725][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[725][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[725][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[725][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[725][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[725][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[725][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[725][ObjSpec] = 99;
   _jumpMap[725][Constant] = 98;
   _jumpMap[725][SignedFloat] = 97;
   _jumpMap[725][SignedInt] = 96;
   _jumpMap[725][Attribute] = 95;
   _jumpMap[725][Function] = 94;
   _jumpMap[725][CasePrepare] = 93;
   _jumpMap[725][CaseClause] = 92;
   _jumpMap[725][Factor] = 91;
   _jumpMap[725][Term] = 90;
   _jumpMap[725][Expr] = 769;
   _actionMap[726][RB] = ActionEntry(SHIFT, 770);
   _actionMap[727][LEFT] = ActionEntry(REDUCE, 317);
   _actionMap[727][RIGHT] = ActionEntry(REDUCE, 317);
   _actionMap[727][INNER] = ActionEntry(REDUCE, 317);
   _actionMap[727][JOIN] = ActionEntry(REDUCE, 317);
   _actionMap[727][RETURNTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[727][SEMICOLON] = ActionEntry(REDUCE, 317);
   _actionMap[727][ENDTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[727][UNION] = ActionEntry(REDUCE, 317);
   _actionMap[727][ROWLIMIT] = ActionEntry(REDUCE, 317);
}
void Cego::loadParser29()
{
   _actionMap[727][ORDER] = ActionEntry(REDUCE, 317);
   _actionMap[727][GROUP] = ActionEntry(REDUCE, 317);
   _actionMap[727][WHERE] = ActionEntry(REDUCE, 317);
   _actionMap[727][THEN] = ActionEntry(REDUCE, 317);
   _actionMap[727][AND] = ActionEntry(REDUCE, 317);
   _actionMap[727][OR] = ActionEntry(REDUCE, 317);
   _actionMap[727][RB] = ActionEntry(REDUCE, 317);
   _actionMap[728][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[728][SelectStatement] = 771;
   _actionMap[729][LEFT] = ActionEntry(REDUCE, 319);
   _actionMap[729][RIGHT] = ActionEntry(REDUCE, 319);
   _actionMap[729][INNER] = ActionEntry(REDUCE, 319);
   _actionMap[729][JOIN] = ActionEntry(REDUCE, 319);
   _actionMap[729][RETURNTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[729][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[729][ENDTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[729][UNION] = ActionEntry(REDUCE, 319);
   _actionMap[729][ROWLIMIT] = ActionEntry(REDUCE, 319);
   _actionMap[729][ORDER] = ActionEntry(REDUCE, 319);
   _actionMap[729][GROUP] = ActionEntry(REDUCE, 319);
   _actionMap[729][WHERE] = ActionEntry(REDUCE, 319);
   _actionMap[729][THEN] = ActionEntry(REDUCE, 319);
   _actionMap[729][AND] = ActionEntry(REDUCE, 319);
   _actionMap[729][OR] = ActionEntry(REDUCE, 319);
   _actionMap[729][RB] = ActionEntry(REDUCE, 319);
   _actionMap[730][THEN] = ActionEntry(REDUCE, 311);
   _actionMap[730][LEFT] = ActionEntry(REDUCE, 311);
   _actionMap[730][RIGHT] = ActionEntry(REDUCE, 311);
   _actionMap[730][INNER] = ActionEntry(REDUCE, 311);
   _actionMap[730][JOIN] = ActionEntry(REDUCE, 311);
   _actionMap[730][RETURNTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[730][SEMICOLON] = ActionEntry(REDUCE, 311);
   _actionMap[730][RB] = ActionEntry(REDUCE, 311);
   _actionMap[730][ENDTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[730][UNION] = ActionEntry(REDUCE, 311);
   _actionMap[730][ROWLIMIT] = ActionEntry(REDUCE, 311);
   _actionMap[730][ORDER] = ActionEntry(REDUCE, 311);
   _actionMap[730][GROUP] = ActionEntry(REDUCE, 311);
   _actionMap[730][WHERE] = ActionEntry(REDUCE, 311);
   _actionMap[730][AND] = ActionEntry(REDUCE, 311);
   _actionMap[730][OR] = ActionEntry(REDUCE, 311);
   _actionMap[731][WHEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][ELSE] = ActionEntry(REDUCE, 358);
   _actionMap[731][LEFT] = ActionEntry(REDUCE, 358);
   _actionMap[731][RIGHT] = ActionEntry(REDUCE, 358);
   _actionMap[731][INNER] = ActionEntry(REDUCE, 358);
   _actionMap[731][JOIN] = ActionEntry(REDUCE, 358);
   _actionMap[731][RETURNTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][ORDER] = ActionEntry(REDUCE, 358);
   _actionMap[731][GROUP] = ActionEntry(REDUCE, 358);
}
void Cego::loadParser30()
{
   _actionMap[731][WHERE] = ActionEntry(REDUCE, 358);
   _actionMap[731][NULLTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][FROM] = ActionEntry(REDUCE, 358);
   _actionMap[731][AS] = ActionEntry(REDUCE, 358);
   _actionMap[731][END_TOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][BEGIN] = ActionEntry(REDUCE, 358);
   _actionMap[731][THEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][OR] = ActionEntry(REDUCE, 358);
   _actionMap[731][AND] = ActionEntry(REDUCE, 358);
   _actionMap[731][INTOK] = ActionEntry(REDUCE, 358);
   _actionMap[731][NOT] = ActionEntry(REDUCE, 358);
   _actionMap[731][BETWEEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][IS] = ActionEntry(REDUCE, 358);
   _actionMap[731][LIKE] = ActionEntry(REDUCE, 358);
   _actionMap[731][MT] = ActionEntry(REDUCE, 358);
   _actionMap[731][LT] = ActionEntry(REDUCE, 358);
   _actionMap[731][NEGATION] = ActionEntry(REDUCE, 358);
   _actionMap[731][EQU] = ActionEntry(REDUCE, 358);
   _actionMap[731][RB] = ActionEntry(REDUCE, 358);
   _actionMap[731][ENDTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[731][UNION] = ActionEntry(REDUCE, 358);
   _actionMap[731][ROWLIMIT] = ActionEntry(REDUCE, 358);
   _actionMap[731][KSEP] = ActionEntry(REDUCE, 358);
   _actionMap[731][ASC] = ActionEntry(REDUCE, 358);
   _actionMap[731][DESC] = ActionEntry(REDUCE, 358);
   _actionMap[731][SEMICOLON] = ActionEntry(REDUCE, 358);
   _actionMap[731][PLUS] = ActionEntry(REDUCE, 358);
   _actionMap[731][MINUS] = ActionEntry(REDUCE, 358);
   _actionMap[731][DIVISION] = ActionEntry(REDUCE, 358);
   _actionMap[731][STAR] = ActionEntry(REDUCE, 358);
   _actionMap[731][CONCAT] = ActionEntry(REDUCE, 358);
   _actionMap[732][VARREF] = ActionEntry(SHIFT, 772);
   _actionMap[733][WHEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][ELSE] = ActionEntry(REDUCE, 149);
   _actionMap[733][LEFT] = ActionEntry(REDUCE, 149);
   _actionMap[733][RIGHT] = ActionEntry(REDUCE, 149);
   _actionMap[733][INNER] = ActionEntry(REDUCE, 149);
   _actionMap[733][JOIN] = ActionEntry(REDUCE, 149);
   _actionMap[733][RETURNTOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][ORDER] = ActionEntry(REDUCE, 149);
   _actionMap[733][GROUP] = ActionEntry(REDUCE, 149);
   _actionMap[733][WHERE] = ActionEntry(REDUCE, 149);
   _actionMap[733][AS] = ActionEntry(REDUCE, 149);
   _actionMap[733][FROM] = ActionEntry(REDUCE, 149);
   _actionMap[733][END_TOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][BEGIN] = ActionEntry(REDUCE, 149);
   _actionMap[733][THEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][OR] = ActionEntry(REDUCE, 149);
   _actionMap[733][AND] = ActionEntry(REDUCE, 149);
   _actionMap[733][LIKE] = ActionEntry(REDUCE, 149);
}
void Cego::loadParser31()
{
   _actionMap[733][IS] = ActionEntry(REDUCE, 149);
   _actionMap[733][BETWEEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][NOT] = ActionEntry(REDUCE, 149);
   _actionMap[733][INTOK] = ActionEntry(REDUCE, 149);
   _actionMap[733][EQU] = ActionEntry(REDUCE, 149);
   _actionMap[733][NEGATION] = ActionEntry(REDUCE, 149);
   _actionMap[733][LT] = ActionEntry(REDUCE, 149);
   _actionMap[733][MT] = ActionEntry(REDUCE, 149);
   _actionMap[733][DESC] = ActionEntry(REDUCE, 149);
   _actionMap[733][ASC] = ActionEntry(REDUCE, 149);
   _actionMap[733][KSEP] = ActionEntry(REDUCE, 149);
   _actionMap[733][ROWLIMIT] = ActionEntry(REDUCE, 149);
   _actionMap[733][UNION] = ActionEntry(REDUCE, 149);
   _actionMap[733][ENDTOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[733][RB] = ActionEntry(REDUCE, 149);
   _actionMap[733][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[733][CONCAT] = ActionEntry(REDUCE, 149);
   _actionMap[733][STAR] = ActionEntry(REDUCE, 149);
   _actionMap[733][DIVISION] = ActionEntry(REDUCE, 149);
   _actionMap[733][MINUS] = ActionEntry(REDUCE, 149);
   _actionMap[733][PLUS] = ActionEntry(REDUCE, 149);
   _actionMap[734][WHEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][ELSE] = ActionEntry(REDUCE, 300);
   _actionMap[734][LEFT] = ActionEntry(REDUCE, 300);
   _actionMap[734][RIGHT] = ActionEntry(REDUCE, 300);
   _actionMap[734][INNER] = ActionEntry(REDUCE, 300);
   _actionMap[734][JOIN] = ActionEntry(REDUCE, 300);
   _actionMap[734][RETURNTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][ORDER] = ActionEntry(REDUCE, 300);
   _actionMap[734][GROUP] = ActionEntry(REDUCE, 300);
   _actionMap[734][WHERE] = ActionEntry(REDUCE, 300);
   _actionMap[734][FROM] = ActionEntry(REDUCE, 300);
   _actionMap[734][AS] = ActionEntry(REDUCE, 300);
   _actionMap[734][END_TOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][BEGIN] = ActionEntry(REDUCE, 300);
   _actionMap[734][THEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][OR] = ActionEntry(REDUCE, 300);
   _actionMap[734][AND] = ActionEntry(REDUCE, 300);
   _actionMap[734][INTOK] = ActionEntry(REDUCE, 300);
   _actionMap[734][NOT] = ActionEntry(REDUCE, 300);
   _actionMap[734][BETWEEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][IS] = ActionEntry(REDUCE, 300);
   _actionMap[734][LIKE] = ActionEntry(REDUCE, 300);
   _actionMap[734][MT] = ActionEntry(REDUCE, 300);
   _actionMap[734][LT] = ActionEntry(REDUCE, 300);
   _actionMap[734][NEGATION] = ActionEntry(REDUCE, 300);
   _actionMap[734][EQU] = ActionEntry(REDUCE, 300);
   _actionMap[734][RB] = ActionEntry(REDUCE, 300);
   _actionMap[734][ENDTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[734][UNION] = ActionEntry(REDUCE, 300);
}
void Cego::loadParser32()
{
   _actionMap[734][ROWLIMIT] = ActionEntry(REDUCE, 300);
   _actionMap[734][KSEP] = ActionEntry(REDUCE, 300);
   _actionMap[734][ASC] = ActionEntry(REDUCE, 300);
   _actionMap[734][DESC] = ActionEntry(REDUCE, 300);
   _actionMap[734][SEMICOLON] = ActionEntry(REDUCE, 300);
   _actionMap[734][PLUS] = ActionEntry(REDUCE, 300);
   _actionMap[734][MINUS] = ActionEntry(REDUCE, 300);
   _actionMap[734][DIVISION] = ActionEntry(REDUCE, 300);
   _actionMap[734][STAR] = ActionEntry(REDUCE, 300);
   _actionMap[734][CONCAT] = ActionEntry(REDUCE, 300);
   _actionMap[735][SEMICOLON] = ActionEntry(REDUCE, 246);
   _actionMap[735][RB] = ActionEntry(REDUCE, 246);
   _actionMap[735][ENDTOKEN] = ActionEntry(REDUCE, 246);
   _actionMap[735][UNION] = ActionEntry(REDUCE, 246);
   _actionMap[735][ROWLIMIT] = ActionEntry(SHIFT, 775);
   _jumpMap[735][NoLimit] = 774;
   _jumpMap[735][LimitOpt] = 773;
   _actionMap[736][ROWLIMIT] = ActionEntry(REDUCE, 234);
   _actionMap[736][UNION] = ActionEntry(REDUCE, 234);
   _actionMap[736][ENDTOKEN] = ActionEntry(REDUCE, 234);
   _actionMap[736][RB] = ActionEntry(REDUCE, 234);
   _actionMap[736][SEMICOLON] = ActionEntry(REDUCE, 234);
   _actionMap[737][BY] = ActionEntry(SHIFT, 776);
   _actionMap[738][IDENTIFIER] = ActionEntry(SHIFT, 779);
   _actionMap[738][QUALIFIEDOBJ] = ActionEntry(SHIFT, 780);
   _actionMap[738][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _jumpMap[738][Attribute] = 778;
   _jumpMap[738][GroupList] = 777;
   _actionMap[739][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[739][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[739][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[739][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[739][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[739][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[739][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[739][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[739][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[739][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[739][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[739][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[739][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[739][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[739][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[739][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[739][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[739][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[739][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[739][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[739][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[739][STR2DATE] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser33()
{
   _actionMap[739][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[739][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[739][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[739][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[739][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[739][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[739][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[739][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[739][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[739][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[739][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[739][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[739][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[739][LB] = ActionEntry(SHIFT, 373);
   _actionMap[739][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[739][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[739][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[739][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[739][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[739][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[739][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[739][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[739][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[739][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[739][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[739][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[739][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[739][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[739][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[739][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[739][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[739][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[739][ObjSpec] = 99;
   _jumpMap[739][Constant] = 98;
   _jumpMap[739][SignedFloat] = 97;
   _jumpMap[739][SignedInt] = 96;
   _jumpMap[739][Attribute] = 95;
   _jumpMap[739][QueryPredicate] = 370;
   _jumpMap[739][QueryCondition] = 781;
   _jumpMap[739][Function] = 94;
   _jumpMap[739][CasePrepare] = 93;
   _jumpMap[739][CaseClause] = 92;
   _jumpMap[739][Factor] = 91;
   _jumpMap[739][Term] = 90;
   _jumpMap[739][Expr] = 368;
   _actionMap[740][EXISTS] = ActionEntry(REDUCE, 221);
   _actionMap[740][LB] = ActionEntry(REDUCE, 221);
   _actionMap[740][NOT] = ActionEntry(REDUCE, 221);
   _actionMap[740][VARREF] = ActionEntry(REDUCE, 221);
   _actionMap[740][FETCH] = ActionEntry(REDUCE, 221);
}
void Cego::loadParser34()
{
   _actionMap[740][COUNT] = ActionEntry(REDUCE, 221);
   _actionMap[740][SUM] = ActionEntry(REDUCE, 221);
   _actionMap[740][AVG] = ActionEntry(REDUCE, 221);
   _actionMap[740][MIN] = ActionEntry(REDUCE, 221);
   _actionMap[740][MAX] = ActionEntry(REDUCE, 221);
   _actionMap[740][CASE] = ActionEntry(REDUCE, 221);
   _actionMap[740][TRIM] = ActionEntry(REDUCE, 221);
   _actionMap[740][RTRIM] = ActionEntry(REDUCE, 221);
   _actionMap[740][LTRIM] = ActionEntry(REDUCE, 221);
   _actionMap[740][ROUND] = ActionEntry(REDUCE, 221);
   _actionMap[740][DATE2STR] = ActionEntry(REDUCE, 221);
   _actionMap[740][DATE2INT] = ActionEntry(REDUCE, 221);
   _actionMap[740][INT2DATE] = ActionEntry(REDUCE, 221);
   _actionMap[740][LOWER] = ActionEntry(REDUCE, 221);
   _actionMap[740][UPPER] = ActionEntry(REDUCE, 221);
   _actionMap[740][LEFT] = ActionEntry(REDUCE, 221);
   _actionMap[740][RIGHT] = ActionEntry(REDUCE, 221);
   _actionMap[740][GETPOS] = ActionEntry(REDUCE, 221);
   _actionMap[740][SUBSTR] = ActionEntry(REDUCE, 221);
   _actionMap[740][REPLACE] = ActionEntry(REDUCE, 221);
   _actionMap[740][LENGTH] = ActionEntry(REDUCE, 221);
   _actionMap[740][TRUNC] = ActionEntry(REDUCE, 221);
   _actionMap[740][STR2INT] = ActionEntry(REDUCE, 221);
   _actionMap[740][STR2LONG] = ActionEntry(REDUCE, 221);
   _actionMap[740][STR2DATE] = ActionEntry(REDUCE, 221);
   _actionMap[740][RANDSTR] = ActionEntry(REDUCE, 221);
   _actionMap[740][RANDINT] = ActionEntry(REDUCE, 221);
   _actionMap[740][MOD] = ActionEntry(REDUCE, 221);
   _actionMap[740][DIV] = ActionEntry(REDUCE, 221);
   _actionMap[740][POWER] = ActionEntry(REDUCE, 221);
   _actionMap[740][BITAND] = ActionEntry(REDUCE, 221);
   _actionMap[740][BITOR] = ActionEntry(REDUCE, 221);
   _actionMap[740][BITXOR] = ActionEntry(REDUCE, 221);
   _actionMap[740][NEXTCOUNT] = ActionEntry(REDUCE, 221);
   _actionMap[740][SETCOUNT] = ActionEntry(REDUCE, 221);
   _actionMap[740][IDENTIFIER] = ActionEntry(REDUCE, 221);
   _actionMap[740][QUALIFIEDOBJ] = ActionEntry(REDUCE, 221);
   _actionMap[740][QUALIFIEDTS] = ActionEntry(REDUCE, 221);
   _actionMap[740][QUALIFIEDPRE] = ActionEntry(REDUCE, 221);
   _actionMap[740][STRINGVAL] = ActionEntry(REDUCE, 221);
   _actionMap[740][DATE] = ActionEntry(REDUCE, 221);
   _actionMap[740][SYSDATE] = ActionEntry(REDUCE, 221);
   _actionMap[740][NULLTOKEN] = ActionEntry(REDUCE, 221);
   _actionMap[740][TRUEVAL] = ActionEntry(REDUCE, 221);
   _actionMap[740][FALSEVAL] = ActionEntry(REDUCE, 221);
   _actionMap[740][LAB] = ActionEntry(REDUCE, 221);
   _actionMap[740][FLOATVAL] = ActionEntry(REDUCE, 221);
   _actionMap[740][MINUS] = ActionEntry(REDUCE, 221);
   _actionMap[740][INTVAL] = ActionEntry(REDUCE, 221);
   _actionMap[741][IDENTIFIER] = ActionEntry(SHIFT, 50);
}
void Cego::loadParser35()
{
   _actionMap[741][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[741][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[741][ObjSpec] = 436;
   _jumpMap[741][Table] = 782;
   _actionMap[742][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[742][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[742][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[742][ObjSpec] = 436;
   _jumpMap[742][Table] = 783;
   _actionMap[743][KSEP] = ActionEntry(SHIFT, 784);
   _actionMap[743][SEMICOLON] = ActionEntry(REDUCE, 251);
   _actionMap[744][SEMICOLON] = ActionEntry(REDUCE, 254);
   _actionMap[744][KSEP] = ActionEntry(REDUCE, 254);
   _actionMap[745][EQU] = ActionEntry(SHIFT, 785);
   _actionMap[586][SEMICOLON] = ActionEntry(REDUCE, 260);
   _actionMap[587][COLUMN] = ActionEntry(SHIFT, 449);
   _actionMap[588][ON] = ActionEntry(SHIFT, 686);
   _actionMap[589][SEMICOLON] = ActionEntry(REDUCE, 263);
   _actionMap[589][KSEP] = ActionEntry(REDUCE, 263);
   _actionMap[590][IDENTIFIER] = ActionEntry(SHIFT, 687);
   _actionMap[591][SEMICOLON] = ActionEntry(REDUCE, 262);
   _actionMap[591][KSEP] = ActionEntry(REDUCE, 262);
   _actionMap[592][SEMICOLON] = ActionEntry(REDUCE, 264);
   _actionMap[592][KSEP] = ActionEntry(REDUCE, 264);
   _actionMap[593][TO] = ActionEntry(SHIFT, 688);
   _actionMap[594][IDENTIFIER] = ActionEntry(SHIFT, 689);
   _actionMap[595][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[595][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[595][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[595][KSEP] = ActionEntry(REDUCE, 118);
   _actionMap[595][RB] = ActionEntry(REDUCE, 118);
   _actionMap[596][ELSE] = ActionEntry(REDUCE, 113);
   _actionMap[596][ELSIF] = ActionEntry(REDUCE, 113);
   _actionMap[596][EXCEPTION] = ActionEntry(REDUCE, 113);
   _actionMap[596][END_TOKEN] = ActionEntry(REDUCE, 113);
   _actionMap[597][WHEN] = ActionEntry(SHIFT, 690);
   _actionMap[598][EXCEPTION] = ActionEntry(REDUCE, 92);
   _actionMap[598][END_TOKEN] = ActionEntry(REDUCE, 92);
   _actionMap[598][ELSE] = ActionEntry(REDUCE, 92);
   _actionMap[598][ELSIF] = ActionEntry(REDUCE, 92);
   _actionMap[598][VAR] = ActionEntry(REDUCE, 92);
   _actionMap[598][CURSOR] = ActionEntry(REDUCE, 92);
   _actionMap[598][CLOSE] = ActionEntry(REDUCE, 92);
   _actionMap[598][VARREF] = ActionEntry(REDUCE, 92);
   _actionMap[598][NOOP] = ActionEntry(REDUCE, 92);
   _actionMap[598][RETURNTOKEN] = ActionEntry(REDUCE, 92);
   _actionMap[598][WHILE] = ActionEntry(REDUCE, 92);
   _actionMap[598][IF] = ActionEntry(REDUCE, 92);
   _actionMap[598][BEGIN] = ActionEntry(REDUCE, 92);
   _actionMap[598][ROLLBACK] = ActionEntry(REDUCE, 92);
}
void Cego::loadParser36()
{
   _actionMap[598][COMMIT] = ActionEntry(REDUCE, 92);
   _actionMap[598][START_TOKEN] = ActionEntry(REDUCE, 92);
   _actionMap[598][UPDATE] = ActionEntry(REDUCE, 92);
   _actionMap[598][DELETETOK] = ActionEntry(REDUCE, 92);
   _actionMap[598][INSERT] = ActionEntry(REDUCE, 92);
   _actionMap[598][FETCH] = ActionEntry(REDUCE, 92);
   _actionMap[598][LB] = ActionEntry(REDUCE, 92);
   _actionMap[598][COUNT] = ActionEntry(REDUCE, 92);
   _actionMap[598][SUM] = ActionEntry(REDUCE, 92);
   _actionMap[598][AVG] = ActionEntry(REDUCE, 92);
   _actionMap[598][MIN] = ActionEntry(REDUCE, 92);
   _actionMap[598][MAX] = ActionEntry(REDUCE, 92);
   _actionMap[598][CASE] = ActionEntry(REDUCE, 92);
   _actionMap[598][TRIM] = ActionEntry(REDUCE, 92);
   _actionMap[598][RTRIM] = ActionEntry(REDUCE, 92);
   _actionMap[598][LTRIM] = ActionEntry(REDUCE, 92);
   _actionMap[598][ROUND] = ActionEntry(REDUCE, 92);
   _actionMap[598][DATE2STR] = ActionEntry(REDUCE, 92);
   _actionMap[598][DATE2INT] = ActionEntry(REDUCE, 92);
   _actionMap[598][INT2DATE] = ActionEntry(REDUCE, 92);
   _actionMap[598][LOWER] = ActionEntry(REDUCE, 92);
   _actionMap[598][UPPER] = ActionEntry(REDUCE, 92);
   _actionMap[598][LEFT] = ActionEntry(REDUCE, 92);
   _actionMap[598][RIGHT] = ActionEntry(REDUCE, 92);
   _actionMap[598][GETPOS] = ActionEntry(REDUCE, 92);
   _actionMap[598][SUBSTR] = ActionEntry(REDUCE, 92);
   _actionMap[598][REPLACE] = ActionEntry(REDUCE, 92);
   _actionMap[598][LENGTH] = ActionEntry(REDUCE, 92);
   _actionMap[598][TRUNC] = ActionEntry(REDUCE, 92);
   _actionMap[598][STR2INT] = ActionEntry(REDUCE, 92);
   _actionMap[598][STR2LONG] = ActionEntry(REDUCE, 92);
   _actionMap[598][STR2DATE] = ActionEntry(REDUCE, 92);
   _actionMap[598][RANDSTR] = ActionEntry(REDUCE, 92);
   _actionMap[598][RANDINT] = ActionEntry(REDUCE, 92);
   _actionMap[598][MOD] = ActionEntry(REDUCE, 92);
   _actionMap[598][DIV] = ActionEntry(REDUCE, 92);
   _actionMap[598][POWER] = ActionEntry(REDUCE, 92);
   _actionMap[598][BITAND] = ActionEntry(REDUCE, 92);
   _actionMap[598][BITOR] = ActionEntry(REDUCE, 92);
   _actionMap[598][BITXOR] = ActionEntry(REDUCE, 92);
   _actionMap[598][NEXTCOUNT] = ActionEntry(REDUCE, 92);
   _actionMap[598][SETCOUNT] = ActionEntry(REDUCE, 92);
   _actionMap[598][IDENTIFIER] = ActionEntry(REDUCE, 92);
   _actionMap[598][QUALIFIEDOBJ] = ActionEntry(REDUCE, 92);
   _actionMap[598][QUALIFIEDTS] = ActionEntry(REDUCE, 92);
   _actionMap[598][QUALIFIEDPRE] = ActionEntry(REDUCE, 92);
   _actionMap[598][STRINGVAL] = ActionEntry(REDUCE, 92);
   _actionMap[598][DATE] = ActionEntry(REDUCE, 92);
   _actionMap[598][SYSDATE] = ActionEntry(REDUCE, 92);
   _actionMap[598][NULLTOKEN] = ActionEntry(REDUCE, 92);
}
void Cego::loadParser37()
{
   _actionMap[598][TRUEVAL] = ActionEntry(REDUCE, 92);
   _actionMap[598][FALSEVAL] = ActionEntry(REDUCE, 92);
   _actionMap[598][LAB] = ActionEntry(REDUCE, 92);
   _actionMap[598][FLOATVAL] = ActionEntry(REDUCE, 92);
   _actionMap[598][MINUS] = ActionEntry(REDUCE, 92);
   _actionMap[598][INTVAL] = ActionEntry(REDUCE, 92);
   _actionMap[599][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[600][END_TOKEN] = ActionEntry(SHIFT, 603);
   _actionMap[601][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[601][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[601][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[601][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[601][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[601][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[601][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[601][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[601][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[601][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[601][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[601][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[601][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[601][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[601][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[601][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[601][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[601][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[601][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[601][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[601][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[601][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[601][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[601][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[601][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[601][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[601][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[601][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[601][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[601][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[601][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[601][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[601][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[601][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[601][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[601][LB] = ActionEntry(SHIFT, 142);
   _actionMap[601][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[601][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[601][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[601][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[601][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[601][FALSEVAL] = ActionEntry(SHIFT, 111);
}
void Cego::loadParser38()
{
   _actionMap[601][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[601][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[601][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[601][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[601][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[601][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[601][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[601][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[601][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[601][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[601][IF] = ActionEntry(SHIFT, 338);
   _actionMap[601][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[601][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[601][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[601][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[601][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[601][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[601][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[601][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[601][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[601][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[601][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[601][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[601][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[601][ObjSpec] = 99;
   _jumpMap[601][Constant] = 98;
   _jumpMap[601][SignedFloat] = 97;
   _jumpMap[601][SignedInt] = 96;
   _jumpMap[601][Attribute] = 95;
   _jumpMap[601][Function] = 94;
   _jumpMap[601][DeleteStatement] = 334;
   _jumpMap[601][UpdateStatement] = 333;
   _jumpMap[601][InsertStatement] = 332;
   _jumpMap[601][RollbackStatement] = 331;
   _jumpMap[601][CommitStatement] = 330;
   _jumpMap[601][StartStatement] = 329;
   _jumpMap[601][CasePrepare] = 93;
   _jumpMap[601][CaseClause] = 92;
   _jumpMap[601][Factor] = 91;
   _jumpMap[601][Term] = 90;
   _jumpMap[601][Expr] = 328;
   _jumpMap[601][ProcStatement] = 327;
   _jumpMap[601][ProcIfPart] = 326;
   _jumpMap[601][ProcBlockStart] = 325;
   _jumpMap[601][ProcStatementList] = 324;
   _jumpMap[601][ProcStmtBlock] = 691;
   _actionMap[602][VAR] = ActionEntry(REDUCE, 128);
   _actionMap[602][CURSOR] = ActionEntry(REDUCE, 128);
   _actionMap[602][CLOSE] = ActionEntry(REDUCE, 128);
   _actionMap[602][VARREF] = ActionEntry(REDUCE, 128);
}
void Cego::loadParser39()
{
   _actionMap[602][NOOP] = ActionEntry(REDUCE, 128);
   _actionMap[602][RETURNTOKEN] = ActionEntry(REDUCE, 128);
   _actionMap[602][WHILE] = ActionEntry(REDUCE, 128);
   _actionMap[602][IF] = ActionEntry(REDUCE, 128);
   _actionMap[602][BEGIN] = ActionEntry(REDUCE, 128);
   _actionMap[602][ROLLBACK] = ActionEntry(REDUCE, 128);
   _actionMap[602][COMMIT] = ActionEntry(REDUCE, 128);
   _actionMap[602][START_TOKEN] = ActionEntry(REDUCE, 128);
   _actionMap[602][UPDATE] = ActionEntry(REDUCE, 128);
   _actionMap[602][DELETETOK] = ActionEntry(REDUCE, 128);
   _actionMap[602][INSERT] = ActionEntry(REDUCE, 128);
   _actionMap[602][FETCH] = ActionEntry(REDUCE, 128);
   _actionMap[602][LB] = ActionEntry(REDUCE, 128);
   _actionMap[602][COUNT] = ActionEntry(REDUCE, 128);
   _actionMap[602][SUM] = ActionEntry(REDUCE, 128);
   _actionMap[602][AVG] = ActionEntry(REDUCE, 128);
   _actionMap[602][MIN] = ActionEntry(REDUCE, 128);
   _actionMap[602][MAX] = ActionEntry(REDUCE, 128);
   _actionMap[602][CASE] = ActionEntry(REDUCE, 128);
   _actionMap[602][TRIM] = ActionEntry(REDUCE, 128);
   _actionMap[602][RTRIM] = ActionEntry(REDUCE, 128);
   _actionMap[602][LTRIM] = ActionEntry(REDUCE, 128);
   _actionMap[602][ROUND] = ActionEntry(REDUCE, 128);
   _actionMap[602][DATE2STR] = ActionEntry(REDUCE, 128);
   _actionMap[602][DATE2INT] = ActionEntry(REDUCE, 128);
   _actionMap[602][INT2DATE] = ActionEntry(REDUCE, 128);
   _actionMap[602][LOWER] = ActionEntry(REDUCE, 128);
   _actionMap[602][UPPER] = ActionEntry(REDUCE, 128);
   _actionMap[602][LEFT] = ActionEntry(REDUCE, 128);
   _actionMap[602][RIGHT] = ActionEntry(REDUCE, 128);
   _actionMap[602][GETPOS] = ActionEntry(REDUCE, 128);
   _actionMap[602][SUBSTR] = ActionEntry(REDUCE, 128);
   _actionMap[602][REPLACE] = ActionEntry(REDUCE, 128);
   _actionMap[602][LENGTH] = ActionEntry(REDUCE, 128);
   _actionMap[602][TRUNC] = ActionEntry(REDUCE, 128);
   _actionMap[602][STR2INT] = ActionEntry(REDUCE, 128);
   _actionMap[602][STR2LONG] = ActionEntry(REDUCE, 128);
   _actionMap[602][STR2DATE] = ActionEntry(REDUCE, 128);
   _actionMap[602][RANDSTR] = ActionEntry(REDUCE, 128);
   _actionMap[602][RANDINT] = ActionEntry(REDUCE, 128);
   _actionMap[602][MOD] = ActionEntry(REDUCE, 128);
   _actionMap[602][DIV] = ActionEntry(REDUCE, 128);
   _actionMap[602][POWER] = ActionEntry(REDUCE, 128);
   _actionMap[602][BITAND] = ActionEntry(REDUCE, 128);
   _actionMap[602][BITOR] = ActionEntry(REDUCE, 128);
   _actionMap[602][BITXOR] = ActionEntry(REDUCE, 128);
   _actionMap[602][NEXTCOUNT] = ActionEntry(REDUCE, 128);
   _actionMap[602][SETCOUNT] = ActionEntry(REDUCE, 128);
   _actionMap[602][IDENTIFIER] = ActionEntry(REDUCE, 128);
   _actionMap[602][QUALIFIEDOBJ] = ActionEntry(REDUCE, 128);
}
void Cego::loadParser40()
{
   _actionMap[602][QUALIFIEDTS] = ActionEntry(REDUCE, 128);
   _actionMap[602][QUALIFIEDPRE] = ActionEntry(REDUCE, 128);
   _actionMap[602][STRINGVAL] = ActionEntry(REDUCE, 128);
   _actionMap[602][DATE] = ActionEntry(REDUCE, 128);
   _actionMap[602][SYSDATE] = ActionEntry(REDUCE, 128);
   _actionMap[602][NULLTOKEN] = ActionEntry(REDUCE, 128);
   _actionMap[602][TRUEVAL] = ActionEntry(REDUCE, 128);
   _actionMap[602][FALSEVAL] = ActionEntry(REDUCE, 128);
   _actionMap[602][LAB] = ActionEntry(REDUCE, 128);
   _actionMap[602][FLOATVAL] = ActionEntry(REDUCE, 128);
   _actionMap[602][MINUS] = ActionEntry(REDUCE, 128);
   _actionMap[602][INTVAL] = ActionEntry(REDUCE, 128);
   _actionMap[603][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[604][END_TOKEN] = ActionEntry(REDUCE, 123);
   _actionMap[604][ELSE] = ActionEntry(REDUCE, 123);
   _actionMap[605][THEN] = ActionEntry(SHIFT, 692);
   _actionMap[606][OR] = ActionEntry(SHIFT, 610);
   _actionMap[606][AND] = ActionEntry(SHIFT, 609);
   _actionMap[606][THEN] = ActionEntry(REDUCE, 130);
   _actionMap[607][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[607][SelectStatement] = 693;
   _actionMap[608][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[608][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[608][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[608][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[608][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[608][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[608][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[608][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[608][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[608][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[608][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[608][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[608][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[608][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[608][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[608][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[608][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[608][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[608][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[608][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[608][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[608][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[608][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[608][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[608][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[608][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[608][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[608][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[608][BITOR] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser41()
{
   _actionMap[608][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[608][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[608][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[608][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[608][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[608][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[608][LB] = ActionEntry(SHIFT, 142);
   _actionMap[608][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[608][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[608][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[608][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[608][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[608][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[608][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[608][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[608][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[608][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[608][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[608][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[608][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[608][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[608][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[608][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[608][IF] = ActionEntry(SHIFT, 338);
   _actionMap[608][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[608][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[608][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[608][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[608][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[608][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[608][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[608][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[608][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[608][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[608][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[608][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[608][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[608][ObjSpec] = 99;
   _jumpMap[608][Constant] = 98;
   _jumpMap[608][SignedFloat] = 97;
   _jumpMap[608][SignedInt] = 96;
   _jumpMap[608][Attribute] = 95;
   _jumpMap[608][Function] = 94;
   _jumpMap[608][DeleteStatement] = 334;
   _jumpMap[608][UpdateStatement] = 333;
   _jumpMap[608][InsertStatement] = 332;
   _jumpMap[608][RollbackStatement] = 331;
   _jumpMap[608][CommitStatement] = 330;
   _jumpMap[608][StartStatement] = 329;
   _jumpMap[608][CasePrepare] = 93;
}
void Cego::loadParser42()
{
   _jumpMap[608][CaseClause] = 92;
   _jumpMap[608][Factor] = 91;
   _jumpMap[608][Term] = 90;
   _jumpMap[608][Expr] = 328;
   _jumpMap[608][ProcStatement] = 327;
   _jumpMap[608][ProcIfPart] = 326;
   _jumpMap[608][ProcBlockStart] = 325;
   _jumpMap[608][ProcStatementList] = 324;
   _jumpMap[608][ProcStmtBlock] = 694;
   _actionMap[609][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[609][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[609][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[609][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[609][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[609][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[609][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[609][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[609][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[609][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[609][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[609][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[609][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[609][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[609][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[609][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[609][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[609][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[609][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[609][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[609][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[609][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[609][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[609][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[609][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[609][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[609][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[609][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[609][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[609][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[609][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[609][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[609][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[609][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[609][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[609][LB] = ActionEntry(SHIFT, 470);
   _actionMap[609][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[609][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[609][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[609][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[609][TRUEVAL] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser43()
{
   _actionMap[609][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[609][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[609][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[609][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[609][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[609][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[609][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[609][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[609][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[609][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[609][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[609][ObjSpec] = 99;
   _jumpMap[609][Constant] = 98;
   _jumpMap[609][SignedFloat] = 97;
   _jumpMap[609][SignedInt] = 96;
   _jumpMap[609][Attribute] = 95;
   _jumpMap[609][Function] = 94;
   _jumpMap[609][CasePrepare] = 93;
   _jumpMap[609][CaseClause] = 92;
   _jumpMap[609][Factor] = 91;
   _jumpMap[609][Term] = 90;
   _jumpMap[609][Expr] = 469;
   _jumpMap[609][ProcPredicate] = 695;
   _actionMap[610][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[610][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[610][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[610][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[610][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[610][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[610][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[610][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[610][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[610][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[610][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[610][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[610][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[610][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[610][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[610][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[610][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[610][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[610][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[610][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[610][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[610][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[610][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[610][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[610][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[610][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[610][POWER] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser44()
{
   _actionMap[610][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[610][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[610][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[610][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[610][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[610][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[610][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[610][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[610][LB] = ActionEntry(SHIFT, 470);
   _actionMap[610][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[610][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[610][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[610][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[610][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[610][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[610][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[610][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[610][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[610][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[610][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[610][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[610][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[610][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[610][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[610][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[610][ObjSpec] = 99;
   _jumpMap[610][Constant] = 98;
   _jumpMap[610][SignedFloat] = 97;
   _jumpMap[610][SignedInt] = 96;
   _jumpMap[610][Attribute] = 95;
   _jumpMap[610][Function] = 94;
   _jumpMap[610][CasePrepare] = 93;
   _jumpMap[610][CaseClause] = 92;
   _jumpMap[610][Factor] = 91;
   _jumpMap[610][Term] = 90;
   _jumpMap[610][Expr] = 469;
   _jumpMap[610][ProcPredicate] = 696;
   _actionMap[611][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[611][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[611][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[611][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[611][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[611][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[611][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[611][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[611][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[611][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[611][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[611][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[611][LEFT] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser45()
{
   _actionMap[611][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[611][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[611][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[611][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[611][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[611][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[611][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[611][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[611][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[611][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[611][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[611][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[611][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[611][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[611][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[611][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[611][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[611][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[611][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[611][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[611][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[611][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[611][LB] = ActionEntry(SHIFT, 142);
   _actionMap[611][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[611][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[611][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[611][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[611][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[611][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[611][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[611][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[611][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[611][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[611][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[611][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[611][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[611][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[611][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[611][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[611][ObjSpec] = 99;
   _jumpMap[611][Constant] = 98;
   _jumpMap[611][SignedFloat] = 97;
   _jumpMap[611][SignedInt] = 96;
   _jumpMap[611][Attribute] = 95;
   _jumpMap[611][Function] = 94;
   _jumpMap[611][CasePrepare] = 93;
   _jumpMap[611][CaseClause] = 92;
   _jumpMap[611][Factor] = 91;
   _jumpMap[611][Term] = 90;
   _jumpMap[611][Expr] = 697;
}
void Cego::loadParser46()
{
   _actionMap[612][NOT] = ActionEntry(SHIFT, 698);
   _actionMap[612][NULLTOKEN] = ActionEntry(SHIFT, 699);
   _actionMap[613][RB] = ActionEntry(SHIFT, 700);
   _actionMap[613][OR] = ActionEntry(SHIFT, 610);
   _actionMap[613][AND] = ActionEntry(SHIFT, 609);
   _actionMap[614][RB] = ActionEntry(SHIFT, 416);
   _actionMap[614][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[614][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[614][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[614][IS] = ActionEntry(SHIFT, 612);
   _actionMap[614][EQU] = ActionEntry(SHIFT, 503);
   _actionMap[614][NEGATION] = ActionEntry(SHIFT, 506);
   _actionMap[614][LT] = ActionEntry(SHIFT, 504);
   _actionMap[614][MT] = ActionEntry(SHIFT, 505);
   _jumpMap[614][Comparison] = 611;
   _actionMap[615][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[615][EQU] = ActionEntry(SHIFT, 703);
   _jumpMap[615][ProcNoAssignment] = 702;
   _jumpMap[615][ProcInitialAssignment] = 701;
   _actionMap[616][LB] = ActionEntry(SHIFT, 704);
   _actionMap[617][BEGIN] = ActionEntry(REDUCE, 334);
   _actionMap[617][DEFAULT] = ActionEntry(REDUCE, 334);
   _actionMap[617][NULLTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[617][NOT] = ActionEntry(REDUCE, 334);
   _actionMap[617][KSEP] = ActionEntry(REDUCE, 334);
   _actionMap[617][RB] = ActionEntry(REDUCE, 334);
   _actionMap[617][EQU] = ActionEntry(REDUCE, 334);
   _actionMap[617][SEMICOLON] = ActionEntry(REDUCE, 334);
   _actionMap[618][BEGIN] = ActionEntry(REDUCE, 326);
   _actionMap[618][DEFAULT] = ActionEntry(REDUCE, 326);
   _actionMap[618][NULLTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[618][NOT] = ActionEntry(REDUCE, 326);
   _actionMap[618][KSEP] = ActionEntry(REDUCE, 326);
   _actionMap[618][RB] = ActionEntry(REDUCE, 326);
   _actionMap[618][EQU] = ActionEntry(REDUCE, 326);
   _actionMap[618][SEMICOLON] = ActionEntry(REDUCE, 326);
   _actionMap[619][BEGIN] = ActionEntry(REDUCE, 325);
   _actionMap[619][DEFAULT] = ActionEntry(REDUCE, 325);
   _actionMap[619][NULLTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[619][NOT] = ActionEntry(REDUCE, 325);
   _actionMap[619][KSEP] = ActionEntry(REDUCE, 325);
   _actionMap[619][RB] = ActionEntry(REDUCE, 325);
   _actionMap[619][EQU] = ActionEntry(REDUCE, 325);
   _actionMap[619][SEMICOLON] = ActionEntry(REDUCE, 325);
   _actionMap[620][LB] = ActionEntry(SHIFT, 705);
   _actionMap[621][BEGIN] = ActionEntry(REDUCE, 329);
   _actionMap[621][DEFAULT] = ActionEntry(REDUCE, 329);
   _actionMap[621][NULLTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[621][NOT] = ActionEntry(REDUCE, 329);
   _actionMap[621][KSEP] = ActionEntry(REDUCE, 329);
}
void Cego::loadParser47()
{
   _actionMap[621][RB] = ActionEntry(REDUCE, 329);
   _actionMap[621][EQU] = ActionEntry(REDUCE, 329);
   _actionMap[621][SEMICOLON] = ActionEntry(REDUCE, 329);
   _actionMap[622][LB] = ActionEntry(SHIFT, 706);
   _actionMap[623][BEGIN] = ActionEntry(REDUCE, 328);
   _actionMap[623][DEFAULT] = ActionEntry(REDUCE, 328);
   _actionMap[623][NULLTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[623][NOT] = ActionEntry(REDUCE, 328);
   _actionMap[623][KSEP] = ActionEntry(REDUCE, 328);
   _actionMap[623][RB] = ActionEntry(REDUCE, 328);
   _actionMap[623][EQU] = ActionEntry(REDUCE, 328);
   _actionMap[623][SEMICOLON] = ActionEntry(REDUCE, 328);
   _actionMap[624][BEGIN] = ActionEntry(REDUCE, 322);
   _actionMap[624][DEFAULT] = ActionEntry(REDUCE, 322);
   _actionMap[624][NULLTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[624][NOT] = ActionEntry(REDUCE, 322);
   _actionMap[624][KSEP] = ActionEntry(REDUCE, 322);
   _actionMap[624][RB] = ActionEntry(REDUCE, 322);
   _actionMap[624][EQU] = ActionEntry(REDUCE, 322);
   _actionMap[624][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[625][BEGIN] = ActionEntry(REDUCE, 323);
   _actionMap[625][DEFAULT] = ActionEntry(REDUCE, 323);
   _actionMap[625][NULLTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[625][NOT] = ActionEntry(REDUCE, 323);
   _actionMap[625][KSEP] = ActionEntry(REDUCE, 323);
   _actionMap[625][RB] = ActionEntry(REDUCE, 323);
   _actionMap[625][EQU] = ActionEntry(REDUCE, 323);
   _actionMap[625][SEMICOLON] = ActionEntry(REDUCE, 323);
   _actionMap[626][BEGIN] = ActionEntry(REDUCE, 330);
   _actionMap[626][DEFAULT] = ActionEntry(REDUCE, 330);
   _actionMap[626][NULLTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[626][NOT] = ActionEntry(REDUCE, 330);
   _actionMap[626][KSEP] = ActionEntry(REDUCE, 330);
   _actionMap[626][RB] = ActionEntry(REDUCE, 330);
   _actionMap[626][EQU] = ActionEntry(REDUCE, 330);
   _actionMap[626][SEMICOLON] = ActionEntry(REDUCE, 330);
   _actionMap[627][LB] = ActionEntry(SHIFT, 707);
   _actionMap[628][BEGIN] = ActionEntry(REDUCE, 331);
   _actionMap[628][DEFAULT] = ActionEntry(REDUCE, 331);
   _actionMap[628][NULLTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[628][NOT] = ActionEntry(REDUCE, 331);
   _actionMap[628][KSEP] = ActionEntry(REDUCE, 331);
   _actionMap[628][RB] = ActionEntry(REDUCE, 331);
   _actionMap[628][EQU] = ActionEntry(REDUCE, 331);
   _actionMap[628][SEMICOLON] = ActionEntry(REDUCE, 331);
   _actionMap[629][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[629][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[629][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[629][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[629][RTRIM] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser48()
{
   _actionMap[629][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[629][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[629][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[629][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[629][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[629][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[629][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[629][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[629][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[629][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[629][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[629][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[629][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[629][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[629][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[629][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[629][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[629][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[629][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[629][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[629][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[629][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[629][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[629][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[629][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[629][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[629][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[629][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[629][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[629][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[629][LB] = ActionEntry(SHIFT, 142);
   _actionMap[629][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[629][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[629][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[629][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[629][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[629][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[629][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[629][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[629][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[629][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[629][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[629][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[629][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[629][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[629][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[629][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[629][IF] = ActionEntry(SHIFT, 338);
   _actionMap[629][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[629][ROLLBACK] = ActionEntry(SHIFT, 29);
}
void Cego::loadParser49()
{
   _actionMap[629][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[629][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[629][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[629][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[629][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[629][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[629][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[629][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[629][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[629][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[629][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[629][ObjSpec] = 99;
   _jumpMap[629][Constant] = 98;
   _jumpMap[629][SignedFloat] = 97;
   _jumpMap[629][SignedInt] = 96;
   _jumpMap[629][Attribute] = 95;
   _jumpMap[629][Function] = 94;
   _jumpMap[629][DeleteStatement] = 334;
   _jumpMap[629][UpdateStatement] = 333;
   _jumpMap[629][InsertStatement] = 332;
   _jumpMap[629][RollbackStatement] = 331;
   _jumpMap[629][CommitStatement] = 330;
   _jumpMap[629][StartStatement] = 329;
   _jumpMap[629][CasePrepare] = 93;
   _jumpMap[629][CaseClause] = 92;
   _jumpMap[629][Factor] = 91;
   _jumpMap[629][Term] = 90;
   _jumpMap[629][Expr] = 328;
   _jumpMap[629][ProcStatement] = 327;
   _jumpMap[629][ProcIfPart] = 326;
   _jumpMap[629][ProcBlockStart] = 325;
   _jumpMap[629][ProcStatementList] = 324;
   _jumpMap[629][ProcStmtBlock] = 708;
   _actionMap[630][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[630][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[630][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[630][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[631][LB] = ActionEntry(SHIFT, 709);
   _actionMap[632][IDENTIFIER] = ActionEntry(SHIFT, 712);
   _jumpMap[632][SimpleAttr] = 711;
   _jumpMap[632][SimpleAttrList] = 710;
   _actionMap[633][IDENTIFIER] = ActionEntry(SHIFT, 482);
   _jumpMap[633][ProcArg] = 713;
   _actionMap[634][BEGIN] = ActionEntry(REDUCE, 81);
   _actionMap[635][INT] = ActionEntry(SHIFT, 624);
   _actionMap[635][LONG] = ActionEntry(SHIFT, 625);
   _actionMap[635][STRING] = ActionEntry(SHIFT, 627);
   _actionMap[635][DATETIME] = ActionEntry(SHIFT, 619);
   _actionMap[635][BOOL] = ActionEntry(SHIFT, 618);
   _actionMap[635][BIGINT] = ActionEntry(SHIFT, 616);
}
void Cego::loadParser50()
{
   _actionMap[635][FLOAT] = ActionEntry(SHIFT, 623);
   _actionMap[635][DOUBLE] = ActionEntry(SHIFT, 621);
   _actionMap[635][SMALLINT] = ActionEntry(SHIFT, 626);
   _actionMap[635][TINYINT] = ActionEntry(SHIFT, 628);
   _actionMap[635][DECIMAL] = ActionEntry(SHIFT, 620);
   _actionMap[635][FIXED] = ActionEntry(SHIFT, 622);
   _actionMap[635][BLOB] = ActionEntry(SHIFT, 617);
   _jumpMap[635][DataTypeProd] = 714;
   _actionMap[636][INT] = ActionEntry(SHIFT, 624);
   _actionMap[636][LONG] = ActionEntry(SHIFT, 625);
   _actionMap[636][STRING] = ActionEntry(SHIFT, 627);
   _actionMap[636][DATETIME] = ActionEntry(SHIFT, 619);
   _actionMap[636][BOOL] = ActionEntry(SHIFT, 618);
   _actionMap[636][BIGINT] = ActionEntry(SHIFT, 616);
   _actionMap[636][FLOAT] = ActionEntry(SHIFT, 623);
   _actionMap[636][DOUBLE] = ActionEntry(SHIFT, 621);
   _actionMap[636][SMALLINT] = ActionEntry(SHIFT, 626);
   _actionMap[636][TINYINT] = ActionEntry(SHIFT, 628);
   _actionMap[636][DECIMAL] = ActionEntry(SHIFT, 620);
   _actionMap[636][FIXED] = ActionEntry(SHIFT, 622);
   _actionMap[636][BLOB] = ActionEntry(SHIFT, 617);
   _jumpMap[636][DataTypeProd] = 715;
   _actionMap[637][INT] = ActionEntry(SHIFT, 624);
   _actionMap[637][LONG] = ActionEntry(SHIFT, 625);
   _actionMap[637][STRING] = ActionEntry(SHIFT, 627);
   _actionMap[637][DATETIME] = ActionEntry(SHIFT, 619);
   _actionMap[637][BOOL] = ActionEntry(SHIFT, 618);
   _actionMap[637][BIGINT] = ActionEntry(SHIFT, 616);
   _actionMap[637][FLOAT] = ActionEntry(SHIFT, 623);
   _actionMap[637][DOUBLE] = ActionEntry(SHIFT, 621);
   _actionMap[637][SMALLINT] = ActionEntry(SHIFT, 626);
   _actionMap[637][TINYINT] = ActionEntry(SHIFT, 628);
   _actionMap[637][DECIMAL] = ActionEntry(SHIFT, 620);
   _actionMap[637][FIXED] = ActionEntry(SHIFT, 622);
   _actionMap[637][BLOB] = ActionEntry(SHIFT, 617);
   _jumpMap[637][DataTypeProd] = 716;
   _actionMap[638][IDENTIFIER] = ActionEntry(SHIFT, 487);
   _actionMap[638][PRIMARY] = ActionEntry(SHIFT, 486);
   _jumpMap[638][ColumnDesc] = 485;
   _jumpMap[638][KeyColumn] = 717;
   _actionMap[639][SEMICOLON] = ActionEntry(REDUCE, 55);
   _actionMap[640][KSEP] = ActionEntry(REDUCE, 170);
   _actionMap[640][RB] = ActionEntry(REDUCE, 170);
   _actionMap[641][RB] = ActionEntry(REDUCE, 179);
   _actionMap[641][SEMICOLON] = ActionEntry(REDUCE, 179);
   _actionMap[641][KSEP] = ActionEntry(REDUCE, 179);
   _actionMap[641][NOT] = ActionEntry(REDUCE, 179);
   _actionMap[641][NULLTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[641][DEFAULT] = ActionEntry(SHIFT, 720);
   _jumpMap[641][DefaultDefOpt] = 719;
}
void Cego::loadParser51()
{
   _jumpMap[641][DefaultOpt] = 718;
   _actionMap[642][LB] = ActionEntry(SHIFT, 492);
   _jumpMap[642][InsertValueSpec] = 721;
   _actionMap[643][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[643][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[643][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[643][KSEP] = ActionEntry(REDUCE, 201);
   _actionMap[643][RB] = ActionEntry(REDUCE, 201);
   _actionMap[644][RB] = ActionEntry(SHIFT, 723);
   _actionMap[644][KSEP] = ActionEntry(SHIFT, 722);
   _actionMap[645][IDENTIFIER] = ActionEntry(SHIFT, 724);
   _actionMap[646][SELECT] = ActionEntry(REDUCE, 192);
   _actionMap[646][VALUES] = ActionEntry(REDUCE, 192);
   _actionMap[647][WHEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][ELSE] = ActionEntry(REDUCE, 161);
   _actionMap[647][LEFT] = ActionEntry(REDUCE, 161);
   _actionMap[647][RIGHT] = ActionEntry(REDUCE, 161);
   _actionMap[647][INNER] = ActionEntry(REDUCE, 161);
   _actionMap[647][JOIN] = ActionEntry(REDUCE, 161);
   _actionMap[647][RETURNTOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][ORDER] = ActionEntry(REDUCE, 161);
   _actionMap[647][GROUP] = ActionEntry(REDUCE, 161);
   _actionMap[647][WHERE] = ActionEntry(REDUCE, 161);
   _actionMap[647][BEGIN] = ActionEntry(REDUCE, 161);
   _actionMap[647][THEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][OR] = ActionEntry(REDUCE, 161);
   _actionMap[647][FROM] = ActionEntry(REDUCE, 161);
   _actionMap[647][AS] = ActionEntry(REDUCE, 161);
   _actionMap[647][END_TOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][AND] = ActionEntry(REDUCE, 161);
   _actionMap[647][INTOK] = ActionEntry(REDUCE, 161);
   _actionMap[647][NOT] = ActionEntry(REDUCE, 161);
   _actionMap[647][BETWEEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][IS] = ActionEntry(REDUCE, 161);
   _actionMap[647][LIKE] = ActionEntry(REDUCE, 161);
   _actionMap[647][MT] = ActionEntry(REDUCE, 161);
   _actionMap[647][LT] = ActionEntry(REDUCE, 161);
   _actionMap[647][NEGATION] = ActionEntry(REDUCE, 161);
   _actionMap[647][EQU] = ActionEntry(REDUCE, 161);
   _actionMap[647][RB] = ActionEntry(REDUCE, 161);
   _actionMap[647][ENDTOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[647][UNION] = ActionEntry(REDUCE, 161);
   _actionMap[647][ROWLIMIT] = ActionEntry(REDUCE, 161);
   _actionMap[647][KSEP] = ActionEntry(REDUCE, 161);
   _actionMap[647][ASC] = ActionEntry(REDUCE, 161);
   _actionMap[647][DESC] = ActionEntry(REDUCE, 161);
   _actionMap[647][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[647][PLUS] = ActionEntry(REDUCE, 161);
   _actionMap[647][MINUS] = ActionEntry(REDUCE, 161);
   _actionMap[647][DIVISION] = ActionEntry(REDUCE, 161);
}
void Cego::loadParser52()
{
   _actionMap[647][STAR] = ActionEntry(REDUCE, 161);
   _actionMap[647][CONCAT] = ActionEntry(REDUCE, 161);
   _actionMap[648][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[648][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[648][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[648][LEFT] = ActionEntry(REDUCE, 314);
   _actionMap[648][RIGHT] = ActionEntry(REDUCE, 314);
   _actionMap[648][INNER] = ActionEntry(REDUCE, 314);
   _actionMap[648][JOIN] = ActionEntry(REDUCE, 314);
   _actionMap[648][RETURNTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[648][SEMICOLON] = ActionEntry(REDUCE, 314);
   _actionMap[648][ENDTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[648][UNION] = ActionEntry(REDUCE, 314);
   _actionMap[648][ROWLIMIT] = ActionEntry(REDUCE, 314);
   _actionMap[648][ORDER] = ActionEntry(REDUCE, 314);
   _actionMap[648][GROUP] = ActionEntry(REDUCE, 314);
   _actionMap[648][WHERE] = ActionEntry(REDUCE, 314);
   _actionMap[648][THEN] = ActionEntry(REDUCE, 314);
   _actionMap[648][AND] = ActionEntry(REDUCE, 314);
   _actionMap[648][OR] = ActionEntry(REDUCE, 314);
   _actionMap[648][RB] = ActionEntry(REDUCE, 314);
   _actionMap[649][AND] = ActionEntry(SHIFT, 725);
   _actionMap[649][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[649][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[649][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[650][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[650][SelectStatement] = 726;
   _actionMap[651][NULLTOKEN] = ActionEntry(SHIFT, 727);
   _actionMap[652][LEFT] = ActionEntry(REDUCE, 316);
   _actionMap[652][RIGHT] = ActionEntry(REDUCE, 316);
   _actionMap[652][INNER] = ActionEntry(REDUCE, 316);
   _actionMap[652][JOIN] = ActionEntry(REDUCE, 316);
   _actionMap[652][RETURNTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[652][SEMICOLON] = ActionEntry(REDUCE, 316);
   _actionMap[652][ENDTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[652][UNION] = ActionEntry(REDUCE, 316);
   _actionMap[652][ROWLIMIT] = ActionEntry(REDUCE, 316);
   _actionMap[652][ORDER] = ActionEntry(REDUCE, 316);
   _actionMap[652][GROUP] = ActionEntry(REDUCE, 316);
   _actionMap[652][WHERE] = ActionEntry(REDUCE, 316);
   _actionMap[652][THEN] = ActionEntry(REDUCE, 316);
   _actionMap[652][AND] = ActionEntry(REDUCE, 316);
   _actionMap[652][OR] = ActionEntry(REDUCE, 316);
   _actionMap[652][RB] = ActionEntry(REDUCE, 316);
   _actionMap[653][LEFT] = ActionEntry(REDUCE, 318);
   _actionMap[653][RIGHT] = ActionEntry(REDUCE, 318);
   _actionMap[653][INNER] = ActionEntry(REDUCE, 318);
   _actionMap[653][JOIN] = ActionEntry(REDUCE, 318);
   _actionMap[653][RETURNTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[653][SEMICOLON] = ActionEntry(REDUCE, 318);
}
void Cego::loadParser53()
{
   _actionMap[653][ENDTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[653][UNION] = ActionEntry(REDUCE, 318);
   _actionMap[653][ROWLIMIT] = ActionEntry(REDUCE, 318);
   _actionMap[653][ORDER] = ActionEntry(REDUCE, 318);
   _actionMap[653][GROUP] = ActionEntry(REDUCE, 318);
   _actionMap[653][WHERE] = ActionEntry(REDUCE, 318);
   _actionMap[653][THEN] = ActionEntry(REDUCE, 318);
   _actionMap[653][AND] = ActionEntry(REDUCE, 318);
   _actionMap[653][OR] = ActionEntry(REDUCE, 318);
   _actionMap[653][RB] = ActionEntry(REDUCE, 318);
   _actionMap[654][LB] = ActionEntry(SHIFT, 728);
   _actionMap[655][STRINGVAL] = ActionEntry(SHIFT, 729);
   _actionMap[656][VARREF] = ActionEntry(REDUCE, 339);
   _actionMap[656][FETCH] = ActionEntry(REDUCE, 339);
   _actionMap[656][LB] = ActionEntry(REDUCE, 339);
   _actionMap[656][COUNT] = ActionEntry(REDUCE, 339);
   _actionMap[656][SUM] = ActionEntry(REDUCE, 339);
   _actionMap[656][AVG] = ActionEntry(REDUCE, 339);
   _actionMap[656][MIN] = ActionEntry(REDUCE, 339);
   _actionMap[656][MAX] = ActionEntry(REDUCE, 339);
   _actionMap[656][CASE] = ActionEntry(REDUCE, 339);
   _actionMap[656][TRIM] = ActionEntry(REDUCE, 339);
   _actionMap[656][RTRIM] = ActionEntry(REDUCE, 339);
   _actionMap[656][LTRIM] = ActionEntry(REDUCE, 339);
   _actionMap[656][ROUND] = ActionEntry(REDUCE, 339);
   _actionMap[656][DATE2STR] = ActionEntry(REDUCE, 339);
   _actionMap[656][DATE2INT] = ActionEntry(REDUCE, 339);
   _actionMap[656][INT2DATE] = ActionEntry(REDUCE, 339);
   _actionMap[656][LOWER] = ActionEntry(REDUCE, 339);
   _actionMap[656][UPPER] = ActionEntry(REDUCE, 339);
   _actionMap[656][LEFT] = ActionEntry(REDUCE, 339);
   _actionMap[656][RIGHT] = ActionEntry(REDUCE, 339);
   _actionMap[656][GETPOS] = ActionEntry(REDUCE, 339);
   _actionMap[656][SUBSTR] = ActionEntry(REDUCE, 339);
   _actionMap[656][REPLACE] = ActionEntry(REDUCE, 339);
   _actionMap[656][LENGTH] = ActionEntry(REDUCE, 339);
   _actionMap[656][TRUNC] = ActionEntry(REDUCE, 339);
   _actionMap[656][STR2INT] = ActionEntry(REDUCE, 339);
   _actionMap[656][STR2LONG] = ActionEntry(REDUCE, 339);
   _actionMap[656][STR2DATE] = ActionEntry(REDUCE, 339);
   _actionMap[656][RANDSTR] = ActionEntry(REDUCE, 339);
   _actionMap[656][RANDINT] = ActionEntry(REDUCE, 339);
   _actionMap[656][MOD] = ActionEntry(REDUCE, 339);
   _actionMap[656][DIV] = ActionEntry(REDUCE, 339);
   _actionMap[656][POWER] = ActionEntry(REDUCE, 339);
   _actionMap[656][BITAND] = ActionEntry(REDUCE, 339);
   _actionMap[656][BITOR] = ActionEntry(REDUCE, 339);
   _actionMap[656][BITXOR] = ActionEntry(REDUCE, 339);
   _actionMap[656][NEXTCOUNT] = ActionEntry(REDUCE, 339);
   _actionMap[656][SETCOUNT] = ActionEntry(REDUCE, 339);
}
void Cego::loadParser54()
{
   _actionMap[656][IDENTIFIER] = ActionEntry(REDUCE, 339);
   _actionMap[656][QUALIFIEDOBJ] = ActionEntry(REDUCE, 339);
   _actionMap[656][QUALIFIEDTS] = ActionEntry(REDUCE, 339);
   _actionMap[656][QUALIFIEDPRE] = ActionEntry(REDUCE, 339);
   _actionMap[656][STRINGVAL] = ActionEntry(REDUCE, 339);
   _actionMap[656][DATE] = ActionEntry(REDUCE, 339);
   _actionMap[656][SYSDATE] = ActionEntry(REDUCE, 339);
   _actionMap[656][NULLTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[656][TRUEVAL] = ActionEntry(REDUCE, 339);
   _actionMap[656][FALSEVAL] = ActionEntry(REDUCE, 339);
   _actionMap[656][LAB] = ActionEntry(REDUCE, 339);
   _actionMap[656][FLOATVAL] = ActionEntry(REDUCE, 339);
   _actionMap[656][MINUS] = ActionEntry(REDUCE, 339);
   _actionMap[656][INTVAL] = ActionEntry(REDUCE, 339);
   _actionMap[657][VARREF] = ActionEntry(REDUCE, 340);
   _actionMap[657][FETCH] = ActionEntry(REDUCE, 340);
   _actionMap[657][LB] = ActionEntry(REDUCE, 340);
   _actionMap[657][COUNT] = ActionEntry(REDUCE, 340);
   _actionMap[657][SUM] = ActionEntry(REDUCE, 340);
   _actionMap[657][AVG] = ActionEntry(REDUCE, 340);
   _actionMap[657][MIN] = ActionEntry(REDUCE, 340);
   _actionMap[657][MAX] = ActionEntry(REDUCE, 340);
   _actionMap[657][CASE] = ActionEntry(REDUCE, 340);
   _actionMap[657][TRIM] = ActionEntry(REDUCE, 340);
   _actionMap[657][RTRIM] = ActionEntry(REDUCE, 340);
   _actionMap[657][LTRIM] = ActionEntry(REDUCE, 340);
   _actionMap[657][ROUND] = ActionEntry(REDUCE, 340);
   _actionMap[657][DATE2STR] = ActionEntry(REDUCE, 340);
   _actionMap[657][DATE2INT] = ActionEntry(REDUCE, 340);
   _actionMap[657][INT2DATE] = ActionEntry(REDUCE, 340);
   _actionMap[657][LOWER] = ActionEntry(REDUCE, 340);
   _actionMap[657][UPPER] = ActionEntry(REDUCE, 340);
   _actionMap[657][LEFT] = ActionEntry(REDUCE, 340);
   _actionMap[657][RIGHT] = ActionEntry(REDUCE, 340);
   _actionMap[657][GETPOS] = ActionEntry(REDUCE, 340);
   _actionMap[657][SUBSTR] = ActionEntry(REDUCE, 340);
   _actionMap[657][REPLACE] = ActionEntry(REDUCE, 340);
   _actionMap[657][LENGTH] = ActionEntry(REDUCE, 340);
   _actionMap[657][TRUNC] = ActionEntry(REDUCE, 340);
   _actionMap[657][STR2INT] = ActionEntry(REDUCE, 340);
   _actionMap[657][STR2LONG] = ActionEntry(REDUCE, 340);
   _actionMap[657][STR2DATE] = ActionEntry(REDUCE, 340);
   _actionMap[657][RANDSTR] = ActionEntry(REDUCE, 340);
   _actionMap[657][RANDINT] = ActionEntry(REDUCE, 340);
   _actionMap[657][MOD] = ActionEntry(REDUCE, 340);
   _actionMap[657][DIV] = ActionEntry(REDUCE, 340);
   _actionMap[657][POWER] = ActionEntry(REDUCE, 340);
   _actionMap[657][BITAND] = ActionEntry(REDUCE, 340);
   _actionMap[657][BITOR] = ActionEntry(REDUCE, 340);
   _actionMap[657][BITXOR] = ActionEntry(REDUCE, 340);
}
void Cego::loadParser55()
{
   _actionMap[657][NEXTCOUNT] = ActionEntry(REDUCE, 340);
   _actionMap[657][SETCOUNT] = ActionEntry(REDUCE, 340);
   _actionMap[657][IDENTIFIER] = ActionEntry(REDUCE, 340);
   _actionMap[657][QUALIFIEDOBJ] = ActionEntry(REDUCE, 340);
   _actionMap[657][QUALIFIEDTS] = ActionEntry(REDUCE, 340);
   _actionMap[657][QUALIFIEDPRE] = ActionEntry(REDUCE, 340);
   _actionMap[657][STRINGVAL] = ActionEntry(REDUCE, 340);
   _actionMap[657][DATE] = ActionEntry(REDUCE, 340);
   _actionMap[657][SYSDATE] = ActionEntry(REDUCE, 340);
   _actionMap[657][NULLTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[657][TRUEVAL] = ActionEntry(REDUCE, 340);
   _actionMap[657][FALSEVAL] = ActionEntry(REDUCE, 340);
   _actionMap[657][LAB] = ActionEntry(REDUCE, 340);
   _actionMap[657][FLOATVAL] = ActionEntry(REDUCE, 340);
   _actionMap[657][MINUS] = ActionEntry(REDUCE, 340);
   _actionMap[657][INTVAL] = ActionEntry(REDUCE, 340);
   _actionMap[658][VARREF] = ActionEntry(REDUCE, 336);
   _actionMap[658][FETCH] = ActionEntry(REDUCE, 336);
   _actionMap[658][LB] = ActionEntry(REDUCE, 336);
   _actionMap[658][COUNT] = ActionEntry(REDUCE, 336);
   _actionMap[658][SUM] = ActionEntry(REDUCE, 336);
   _actionMap[658][AVG] = ActionEntry(REDUCE, 336);
   _actionMap[658][MIN] = ActionEntry(REDUCE, 336);
   _actionMap[658][MAX] = ActionEntry(REDUCE, 336);
   _actionMap[658][CASE] = ActionEntry(REDUCE, 336);
   _actionMap[658][TRIM] = ActionEntry(REDUCE, 336);
   _actionMap[658][RTRIM] = ActionEntry(REDUCE, 336);
   _actionMap[658][LTRIM] = ActionEntry(REDUCE, 336);
   _actionMap[658][ROUND] = ActionEntry(REDUCE, 336);
   _actionMap[658][DATE2STR] = ActionEntry(REDUCE, 336);
   _actionMap[658][DATE2INT] = ActionEntry(REDUCE, 336);
   _actionMap[658][INT2DATE] = ActionEntry(REDUCE, 336);
   _actionMap[658][LOWER] = ActionEntry(REDUCE, 336);
   _actionMap[658][UPPER] = ActionEntry(REDUCE, 336);
   _actionMap[658][LEFT] = ActionEntry(REDUCE, 336);
   _actionMap[658][RIGHT] = ActionEntry(REDUCE, 336);
   _actionMap[658][GETPOS] = ActionEntry(REDUCE, 336);
   _actionMap[658][SUBSTR] = ActionEntry(REDUCE, 336);
   _actionMap[658][REPLACE] = ActionEntry(REDUCE, 336);
   _actionMap[658][LENGTH] = ActionEntry(REDUCE, 336);
   _actionMap[658][TRUNC] = ActionEntry(REDUCE, 336);
   _actionMap[658][STR2INT] = ActionEntry(REDUCE, 336);
   _actionMap[658][STR2LONG] = ActionEntry(REDUCE, 336);
   _actionMap[658][STR2DATE] = ActionEntry(REDUCE, 336);
   _actionMap[658][RANDSTR] = ActionEntry(REDUCE, 336);
   _actionMap[658][RANDINT] = ActionEntry(REDUCE, 336);
   _actionMap[658][MOD] = ActionEntry(REDUCE, 336);
   _actionMap[658][DIV] = ActionEntry(REDUCE, 336);
   _actionMap[658][POWER] = ActionEntry(REDUCE, 336);
   _actionMap[658][BITAND] = ActionEntry(REDUCE, 336);
}
void Cego::loadParser56()
{
   _actionMap[658][BITOR] = ActionEntry(REDUCE, 336);
   _actionMap[658][BITXOR] = ActionEntry(REDUCE, 336);
   _actionMap[658][NEXTCOUNT] = ActionEntry(REDUCE, 336);
   _actionMap[658][SETCOUNT] = ActionEntry(REDUCE, 336);
   _actionMap[658][IDENTIFIER] = ActionEntry(REDUCE, 336);
   _actionMap[658][QUALIFIEDOBJ] = ActionEntry(REDUCE, 336);
   _actionMap[658][QUALIFIEDTS] = ActionEntry(REDUCE, 336);
   _actionMap[658][QUALIFIEDPRE] = ActionEntry(REDUCE, 336);
   _actionMap[658][STRINGVAL] = ActionEntry(REDUCE, 336);
   _actionMap[658][DATE] = ActionEntry(REDUCE, 336);
   _actionMap[658][SYSDATE] = ActionEntry(REDUCE, 336);
   _actionMap[658][NULLTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[658][TRUEVAL] = ActionEntry(REDUCE, 336);
   _actionMap[658][FALSEVAL] = ActionEntry(REDUCE, 336);
   _actionMap[658][LAB] = ActionEntry(REDUCE, 336);
   _actionMap[658][FLOATVAL] = ActionEntry(REDUCE, 336);
   _actionMap[658][MINUS] = ActionEntry(REDUCE, 336);
   _actionMap[658][INTVAL] = ActionEntry(REDUCE, 336);
   _actionMap[659][THEN] = ActionEntry(REDUCE, 308);
   _actionMap[659][LEFT] = ActionEntry(REDUCE, 308);
   _actionMap[659][RIGHT] = ActionEntry(REDUCE, 308);
   _actionMap[659][INNER] = ActionEntry(REDUCE, 308);
   _actionMap[659][JOIN] = ActionEntry(REDUCE, 308);
   _actionMap[659][RETURNTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[659][SEMICOLON] = ActionEntry(REDUCE, 308);
   _actionMap[659][RB] = ActionEntry(REDUCE, 308);
   _actionMap[659][ENDTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[659][UNION] = ActionEntry(REDUCE, 308);
   _actionMap[659][ROWLIMIT] = ActionEntry(REDUCE, 308);
   _actionMap[659][ORDER] = ActionEntry(REDUCE, 308);
   _actionMap[659][GROUP] = ActionEntry(REDUCE, 308);
   _actionMap[659][WHERE] = ActionEntry(REDUCE, 308);
   _actionMap[659][OR] = ActionEntry(REDUCE, 308);
   _actionMap[659][AND] = ActionEntry(REDUCE, 308);
   _actionMap[660][THEN] = ActionEntry(REDUCE, 309);
   _actionMap[660][LEFT] = ActionEntry(REDUCE, 309);
   _actionMap[660][RIGHT] = ActionEntry(REDUCE, 309);
   _actionMap[660][INNER] = ActionEntry(REDUCE, 309);
   _actionMap[660][JOIN] = ActionEntry(REDUCE, 309);
   _actionMap[660][RETURNTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[660][SEMICOLON] = ActionEntry(REDUCE, 309);
   _actionMap[660][RB] = ActionEntry(REDUCE, 309);
   _actionMap[660][ENDTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[660][UNION] = ActionEntry(REDUCE, 309);
   _actionMap[660][ROWLIMIT] = ActionEntry(REDUCE, 309);
   _actionMap[660][ORDER] = ActionEntry(REDUCE, 309);
   _actionMap[660][GROUP] = ActionEntry(REDUCE, 309);
   _actionMap[660][WHERE] = ActionEntry(REDUCE, 309);
   _actionMap[660][OR] = ActionEntry(REDUCE, 309);
   _actionMap[660][AND] = ActionEntry(REDUCE, 309);
}
void Cego::loadParser57()
{
   _actionMap[661][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[661][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[661][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[661][WHEN] = ActionEntry(REDUCE, 164);
   _actionMap[661][ELSE] = ActionEntry(REDUCE, 164);
   _actionMap[662][RB] = ActionEntry(SHIFT, 730);
   _actionMap[663][THEN] = ActionEntry(REDUCE, 320);
   _actionMap[663][LEFT] = ActionEntry(REDUCE, 320);
   _actionMap[663][RIGHT] = ActionEntry(REDUCE, 320);
   _actionMap[663][INNER] = ActionEntry(REDUCE, 320);
   _actionMap[663][JOIN] = ActionEntry(REDUCE, 320);
   _actionMap[663][RETURNTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[663][SEMICOLON] = ActionEntry(REDUCE, 320);
   _actionMap[663][RB] = ActionEntry(REDUCE, 320);
   _actionMap[663][ENDTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[663][UNION] = ActionEntry(REDUCE, 320);
   _actionMap[663][ROWLIMIT] = ActionEntry(REDUCE, 320);
   _actionMap[663][ORDER] = ActionEntry(REDUCE, 320);
   _actionMap[663][GROUP] = ActionEntry(REDUCE, 320);
   _actionMap[663][WHERE] = ActionEntry(REDUCE, 320);
   _actionMap[663][AND] = ActionEntry(REDUCE, 320);
   _actionMap[663][OR] = ActionEntry(REDUCE, 320);
   _actionMap[664][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[664][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[664][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[664][KSEP] = ActionEntry(REDUCE, 303);
   _actionMap[664][RB] = ActionEntry(REDUCE, 303);
   _actionMap[665][RB] = ActionEntry(SHIFT, 731);
   _actionMap[666][RB] = ActionEntry(REDUCE, 365);
   _actionMap[667][RB] = ActionEntry(SHIFT, 733);
   _actionMap[667][KSEP] = ActionEntry(SHIFT, 732);
   _actionMap[668][KSEP] = ActionEntry(REDUCE, 167);
   _actionMap[668][RB] = ActionEntry(REDUCE, 167);
   _actionMap[669][RB] = ActionEntry(SHIFT, 734);
   _actionMap[669][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[669][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[669][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[670][WHEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][ELSE] = ActionEntry(REDUCE, 363);
   _actionMap[670][LEFT] = ActionEntry(REDUCE, 363);
   _actionMap[670][RIGHT] = ActionEntry(REDUCE, 363);
   _actionMap[670][INNER] = ActionEntry(REDUCE, 363);
   _actionMap[670][JOIN] = ActionEntry(REDUCE, 363);
   _actionMap[670][RETURNTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][ORDER] = ActionEntry(REDUCE, 363);
   _actionMap[670][GROUP] = ActionEntry(REDUCE, 363);
   _actionMap[670][WHERE] = ActionEntry(REDUCE, 363);
   _actionMap[670][FROM] = ActionEntry(REDUCE, 363);
   _actionMap[670][AS] = ActionEntry(REDUCE, 363);
   _actionMap[670][END_TOKEN] = ActionEntry(REDUCE, 363);
}
void Cego::loadParser58()
{
   _actionMap[670][BEGIN] = ActionEntry(REDUCE, 363);
   _actionMap[670][THEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][OR] = ActionEntry(REDUCE, 363);
   _actionMap[670][AND] = ActionEntry(REDUCE, 363);
   _actionMap[670][NULLTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][INTOK] = ActionEntry(REDUCE, 363);
   _actionMap[670][NOT] = ActionEntry(REDUCE, 363);
   _actionMap[670][BETWEEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][IS] = ActionEntry(REDUCE, 363);
   _actionMap[670][LIKE] = ActionEntry(REDUCE, 363);
   _actionMap[670][MT] = ActionEntry(REDUCE, 363);
   _actionMap[670][LT] = ActionEntry(REDUCE, 363);
   _actionMap[670][NEGATION] = ActionEntry(REDUCE, 363);
   _actionMap[670][EQU] = ActionEntry(REDUCE, 363);
   _actionMap[670][RB] = ActionEntry(REDUCE, 363);
   _actionMap[670][ENDTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[670][UNION] = ActionEntry(REDUCE, 363);
   _actionMap[670][ROWLIMIT] = ActionEntry(REDUCE, 363);
   _actionMap[670][KSEP] = ActionEntry(REDUCE, 363);
   _actionMap[670][ASC] = ActionEntry(REDUCE, 363);
   _actionMap[670][DESC] = ActionEntry(REDUCE, 363);
   _actionMap[670][SEMICOLON] = ActionEntry(REDUCE, 363);
   _actionMap[670][PLUS] = ActionEntry(REDUCE, 363);
   _actionMap[670][MINUS] = ActionEntry(REDUCE, 363);
   _actionMap[670][DIVISION] = ActionEntry(REDUCE, 363);
   _actionMap[670][STAR] = ActionEntry(REDUCE, 363);
   _actionMap[670][CONCAT] = ActionEntry(REDUCE, 363);
   _actionMap[671][SEMICOLON] = ActionEntry(REDUCE, 235);
   _actionMap[671][RB] = ActionEntry(REDUCE, 235);
   _actionMap[671][ENDTOKEN] = ActionEntry(REDUCE, 235);
   _actionMap[671][UNION] = ActionEntry(REDUCE, 235);
   _actionMap[671][ROWLIMIT] = ActionEntry(REDUCE, 235);
   _actionMap[671][ORDER] = ActionEntry(SHIFT, 737);
   _jumpMap[671][NoOrdering] = 736;
   _jumpMap[671][OrderingClause] = 735;
   _actionMap[672][ORDER] = ActionEntry(REDUCE, 226);
   _actionMap[672][ROWLIMIT] = ActionEntry(REDUCE, 226);
   _actionMap[672][UNION] = ActionEntry(REDUCE, 226);
   _actionMap[672][ENDTOKEN] = ActionEntry(REDUCE, 226);
   _actionMap[672][RB] = ActionEntry(REDUCE, 226);
   _actionMap[672][SEMICOLON] = ActionEntry(REDUCE, 226);
   _actionMap[673][BY] = ActionEntry(SHIFT, 738);
   _actionMap[674][ON] = ActionEntry(SHIFT, 740);
   _jumpMap[674][JoinTableOn] = 739;
   _actionMap[675][IDENTIFIER] = ActionEntry(REDUCE, 215);
   _actionMap[675][QUALIFIEDOBJ] = ActionEntry(REDUCE, 215);
   _actionMap[675][QUALIFIEDTS] = ActionEntry(REDUCE, 215);
   _actionMap[676][JOIN] = ActionEntry(SHIFT, 741);
   _actionMap[677][JOIN] = ActionEntry(SHIFT, 742);
   _actionMap[678][RETURNTOKEN] = ActionEntry(REDUCE, 217);
}
void Cego::loadParser59()
{
   _actionMap[678][SEMICOLON] = ActionEntry(REDUCE, 217);
   _actionMap[678][RB] = ActionEntry(REDUCE, 217);
   _actionMap[678][ENDTOKEN] = ActionEntry(REDUCE, 217);
   _actionMap[678][UNION] = ActionEntry(REDUCE, 217);
   _actionMap[678][ROWLIMIT] = ActionEntry(REDUCE, 217);
   _actionMap[678][ORDER] = ActionEntry(REDUCE, 217);
   _actionMap[678][GROUP] = ActionEntry(REDUCE, 217);
   _actionMap[678][WHERE] = ActionEntry(REDUCE, 217);
   _actionMap[679][KSEP] = ActionEntry(SHIFT, 577);
   _actionMap[679][RETURNTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[679][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[679][RB] = ActionEntry(REDUCE, 218);
   _actionMap[679][ENDTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[679][UNION] = ActionEntry(REDUCE, 218);
   _actionMap[679][ROWLIMIT] = ActionEntry(REDUCE, 218);
   _actionMap[679][ORDER] = ActionEntry(REDUCE, 218);
   _actionMap[679][GROUP] = ActionEntry(REDUCE, 218);
   _actionMap[679][WHERE] = ActionEntry(REDUCE, 218);
   _actionMap[680][SEMICOLON] = ActionEntry(REDUCE, 247);
   _actionMap[681][VARREF] = ActionEntry(SHIFT, 745);
   _jumpMap[681][ReturnVar] = 744;
   _jumpMap[681][ReturnVarList] = 743;
   _actionMap[682][KSEP] = ActionEntry(REDUCE, 248);
   _actionMap[682][WHERE] = ActionEntry(REDUCE, 248);
   _actionMap[682][GROUP] = ActionEntry(REDUCE, 248);
   _actionMap[682][ORDER] = ActionEntry(REDUCE, 248);
   _actionMap[682][ROWLIMIT] = ActionEntry(REDUCE, 248);
   _actionMap[682][UNION] = ActionEntry(REDUCE, 248);
   _actionMap[682][ENDTOKEN] = ActionEntry(REDUCE, 248);
   _actionMap[682][RB] = ActionEntry(REDUCE, 248);
   _actionMap[682][SEMICOLON] = ActionEntry(REDUCE, 248);
   _actionMap[682][RETURNTOKEN] = ActionEntry(REDUCE, 248);
   _actionMap[683][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[683][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[683][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[683][KSEP] = ActionEntry(REDUCE, 250);
   _actionMap[683][WHERE] = ActionEntry(REDUCE, 250);
   _actionMap[683][GROUP] = ActionEntry(REDUCE, 250);
   _actionMap[683][ORDER] = ActionEntry(REDUCE, 250);
   _actionMap[683][ROWLIMIT] = ActionEntry(REDUCE, 250);
   _actionMap[683][UNION] = ActionEntry(REDUCE, 250);
   _actionMap[683][ENDTOKEN] = ActionEntry(REDUCE, 250);
   _actionMap[683][RB] = ActionEntry(REDUCE, 250);
   _actionMap[683][SEMICOLON] = ActionEntry(REDUCE, 250);
   _actionMap[683][RETURNTOKEN] = ActionEntry(REDUCE, 250);
   _actionMap[684][RB] = ActionEntry(SHIFT, 685);
   _actionMap[685][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[447][DROP] = ActionEntry(SHIFT, 315);
   _actionMap[447][ADD] = ActionEntry(SHIFT, 587);
   _actionMap[447][MODIFY] = ActionEntry(SHIFT, 316);
}
void Cego::loadParser60()
{
   _actionMap[447][RENAME] = ActionEntry(SHIFT, 317);
   _jumpMap[447][AlterOption] = 313;
   _jumpMap[447][AlterList] = 586;
   _actionMap[448][IDENTIFIER] = ActionEntry(SHIFT, 588);
   _actionMap[449][IDENTIFIER] = ActionEntry(SHIFT, 487);
   _jumpMap[449][ColumnDesc] = 589;
   _actionMap[450][KEY] = ActionEntry(SHIFT, 590);
   _actionMap[451][IDENTIFIER] = ActionEntry(SHIFT, 591);
   _actionMap[452][IDENTIFIER] = ActionEntry(SHIFT, 487);
   _jumpMap[452][ColumnDesc] = 592;
   _actionMap[453][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _actionMap[454][FOR] = ActionEntry(SHIFT, 594);
   _actionMap[455][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[455][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[455][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[455][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[455][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[455][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[455][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[455][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[455][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[455][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[455][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[455][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[455][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[455][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[455][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[455][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[455][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[455][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[455][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[455][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[455][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[455][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[455][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[455][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[455][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[455][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[455][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[455][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[455][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[455][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[455][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[455][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[455][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[455][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[455][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[455][LB] = ActionEntry(SHIFT, 142);
   _actionMap[455][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[455][DATE] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser61()
{
   _actionMap[455][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[455][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[455][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[455][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[455][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[455][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[455][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[455][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[455][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[455][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[455][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[455][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[455][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[455][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[455][ObjSpec] = 99;
   _jumpMap[455][Constant] = 98;
   _jumpMap[455][SignedFloat] = 97;
   _jumpMap[455][SignedInt] = 96;
   _jumpMap[455][Attribute] = 95;
   _jumpMap[455][Function] = 94;
   _jumpMap[455][CasePrepare] = 93;
   _jumpMap[455][CaseClause] = 92;
   _jumpMap[455][Factor] = 91;
   _jumpMap[455][Term] = 90;
   _jumpMap[455][Expr] = 595;
   _actionMap[456][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[457][ELSE] = ActionEntry(REDUCE, 91);
   _actionMap[457][ELSIF] = ActionEntry(REDUCE, 91);
   _actionMap[457][END_TOKEN] = ActionEntry(REDUCE, 91);
   _actionMap[457][EXCEPTION] = ActionEntry(SHIFT, 597);
   _jumpMap[457][ProcExceptionStmt] = 596;
   _actionMap[458][SEMICOLON] = ActionEntry(SHIFT, 598);
   _actionMap[459][END_TOKEN] = ActionEntry(SHIFT, 599);
   _actionMap[460][ELSE] = ActionEntry(SHIFT, 602);
   _actionMap[460][END_TOKEN] = ActionEntry(REDUCE, 127);
   _jumpMap[460][ProcElsePart] = 601;
   _jumpMap[460][ProcElseOpt] = 600;
   _actionMap[461][ELSIF] = ActionEntry(SHIFT, 462);
   _actionMap[461][END_TOKEN] = ActionEntry(REDUCE, 124);
   _actionMap[461][ELSE] = ActionEntry(REDUCE, 124);
   _jumpMap[461][ProcElsIfOpt] = 461;
   _jumpMap[461][ProcElsIfList] = 604;
   _actionMap[462][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[462][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[462][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[462][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[462][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[462][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[462][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[462][DATE2STR] = ActionEntry(SHIFT, 108);
}
void Cego::loadParser62()
{
   _actionMap[462][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[462][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[462][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[462][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[462][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[462][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[462][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[462][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[462][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[462][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[462][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[462][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[462][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[462][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[462][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[462][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[462][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[462][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[462][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[462][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[462][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[462][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[462][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[462][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[462][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[462][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[462][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[462][LB] = ActionEntry(SHIFT, 470);
   _actionMap[462][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[462][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[462][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[462][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[462][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[462][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[462][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[462][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[462][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[462][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[462][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[462][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[462][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[462][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[462][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[462][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[462][ObjSpec] = 99;
   _jumpMap[462][Constant] = 98;
   _jumpMap[462][SignedFloat] = 97;
   _jumpMap[462][SignedInt] = 96;
   _jumpMap[462][Attribute] = 95;
   _jumpMap[462][Function] = 94;
}
void Cego::loadParser63()
{
   _jumpMap[462][CasePrepare] = 93;
   _jumpMap[462][CaseClause] = 92;
   _jumpMap[462][Factor] = 91;
   _jumpMap[462][Term] = 90;
   _jumpMap[462][Expr] = 469;
   _jumpMap[462][ProcPredicate] = 468;
   _jumpMap[462][ProcCondition] = 606;
   _jumpMap[462][ProcElsIfCondition] = 605;
   _actionMap[463][EXCEPTION] = ActionEntry(REDUCE, 93);
   _actionMap[463][END_TOKEN] = ActionEntry(REDUCE, 93);
   _actionMap[463][ELSE] = ActionEntry(REDUCE, 93);
   _actionMap[463][ELSIF] = ActionEntry(REDUCE, 93);
   _actionMap[463][VAR] = ActionEntry(REDUCE, 93);
   _actionMap[463][CURSOR] = ActionEntry(REDUCE, 93);
   _actionMap[463][CLOSE] = ActionEntry(REDUCE, 93);
   _actionMap[463][VARREF] = ActionEntry(REDUCE, 93);
   _actionMap[463][NOOP] = ActionEntry(REDUCE, 93);
   _actionMap[463][RETURNTOKEN] = ActionEntry(REDUCE, 93);
   _actionMap[463][WHILE] = ActionEntry(REDUCE, 93);
   _actionMap[463][IF] = ActionEntry(REDUCE, 93);
   _actionMap[463][BEGIN] = ActionEntry(REDUCE, 93);
   _actionMap[463][ROLLBACK] = ActionEntry(REDUCE, 93);
   _actionMap[463][COMMIT] = ActionEntry(REDUCE, 93);
   _actionMap[463][START_TOKEN] = ActionEntry(REDUCE, 93);
   _actionMap[463][UPDATE] = ActionEntry(REDUCE, 93);
   _actionMap[463][DELETETOK] = ActionEntry(REDUCE, 93);
   _actionMap[463][INSERT] = ActionEntry(REDUCE, 93);
   _actionMap[463][FETCH] = ActionEntry(REDUCE, 93);
   _actionMap[463][LB] = ActionEntry(REDUCE, 93);
   _actionMap[463][COUNT] = ActionEntry(REDUCE, 93);
   _actionMap[463][SUM] = ActionEntry(REDUCE, 93);
   _actionMap[463][AVG] = ActionEntry(REDUCE, 93);
   _actionMap[463][MIN] = ActionEntry(REDUCE, 93);
   _actionMap[463][MAX] = ActionEntry(REDUCE, 93);
   _actionMap[463][CASE] = ActionEntry(REDUCE, 93);
   _actionMap[463][TRIM] = ActionEntry(REDUCE, 93);
   _actionMap[463][RTRIM] = ActionEntry(REDUCE, 93);
   _actionMap[463][LTRIM] = ActionEntry(REDUCE, 93);
   _actionMap[463][ROUND] = ActionEntry(REDUCE, 93);
   _actionMap[463][DATE2STR] = ActionEntry(REDUCE, 93);
   _actionMap[463][DATE2INT] = ActionEntry(REDUCE, 93);
   _actionMap[463][INT2DATE] = ActionEntry(REDUCE, 93);
   _actionMap[463][LOWER] = ActionEntry(REDUCE, 93);
   _actionMap[463][UPPER] = ActionEntry(REDUCE, 93);
   _actionMap[463][LEFT] = ActionEntry(REDUCE, 93);
   _actionMap[463][RIGHT] = ActionEntry(REDUCE, 93);
   _actionMap[463][GETPOS] = ActionEntry(REDUCE, 93);
   _actionMap[463][SUBSTR] = ActionEntry(REDUCE, 93);
   _actionMap[463][REPLACE] = ActionEntry(REDUCE, 93);
   _actionMap[463][LENGTH] = ActionEntry(REDUCE, 93);
}
void Cego::loadParser64()
{
   _actionMap[463][TRUNC] = ActionEntry(REDUCE, 93);
   _actionMap[463][STR2INT] = ActionEntry(REDUCE, 93);
   _actionMap[463][STR2LONG] = ActionEntry(REDUCE, 93);
   _actionMap[463][STR2DATE] = ActionEntry(REDUCE, 93);
   _actionMap[463][RANDSTR] = ActionEntry(REDUCE, 93);
   _actionMap[463][RANDINT] = ActionEntry(REDUCE, 93);
   _actionMap[463][MOD] = ActionEntry(REDUCE, 93);
   _actionMap[463][DIV] = ActionEntry(REDUCE, 93);
   _actionMap[463][POWER] = ActionEntry(REDUCE, 93);
   _actionMap[463][BITAND] = ActionEntry(REDUCE, 93);
   _actionMap[463][BITOR] = ActionEntry(REDUCE, 93);
   _actionMap[463][BITXOR] = ActionEntry(REDUCE, 93);
   _actionMap[463][NEXTCOUNT] = ActionEntry(REDUCE, 93);
   _actionMap[463][SETCOUNT] = ActionEntry(REDUCE, 93);
   _actionMap[463][IDENTIFIER] = ActionEntry(REDUCE, 93);
   _actionMap[463][QUALIFIEDOBJ] = ActionEntry(REDUCE, 93);
   _actionMap[463][QUALIFIEDTS] = ActionEntry(REDUCE, 93);
   _actionMap[463][QUALIFIEDPRE] = ActionEntry(REDUCE, 93);
   _actionMap[463][STRINGVAL] = ActionEntry(REDUCE, 93);
   _actionMap[463][DATE] = ActionEntry(REDUCE, 93);
   _actionMap[463][SYSDATE] = ActionEntry(REDUCE, 93);
   _actionMap[463][NULLTOKEN] = ActionEntry(REDUCE, 93);
   _actionMap[463][TRUEVAL] = ActionEntry(REDUCE, 93);
   _actionMap[463][FALSEVAL] = ActionEntry(REDUCE, 93);
   _actionMap[463][LAB] = ActionEntry(REDUCE, 93);
   _actionMap[463][FLOATVAL] = ActionEntry(REDUCE, 93);
   _actionMap[463][MINUS] = ActionEntry(REDUCE, 93);
   _actionMap[463][INTVAL] = ActionEntry(REDUCE, 93);
   _actionMap[464][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[465][AS] = ActionEntry(SHIFT, 607);
   _actionMap[466][THEN] = ActionEntry(SHIFT, 608);
   _actionMap[467][OR] = ActionEntry(SHIFT, 610);
   _actionMap[467][AND] = ActionEntry(SHIFT, 609);
   _actionMap[467][THEN] = ActionEntry(REDUCE, 129);
   _actionMap[468][BEGIN] = ActionEntry(REDUCE, 135);
   _actionMap[468][RB] = ActionEntry(REDUCE, 135);
   _actionMap[468][AND] = ActionEntry(REDUCE, 135);
   _actionMap[468][OR] = ActionEntry(REDUCE, 135);
   _actionMap[468][THEN] = ActionEntry(REDUCE, 135);
   _actionMap[469][IS] = ActionEntry(SHIFT, 612);
   _actionMap[469][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[469][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[469][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[469][EQU] = ActionEntry(SHIFT, 503);
   _actionMap[469][NEGATION] = ActionEntry(SHIFT, 506);
   _actionMap[469][LT] = ActionEntry(SHIFT, 504);
   _actionMap[469][MT] = ActionEntry(SHIFT, 505);
   _jumpMap[469][Comparison] = 611;
   _actionMap[470][LONG] = ActionEntry(SHIFT, 275);
   _actionMap[470][BIGINT] = ActionEntry(SHIFT, 271);
}
void Cego::loadParser65()
{
   _actionMap[470][SMALLINT] = ActionEntry(SHIFT, 276);
   _actionMap[470][TINYINT] = ActionEntry(SHIFT, 277);
   _actionMap[470][DOUBLE] = ActionEntry(SHIFT, 273);
   _actionMap[470][DECIMAL] = ActionEntry(SHIFT, 272);
   _actionMap[470][FIXED] = ActionEntry(SHIFT, 274);
   _actionMap[470][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[470][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[470][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[470][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[470][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[470][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[470][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[470][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[470][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[470][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[470][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[470][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[470][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[470][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[470][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[470][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[470][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[470][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[470][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[470][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[470][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[470][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[470][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[470][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[470][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[470][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[470][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[470][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[470][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[470][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[470][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[470][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[470][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[470][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[470][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[470][LB] = ActionEntry(SHIFT, 470);
   _actionMap[470][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[470][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[470][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[470][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[470][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[470][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[470][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[470][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[470][CASE] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser66()
{
   _actionMap[470][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[470][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[470][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[470][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[470][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[470][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[470][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[470][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[470][ObjSpec] = 99;
   _jumpMap[470][Constant] = 98;
   _jumpMap[470][SignedFloat] = 97;
   _jumpMap[470][SignedInt] = 96;
   _jumpMap[470][Attribute] = 95;
   _jumpMap[470][Function] = 94;
   _jumpMap[470][SelectStatement] = 270;
   _jumpMap[470][CasePrepare] = 93;
   _jumpMap[470][CaseClause] = 92;
   _jumpMap[470][Factor] = 91;
   _jumpMap[470][Term] = 90;
   _jumpMap[470][Expr] = 614;
   _jumpMap[470][ProcPredicate] = 468;
   _jumpMap[470][ProcCondition] = 613;
   _actionMap[471][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[471][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[471][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[471][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[472][INT] = ActionEntry(SHIFT, 624);
   _actionMap[472][LONG] = ActionEntry(SHIFT, 625);
   _actionMap[472][STRING] = ActionEntry(SHIFT, 627);
   _actionMap[472][DATETIME] = ActionEntry(SHIFT, 619);
   _actionMap[472][BOOL] = ActionEntry(SHIFT, 618);
   _actionMap[472][BIGINT] = ActionEntry(SHIFT, 616);
   _actionMap[472][FLOAT] = ActionEntry(SHIFT, 623);
   _actionMap[472][DOUBLE] = ActionEntry(SHIFT, 621);
   _actionMap[472][SMALLINT] = ActionEntry(SHIFT, 626);
   _actionMap[472][TINYINT] = ActionEntry(SHIFT, 628);
   _actionMap[472][DECIMAL] = ActionEntry(SHIFT, 620);
   _actionMap[472][FIXED] = ActionEntry(SHIFT, 622);
   _actionMap[472][BLOB] = ActionEntry(SHIFT, 617);
   _jumpMap[472][DataTypeProd] = 615;
   _actionMap[473][BEGIN] = ActionEntry(SHIFT, 629);
   _actionMap[474][OR] = ActionEntry(SHIFT, 610);
   _actionMap[474][AND] = ActionEntry(SHIFT, 609);
   _actionMap[474][BEGIN] = ActionEntry(REDUCE, 132);
   _actionMap[475][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[475][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[475][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[475][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[475][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[475][LTRIM] = ActionEntry(SHIFT, 118);
}
void Cego::loadParser67()
{
   _actionMap[475][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[475][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[475][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[475][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[475][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[475][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[475][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[475][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[475][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[475][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[475][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[475][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[475][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[475][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[475][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[475][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[475][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[475][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[475][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[475][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[475][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[475][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[475][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[475][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[475][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[475][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[475][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[475][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[475][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[475][LB] = ActionEntry(SHIFT, 142);
   _actionMap[475][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[475][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[475][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[475][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[475][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[475][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[475][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[475][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[475][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[475][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[475][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[475][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[475][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[475][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[475][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[475][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[475][ObjSpec] = 99;
   _jumpMap[475][Constant] = 98;
   _jumpMap[475][SignedFloat] = 97;
   _jumpMap[475][SignedInt] = 96;
}
void Cego::loadParser68()
{
   _jumpMap[475][Attribute] = 95;
   _jumpMap[475][Function] = 94;
   _jumpMap[475][CasePrepare] = 93;
   _jumpMap[475][CaseClause] = 92;
   _jumpMap[475][Factor] = 91;
   _jumpMap[475][Term] = 90;
   _jumpMap[475][Expr] = 630;
   _actionMap[476][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[476][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[476][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[476][ObjSpec] = 631;
   _actionMap[477][LB] = ActionEntry(SHIFT, 632);
   _actionMap[478][RB] = ActionEntry(SHIFT, 481);
   _actionMap[479][KSEP] = ActionEntry(SHIFT, 633);
   _actionMap[479][RB] = ActionEntry(REDUCE, 85);
   _actionMap[480][KSEP] = ActionEntry(REDUCE, 88);
   _actionMap[480][RB] = ActionEntry(REDUCE, 88);
   _actionMap[481][RETURNTOKEN] = ActionEntry(SHIFT, 635);
   _actionMap[481][BEGIN] = ActionEntry(REDUCE, 84);
   _jumpMap[481][ReturnOpt] = 634;
   _actionMap[482][INTOK] = ActionEntry(SHIFT, 636);
   _actionMap[482][OUTTOK] = ActionEntry(SHIFT, 637);
   _actionMap[483][RB] = ActionEntry(SHIFT, 639);
   _actionMap[483][KSEP] = ActionEntry(SHIFT, 638);
   _actionMap[484][KSEP] = ActionEntry(REDUCE, 169);
   _actionMap[484][RB] = ActionEntry(REDUCE, 169);
   _actionMap[485][KSEP] = ActionEntry(REDUCE, 171);
   _actionMap[485][RB] = ActionEntry(REDUCE, 171);
   _actionMap[486][IDENTIFIER] = ActionEntry(SHIFT, 487);
   _jumpMap[486][ColumnDesc] = 640;
   _actionMap[487][INT] = ActionEntry(SHIFT, 624);
   _actionMap[487][LONG] = ActionEntry(SHIFT, 625);
   _actionMap[487][STRING] = ActionEntry(SHIFT, 627);
   _actionMap[487][DATETIME] = ActionEntry(SHIFT, 619);
   _actionMap[487][BOOL] = ActionEntry(SHIFT, 618);
   _actionMap[487][BIGINT] = ActionEntry(SHIFT, 616);
   _actionMap[487][FLOAT] = ActionEntry(SHIFT, 623);
   _actionMap[487][DOUBLE] = ActionEntry(SHIFT, 621);
   _actionMap[487][SMALLINT] = ActionEntry(SHIFT, 626);
   _actionMap[487][TINYINT] = ActionEntry(SHIFT, 628);
   _actionMap[487][DECIMAL] = ActionEntry(SHIFT, 620);
   _actionMap[487][FIXED] = ActionEntry(SHIFT, 622);
   _actionMap[487][BLOB] = ActionEntry(SHIFT, 617);
   _jumpMap[487][DataTypeProd] = 641;
   _actionMap[488][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[489][AND] = ActionEntry(SHIFT, 507);
   _actionMap[489][OR] = ActionEntry(SHIFT, 508);
   _actionMap[489][RETURNTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[489][GROUP] = ActionEntry(REDUCE, 305);
   _actionMap[489][ORDER] = ActionEntry(REDUCE, 305);
}
void Cego::loadParser69()
{
   _actionMap[489][ROWLIMIT] = ActionEntry(REDUCE, 305);
   _actionMap[489][UNION] = ActionEntry(REDUCE, 305);
   _actionMap[489][ENDTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[489][RB] = ActionEntry(REDUCE, 305);
   _actionMap[489][SEMICOLON] = ActionEntry(REDUCE, 305);
   _actionMap[490][KSEP] = ActionEntry(SHIFT, 642);
   _actionMap[490][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[491][SEMICOLON] = ActionEntry(REDUCE, 196);
   _actionMap[491][KSEP] = ActionEntry(REDUCE, 196);
   _actionMap[492][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[492][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[492][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[492][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[492][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[492][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[492][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[492][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[492][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[492][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[492][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[492][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[492][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[492][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[492][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[492][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[492][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[492][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[492][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[492][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[492][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[492][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[492][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[492][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[492][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[492][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[492][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[492][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[492][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[492][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[492][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[492][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[492][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[492][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[492][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[492][LB] = ActionEntry(SHIFT, 142);
   _actionMap[492][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[492][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[492][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[492][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[492][TRUEVAL] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser70()
{
   _actionMap[492][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[492][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[492][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[492][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[492][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[492][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[492][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[492][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[492][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[492][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[492][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[492][ObjSpec] = 99;
   _jumpMap[492][Constant] = 98;
   _jumpMap[492][SignedFloat] = 97;
   _jumpMap[492][SignedInt] = 96;
   _jumpMap[492][Attribute] = 95;
   _jumpMap[492][Function] = 94;
   _jumpMap[492][InsertValueList] = 644;
   _jumpMap[492][CasePrepare] = 93;
   _jumpMap[492][CaseClause] = 92;
   _jumpMap[492][Factor] = 91;
   _jumpMap[492][Term] = 90;
   _jumpMap[492][Expr] = 643;
   _actionMap[493][RB] = ActionEntry(SHIFT, 646);
   _actionMap[493][KSEP] = ActionEntry(SHIFT, 645);
   _actionMap[494][KSEP] = ActionEntry(REDUCE, 199);
   _actionMap[494][RB] = ActionEntry(REDUCE, 199);
   _actionMap[495][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[496][END_TOKEN] = ActionEntry(SHIFT, 647);
   _actionMap[496][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[496][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[496][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[497][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[497][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[497][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[497][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[497][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[497][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[497][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[497][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[497][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[497][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[497][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[497][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[497][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[497][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[497][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[497][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[497][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[497][LENGTH] = ActionEntry(SHIFT, 116);
}
void Cego::loadParser71()
{
   _actionMap[497][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[497][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[497][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[497][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[497][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[497][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[497][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[497][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[497][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[497][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[497][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[497][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[497][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[497][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[497][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[497][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[497][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[497][LB] = ActionEntry(SHIFT, 142);
   _actionMap[497][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[497][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[497][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[497][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[497][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[497][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[497][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[497][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[497][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[497][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[497][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[497][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[497][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[497][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[497][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[497][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[497][ObjSpec] = 99;
   _jumpMap[497][Constant] = 98;
   _jumpMap[497][SignedFloat] = 97;
   _jumpMap[497][SignedInt] = 96;
   _jumpMap[497][Attribute] = 95;
   _jumpMap[497][Function] = 94;
   _jumpMap[497][CasePrepare] = 93;
   _jumpMap[497][CaseClause] = 92;
   _jumpMap[497][Factor] = 91;
   _jumpMap[497][Term] = 90;
   _jumpMap[497][Expr] = 648;
   _actionMap[498][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[498][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[498][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[498][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[498][RTRIM] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser72()
{
   _actionMap[498][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[498][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[498][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[498][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[498][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[498][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[498][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[498][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[498][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[498][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[498][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[498][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[498][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[498][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[498][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[498][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[498][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[498][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[498][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[498][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[498][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[498][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[498][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[498][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[498][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[498][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[498][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[498][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[498][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[498][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[498][LB] = ActionEntry(SHIFT, 142);
   _actionMap[498][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[498][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[498][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[498][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[498][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[498][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[498][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[498][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[498][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[498][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[498][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[498][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[498][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[498][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[498][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[498][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[498][ObjSpec] = 99;
   _jumpMap[498][Constant] = 98;
   _jumpMap[498][SignedFloat] = 97;
}
void Cego::loadParser73()
{
   _jumpMap[498][SignedInt] = 96;
   _jumpMap[498][Attribute] = 95;
   _jumpMap[498][Function] = 94;
   _jumpMap[498][CasePrepare] = 93;
   _jumpMap[498][CaseClause] = 92;
   _jumpMap[498][Factor] = 91;
   _jumpMap[498][Term] = 90;
   _jumpMap[498][Expr] = 649;
   _actionMap[499][LB] = ActionEntry(SHIFT, 650);
   _actionMap[500][NOT] = ActionEntry(SHIFT, 651);
   _actionMap[500][NULLTOKEN] = ActionEntry(SHIFT, 652);
   _actionMap[501][STRINGVAL] = ActionEntry(SHIFT, 653);
   _actionMap[502][LIKE] = ActionEntry(SHIFT, 655);
   _actionMap[502][INTOK] = ActionEntry(SHIFT, 654);
   _actionMap[503][VARREF] = ActionEntry(REDUCE, 335);
   _actionMap[503][FETCH] = ActionEntry(REDUCE, 335);
   _actionMap[503][LB] = ActionEntry(REDUCE, 335);
   _actionMap[503][COUNT] = ActionEntry(REDUCE, 335);
   _actionMap[503][SUM] = ActionEntry(REDUCE, 335);
   _actionMap[503][AVG] = ActionEntry(REDUCE, 335);
   _actionMap[503][MIN] = ActionEntry(REDUCE, 335);
   _actionMap[503][MAX] = ActionEntry(REDUCE, 335);
   _actionMap[503][CASE] = ActionEntry(REDUCE, 335);
   _actionMap[503][TRIM] = ActionEntry(REDUCE, 335);
   _actionMap[503][RTRIM] = ActionEntry(REDUCE, 335);
   _actionMap[503][LTRIM] = ActionEntry(REDUCE, 335);
   _actionMap[503][ROUND] = ActionEntry(REDUCE, 335);
   _actionMap[503][DATE2STR] = ActionEntry(REDUCE, 335);
   _actionMap[503][DATE2INT] = ActionEntry(REDUCE, 335);
   _actionMap[503][INT2DATE] = ActionEntry(REDUCE, 335);
   _actionMap[503][LOWER] = ActionEntry(REDUCE, 335);
   _actionMap[503][UPPER] = ActionEntry(REDUCE, 335);
   _actionMap[503][LEFT] = ActionEntry(REDUCE, 335);
   _actionMap[503][RIGHT] = ActionEntry(REDUCE, 335);
   _actionMap[503][GETPOS] = ActionEntry(REDUCE, 335);
   _actionMap[503][SUBSTR] = ActionEntry(REDUCE, 335);
   _actionMap[503][REPLACE] = ActionEntry(REDUCE, 335);
   _actionMap[503][LENGTH] = ActionEntry(REDUCE, 335);
   _actionMap[503][TRUNC] = ActionEntry(REDUCE, 335);
   _actionMap[503][STR2INT] = ActionEntry(REDUCE, 335);
   _actionMap[503][STR2LONG] = ActionEntry(REDUCE, 335);
   _actionMap[503][STR2DATE] = ActionEntry(REDUCE, 335);
   _actionMap[503][RANDSTR] = ActionEntry(REDUCE, 335);
   _actionMap[503][RANDINT] = ActionEntry(REDUCE, 335);
   _actionMap[503][MOD] = ActionEntry(REDUCE, 335);
   _actionMap[503][DIV] = ActionEntry(REDUCE, 335);
   _actionMap[503][POWER] = ActionEntry(REDUCE, 335);
   _actionMap[503][BITAND] = ActionEntry(REDUCE, 335);
   _actionMap[503][BITOR] = ActionEntry(REDUCE, 335);
   _actionMap[503][BITXOR] = ActionEntry(REDUCE, 335);
}
void Cego::loadParser74()
{
   _actionMap[503][NEXTCOUNT] = ActionEntry(REDUCE, 335);
   _actionMap[503][SETCOUNT] = ActionEntry(REDUCE, 335);
   _actionMap[503][IDENTIFIER] = ActionEntry(REDUCE, 335);
   _actionMap[503][QUALIFIEDOBJ] = ActionEntry(REDUCE, 335);
   _actionMap[503][QUALIFIEDTS] = ActionEntry(REDUCE, 335);
   _actionMap[503][QUALIFIEDPRE] = ActionEntry(REDUCE, 335);
   _actionMap[503][STRINGVAL] = ActionEntry(REDUCE, 335);
   _actionMap[503][DATE] = ActionEntry(REDUCE, 335);
   _actionMap[503][SYSDATE] = ActionEntry(REDUCE, 335);
   _actionMap[503][NULLTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[503][TRUEVAL] = ActionEntry(REDUCE, 335);
   _actionMap[503][FALSEVAL] = ActionEntry(REDUCE, 335);
   _actionMap[503][LAB] = ActionEntry(REDUCE, 335);
   _actionMap[503][FLOATVAL] = ActionEntry(REDUCE, 335);
   _actionMap[503][MINUS] = ActionEntry(REDUCE, 335);
   _actionMap[503][INTVAL] = ActionEntry(REDUCE, 335);
   _actionMap[504][VARREF] = ActionEntry(REDUCE, 337);
   _actionMap[504][FETCH] = ActionEntry(REDUCE, 337);
   _actionMap[504][LB] = ActionEntry(REDUCE, 337);
   _actionMap[504][COUNT] = ActionEntry(REDUCE, 337);
   _actionMap[504][SUM] = ActionEntry(REDUCE, 337);
   _actionMap[504][AVG] = ActionEntry(REDUCE, 337);
   _actionMap[504][MIN] = ActionEntry(REDUCE, 337);
   _actionMap[504][MAX] = ActionEntry(REDUCE, 337);
   _actionMap[504][CASE] = ActionEntry(REDUCE, 337);
   _actionMap[504][TRIM] = ActionEntry(REDUCE, 337);
   _actionMap[504][RTRIM] = ActionEntry(REDUCE, 337);
   _actionMap[504][LTRIM] = ActionEntry(REDUCE, 337);
   _actionMap[504][ROUND] = ActionEntry(REDUCE, 337);
   _actionMap[504][DATE2STR] = ActionEntry(REDUCE, 337);
   _actionMap[504][DATE2INT] = ActionEntry(REDUCE, 337);
   _actionMap[504][INT2DATE] = ActionEntry(REDUCE, 337);
   _actionMap[504][LOWER] = ActionEntry(REDUCE, 337);
   _actionMap[504][UPPER] = ActionEntry(REDUCE, 337);
   _actionMap[504][LEFT] = ActionEntry(REDUCE, 337);
   _actionMap[504][RIGHT] = ActionEntry(REDUCE, 337);
   _actionMap[504][GETPOS] = ActionEntry(REDUCE, 337);
   _actionMap[504][SUBSTR] = ActionEntry(REDUCE, 337);
   _actionMap[504][REPLACE] = ActionEntry(REDUCE, 337);
   _actionMap[504][LENGTH] = ActionEntry(REDUCE, 337);
   _actionMap[504][TRUNC] = ActionEntry(REDUCE, 337);
   _actionMap[504][STR2INT] = ActionEntry(REDUCE, 337);
   _actionMap[504][STR2LONG] = ActionEntry(REDUCE, 337);
   _actionMap[504][STR2DATE] = ActionEntry(REDUCE, 337);
   _actionMap[504][RANDSTR] = ActionEntry(REDUCE, 337);
   _actionMap[504][RANDINT] = ActionEntry(REDUCE, 337);
   _actionMap[504][MOD] = ActionEntry(REDUCE, 337);
   _actionMap[504][DIV] = ActionEntry(REDUCE, 337);
   _actionMap[504][POWER] = ActionEntry(REDUCE, 337);
   _actionMap[504][BITAND] = ActionEntry(REDUCE, 337);
}
void Cego::loadParser75()
{
   _actionMap[504][BITOR] = ActionEntry(REDUCE, 337);
   _actionMap[504][BITXOR] = ActionEntry(REDUCE, 337);
   _actionMap[504][NEXTCOUNT] = ActionEntry(REDUCE, 337);
   _actionMap[504][SETCOUNT] = ActionEntry(REDUCE, 337);
   _actionMap[504][IDENTIFIER] = ActionEntry(REDUCE, 337);
   _actionMap[504][QUALIFIEDOBJ] = ActionEntry(REDUCE, 337);
   _actionMap[504][QUALIFIEDTS] = ActionEntry(REDUCE, 337);
   _actionMap[504][QUALIFIEDPRE] = ActionEntry(REDUCE, 337);
   _actionMap[504][STRINGVAL] = ActionEntry(REDUCE, 337);
   _actionMap[504][DATE] = ActionEntry(REDUCE, 337);
   _actionMap[504][SYSDATE] = ActionEntry(REDUCE, 337);
   _actionMap[504][NULLTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[504][TRUEVAL] = ActionEntry(REDUCE, 337);
   _actionMap[504][FALSEVAL] = ActionEntry(REDUCE, 337);
   _actionMap[504][LAB] = ActionEntry(REDUCE, 337);
   _actionMap[504][FLOATVAL] = ActionEntry(REDUCE, 337);
   _actionMap[504][MINUS] = ActionEntry(REDUCE, 337);
   _actionMap[504][INTVAL] = ActionEntry(REDUCE, 337);
   _actionMap[504][EQU] = ActionEntry(SHIFT, 656);
   _actionMap[505][VARREF] = ActionEntry(REDUCE, 338);
   _actionMap[505][FETCH] = ActionEntry(REDUCE, 338);
   _actionMap[505][LB] = ActionEntry(REDUCE, 338);
   _actionMap[505][COUNT] = ActionEntry(REDUCE, 338);
   _actionMap[505][SUM] = ActionEntry(REDUCE, 338);
   _actionMap[505][AVG] = ActionEntry(REDUCE, 338);
   _actionMap[505][MIN] = ActionEntry(REDUCE, 338);
   _actionMap[505][MAX] = ActionEntry(REDUCE, 338);
   _actionMap[505][CASE] = ActionEntry(REDUCE, 338);
   _actionMap[505][TRIM] = ActionEntry(REDUCE, 338);
   _actionMap[505][RTRIM] = ActionEntry(REDUCE, 338);
   _actionMap[505][LTRIM] = ActionEntry(REDUCE, 338);
   _actionMap[505][ROUND] = ActionEntry(REDUCE, 338);
   _actionMap[505][DATE2STR] = ActionEntry(REDUCE, 338);
   _actionMap[505][DATE2INT] = ActionEntry(REDUCE, 338);
   _actionMap[505][INT2DATE] = ActionEntry(REDUCE, 338);
   _actionMap[505][LOWER] = ActionEntry(REDUCE, 338);
   _actionMap[505][UPPER] = ActionEntry(REDUCE, 338);
   _actionMap[505][LEFT] = ActionEntry(REDUCE, 338);
   _actionMap[505][RIGHT] = ActionEntry(REDUCE, 338);
   _actionMap[505][GETPOS] = ActionEntry(REDUCE, 338);
   _actionMap[505][SUBSTR] = ActionEntry(REDUCE, 338);
   _actionMap[505][REPLACE] = ActionEntry(REDUCE, 338);
   _actionMap[505][LENGTH] = ActionEntry(REDUCE, 338);
   _actionMap[505][TRUNC] = ActionEntry(REDUCE, 338);
   _actionMap[505][STR2INT] = ActionEntry(REDUCE, 338);
   _actionMap[505][STR2LONG] = ActionEntry(REDUCE, 338);
   _actionMap[505][STR2DATE] = ActionEntry(REDUCE, 338);
   _actionMap[505][RANDSTR] = ActionEntry(REDUCE, 338);
   _actionMap[505][RANDINT] = ActionEntry(REDUCE, 338);
   _actionMap[505][MOD] = ActionEntry(REDUCE, 338);
}
void Cego::loadParser76()
{
   _actionMap[505][DIV] = ActionEntry(REDUCE, 338);
   _actionMap[505][POWER] = ActionEntry(REDUCE, 338);
   _actionMap[505][BITAND] = ActionEntry(REDUCE, 338);
   _actionMap[505][BITOR] = ActionEntry(REDUCE, 338);
   _actionMap[505][BITXOR] = ActionEntry(REDUCE, 338);
   _actionMap[505][NEXTCOUNT] = ActionEntry(REDUCE, 338);
   _actionMap[505][SETCOUNT] = ActionEntry(REDUCE, 338);
   _actionMap[505][IDENTIFIER] = ActionEntry(REDUCE, 338);
   _actionMap[505][QUALIFIEDOBJ] = ActionEntry(REDUCE, 338);
   _actionMap[505][QUALIFIEDTS] = ActionEntry(REDUCE, 338);
   _actionMap[505][QUALIFIEDPRE] = ActionEntry(REDUCE, 338);
   _actionMap[505][STRINGVAL] = ActionEntry(REDUCE, 338);
   _actionMap[505][DATE] = ActionEntry(REDUCE, 338);
   _actionMap[505][SYSDATE] = ActionEntry(REDUCE, 338);
   _actionMap[505][NULLTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[505][TRUEVAL] = ActionEntry(REDUCE, 338);
   _actionMap[505][FALSEVAL] = ActionEntry(REDUCE, 338);
   _actionMap[505][LAB] = ActionEntry(REDUCE, 338);
   _actionMap[505][FLOATVAL] = ActionEntry(REDUCE, 338);
   _actionMap[505][MINUS] = ActionEntry(REDUCE, 338);
   _actionMap[505][INTVAL] = ActionEntry(REDUCE, 338);
   _actionMap[505][EQU] = ActionEntry(SHIFT, 657);
   _actionMap[506][EQU] = ActionEntry(SHIFT, 658);
   _actionMap[507][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[507][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[507][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[507][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[507][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[507][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[507][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[507][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[507][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[507][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[507][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[507][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[507][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[507][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[507][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[507][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[507][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[507][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[507][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[507][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[507][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[507][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[507][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[507][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[507][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[507][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[507][POWER] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser77()
{
   _actionMap[507][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[507][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[507][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[507][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[507][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[507][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[507][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[507][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[507][LB] = ActionEntry(SHIFT, 373);
   _actionMap[507][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[507][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[507][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[507][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[507][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[507][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[507][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[507][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[507][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[507][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[507][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[507][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[507][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[507][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[507][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[507][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[507][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[507][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[507][ObjSpec] = 99;
   _jumpMap[507][Constant] = 98;
   _jumpMap[507][SignedFloat] = 97;
   _jumpMap[507][SignedInt] = 96;
   _jumpMap[507][Attribute] = 95;
   _jumpMap[507][QueryPredicate] = 659;
   _jumpMap[507][Function] = 94;
   _jumpMap[507][CasePrepare] = 93;
   _jumpMap[507][CaseClause] = 92;
   _jumpMap[507][Factor] = 91;
   _jumpMap[507][Term] = 90;
   _jumpMap[507][Expr] = 368;
   _actionMap[508][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[508][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[508][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[508][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[508][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[508][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[508][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[508][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[508][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[508][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[508][LOWER] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser78()
{
   _actionMap[508][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[508][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[508][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[508][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[508][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[508][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[508][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[508][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[508][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[508][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[508][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[508][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[508][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[508][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[508][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[508][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[508][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[508][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[508][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[508][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[508][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[508][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[508][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[508][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[508][LB] = ActionEntry(SHIFT, 373);
   _actionMap[508][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[508][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[508][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[508][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[508][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[508][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[508][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[508][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[508][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[508][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[508][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[508][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[508][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[508][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[508][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[508][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[508][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[508][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[508][ObjSpec] = 99;
   _jumpMap[508][Constant] = 98;
   _jumpMap[508][SignedFloat] = 97;
   _jumpMap[508][SignedInt] = 96;
   _jumpMap[508][Attribute] = 95;
   _jumpMap[508][QueryPredicate] = 660;
   _jumpMap[508][Function] = 94;
}
void Cego::loadParser79()
{
   _jumpMap[508][CasePrepare] = 93;
   _jumpMap[508][CaseClause] = 92;
   _jumpMap[508][Factor] = 91;
   _jumpMap[508][Term] = 90;
   _jumpMap[508][Expr] = 368;
   _actionMap[509][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[509][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[509][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[509][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[509][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[509][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[509][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[509][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[509][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[509][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[509][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[509][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[509][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[509][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[509][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[509][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[509][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[509][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[509][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[509][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[509][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[509][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[509][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[509][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[509][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[509][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[509][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[509][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[509][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[509][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[509][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[509][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[509][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[509][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[509][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[509][LB] = ActionEntry(SHIFT, 142);
   _actionMap[509][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[509][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[509][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[509][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[509][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[509][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[509][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[509][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[509][CASE] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser80()
{
   _actionMap[509][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[509][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[509][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[509][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[509][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[509][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[509][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[509][ObjSpec] = 99;
   _jumpMap[509][Constant] = 98;
   _jumpMap[509][SignedFloat] = 97;
   _jumpMap[509][SignedInt] = 96;
   _jumpMap[509][Attribute] = 95;
   _jumpMap[509][Function] = 94;
   _jumpMap[509][CasePrepare] = 93;
   _jumpMap[509][CaseClause] = 92;
   _jumpMap[509][Factor] = 91;
   _jumpMap[509][Term] = 90;
   _jumpMap[509][Expr] = 661;
   _actionMap[510][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[510][SelectStatement] = 662;
   _actionMap[511][THEN] = ActionEntry(REDUCE, 321);
   _actionMap[511][LEFT] = ActionEntry(REDUCE, 321);
   _actionMap[511][RIGHT] = ActionEntry(REDUCE, 321);
   _actionMap[511][INNER] = ActionEntry(REDUCE, 321);
   _actionMap[511][JOIN] = ActionEntry(REDUCE, 321);
   _actionMap[511][RETURNTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[511][SEMICOLON] = ActionEntry(REDUCE, 321);
   _actionMap[511][RB] = ActionEntry(REDUCE, 321);
   _actionMap[511][ENDTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[511][UNION] = ActionEntry(REDUCE, 321);
   _actionMap[511][ROWLIMIT] = ActionEntry(REDUCE, 321);
   _actionMap[511][ORDER] = ActionEntry(REDUCE, 321);
   _actionMap[511][GROUP] = ActionEntry(REDUCE, 321);
   _actionMap[511][WHERE] = ActionEntry(REDUCE, 321);
   _actionMap[511][AND] = ActionEntry(REDUCE, 321);
   _actionMap[511][OR] = ActionEntry(REDUCE, 321);
   _actionMap[512][RB] = ActionEntry(SHIFT, 416);
   _actionMap[512][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[512][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[512][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[512][INTOK] = ActionEntry(SHIFT, 499);
   _actionMap[512][NOT] = ActionEntry(SHIFT, 502);
   _actionMap[512][BETWEEN] = ActionEntry(SHIFT, 498);
   _actionMap[512][IS] = ActionEntry(SHIFT, 500);
   _actionMap[512][LIKE] = ActionEntry(SHIFT, 501);
   _actionMap[512][EQU] = ActionEntry(SHIFT, 503);
   _actionMap[512][NEGATION] = ActionEntry(SHIFT, 506);
   _actionMap[512][LT] = ActionEntry(SHIFT, 504);
   _actionMap[512][MT] = ActionEntry(SHIFT, 505);
   _jumpMap[512][Comparison] = 497;
}
void Cego::loadParser81()
{
   _actionMap[513][RB] = ActionEntry(SHIFT, 663);
   _actionMap[513][AND] = ActionEntry(SHIFT, 507);
   _actionMap[513][OR] = ActionEntry(SHIFT, 508);
   _actionMap[514][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[514][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[514][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[514][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[514][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[514][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[514][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[514][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[514][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[514][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[514][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[514][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[514][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[514][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[514][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[514][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[514][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[514][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[514][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[514][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[514][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[514][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[514][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[514][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[514][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[514][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[514][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[514][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[514][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[514][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[514][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[514][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[514][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[514][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[514][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[514][LB] = ActionEntry(SHIFT, 142);
   _actionMap[514][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[514][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[514][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[514][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[514][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[514][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[514][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[514][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[514][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[514][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[514][FETCH] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser82()
{
   _actionMap[514][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[514][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[514][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[514][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[514][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[514][ObjSpec] = 99;
   _jumpMap[514][Constant] = 98;
   _jumpMap[514][SignedFloat] = 97;
   _jumpMap[514][SignedInt] = 96;
   _jumpMap[514][Attribute] = 95;
   _jumpMap[514][Function] = 94;
   _jumpMap[514][CasePrepare] = 93;
   _jumpMap[514][CaseClause] = 92;
   _jumpMap[514][Factor] = 91;
   _jumpMap[514][Term] = 90;
   _jumpMap[514][Expr] = 664;
   _actionMap[515][WHEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][ELSE] = ActionEntry(REDUCE, 301);
   _actionMap[515][LEFT] = ActionEntry(REDUCE, 301);
   _actionMap[515][RIGHT] = ActionEntry(REDUCE, 301);
   _actionMap[515][INNER] = ActionEntry(REDUCE, 301);
   _actionMap[515][JOIN] = ActionEntry(REDUCE, 301);
   _actionMap[515][RETURNTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][ORDER] = ActionEntry(REDUCE, 301);
   _actionMap[515][GROUP] = ActionEntry(REDUCE, 301);
   _actionMap[515][WHERE] = ActionEntry(REDUCE, 301);
   _actionMap[515][FROM] = ActionEntry(REDUCE, 301);
   _actionMap[515][AS] = ActionEntry(REDUCE, 301);
   _actionMap[515][END_TOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][BEGIN] = ActionEntry(REDUCE, 301);
   _actionMap[515][THEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][OR] = ActionEntry(REDUCE, 301);
   _actionMap[515][AND] = ActionEntry(REDUCE, 301);
   _actionMap[515][INTOK] = ActionEntry(REDUCE, 301);
   _actionMap[515][NOT] = ActionEntry(REDUCE, 301);
   _actionMap[515][BETWEEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][IS] = ActionEntry(REDUCE, 301);
   _actionMap[515][LIKE] = ActionEntry(REDUCE, 301);
   _actionMap[515][MT] = ActionEntry(REDUCE, 301);
   _actionMap[515][LT] = ActionEntry(REDUCE, 301);
   _actionMap[515][NEGATION] = ActionEntry(REDUCE, 301);
   _actionMap[515][EQU] = ActionEntry(REDUCE, 301);
   _actionMap[515][RB] = ActionEntry(REDUCE, 301);
   _actionMap[515][ENDTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[515][UNION] = ActionEntry(REDUCE, 301);
   _actionMap[515][ROWLIMIT] = ActionEntry(REDUCE, 301);
   _actionMap[515][KSEP] = ActionEntry(REDUCE, 301);
   _actionMap[515][ASC] = ActionEntry(REDUCE, 301);
   _actionMap[515][DESC] = ActionEntry(REDUCE, 301);
   _actionMap[515][SEMICOLON] = ActionEntry(REDUCE, 301);
}
void Cego::loadParser83()
{
   _actionMap[515][PLUS] = ActionEntry(REDUCE, 301);
   _actionMap[515][MINUS] = ActionEntry(REDUCE, 301);
   _actionMap[515][DIVISION] = ActionEntry(REDUCE, 301);
   _actionMap[515][STAR] = ActionEntry(REDUCE, 301);
   _actionMap[515][CONCAT] = ActionEntry(REDUCE, 301);
   _actionMap[516][WHEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][ELSE] = ActionEntry(REDUCE, 157);
   _actionMap[516][LEFT] = ActionEntry(REDUCE, 157);
   _actionMap[516][RIGHT] = ActionEntry(REDUCE, 157);
   _actionMap[516][INNER] = ActionEntry(REDUCE, 157);
   _actionMap[516][JOIN] = ActionEntry(REDUCE, 157);
   _actionMap[516][RETURNTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][ORDER] = ActionEntry(REDUCE, 157);
   _actionMap[516][GROUP] = ActionEntry(REDUCE, 157);
   _actionMap[516][WHERE] = ActionEntry(REDUCE, 157);
   _actionMap[516][AS] = ActionEntry(REDUCE, 157);
   _actionMap[516][FROM] = ActionEntry(REDUCE, 157);
   _actionMap[516][END_TOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][BEGIN] = ActionEntry(REDUCE, 157);
   _actionMap[516][THEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][OR] = ActionEntry(REDUCE, 157);
   _actionMap[516][AND] = ActionEntry(REDUCE, 157);
   _actionMap[516][LIKE] = ActionEntry(REDUCE, 157);
   _actionMap[516][IS] = ActionEntry(REDUCE, 157);
   _actionMap[516][BETWEEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][NOT] = ActionEntry(REDUCE, 157);
   _actionMap[516][INTOK] = ActionEntry(REDUCE, 157);
   _actionMap[516][EQU] = ActionEntry(REDUCE, 157);
   _actionMap[516][NEGATION] = ActionEntry(REDUCE, 157);
   _actionMap[516][LT] = ActionEntry(REDUCE, 157);
   _actionMap[516][MT] = ActionEntry(REDUCE, 157);
   _actionMap[516][DESC] = ActionEntry(REDUCE, 157);
   _actionMap[516][ASC] = ActionEntry(REDUCE, 157);
   _actionMap[516][KSEP] = ActionEntry(REDUCE, 157);
   _actionMap[516][ROWLIMIT] = ActionEntry(REDUCE, 157);
   _actionMap[516][UNION] = ActionEntry(REDUCE, 157);
   _actionMap[516][ENDTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[516][RB] = ActionEntry(REDUCE, 157);
   _actionMap[516][SEMICOLON] = ActionEntry(REDUCE, 157);
   _actionMap[516][CONCAT] = ActionEntry(REDUCE, 157);
   _actionMap[516][STAR] = ActionEntry(REDUCE, 157);
   _actionMap[516][DIVISION] = ActionEntry(REDUCE, 157);
   _actionMap[516][MINUS] = ActionEntry(REDUCE, 157);
   _actionMap[516][PLUS] = ActionEntry(REDUCE, 157);
   _actionMap[517][WHEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][ELSE] = ActionEntry(REDUCE, 296);
   _actionMap[517][LEFT] = ActionEntry(REDUCE, 296);
   _actionMap[517][RIGHT] = ActionEntry(REDUCE, 296);
   _actionMap[517][INNER] = ActionEntry(REDUCE, 296);
   _actionMap[517][JOIN] = ActionEntry(REDUCE, 296);
}
void Cego::loadParser84()
{
   _actionMap[517][RETURNTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][ORDER] = ActionEntry(REDUCE, 296);
   _actionMap[517][GROUP] = ActionEntry(REDUCE, 296);
   _actionMap[517][WHERE] = ActionEntry(REDUCE, 296);
   _actionMap[517][FROM] = ActionEntry(REDUCE, 296);
   _actionMap[517][AS] = ActionEntry(REDUCE, 296);
   _actionMap[517][END_TOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][BEGIN] = ActionEntry(REDUCE, 296);
   _actionMap[517][THEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][OR] = ActionEntry(REDUCE, 296);
   _actionMap[517][AND] = ActionEntry(REDUCE, 296);
   _actionMap[517][INTOK] = ActionEntry(REDUCE, 296);
   _actionMap[517][NOT] = ActionEntry(REDUCE, 296);
   _actionMap[517][BETWEEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][IS] = ActionEntry(REDUCE, 296);
   _actionMap[517][LIKE] = ActionEntry(REDUCE, 296);
   _actionMap[517][MT] = ActionEntry(REDUCE, 296);
   _actionMap[517][LT] = ActionEntry(REDUCE, 296);
   _actionMap[517][NEGATION] = ActionEntry(REDUCE, 296);
   _actionMap[517][EQU] = ActionEntry(REDUCE, 296);
   _actionMap[517][RB] = ActionEntry(REDUCE, 296);
   _actionMap[517][ENDTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[517][UNION] = ActionEntry(REDUCE, 296);
   _actionMap[517][ROWLIMIT] = ActionEntry(REDUCE, 296);
   _actionMap[517][KSEP] = ActionEntry(REDUCE, 296);
   _actionMap[517][ASC] = ActionEntry(REDUCE, 296);
   _actionMap[517][DESC] = ActionEntry(REDUCE, 296);
   _actionMap[517][SEMICOLON] = ActionEntry(REDUCE, 296);
   _actionMap[517][PLUS] = ActionEntry(REDUCE, 296);
   _actionMap[517][MINUS] = ActionEntry(REDUCE, 296);
   _actionMap[517][DIVISION] = ActionEntry(REDUCE, 296);
   _actionMap[517][STAR] = ActionEntry(REDUCE, 296);
   _actionMap[517][CONCAT] = ActionEntry(REDUCE, 296);
   _actionMap[518][WHEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][ELSE] = ActionEntry(REDUCE, 297);
   _actionMap[518][LEFT] = ActionEntry(REDUCE, 297);
   _actionMap[518][RIGHT] = ActionEntry(REDUCE, 297);
   _actionMap[518][INNER] = ActionEntry(REDUCE, 297);
   _actionMap[518][JOIN] = ActionEntry(REDUCE, 297);
   _actionMap[518][RETURNTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][ORDER] = ActionEntry(REDUCE, 297);
   _actionMap[518][GROUP] = ActionEntry(REDUCE, 297);
   _actionMap[518][WHERE] = ActionEntry(REDUCE, 297);
   _actionMap[518][FROM] = ActionEntry(REDUCE, 297);
   _actionMap[518][AS] = ActionEntry(REDUCE, 297);
   _actionMap[518][END_TOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][BEGIN] = ActionEntry(REDUCE, 297);
   _actionMap[518][THEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][OR] = ActionEntry(REDUCE, 297);
   _actionMap[518][AND] = ActionEntry(REDUCE, 297);
}
void Cego::loadParser85()
{
   _actionMap[518][INTOK] = ActionEntry(REDUCE, 297);
   _actionMap[518][NOT] = ActionEntry(REDUCE, 297);
   _actionMap[518][BETWEEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][IS] = ActionEntry(REDUCE, 297);
   _actionMap[518][LIKE] = ActionEntry(REDUCE, 297);
   _actionMap[518][MT] = ActionEntry(REDUCE, 297);
   _actionMap[518][LT] = ActionEntry(REDUCE, 297);
   _actionMap[518][NEGATION] = ActionEntry(REDUCE, 297);
   _actionMap[518][EQU] = ActionEntry(REDUCE, 297);
   _actionMap[518][RB] = ActionEntry(REDUCE, 297);
   _actionMap[518][ENDTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[518][UNION] = ActionEntry(REDUCE, 297);
   _actionMap[518][ROWLIMIT] = ActionEntry(REDUCE, 297);
   _actionMap[518][KSEP] = ActionEntry(REDUCE, 297);
   _actionMap[518][ASC] = ActionEntry(REDUCE, 297);
   _actionMap[518][DESC] = ActionEntry(REDUCE, 297);
   _actionMap[518][SEMICOLON] = ActionEntry(REDUCE, 297);
   _actionMap[518][PLUS] = ActionEntry(REDUCE, 297);
   _actionMap[518][MINUS] = ActionEntry(REDUCE, 297);
   _actionMap[518][DIVISION] = ActionEntry(REDUCE, 297);
   _actionMap[518][STAR] = ActionEntry(REDUCE, 297);
   _actionMap[518][CONCAT] = ActionEntry(REDUCE, 297);
   _actionMap[519][WHEN] = ActionEntry(REDUCE, 298);
   _actionMap[519][ELSE] = ActionEntry(REDUCE, 298);
   _actionMap[519][LEFT] = ActionEntry(REDUCE, 298);
   _actionMap[519][RIGHT] = ActionEntry(REDUCE, 298);
   _actionMap[519][INNER] = ActionEntry(REDUCE, 298);
   _actionMap[519][JOIN] = ActionEntry(REDUCE, 298);
   _actionMap[519][RETURNTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[519][ORDER] = ActionEntry(REDUCE, 298);
   _actionMap[519][GROUP] = ActionEntry(REDUCE, 298);
   _actionMap[519][WHERE] = ActionEntry(REDUCE, 298);
   _actionMap[519][FROM] = ActionEntry(REDUCE, 298);
   _actionMap[519][AS] = ActionEntry(REDUCE, 298);
   _actionMap[519][END_TOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[519][BEGIN] = ActionEntry(REDUCE, 298);
   _actionMap[519][THEN] = ActionEntry(REDUCE, 298);
   _actionMap[519][OR] = ActionEntry(REDUCE, 298);
   _actionMap[519][AND] = ActionEntry(REDUCE, 298);
   _actionMap[519][INTOK] = ActionEntry(REDUCE, 298);
   _actionMap[519][NOT] = ActionEntry(REDUCE, 298);
   _actionMap[519][BETWEEN] = ActionEntry(REDUCE, 298);
   _actionMap[519][IS] = ActionEntry(REDUCE, 298);
   _actionMap[519][LIKE] = ActionEntry(REDUCE, 298);
   _actionMap[519][MT] = ActionEntry(REDUCE, 298);
   _actionMap[519][LT] = ActionEntry(REDUCE, 298);
   _actionMap[519][NEGATION] = ActionEntry(REDUCE, 298);
   _actionMap[519][EQU] = ActionEntry(REDUCE, 298);
   _actionMap[519][RB] = ActionEntry(REDUCE, 298);
   _actionMap[519][ENDTOKEN] = ActionEntry(REDUCE, 298);
}
void Cego::loadParser86()
{
   _actionMap[519][UNION] = ActionEntry(REDUCE, 298);
   _actionMap[519][ROWLIMIT] = ActionEntry(REDUCE, 298);
   _actionMap[519][KSEP] = ActionEntry(REDUCE, 298);
   _actionMap[519][ASC] = ActionEntry(REDUCE, 298);
   _actionMap[519][DESC] = ActionEntry(REDUCE, 298);
   _actionMap[519][SEMICOLON] = ActionEntry(REDUCE, 298);
   _actionMap[519][PLUS] = ActionEntry(REDUCE, 298);
   _actionMap[519][MINUS] = ActionEntry(REDUCE, 298);
   _actionMap[519][DIVISION] = ActionEntry(REDUCE, 298);
   _actionMap[519][STAR] = ActionEntry(REDUCE, 298);
   _actionMap[519][CONCAT] = ActionEntry(REDUCE, 298);
   _actionMap[520][WHEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][ELSE] = ActionEntry(REDUCE, 158);
   _actionMap[520][LEFT] = ActionEntry(REDUCE, 158);
   _actionMap[520][RIGHT] = ActionEntry(REDUCE, 158);
   _actionMap[520][INNER] = ActionEntry(REDUCE, 158);
   _actionMap[520][JOIN] = ActionEntry(REDUCE, 158);
   _actionMap[520][RETURNTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][ORDER] = ActionEntry(REDUCE, 158);
   _actionMap[520][GROUP] = ActionEntry(REDUCE, 158);
   _actionMap[520][WHERE] = ActionEntry(REDUCE, 158);
   _actionMap[520][AS] = ActionEntry(REDUCE, 158);
   _actionMap[520][FROM] = ActionEntry(REDUCE, 158);
   _actionMap[520][END_TOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][BEGIN] = ActionEntry(REDUCE, 158);
   _actionMap[520][THEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][OR] = ActionEntry(REDUCE, 158);
   _actionMap[520][AND] = ActionEntry(REDUCE, 158);
   _actionMap[520][LIKE] = ActionEntry(REDUCE, 158);
   _actionMap[520][IS] = ActionEntry(REDUCE, 158);
   _actionMap[520][BETWEEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][NOT] = ActionEntry(REDUCE, 158);
   _actionMap[520][INTOK] = ActionEntry(REDUCE, 158);
   _actionMap[520][EQU] = ActionEntry(REDUCE, 158);
   _actionMap[520][NEGATION] = ActionEntry(REDUCE, 158);
   _actionMap[520][LT] = ActionEntry(REDUCE, 158);
   _actionMap[520][MT] = ActionEntry(REDUCE, 158);
   _actionMap[520][DESC] = ActionEntry(REDUCE, 158);
   _actionMap[520][ASC] = ActionEntry(REDUCE, 158);
   _actionMap[520][KSEP] = ActionEntry(REDUCE, 158);
   _actionMap[520][ROWLIMIT] = ActionEntry(REDUCE, 158);
   _actionMap[520][UNION] = ActionEntry(REDUCE, 158);
   _actionMap[520][ENDTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[520][RB] = ActionEntry(REDUCE, 158);
   _actionMap[520][SEMICOLON] = ActionEntry(REDUCE, 158);
   _actionMap[520][CONCAT] = ActionEntry(REDUCE, 158);
   _actionMap[520][STAR] = ActionEntry(REDUCE, 158);
   _actionMap[520][DIVISION] = ActionEntry(REDUCE, 158);
   _actionMap[520][MINUS] = ActionEntry(REDUCE, 158);
   _actionMap[520][PLUS] = ActionEntry(REDUCE, 158);
}
void Cego::loadParser87()
{
   _actionMap[521][WHEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][ELSE] = ActionEntry(REDUCE, 155);
   _actionMap[521][LEFT] = ActionEntry(REDUCE, 155);
   _actionMap[521][RIGHT] = ActionEntry(REDUCE, 155);
   _actionMap[521][INNER] = ActionEntry(REDUCE, 155);
   _actionMap[521][JOIN] = ActionEntry(REDUCE, 155);
   _actionMap[521][RETURNTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][ORDER] = ActionEntry(REDUCE, 155);
   _actionMap[521][GROUP] = ActionEntry(REDUCE, 155);
   _actionMap[521][WHERE] = ActionEntry(REDUCE, 155);
   _actionMap[521][AS] = ActionEntry(REDUCE, 155);
   _actionMap[521][FROM] = ActionEntry(REDUCE, 155);
   _actionMap[521][END_TOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][BEGIN] = ActionEntry(REDUCE, 155);
   _actionMap[521][THEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][OR] = ActionEntry(REDUCE, 155);
   _actionMap[521][AND] = ActionEntry(REDUCE, 155);
   _actionMap[521][LIKE] = ActionEntry(REDUCE, 155);
   _actionMap[521][IS] = ActionEntry(REDUCE, 155);
   _actionMap[521][BETWEEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][NOT] = ActionEntry(REDUCE, 155);
   _actionMap[521][INTOK] = ActionEntry(REDUCE, 155);
   _actionMap[521][EQU] = ActionEntry(REDUCE, 155);
   _actionMap[521][NEGATION] = ActionEntry(REDUCE, 155);
   _actionMap[521][LT] = ActionEntry(REDUCE, 155);
   _actionMap[521][MT] = ActionEntry(REDUCE, 155);
   _actionMap[521][DESC] = ActionEntry(REDUCE, 155);
   _actionMap[521][ASC] = ActionEntry(REDUCE, 155);
   _actionMap[521][KSEP] = ActionEntry(REDUCE, 155);
   _actionMap[521][ROWLIMIT] = ActionEntry(REDUCE, 155);
   _actionMap[521][UNION] = ActionEntry(REDUCE, 155);
   _actionMap[521][ENDTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[521][RB] = ActionEntry(REDUCE, 155);
   _actionMap[521][SEMICOLON] = ActionEntry(REDUCE, 155);
   _actionMap[521][CONCAT] = ActionEntry(REDUCE, 155);
   _actionMap[521][STAR] = ActionEntry(REDUCE, 155);
   _actionMap[521][DIVISION] = ActionEntry(REDUCE, 155);
   _actionMap[521][MINUS] = ActionEntry(REDUCE, 155);
   _actionMap[521][PLUS] = ActionEntry(REDUCE, 155);
   _actionMap[522][STRINGVAL] = ActionEntry(SHIFT, 666);
   _jumpMap[522][DateValue] = 665;
   _actionMap[523][WHEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][ELSE] = ActionEntry(REDUCE, 276);
   _actionMap[523][LEFT] = ActionEntry(REDUCE, 276);
   _actionMap[523][RIGHT] = ActionEntry(REDUCE, 276);
   _actionMap[523][INNER] = ActionEntry(REDUCE, 276);
   _actionMap[523][JOIN] = ActionEntry(REDUCE, 276);
   _actionMap[523][RETURNTOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][ORDER] = ActionEntry(REDUCE, 276);
   _actionMap[523][GROUP] = ActionEntry(REDUCE, 276);
}
void Cego::loadParser88()
{
   _actionMap[523][WHERE] = ActionEntry(REDUCE, 276);
   _actionMap[523][FROM] = ActionEntry(REDUCE, 276);
   _actionMap[523][AS] = ActionEntry(REDUCE, 276);
   _actionMap[523][END_TOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][BEGIN] = ActionEntry(REDUCE, 276);
   _actionMap[523][THEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][OR] = ActionEntry(REDUCE, 276);
   _actionMap[523][AND] = ActionEntry(REDUCE, 276);
   _actionMap[523][INTOK] = ActionEntry(REDUCE, 276);
   _actionMap[523][NOT] = ActionEntry(REDUCE, 276);
   _actionMap[523][BETWEEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][IS] = ActionEntry(REDUCE, 276);
   _actionMap[523][LIKE] = ActionEntry(REDUCE, 276);
   _actionMap[523][MT] = ActionEntry(REDUCE, 276);
   _actionMap[523][LT] = ActionEntry(REDUCE, 276);
   _actionMap[523][NEGATION] = ActionEntry(REDUCE, 276);
   _actionMap[523][EQU] = ActionEntry(REDUCE, 276);
   _actionMap[523][RB] = ActionEntry(REDUCE, 276);
   _actionMap[523][ENDTOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[523][UNION] = ActionEntry(REDUCE, 276);
   _actionMap[523][ROWLIMIT] = ActionEntry(REDUCE, 276);
   _actionMap[523][KSEP] = ActionEntry(REDUCE, 276);
   _actionMap[523][ASC] = ActionEntry(REDUCE, 276);
   _actionMap[523][DESC] = ActionEntry(REDUCE, 276);
   _actionMap[523][SEMICOLON] = ActionEntry(REDUCE, 276);
   _actionMap[523][PLUS] = ActionEntry(REDUCE, 276);
   _actionMap[523][MINUS] = ActionEntry(REDUCE, 276);
   _actionMap[523][DIVISION] = ActionEntry(REDUCE, 276);
   _actionMap[523][STAR] = ActionEntry(REDUCE, 276);
   _actionMap[523][CONCAT] = ActionEntry(REDUCE, 276);
   _actionMap[524][WHEN] = ActionEntry(REDUCE, 277);
   _actionMap[524][ELSE] = ActionEntry(REDUCE, 277);
   _actionMap[524][LEFT] = ActionEntry(REDUCE, 277);
   _actionMap[524][RIGHT] = ActionEntry(REDUCE, 277);
   _actionMap[524][INNER] = ActionEntry(REDUCE, 277);
   _actionMap[524][JOIN] = ActionEntry(REDUCE, 277);
   _actionMap[524][RETURNTOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[524][ORDER] = ActionEntry(REDUCE, 277);
   _actionMap[524][GROUP] = ActionEntry(REDUCE, 277);
   _actionMap[524][WHERE] = ActionEntry(REDUCE, 277);
   _actionMap[524][FROM] = ActionEntry(REDUCE, 277);
   _actionMap[524][AS] = ActionEntry(REDUCE, 277);
   _actionMap[524][END_TOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[524][BEGIN] = ActionEntry(REDUCE, 277);
   _actionMap[524][THEN] = ActionEntry(REDUCE, 277);
   _actionMap[524][OR] = ActionEntry(REDUCE, 277);
   _actionMap[524][AND] = ActionEntry(REDUCE, 277);
   _actionMap[524][INTOK] = ActionEntry(REDUCE, 277);
   _actionMap[524][NOT] = ActionEntry(REDUCE, 277);
   _actionMap[524][BETWEEN] = ActionEntry(REDUCE, 277);
}
void Cego::loadParser89()
{
   _actionMap[524][IS] = ActionEntry(REDUCE, 277);
   _actionMap[524][LIKE] = ActionEntry(REDUCE, 277);
   _actionMap[524][MT] = ActionEntry(REDUCE, 277);
   _actionMap[524][LT] = ActionEntry(REDUCE, 277);
   _actionMap[524][NEGATION] = ActionEntry(REDUCE, 277);
   _actionMap[524][EQU] = ActionEntry(REDUCE, 277);
   _actionMap[524][RB] = ActionEntry(REDUCE, 277);
   _actionMap[524][ENDTOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[524][UNION] = ActionEntry(REDUCE, 277);
   _actionMap[524][ROWLIMIT] = ActionEntry(REDUCE, 277);
   _actionMap[524][KSEP] = ActionEntry(REDUCE, 277);
   _actionMap[524][ASC] = ActionEntry(REDUCE, 277);
   _actionMap[524][DESC] = ActionEntry(REDUCE, 277);
   _actionMap[524][SEMICOLON] = ActionEntry(REDUCE, 277);
   _actionMap[524][PLUS] = ActionEntry(REDUCE, 277);
   _actionMap[524][MINUS] = ActionEntry(REDUCE, 277);
   _actionMap[524][DIVISION] = ActionEntry(REDUCE, 277);
   _actionMap[524][STAR] = ActionEntry(REDUCE, 277);
   _actionMap[524][CONCAT] = ActionEntry(REDUCE, 277);
   _actionMap[525][WHEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][ELSE] = ActionEntry(REDUCE, 294);
   _actionMap[525][LEFT] = ActionEntry(REDUCE, 294);
   _actionMap[525][RIGHT] = ActionEntry(REDUCE, 294);
   _actionMap[525][INNER] = ActionEntry(REDUCE, 294);
   _actionMap[525][JOIN] = ActionEntry(REDUCE, 294);
   _actionMap[525][RETURNTOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][ORDER] = ActionEntry(REDUCE, 294);
   _actionMap[525][GROUP] = ActionEntry(REDUCE, 294);
   _actionMap[525][WHERE] = ActionEntry(REDUCE, 294);
   _actionMap[525][FROM] = ActionEntry(REDUCE, 294);
   _actionMap[525][AS] = ActionEntry(REDUCE, 294);
   _actionMap[525][END_TOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][BEGIN] = ActionEntry(REDUCE, 294);
   _actionMap[525][THEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][OR] = ActionEntry(REDUCE, 294);
   _actionMap[525][AND] = ActionEntry(REDUCE, 294);
   _actionMap[525][INTOK] = ActionEntry(REDUCE, 294);
   _actionMap[525][NOT] = ActionEntry(REDUCE, 294);
   _actionMap[525][BETWEEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][IS] = ActionEntry(REDUCE, 294);
   _actionMap[525][LIKE] = ActionEntry(REDUCE, 294);
   _actionMap[525][MT] = ActionEntry(REDUCE, 294);
   _actionMap[525][LT] = ActionEntry(REDUCE, 294);
   _actionMap[525][NEGATION] = ActionEntry(REDUCE, 294);
   _actionMap[525][EQU] = ActionEntry(REDUCE, 294);
   _actionMap[525][RB] = ActionEntry(REDUCE, 294);
   _actionMap[525][ENDTOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[525][UNION] = ActionEntry(REDUCE, 294);
   _actionMap[525][ROWLIMIT] = ActionEntry(REDUCE, 294);
   _actionMap[525][KSEP] = ActionEntry(REDUCE, 294);
}
void Cego::loadParser90()
{
   _actionMap[525][ASC] = ActionEntry(REDUCE, 294);
   _actionMap[525][DESC] = ActionEntry(REDUCE, 294);
   _actionMap[525][SEMICOLON] = ActionEntry(REDUCE, 294);
   _actionMap[525][PLUS] = ActionEntry(REDUCE, 294);
   _actionMap[525][MINUS] = ActionEntry(REDUCE, 294);
   _actionMap[525][DIVISION] = ActionEntry(REDUCE, 294);
   _actionMap[525][STAR] = ActionEntry(REDUCE, 294);
   _actionMap[525][CONCAT] = ActionEntry(REDUCE, 294);
   _actionMap[526][VARREF] = ActionEntry(SHIFT, 668);
   _jumpMap[526][FetchArgList] = 667;
   _actionMap[527][WHEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][ELSE] = ActionEntry(REDUCE, 283);
   _actionMap[527][LEFT] = ActionEntry(REDUCE, 283);
   _actionMap[527][RIGHT] = ActionEntry(REDUCE, 283);
   _actionMap[527][INNER] = ActionEntry(REDUCE, 283);
   _actionMap[527][JOIN] = ActionEntry(REDUCE, 283);
   _actionMap[527][RETURNTOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][ORDER] = ActionEntry(REDUCE, 283);
   _actionMap[527][GROUP] = ActionEntry(REDUCE, 283);
   _actionMap[527][WHERE] = ActionEntry(REDUCE, 283);
   _actionMap[527][FROM] = ActionEntry(REDUCE, 283);
   _actionMap[527][AS] = ActionEntry(REDUCE, 283);
   _actionMap[527][END_TOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][BEGIN] = ActionEntry(REDUCE, 283);
   _actionMap[527][THEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][OR] = ActionEntry(REDUCE, 283);
   _actionMap[527][AND] = ActionEntry(REDUCE, 283);
   _actionMap[527][INTOK] = ActionEntry(REDUCE, 283);
   _actionMap[527][NOT] = ActionEntry(REDUCE, 283);
   _actionMap[527][BETWEEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][IS] = ActionEntry(REDUCE, 283);
   _actionMap[527][LIKE] = ActionEntry(REDUCE, 283);
   _actionMap[527][MT] = ActionEntry(REDUCE, 283);
   _actionMap[527][LT] = ActionEntry(REDUCE, 283);
   _actionMap[527][NEGATION] = ActionEntry(REDUCE, 283);
   _actionMap[527][EQU] = ActionEntry(REDUCE, 283);
   _actionMap[527][RB] = ActionEntry(REDUCE, 283);
   _actionMap[527][ENDTOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[527][UNION] = ActionEntry(REDUCE, 283);
   _actionMap[527][ROWLIMIT] = ActionEntry(REDUCE, 283);
   _actionMap[527][KSEP] = ActionEntry(REDUCE, 283);
   _actionMap[527][ASC] = ActionEntry(REDUCE, 283);
   _actionMap[527][DESC] = ActionEntry(REDUCE, 283);
   _actionMap[527][SEMICOLON] = ActionEntry(REDUCE, 283);
   _actionMap[527][PLUS] = ActionEntry(REDUCE, 283);
   _actionMap[527][MINUS] = ActionEntry(REDUCE, 283);
   _actionMap[527][DIVISION] = ActionEntry(REDUCE, 283);
   _actionMap[527][STAR] = ActionEntry(REDUCE, 283);
   _actionMap[527][CONCAT] = ActionEntry(REDUCE, 283);
   _actionMap[528][WHEN] = ActionEntry(REDUCE, 278);
}
void Cego::loadParser91()
{
   _actionMap[528][ELSE] = ActionEntry(REDUCE, 278);
   _actionMap[528][LEFT] = ActionEntry(REDUCE, 278);
   _actionMap[528][RIGHT] = ActionEntry(REDUCE, 278);
   _actionMap[528][INNER] = ActionEntry(REDUCE, 278);
   _actionMap[528][JOIN] = ActionEntry(REDUCE, 278);
   _actionMap[528][RETURNTOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[528][ORDER] = ActionEntry(REDUCE, 278);
   _actionMap[528][GROUP] = ActionEntry(REDUCE, 278);
   _actionMap[528][WHERE] = ActionEntry(REDUCE, 278);
   _actionMap[528][FROM] = ActionEntry(REDUCE, 278);
   _actionMap[528][AS] = ActionEntry(REDUCE, 278);
   _actionMap[528][END_TOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[528][BEGIN] = ActionEntry(REDUCE, 278);
   _actionMap[528][THEN] = ActionEntry(REDUCE, 278);
   _actionMap[528][OR] = ActionEntry(REDUCE, 278);
   _actionMap[528][AND] = ActionEntry(REDUCE, 278);
   _actionMap[528][INTOK] = ActionEntry(REDUCE, 278);
   _actionMap[528][NOT] = ActionEntry(REDUCE, 278);
   _actionMap[528][BETWEEN] = ActionEntry(REDUCE, 278);
   _actionMap[528][IS] = ActionEntry(REDUCE, 278);
   _actionMap[528][LIKE] = ActionEntry(REDUCE, 278);
   _actionMap[528][MT] = ActionEntry(REDUCE, 278);
   _actionMap[528][LT] = ActionEntry(REDUCE, 278);
   _actionMap[528][NEGATION] = ActionEntry(REDUCE, 278);
   _actionMap[528][EQU] = ActionEntry(REDUCE, 278);
   _actionMap[528][RB] = ActionEntry(REDUCE, 278);
   _actionMap[528][ENDTOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[528][UNION] = ActionEntry(REDUCE, 278);
   _actionMap[528][ROWLIMIT] = ActionEntry(REDUCE, 278);
   _actionMap[528][KSEP] = ActionEntry(REDUCE, 278);
   _actionMap[528][ASC] = ActionEntry(REDUCE, 278);
   _actionMap[528][DESC] = ActionEntry(REDUCE, 278);
   _actionMap[528][SEMICOLON] = ActionEntry(REDUCE, 278);
   _actionMap[528][PLUS] = ActionEntry(REDUCE, 278);
   _actionMap[528][MINUS] = ActionEntry(REDUCE, 278);
   _actionMap[528][DIVISION] = ActionEntry(REDUCE, 278);
   _actionMap[528][STAR] = ActionEntry(REDUCE, 278);
   _actionMap[528][CONCAT] = ActionEntry(REDUCE, 278);
   _actionMap[529][WHEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][ELSE] = ActionEntry(REDUCE, 281);
   _actionMap[529][LEFT] = ActionEntry(REDUCE, 281);
   _actionMap[529][RIGHT] = ActionEntry(REDUCE, 281);
   _actionMap[529][INNER] = ActionEntry(REDUCE, 281);
   _actionMap[529][JOIN] = ActionEntry(REDUCE, 281);
   _actionMap[529][RETURNTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][ORDER] = ActionEntry(REDUCE, 281);
   _actionMap[529][GROUP] = ActionEntry(REDUCE, 281);
   _actionMap[529][WHERE] = ActionEntry(REDUCE, 281);
   _actionMap[529][FROM] = ActionEntry(REDUCE, 281);
   _actionMap[529][AS] = ActionEntry(REDUCE, 281);
}
void Cego::loadParser92()
{
   _actionMap[529][END_TOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][BEGIN] = ActionEntry(REDUCE, 281);
   _actionMap[529][THEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][OR] = ActionEntry(REDUCE, 281);
   _actionMap[529][AND] = ActionEntry(REDUCE, 281);
   _actionMap[529][INTOK] = ActionEntry(REDUCE, 281);
   _actionMap[529][NOT] = ActionEntry(REDUCE, 281);
   _actionMap[529][BETWEEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][IS] = ActionEntry(REDUCE, 281);
   _actionMap[529][LIKE] = ActionEntry(REDUCE, 281);
   _actionMap[529][MT] = ActionEntry(REDUCE, 281);
   _actionMap[529][LT] = ActionEntry(REDUCE, 281);
   _actionMap[529][NEGATION] = ActionEntry(REDUCE, 281);
   _actionMap[529][EQU] = ActionEntry(REDUCE, 281);
   _actionMap[529][RB] = ActionEntry(REDUCE, 281);
   _actionMap[529][ENDTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[529][UNION] = ActionEntry(REDUCE, 281);
   _actionMap[529][ROWLIMIT] = ActionEntry(REDUCE, 281);
   _actionMap[529][KSEP] = ActionEntry(REDUCE, 281);
   _actionMap[529][ASC] = ActionEntry(REDUCE, 281);
   _actionMap[529][DESC] = ActionEntry(REDUCE, 281);
   _actionMap[529][SEMICOLON] = ActionEntry(REDUCE, 281);
   _actionMap[529][PLUS] = ActionEntry(REDUCE, 281);
   _actionMap[529][MINUS] = ActionEntry(REDUCE, 281);
   _actionMap[529][DIVISION] = ActionEntry(REDUCE, 281);
   _actionMap[529][STAR] = ActionEntry(REDUCE, 281);
   _actionMap[529][CONCAT] = ActionEntry(REDUCE, 281);
   _actionMap[530][WHEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][ELSE] = ActionEntry(REDUCE, 286);
   _actionMap[530][LEFT] = ActionEntry(REDUCE, 286);
   _actionMap[530][RIGHT] = ActionEntry(REDUCE, 286);
   _actionMap[530][INNER] = ActionEntry(REDUCE, 286);
   _actionMap[530][JOIN] = ActionEntry(REDUCE, 286);
   _actionMap[530][RETURNTOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][ORDER] = ActionEntry(REDUCE, 286);
   _actionMap[530][GROUP] = ActionEntry(REDUCE, 286);
   _actionMap[530][WHERE] = ActionEntry(REDUCE, 286);
   _actionMap[530][FROM] = ActionEntry(REDUCE, 286);
   _actionMap[530][AS] = ActionEntry(REDUCE, 286);
   _actionMap[530][END_TOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][BEGIN] = ActionEntry(REDUCE, 286);
   _actionMap[530][THEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][OR] = ActionEntry(REDUCE, 286);
   _actionMap[530][AND] = ActionEntry(REDUCE, 286);
   _actionMap[530][INTOK] = ActionEntry(REDUCE, 286);
   _actionMap[530][NOT] = ActionEntry(REDUCE, 286);
   _actionMap[530][BETWEEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][IS] = ActionEntry(REDUCE, 286);
   _actionMap[530][LIKE] = ActionEntry(REDUCE, 286);
   _actionMap[530][MT] = ActionEntry(REDUCE, 286);
}
void Cego::loadParser93()
{
   _actionMap[530][LT] = ActionEntry(REDUCE, 286);
   _actionMap[530][NEGATION] = ActionEntry(REDUCE, 286);
   _actionMap[530][EQU] = ActionEntry(REDUCE, 286);
   _actionMap[530][RB] = ActionEntry(REDUCE, 286);
   _actionMap[530][ENDTOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[530][UNION] = ActionEntry(REDUCE, 286);
   _actionMap[530][ROWLIMIT] = ActionEntry(REDUCE, 286);
   _actionMap[530][KSEP] = ActionEntry(REDUCE, 286);
   _actionMap[530][ASC] = ActionEntry(REDUCE, 286);
   _actionMap[530][DESC] = ActionEntry(REDUCE, 286);
   _actionMap[530][SEMICOLON] = ActionEntry(REDUCE, 286);
   _actionMap[530][PLUS] = ActionEntry(REDUCE, 286);
   _actionMap[530][MINUS] = ActionEntry(REDUCE, 286);
   _actionMap[530][DIVISION] = ActionEntry(REDUCE, 286);
   _actionMap[530][STAR] = ActionEntry(REDUCE, 286);
   _actionMap[530][CONCAT] = ActionEntry(REDUCE, 286);
   _actionMap[531][WHEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][ELSE] = ActionEntry(REDUCE, 279);
   _actionMap[531][LEFT] = ActionEntry(REDUCE, 279);
   _actionMap[531][RIGHT] = ActionEntry(REDUCE, 279);
   _actionMap[531][INNER] = ActionEntry(REDUCE, 279);
   _actionMap[531][JOIN] = ActionEntry(REDUCE, 279);
   _actionMap[531][RETURNTOKEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][ORDER] = ActionEntry(REDUCE, 279);
   _actionMap[531][GROUP] = ActionEntry(REDUCE, 279);
   _actionMap[531][WHERE] = ActionEntry(REDUCE, 279);
   _actionMap[531][FROM] = ActionEntry(REDUCE, 279);
   _actionMap[531][AS] = ActionEntry(REDUCE, 279);
   _actionMap[531][END_TOKEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][BEGIN] = ActionEntry(REDUCE, 279);
   _actionMap[531][THEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][OR] = ActionEntry(REDUCE, 279);
   _actionMap[531][AND] = ActionEntry(REDUCE, 279);
   _actionMap[531][INTOK] = ActionEntry(REDUCE, 279);
   _actionMap[531][NOT] = ActionEntry(REDUCE, 279);
   _actionMap[531][BETWEEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][IS] = ActionEntry(REDUCE, 279);
   _actionMap[531][LIKE] = ActionEntry(REDUCE, 279);
   _actionMap[531][MT] = ActionEntry(REDUCE, 279);
   _actionMap[531][LT] = ActionEntry(REDUCE, 279);
   _actionMap[531][NEGATION] = ActionEntry(REDUCE, 279);
   _actionMap[531][EQU] = ActionEntry(REDUCE, 279);
   _actionMap[531][RB] = ActionEntry(REDUCE, 279);
   _actionMap[531][ENDTOKEN] = ActionEntry(REDUCE, 279);
   _actionMap[531][UNION] = ActionEntry(REDUCE, 279);
   _actionMap[531][ROWLIMIT] = ActionEntry(REDUCE, 279);
   _actionMap[531][KSEP] = ActionEntry(REDUCE, 279);
   _actionMap[531][ASC] = ActionEntry(REDUCE, 279);
   _actionMap[531][DESC] = ActionEntry(REDUCE, 279);
   _actionMap[531][SEMICOLON] = ActionEntry(REDUCE, 279);
}
void Cego::loadParser94()
{
   _actionMap[531][PLUS] = ActionEntry(REDUCE, 279);
   _actionMap[531][MINUS] = ActionEntry(REDUCE, 279);
   _actionMap[531][DIVISION] = ActionEntry(REDUCE, 279);
   _actionMap[531][STAR] = ActionEntry(REDUCE, 279);
   _actionMap[531][CONCAT] = ActionEntry(REDUCE, 279);
   _actionMap[532][WHEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][ELSE] = ActionEntry(REDUCE, 274);
   _actionMap[532][LEFT] = ActionEntry(REDUCE, 274);
   _actionMap[532][RIGHT] = ActionEntry(REDUCE, 274);
   _actionMap[532][INNER] = ActionEntry(REDUCE, 274);
   _actionMap[532][JOIN] = ActionEntry(REDUCE, 274);
   _actionMap[532][RETURNTOKEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][ORDER] = ActionEntry(REDUCE, 274);
   _actionMap[532][GROUP] = ActionEntry(REDUCE, 274);
   _actionMap[532][WHERE] = ActionEntry(REDUCE, 274);
   _actionMap[532][FROM] = ActionEntry(REDUCE, 274);
   _actionMap[532][AS] = ActionEntry(REDUCE, 274);
   _actionMap[532][END_TOKEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][BEGIN] = ActionEntry(REDUCE, 274);
   _actionMap[532][THEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][OR] = ActionEntry(REDUCE, 274);
   _actionMap[532][AND] = ActionEntry(REDUCE, 274);
   _actionMap[532][INTOK] = ActionEntry(REDUCE, 274);
   _actionMap[532][NOT] = ActionEntry(REDUCE, 274);
   _actionMap[532][BETWEEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][IS] = ActionEntry(REDUCE, 274);
   _actionMap[532][LIKE] = ActionEntry(REDUCE, 274);
   _actionMap[532][MT] = ActionEntry(REDUCE, 274);
   _actionMap[532][LT] = ActionEntry(REDUCE, 274);
   _actionMap[532][NEGATION] = ActionEntry(REDUCE, 274);
   _actionMap[532][EQU] = ActionEntry(REDUCE, 274);
   _actionMap[532][RB] = ActionEntry(REDUCE, 274);
   _actionMap[532][ENDTOKEN] = ActionEntry(REDUCE, 274);
   _actionMap[532][UNION] = ActionEntry(REDUCE, 274);
   _actionMap[532][ROWLIMIT] = ActionEntry(REDUCE, 274);
   _actionMap[532][KSEP] = ActionEntry(REDUCE, 274);
   _actionMap[532][ASC] = ActionEntry(REDUCE, 274);
   _actionMap[532][DESC] = ActionEntry(REDUCE, 274);
   _actionMap[532][SEMICOLON] = ActionEntry(REDUCE, 274);
   _actionMap[532][PLUS] = ActionEntry(REDUCE, 274);
   _actionMap[532][MINUS] = ActionEntry(REDUCE, 274);
   _actionMap[532][DIVISION] = ActionEntry(REDUCE, 274);
   _actionMap[532][STAR] = ActionEntry(REDUCE, 274);
   _actionMap[532][CONCAT] = ActionEntry(REDUCE, 274);
   _actionMap[533][WHEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][ELSE] = ActionEntry(REDUCE, 159);
   _actionMap[533][LEFT] = ActionEntry(REDUCE, 159);
   _actionMap[533][RIGHT] = ActionEntry(REDUCE, 159);
   _actionMap[533][INNER] = ActionEntry(REDUCE, 159);
   _actionMap[533][JOIN] = ActionEntry(REDUCE, 159);
}
void Cego::loadParser95()
{
   _actionMap[533][RETURNTOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][ORDER] = ActionEntry(REDUCE, 159);
   _actionMap[533][GROUP] = ActionEntry(REDUCE, 159);
   _actionMap[533][WHERE] = ActionEntry(REDUCE, 159);
   _actionMap[533][AS] = ActionEntry(REDUCE, 159);
   _actionMap[533][FROM] = ActionEntry(REDUCE, 159);
   _actionMap[533][END_TOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][BEGIN] = ActionEntry(REDUCE, 159);
   _actionMap[533][THEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][OR] = ActionEntry(REDUCE, 159);
   _actionMap[533][AND] = ActionEntry(REDUCE, 159);
   _actionMap[533][LIKE] = ActionEntry(REDUCE, 159);
   _actionMap[533][IS] = ActionEntry(REDUCE, 159);
   _actionMap[533][BETWEEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][NOT] = ActionEntry(REDUCE, 159);
   _actionMap[533][INTOK] = ActionEntry(REDUCE, 159);
   _actionMap[533][EQU] = ActionEntry(REDUCE, 159);
   _actionMap[533][NEGATION] = ActionEntry(REDUCE, 159);
   _actionMap[533][LT] = ActionEntry(REDUCE, 159);
   _actionMap[533][MT] = ActionEntry(REDUCE, 159);
   _actionMap[533][DESC] = ActionEntry(REDUCE, 159);
   _actionMap[533][ASC] = ActionEntry(REDUCE, 159);
   _actionMap[533][KSEP] = ActionEntry(REDUCE, 159);
   _actionMap[533][ROWLIMIT] = ActionEntry(REDUCE, 159);
   _actionMap[533][UNION] = ActionEntry(REDUCE, 159);
   _actionMap[533][ENDTOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[533][RB] = ActionEntry(REDUCE, 159);
   _actionMap[533][SEMICOLON] = ActionEntry(REDUCE, 159);
   _actionMap[533][CONCAT] = ActionEntry(REDUCE, 159);
   _actionMap[533][STAR] = ActionEntry(REDUCE, 159);
   _actionMap[533][DIVISION] = ActionEntry(REDUCE, 159);
   _actionMap[533][MINUS] = ActionEntry(REDUCE, 159);
   _actionMap[533][PLUS] = ActionEntry(REDUCE, 159);
   _actionMap[534][WHEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][ELSE] = ActionEntry(REDUCE, 160);
   _actionMap[534][LEFT] = ActionEntry(REDUCE, 160);
   _actionMap[534][RIGHT] = ActionEntry(REDUCE, 160);
   _actionMap[534][INNER] = ActionEntry(REDUCE, 160);
   _actionMap[534][JOIN] = ActionEntry(REDUCE, 160);
   _actionMap[534][RETURNTOKEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][ORDER] = ActionEntry(REDUCE, 160);
   _actionMap[534][GROUP] = ActionEntry(REDUCE, 160);
   _actionMap[534][WHERE] = ActionEntry(REDUCE, 160);
   _actionMap[534][AS] = ActionEntry(REDUCE, 160);
   _actionMap[534][FROM] = ActionEntry(REDUCE, 160);
   _actionMap[534][END_TOKEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][BEGIN] = ActionEntry(REDUCE, 160);
   _actionMap[534][THEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][OR] = ActionEntry(REDUCE, 160);
   _actionMap[534][AND] = ActionEntry(REDUCE, 160);
}
void Cego::loadParser96()
{
   _actionMap[534][LIKE] = ActionEntry(REDUCE, 160);
   _actionMap[534][IS] = ActionEntry(REDUCE, 160);
   _actionMap[534][BETWEEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][NOT] = ActionEntry(REDUCE, 160);
   _actionMap[534][INTOK] = ActionEntry(REDUCE, 160);
   _actionMap[534][EQU] = ActionEntry(REDUCE, 160);
   _actionMap[534][NEGATION] = ActionEntry(REDUCE, 160);
   _actionMap[534][LT] = ActionEntry(REDUCE, 160);
   _actionMap[534][MT] = ActionEntry(REDUCE, 160);
   _actionMap[534][DESC] = ActionEntry(REDUCE, 160);
   _actionMap[534][ASC] = ActionEntry(REDUCE, 160);
   _actionMap[534][KSEP] = ActionEntry(REDUCE, 160);
   _actionMap[534][ROWLIMIT] = ActionEntry(REDUCE, 160);
   _actionMap[534][UNION] = ActionEntry(REDUCE, 160);
   _actionMap[534][ENDTOKEN] = ActionEntry(REDUCE, 160);
   _actionMap[534][RB] = ActionEntry(REDUCE, 160);
   _actionMap[534][SEMICOLON] = ActionEntry(REDUCE, 160);
   _actionMap[534][CONCAT] = ActionEntry(REDUCE, 160);
   _actionMap[534][STAR] = ActionEntry(REDUCE, 160);
   _actionMap[534][DIVISION] = ActionEntry(REDUCE, 160);
   _actionMap[534][MINUS] = ActionEntry(REDUCE, 160);
   _actionMap[534][PLUS] = ActionEntry(REDUCE, 160);
   _actionMap[535][WHEN] = ActionEntry(REDUCE, 293);
   _actionMap[535][ELSE] = ActionEntry(REDUCE, 293);
   _actionMap[535][LEFT] = ActionEntry(REDUCE, 293);
   _actionMap[535][RIGHT] = ActionEntry(REDUCE, 293);
   _actionMap[535][INNER] = ActionEntry(REDUCE, 293);
   _actionMap[535][JOIN] = ActionEntry(REDUCE, 293);
   _actionMap[535][RETURNTOKEN] = ActionEntry(REDUCE, 293);
   _actionMap[535][ORDER] = ActionEntry(REDUCE, 293);
   _actionMap[535][GROUP] = ActionEntry(REDUCE, 293);
   _actionMap[535][WHERE] = ActionEntry(REDUCE, 293);
   _actionMap[535][FROM] = ActionEntry(REDUCE, 293);
   _actionMap[535][AS] = ActionEntry(REDUCE, 293);
   _actionMap[535][END_TOKEN] = ActionEntry(REDUCE, 293);
   _actionMap[535][BEGIN] = ActionEntry(REDUCE, 293);
   _actionMap[535][THEN] = ActionEntry(REDUCE, 293);
   _actionMap[535][OR] = ActionEntry(REDUCE, 293);
   _actionMap[535][AND] = ActionEntry(REDUCE, 293);
   _actionMap[535][INTOK] = ActionEntry(REDUCE, 293);
   _actionMap[535][NOT] = ActionEntry(REDUCE, 293);
   _actionMap[535][BETWEEN] = ActionEntry(REDUCE, 293);
   _actionMap[535][IS] = ActionEntry(REDUCE, 293);
   _actionMap[535][LIKE] = ActionEntry(REDUCE, 293);
   _actionMap[535][MT] = ActionEntry(REDUCE, 293);
   _actionMap[535][LT] = ActionEntry(REDUCE, 293);
   _actionMap[535][NEGATION] = ActionEntry(REDUCE, 293);
   _actionMap[535][EQU] = ActionEntry(REDUCE, 293);
   _actionMap[535][RB] = ActionEntry(REDUCE, 293);
   _actionMap[535][ENDTOKEN] = ActionEntry(REDUCE, 293);
}
void Cego::loadParser97()
{
   _actionMap[535][UNION] = ActionEntry(REDUCE, 293);
   _actionMap[535][ROWLIMIT] = ActionEntry(REDUCE, 293);
   _actionMap[535][KSEP] = ActionEntry(REDUCE, 293);
   _actionMap[535][ASC] = ActionEntry(REDUCE, 293);
   _actionMap[535][DESC] = ActionEntry(REDUCE, 293);
   _actionMap[535][SEMICOLON] = ActionEntry(REDUCE, 293);
   _actionMap[535][PLUS] = ActionEntry(REDUCE, 293);
   _actionMap[535][MINUS] = ActionEntry(REDUCE, 293);
   _actionMap[535][DIVISION] = ActionEntry(REDUCE, 293);
   _actionMap[535][STAR] = ActionEntry(REDUCE, 293);
   _actionMap[535][CONCAT] = ActionEntry(REDUCE, 293);
   _actionMap[536][WHEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][ELSE] = ActionEntry(REDUCE, 299);
   _actionMap[536][LEFT] = ActionEntry(REDUCE, 299);
   _actionMap[536][RIGHT] = ActionEntry(REDUCE, 299);
   _actionMap[536][INNER] = ActionEntry(REDUCE, 299);
   _actionMap[536][JOIN] = ActionEntry(REDUCE, 299);
   _actionMap[536][RETURNTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][ORDER] = ActionEntry(REDUCE, 299);
   _actionMap[536][GROUP] = ActionEntry(REDUCE, 299);
   _actionMap[536][WHERE] = ActionEntry(REDUCE, 299);
   _actionMap[536][FROM] = ActionEntry(REDUCE, 299);
   _actionMap[536][AS] = ActionEntry(REDUCE, 299);
   _actionMap[536][END_TOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][BEGIN] = ActionEntry(REDUCE, 299);
   _actionMap[536][THEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][OR] = ActionEntry(REDUCE, 299);
   _actionMap[536][AND] = ActionEntry(REDUCE, 299);
   _actionMap[536][INTOK] = ActionEntry(REDUCE, 299);
   _actionMap[536][NOT] = ActionEntry(REDUCE, 299);
   _actionMap[536][BETWEEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][IS] = ActionEntry(REDUCE, 299);
   _actionMap[536][LIKE] = ActionEntry(REDUCE, 299);
   _actionMap[536][MT] = ActionEntry(REDUCE, 299);
   _actionMap[536][LT] = ActionEntry(REDUCE, 299);
   _actionMap[536][NEGATION] = ActionEntry(REDUCE, 299);
   _actionMap[536][EQU] = ActionEntry(REDUCE, 299);
   _actionMap[536][RB] = ActionEntry(REDUCE, 299);
   _actionMap[536][ENDTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[536][UNION] = ActionEntry(REDUCE, 299);
   _actionMap[536][ROWLIMIT] = ActionEntry(REDUCE, 299);
   _actionMap[536][KSEP] = ActionEntry(REDUCE, 299);
   _actionMap[536][ASC] = ActionEntry(REDUCE, 299);
   _actionMap[536][DESC] = ActionEntry(REDUCE, 299);
   _actionMap[536][SEMICOLON] = ActionEntry(REDUCE, 299);
   _actionMap[536][PLUS] = ActionEntry(REDUCE, 299);
   _actionMap[536][MINUS] = ActionEntry(REDUCE, 299);
   _actionMap[536][DIVISION] = ActionEntry(REDUCE, 299);
   _actionMap[536][STAR] = ActionEntry(REDUCE, 299);
   _actionMap[536][CONCAT] = ActionEntry(REDUCE, 299);
}
void Cego::loadParser98()
{
   _actionMap[537][WHEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][ELSE] = ActionEntry(REDUCE, 295);
   _actionMap[537][LEFT] = ActionEntry(REDUCE, 295);
   _actionMap[537][RIGHT] = ActionEntry(REDUCE, 295);
   _actionMap[537][INNER] = ActionEntry(REDUCE, 295);
   _actionMap[537][JOIN] = ActionEntry(REDUCE, 295);
   _actionMap[537][RETURNTOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][ORDER] = ActionEntry(REDUCE, 295);
   _actionMap[537][GROUP] = ActionEntry(REDUCE, 295);
   _actionMap[537][WHERE] = ActionEntry(REDUCE, 295);
   _actionMap[537][FROM] = ActionEntry(REDUCE, 295);
   _actionMap[537][AS] = ActionEntry(REDUCE, 295);
   _actionMap[537][END_TOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][BEGIN] = ActionEntry(REDUCE, 295);
   _actionMap[537][THEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][OR] = ActionEntry(REDUCE, 295);
   _actionMap[537][AND] = ActionEntry(REDUCE, 295);
   _actionMap[537][INTOK] = ActionEntry(REDUCE, 295);
   _actionMap[537][NOT] = ActionEntry(REDUCE, 295);
   _actionMap[537][BETWEEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][IS] = ActionEntry(REDUCE, 295);
   _actionMap[537][LIKE] = ActionEntry(REDUCE, 295);
   _actionMap[537][MT] = ActionEntry(REDUCE, 295);
   _actionMap[537][LT] = ActionEntry(REDUCE, 295);
   _actionMap[537][NEGATION] = ActionEntry(REDUCE, 295);
   _actionMap[537][EQU] = ActionEntry(REDUCE, 295);
   _actionMap[537][RB] = ActionEntry(REDUCE, 295);
   _actionMap[537][ENDTOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[537][UNION] = ActionEntry(REDUCE, 295);
   _actionMap[537][ROWLIMIT] = ActionEntry(REDUCE, 295);
   _actionMap[537][KSEP] = ActionEntry(REDUCE, 295);
   _actionMap[537][ASC] = ActionEntry(REDUCE, 295);
   _actionMap[537][DESC] = ActionEntry(REDUCE, 295);
   _actionMap[537][SEMICOLON] = ActionEntry(REDUCE, 295);
   _actionMap[537][PLUS] = ActionEntry(REDUCE, 295);
   _actionMap[537][MINUS] = ActionEntry(REDUCE, 295);
   _actionMap[537][DIVISION] = ActionEntry(REDUCE, 295);
   _actionMap[537][STAR] = ActionEntry(REDUCE, 295);
   _actionMap[537][CONCAT] = ActionEntry(REDUCE, 295);
   _actionMap[538][WHEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][ELSE] = ActionEntry(REDUCE, 291);
   _actionMap[538][LEFT] = ActionEntry(REDUCE, 291);
   _actionMap[538][RIGHT] = ActionEntry(REDUCE, 291);
   _actionMap[538][INNER] = ActionEntry(REDUCE, 291);
   _actionMap[538][JOIN] = ActionEntry(REDUCE, 291);
   _actionMap[538][RETURNTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][ORDER] = ActionEntry(REDUCE, 291);
   _actionMap[538][GROUP] = ActionEntry(REDUCE, 291);
   _actionMap[538][WHERE] = ActionEntry(REDUCE, 291);
   _actionMap[538][FROM] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser99()
{
   _actionMap[538][AS] = ActionEntry(REDUCE, 291);
   _actionMap[538][END_TOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][BEGIN] = ActionEntry(REDUCE, 291);
   _actionMap[538][THEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][OR] = ActionEntry(REDUCE, 291);
   _actionMap[538][AND] = ActionEntry(REDUCE, 291);
   _actionMap[538][INTOK] = ActionEntry(REDUCE, 291);
   _actionMap[538][NOT] = ActionEntry(REDUCE, 291);
   _actionMap[538][BETWEEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][IS] = ActionEntry(REDUCE, 291);
   _actionMap[538][LIKE] = ActionEntry(REDUCE, 291);
   _actionMap[538][MT] = ActionEntry(REDUCE, 291);
   _actionMap[538][LT] = ActionEntry(REDUCE, 291);
   _actionMap[538][NEGATION] = ActionEntry(REDUCE, 291);
   _actionMap[538][EQU] = ActionEntry(REDUCE, 291);
   _actionMap[538][RB] = ActionEntry(REDUCE, 291);
   _actionMap[538][ENDTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[538][UNION] = ActionEntry(REDUCE, 291);
   _actionMap[538][ROWLIMIT] = ActionEntry(REDUCE, 291);
   _actionMap[538][KSEP] = ActionEntry(REDUCE, 291);
   _actionMap[538][ASC] = ActionEntry(REDUCE, 291);
   _actionMap[538][DESC] = ActionEntry(REDUCE, 291);
   _actionMap[538][SEMICOLON] = ActionEntry(REDUCE, 291);
   _actionMap[538][PLUS] = ActionEntry(REDUCE, 291);
   _actionMap[538][MINUS] = ActionEntry(REDUCE, 291);
   _actionMap[538][DIVISION] = ActionEntry(REDUCE, 291);
   _actionMap[538][STAR] = ActionEntry(REDUCE, 291);
   _actionMap[538][CONCAT] = ActionEntry(REDUCE, 291);
   _actionMap[539][WHEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][ELSE] = ActionEntry(REDUCE, 292);
   _actionMap[539][LEFT] = ActionEntry(REDUCE, 292);
   _actionMap[539][RIGHT] = ActionEntry(REDUCE, 292);
   _actionMap[539][INNER] = ActionEntry(REDUCE, 292);
   _actionMap[539][JOIN] = ActionEntry(REDUCE, 292);
   _actionMap[539][RETURNTOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][ORDER] = ActionEntry(REDUCE, 292);
   _actionMap[539][GROUP] = ActionEntry(REDUCE, 292);
   _actionMap[539][WHERE] = ActionEntry(REDUCE, 292);
   _actionMap[539][FROM] = ActionEntry(REDUCE, 292);
   _actionMap[539][AS] = ActionEntry(REDUCE, 292);
   _actionMap[539][END_TOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][BEGIN] = ActionEntry(REDUCE, 292);
   _actionMap[539][THEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][OR] = ActionEntry(REDUCE, 292);
   _actionMap[539][AND] = ActionEntry(REDUCE, 292);
   _actionMap[539][INTOK] = ActionEntry(REDUCE, 292);
   _actionMap[539][NOT] = ActionEntry(REDUCE, 292);
   _actionMap[539][BETWEEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][IS] = ActionEntry(REDUCE, 292);
   _actionMap[539][LIKE] = ActionEntry(REDUCE, 292);
}
void Cego::loadParser100()
{
   _actionMap[539][MT] = ActionEntry(REDUCE, 292);
   _actionMap[539][LT] = ActionEntry(REDUCE, 292);
   _actionMap[539][NEGATION] = ActionEntry(REDUCE, 292);
   _actionMap[539][EQU] = ActionEntry(REDUCE, 292);
   _actionMap[539][RB] = ActionEntry(REDUCE, 292);
   _actionMap[539][ENDTOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[539][UNION] = ActionEntry(REDUCE, 292);
   _actionMap[539][ROWLIMIT] = ActionEntry(REDUCE, 292);
   _actionMap[539][KSEP] = ActionEntry(REDUCE, 292);
   _actionMap[539][ASC] = ActionEntry(REDUCE, 292);
   _actionMap[539][DESC] = ActionEntry(REDUCE, 292);
   _actionMap[539][SEMICOLON] = ActionEntry(REDUCE, 292);
   _actionMap[539][PLUS] = ActionEntry(REDUCE, 292);
   _actionMap[539][MINUS] = ActionEntry(REDUCE, 292);
   _actionMap[539][DIVISION] = ActionEntry(REDUCE, 292);
   _actionMap[539][STAR] = ActionEntry(REDUCE, 292);
   _actionMap[539][CONCAT] = ActionEntry(REDUCE, 292);
   _actionMap[540][WHEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][ELSE] = ActionEntry(REDUCE, 285);
   _actionMap[540][LEFT] = ActionEntry(REDUCE, 285);
   _actionMap[540][RIGHT] = ActionEntry(REDUCE, 285);
   _actionMap[540][INNER] = ActionEntry(REDUCE, 285);
   _actionMap[540][JOIN] = ActionEntry(REDUCE, 285);
   _actionMap[540][RETURNTOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][ORDER] = ActionEntry(REDUCE, 285);
   _actionMap[540][GROUP] = ActionEntry(REDUCE, 285);
   _actionMap[540][WHERE] = ActionEntry(REDUCE, 285);
   _actionMap[540][FROM] = ActionEntry(REDUCE, 285);
   _actionMap[540][AS] = ActionEntry(REDUCE, 285);
   _actionMap[540][END_TOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][BEGIN] = ActionEntry(REDUCE, 285);
   _actionMap[540][THEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][OR] = ActionEntry(REDUCE, 285);
   _actionMap[540][AND] = ActionEntry(REDUCE, 285);
   _actionMap[540][INTOK] = ActionEntry(REDUCE, 285);
   _actionMap[540][NOT] = ActionEntry(REDUCE, 285);
   _actionMap[540][BETWEEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][IS] = ActionEntry(REDUCE, 285);
   _actionMap[540][LIKE] = ActionEntry(REDUCE, 285);
   _actionMap[540][MT] = ActionEntry(REDUCE, 285);
   _actionMap[540][LT] = ActionEntry(REDUCE, 285);
   _actionMap[540][NEGATION] = ActionEntry(REDUCE, 285);
   _actionMap[540][EQU] = ActionEntry(REDUCE, 285);
   _actionMap[540][RB] = ActionEntry(REDUCE, 285);
   _actionMap[540][ENDTOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[540][UNION] = ActionEntry(REDUCE, 285);
   _actionMap[540][ROWLIMIT] = ActionEntry(REDUCE, 285);
   _actionMap[540][KSEP] = ActionEntry(REDUCE, 285);
   _actionMap[540][ASC] = ActionEntry(REDUCE, 285);
   _actionMap[540][DESC] = ActionEntry(REDUCE, 285);
}
void Cego::loadParser101()
{
   _actionMap[540][SEMICOLON] = ActionEntry(REDUCE, 285);
   _actionMap[540][PLUS] = ActionEntry(REDUCE, 285);
   _actionMap[540][MINUS] = ActionEntry(REDUCE, 285);
   _actionMap[540][DIVISION] = ActionEntry(REDUCE, 285);
   _actionMap[540][STAR] = ActionEntry(REDUCE, 285);
   _actionMap[540][CONCAT] = ActionEntry(REDUCE, 285);
   _actionMap[541][WHEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][ELSE] = ActionEntry(REDUCE, 282);
   _actionMap[541][LEFT] = ActionEntry(REDUCE, 282);
   _actionMap[541][RIGHT] = ActionEntry(REDUCE, 282);
   _actionMap[541][INNER] = ActionEntry(REDUCE, 282);
   _actionMap[541][JOIN] = ActionEntry(REDUCE, 282);
   _actionMap[541][RETURNTOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][ORDER] = ActionEntry(REDUCE, 282);
   _actionMap[541][GROUP] = ActionEntry(REDUCE, 282);
   _actionMap[541][WHERE] = ActionEntry(REDUCE, 282);
   _actionMap[541][FROM] = ActionEntry(REDUCE, 282);
   _actionMap[541][AS] = ActionEntry(REDUCE, 282);
   _actionMap[541][END_TOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][BEGIN] = ActionEntry(REDUCE, 282);
   _actionMap[541][THEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][OR] = ActionEntry(REDUCE, 282);
   _actionMap[541][AND] = ActionEntry(REDUCE, 282);
   _actionMap[541][INTOK] = ActionEntry(REDUCE, 282);
   _actionMap[541][NOT] = ActionEntry(REDUCE, 282);
   _actionMap[541][BETWEEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][IS] = ActionEntry(REDUCE, 282);
   _actionMap[541][LIKE] = ActionEntry(REDUCE, 282);
   _actionMap[541][MT] = ActionEntry(REDUCE, 282);
   _actionMap[541][LT] = ActionEntry(REDUCE, 282);
   _actionMap[541][NEGATION] = ActionEntry(REDUCE, 282);
   _actionMap[541][EQU] = ActionEntry(REDUCE, 282);
   _actionMap[541][RB] = ActionEntry(REDUCE, 282);
   _actionMap[541][ENDTOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[541][UNION] = ActionEntry(REDUCE, 282);
   _actionMap[541][ROWLIMIT] = ActionEntry(REDUCE, 282);
   _actionMap[541][KSEP] = ActionEntry(REDUCE, 282);
   _actionMap[541][ASC] = ActionEntry(REDUCE, 282);
   _actionMap[541][DESC] = ActionEntry(REDUCE, 282);
   _actionMap[541][SEMICOLON] = ActionEntry(REDUCE, 282);
   _actionMap[541][PLUS] = ActionEntry(REDUCE, 282);
   _actionMap[541][MINUS] = ActionEntry(REDUCE, 282);
   _actionMap[541][DIVISION] = ActionEntry(REDUCE, 282);
   _actionMap[541][STAR] = ActionEntry(REDUCE, 282);
   _actionMap[541][CONCAT] = ActionEntry(REDUCE, 282);
   _actionMap[542][WHEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][ELSE] = ActionEntry(REDUCE, 275);
   _actionMap[542][LEFT] = ActionEntry(REDUCE, 275);
   _actionMap[542][RIGHT] = ActionEntry(REDUCE, 275);
   _actionMap[542][INNER] = ActionEntry(REDUCE, 275);
}
void Cego::loadParser102()
{
   _actionMap[542][JOIN] = ActionEntry(REDUCE, 275);
   _actionMap[542][RETURNTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][ORDER] = ActionEntry(REDUCE, 275);
   _actionMap[542][GROUP] = ActionEntry(REDUCE, 275);
   _actionMap[542][WHERE] = ActionEntry(REDUCE, 275);
   _actionMap[542][FROM] = ActionEntry(REDUCE, 275);
   _actionMap[542][AS] = ActionEntry(REDUCE, 275);
   _actionMap[542][END_TOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][BEGIN] = ActionEntry(REDUCE, 275);
   _actionMap[542][THEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][OR] = ActionEntry(REDUCE, 275);
   _actionMap[542][AND] = ActionEntry(REDUCE, 275);
   _actionMap[542][INTOK] = ActionEntry(REDUCE, 275);
   _actionMap[542][NOT] = ActionEntry(REDUCE, 275);
   _actionMap[542][BETWEEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][IS] = ActionEntry(REDUCE, 275);
   _actionMap[542][LIKE] = ActionEntry(REDUCE, 275);
   _actionMap[542][MT] = ActionEntry(REDUCE, 275);
   _actionMap[542][LT] = ActionEntry(REDUCE, 275);
   _actionMap[542][NEGATION] = ActionEntry(REDUCE, 275);
   _actionMap[542][EQU] = ActionEntry(REDUCE, 275);
   _actionMap[542][RB] = ActionEntry(REDUCE, 275);
   _actionMap[542][ENDTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[542][UNION] = ActionEntry(REDUCE, 275);
   _actionMap[542][ROWLIMIT] = ActionEntry(REDUCE, 275);
   _actionMap[542][KSEP] = ActionEntry(REDUCE, 275);
   _actionMap[542][ASC] = ActionEntry(REDUCE, 275);
   _actionMap[542][DESC] = ActionEntry(REDUCE, 275);
   _actionMap[542][SEMICOLON] = ActionEntry(REDUCE, 275);
   _actionMap[542][PLUS] = ActionEntry(REDUCE, 275);
   _actionMap[542][MINUS] = ActionEntry(REDUCE, 275);
   _actionMap[542][DIVISION] = ActionEntry(REDUCE, 275);
   _actionMap[542][STAR] = ActionEntry(REDUCE, 275);
   _actionMap[542][CONCAT] = ActionEntry(REDUCE, 275);
   _actionMap[543][WHEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][ELSE] = ActionEntry(REDUCE, 273);
   _actionMap[543][LEFT] = ActionEntry(REDUCE, 273);
   _actionMap[543][RIGHT] = ActionEntry(REDUCE, 273);
   _actionMap[543][INNER] = ActionEntry(REDUCE, 273);
   _actionMap[543][JOIN] = ActionEntry(REDUCE, 273);
   _actionMap[543][RETURNTOKEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][ORDER] = ActionEntry(REDUCE, 273);
   _actionMap[543][GROUP] = ActionEntry(REDUCE, 273);
   _actionMap[543][WHERE] = ActionEntry(REDUCE, 273);
   _actionMap[543][FROM] = ActionEntry(REDUCE, 273);
   _actionMap[543][AS] = ActionEntry(REDUCE, 273);
   _actionMap[543][END_TOKEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][BEGIN] = ActionEntry(REDUCE, 273);
   _actionMap[543][THEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][OR] = ActionEntry(REDUCE, 273);
}
void Cego::loadParser103()
{
   _actionMap[543][AND] = ActionEntry(REDUCE, 273);
   _actionMap[543][INTOK] = ActionEntry(REDUCE, 273);
   _actionMap[543][NOT] = ActionEntry(REDUCE, 273);
   _actionMap[543][BETWEEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][IS] = ActionEntry(REDUCE, 273);
   _actionMap[543][LIKE] = ActionEntry(REDUCE, 273);
   _actionMap[543][MT] = ActionEntry(REDUCE, 273);
   _actionMap[543][LT] = ActionEntry(REDUCE, 273);
   _actionMap[543][NEGATION] = ActionEntry(REDUCE, 273);
   _actionMap[543][EQU] = ActionEntry(REDUCE, 273);
   _actionMap[543][RB] = ActionEntry(REDUCE, 273);
   _actionMap[543][ENDTOKEN] = ActionEntry(REDUCE, 273);
   _actionMap[543][UNION] = ActionEntry(REDUCE, 273);
   _actionMap[543][ROWLIMIT] = ActionEntry(REDUCE, 273);
   _actionMap[543][KSEP] = ActionEntry(REDUCE, 273);
   _actionMap[543][ASC] = ActionEntry(REDUCE, 273);
   _actionMap[543][DESC] = ActionEntry(REDUCE, 273);
   _actionMap[543][SEMICOLON] = ActionEntry(REDUCE, 273);
   _actionMap[543][PLUS] = ActionEntry(REDUCE, 273);
   _actionMap[543][MINUS] = ActionEntry(REDUCE, 273);
   _actionMap[543][DIVISION] = ActionEntry(REDUCE, 273);
   _actionMap[543][STAR] = ActionEntry(REDUCE, 273);
   _actionMap[543][CONCAT] = ActionEntry(REDUCE, 273);
   _actionMap[544][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[544][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[544][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[544][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[544][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[544][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[544][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[544][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[544][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[544][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[544][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[544][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[544][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[544][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[544][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[544][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[544][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[544][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[544][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[544][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[544][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[544][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[544][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[544][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[544][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[544][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[544][POWER] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser104()
{
   _actionMap[544][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[544][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[544][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[544][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[544][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[544][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[544][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[544][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[544][LB] = ActionEntry(SHIFT, 142);
   _actionMap[544][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[544][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[544][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[544][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[544][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[544][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[544][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[544][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[544][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[544][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[544][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[544][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[544][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[544][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[544][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[544][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[544][ObjSpec] = 99;
   _jumpMap[544][Constant] = 98;
   _jumpMap[544][SignedFloat] = 97;
   _jumpMap[544][SignedInt] = 96;
   _jumpMap[544][Attribute] = 95;
   _jumpMap[544][Function] = 94;
   _jumpMap[544][CasePrepare] = 93;
   _jumpMap[544][CaseClause] = 92;
   _jumpMap[544][Factor] = 91;
   _jumpMap[544][Term] = 90;
   _jumpMap[544][Expr] = 669;
   _actionMap[545][WHEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][ELSE] = ActionEntry(REDUCE, 284);
   _actionMap[545][LEFT] = ActionEntry(REDUCE, 284);
   _actionMap[545][RIGHT] = ActionEntry(REDUCE, 284);
   _actionMap[545][INNER] = ActionEntry(REDUCE, 284);
   _actionMap[545][JOIN] = ActionEntry(REDUCE, 284);
   _actionMap[545][RETURNTOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][ORDER] = ActionEntry(REDUCE, 284);
   _actionMap[545][GROUP] = ActionEntry(REDUCE, 284);
   _actionMap[545][WHERE] = ActionEntry(REDUCE, 284);
   _actionMap[545][FROM] = ActionEntry(REDUCE, 284);
   _actionMap[545][AS] = ActionEntry(REDUCE, 284);
   _actionMap[545][END_TOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][BEGIN] = ActionEntry(REDUCE, 284);
}
void Cego::loadParser105()
{
   _actionMap[545][THEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][OR] = ActionEntry(REDUCE, 284);
   _actionMap[545][AND] = ActionEntry(REDUCE, 284);
   _actionMap[545][INTOK] = ActionEntry(REDUCE, 284);
   _actionMap[545][NOT] = ActionEntry(REDUCE, 284);
   _actionMap[545][BETWEEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][IS] = ActionEntry(REDUCE, 284);
   _actionMap[545][LIKE] = ActionEntry(REDUCE, 284);
   _actionMap[545][MT] = ActionEntry(REDUCE, 284);
   _actionMap[545][LT] = ActionEntry(REDUCE, 284);
   _actionMap[545][NEGATION] = ActionEntry(REDUCE, 284);
   _actionMap[545][EQU] = ActionEntry(REDUCE, 284);
   _actionMap[545][RB] = ActionEntry(REDUCE, 284);
   _actionMap[545][ENDTOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[545][UNION] = ActionEntry(REDUCE, 284);
   _actionMap[545][ROWLIMIT] = ActionEntry(REDUCE, 284);
   _actionMap[545][KSEP] = ActionEntry(REDUCE, 284);
   _actionMap[545][ASC] = ActionEntry(REDUCE, 284);
   _actionMap[545][DESC] = ActionEntry(REDUCE, 284);
   _actionMap[545][SEMICOLON] = ActionEntry(REDUCE, 284);
   _actionMap[545][PLUS] = ActionEntry(REDUCE, 284);
   _actionMap[545][MINUS] = ActionEntry(REDUCE, 284);
   _actionMap[545][DIVISION] = ActionEntry(REDUCE, 284);
   _actionMap[545][STAR] = ActionEntry(REDUCE, 284);
   _actionMap[545][CONCAT] = ActionEntry(REDUCE, 284);
   _actionMap[546][WHEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][ELSE] = ActionEntry(REDUCE, 156);
   _actionMap[546][LEFT] = ActionEntry(REDUCE, 156);
   _actionMap[546][RIGHT] = ActionEntry(REDUCE, 156);
   _actionMap[546][INNER] = ActionEntry(REDUCE, 156);
   _actionMap[546][JOIN] = ActionEntry(REDUCE, 156);
   _actionMap[546][RETURNTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][ORDER] = ActionEntry(REDUCE, 156);
   _actionMap[546][GROUP] = ActionEntry(REDUCE, 156);
   _actionMap[546][WHERE] = ActionEntry(REDUCE, 156);
   _actionMap[546][AS] = ActionEntry(REDUCE, 156);
   _actionMap[546][FROM] = ActionEntry(REDUCE, 156);
   _actionMap[546][END_TOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][BEGIN] = ActionEntry(REDUCE, 156);
   _actionMap[546][THEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][OR] = ActionEntry(REDUCE, 156);
   _actionMap[546][AND] = ActionEntry(REDUCE, 156);
   _actionMap[546][LIKE] = ActionEntry(REDUCE, 156);
   _actionMap[546][IS] = ActionEntry(REDUCE, 156);
   _actionMap[546][BETWEEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][NOT] = ActionEntry(REDUCE, 156);
   _actionMap[546][INTOK] = ActionEntry(REDUCE, 156);
   _actionMap[546][EQU] = ActionEntry(REDUCE, 156);
   _actionMap[546][NEGATION] = ActionEntry(REDUCE, 156);
   _actionMap[546][LT] = ActionEntry(REDUCE, 156);
}
void Cego::loadParser106()
{
   _actionMap[546][MT] = ActionEntry(REDUCE, 156);
   _actionMap[546][DESC] = ActionEntry(REDUCE, 156);
   _actionMap[546][ASC] = ActionEntry(REDUCE, 156);
   _actionMap[546][KSEP] = ActionEntry(REDUCE, 156);
   _actionMap[546][ROWLIMIT] = ActionEntry(REDUCE, 156);
   _actionMap[546][UNION] = ActionEntry(REDUCE, 156);
   _actionMap[546][ENDTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[546][RB] = ActionEntry(REDUCE, 156);
   _actionMap[546][SEMICOLON] = ActionEntry(REDUCE, 156);
   _actionMap[546][CONCAT] = ActionEntry(REDUCE, 156);
   _actionMap[546][STAR] = ActionEntry(REDUCE, 156);
   _actionMap[546][DIVISION] = ActionEntry(REDUCE, 156);
   _actionMap[546][MINUS] = ActionEntry(REDUCE, 156);
   _actionMap[546][PLUS] = ActionEntry(REDUCE, 156);
   _actionMap[547][WHEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][ELSE] = ActionEntry(REDUCE, 288);
   _actionMap[547][LEFT] = ActionEntry(REDUCE, 288);
   _actionMap[547][RIGHT] = ActionEntry(REDUCE, 288);
   _actionMap[547][INNER] = ActionEntry(REDUCE, 288);
   _actionMap[547][JOIN] = ActionEntry(REDUCE, 288);
   _actionMap[547][RETURNTOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][ORDER] = ActionEntry(REDUCE, 288);
   _actionMap[547][GROUP] = ActionEntry(REDUCE, 288);
   _actionMap[547][WHERE] = ActionEntry(REDUCE, 288);
   _actionMap[547][FROM] = ActionEntry(REDUCE, 288);
   _actionMap[547][AS] = ActionEntry(REDUCE, 288);
   _actionMap[547][END_TOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][BEGIN] = ActionEntry(REDUCE, 288);
   _actionMap[547][THEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][OR] = ActionEntry(REDUCE, 288);
   _actionMap[547][AND] = ActionEntry(REDUCE, 288);
   _actionMap[547][INTOK] = ActionEntry(REDUCE, 288);
   _actionMap[547][NOT] = ActionEntry(REDUCE, 288);
   _actionMap[547][BETWEEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][IS] = ActionEntry(REDUCE, 288);
   _actionMap[547][LIKE] = ActionEntry(REDUCE, 288);
   _actionMap[547][MT] = ActionEntry(REDUCE, 288);
   _actionMap[547][LT] = ActionEntry(REDUCE, 288);
   _actionMap[547][NEGATION] = ActionEntry(REDUCE, 288);
   _actionMap[547][EQU] = ActionEntry(REDUCE, 288);
   _actionMap[547][RB] = ActionEntry(REDUCE, 288);
   _actionMap[547][ENDTOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[547][UNION] = ActionEntry(REDUCE, 288);
   _actionMap[547][ROWLIMIT] = ActionEntry(REDUCE, 288);
   _actionMap[547][KSEP] = ActionEntry(REDUCE, 288);
   _actionMap[547][ASC] = ActionEntry(REDUCE, 288);
   _actionMap[547][DESC] = ActionEntry(REDUCE, 288);
   _actionMap[547][SEMICOLON] = ActionEntry(REDUCE, 288);
   _actionMap[547][PLUS] = ActionEntry(REDUCE, 288);
   _actionMap[547][MINUS] = ActionEntry(REDUCE, 288);
}
void Cego::loadParser107()
{
   _actionMap[547][DIVISION] = ActionEntry(REDUCE, 288);
   _actionMap[547][STAR] = ActionEntry(REDUCE, 288);
   _actionMap[547][CONCAT] = ActionEntry(REDUCE, 288);
   _actionMap[548][WHEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][ELSE] = ActionEntry(REDUCE, 289);
   _actionMap[548][LEFT] = ActionEntry(REDUCE, 289);
   _actionMap[548][RIGHT] = ActionEntry(REDUCE, 289);
   _actionMap[548][INNER] = ActionEntry(REDUCE, 289);
   _actionMap[548][JOIN] = ActionEntry(REDUCE, 289);
   _actionMap[548][RETURNTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][ORDER] = ActionEntry(REDUCE, 289);
   _actionMap[548][GROUP] = ActionEntry(REDUCE, 289);
   _actionMap[548][WHERE] = ActionEntry(REDUCE, 289);
   _actionMap[548][FROM] = ActionEntry(REDUCE, 289);
   _actionMap[548][AS] = ActionEntry(REDUCE, 289);
   _actionMap[548][END_TOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][BEGIN] = ActionEntry(REDUCE, 289);
   _actionMap[548][THEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][OR] = ActionEntry(REDUCE, 289);
   _actionMap[548][AND] = ActionEntry(REDUCE, 289);
   _actionMap[548][INTOK] = ActionEntry(REDUCE, 289);
   _actionMap[548][NOT] = ActionEntry(REDUCE, 289);
   _actionMap[548][BETWEEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][IS] = ActionEntry(REDUCE, 289);
   _actionMap[548][LIKE] = ActionEntry(REDUCE, 289);
   _actionMap[548][MT] = ActionEntry(REDUCE, 289);
   _actionMap[548][LT] = ActionEntry(REDUCE, 289);
   _actionMap[548][NEGATION] = ActionEntry(REDUCE, 289);
   _actionMap[548][EQU] = ActionEntry(REDUCE, 289);
   _actionMap[548][RB] = ActionEntry(REDUCE, 289);
   _actionMap[548][ENDTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[548][UNION] = ActionEntry(REDUCE, 289);
   _actionMap[548][ROWLIMIT] = ActionEntry(REDUCE, 289);
   _actionMap[548][KSEP] = ActionEntry(REDUCE, 289);
   _actionMap[548][ASC] = ActionEntry(REDUCE, 289);
   _actionMap[548][DESC] = ActionEntry(REDUCE, 289);
   _actionMap[548][SEMICOLON] = ActionEntry(REDUCE, 289);
   _actionMap[548][PLUS] = ActionEntry(REDUCE, 289);
   _actionMap[548][MINUS] = ActionEntry(REDUCE, 289);
   _actionMap[548][DIVISION] = ActionEntry(REDUCE, 289);
   _actionMap[548][STAR] = ActionEntry(REDUCE, 289);
   _actionMap[548][CONCAT] = ActionEntry(REDUCE, 289);
   _actionMap[549][WHEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][ELSE] = ActionEntry(REDUCE, 290);
   _actionMap[549][LEFT] = ActionEntry(REDUCE, 290);
   _actionMap[549][RIGHT] = ActionEntry(REDUCE, 290);
   _actionMap[549][INNER] = ActionEntry(REDUCE, 290);
   _actionMap[549][JOIN] = ActionEntry(REDUCE, 290);
   _actionMap[549][RETURNTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][ORDER] = ActionEntry(REDUCE, 290);
}
void Cego::loadParser108()
{
   _actionMap[549][GROUP] = ActionEntry(REDUCE, 290);
   _actionMap[549][WHERE] = ActionEntry(REDUCE, 290);
   _actionMap[549][FROM] = ActionEntry(REDUCE, 290);
   _actionMap[549][AS] = ActionEntry(REDUCE, 290);
   _actionMap[549][END_TOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][BEGIN] = ActionEntry(REDUCE, 290);
   _actionMap[549][THEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][OR] = ActionEntry(REDUCE, 290);
   _actionMap[549][AND] = ActionEntry(REDUCE, 290);
   _actionMap[549][INTOK] = ActionEntry(REDUCE, 290);
   _actionMap[549][NOT] = ActionEntry(REDUCE, 290);
   _actionMap[549][BETWEEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][IS] = ActionEntry(REDUCE, 290);
   _actionMap[549][LIKE] = ActionEntry(REDUCE, 290);
   _actionMap[549][MT] = ActionEntry(REDUCE, 290);
   _actionMap[549][LT] = ActionEntry(REDUCE, 290);
   _actionMap[549][NEGATION] = ActionEntry(REDUCE, 290);
   _actionMap[549][EQU] = ActionEntry(REDUCE, 290);
   _actionMap[549][RB] = ActionEntry(REDUCE, 290);
   _actionMap[549][ENDTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[549][UNION] = ActionEntry(REDUCE, 290);
   _actionMap[549][ROWLIMIT] = ActionEntry(REDUCE, 290);
   _actionMap[549][KSEP] = ActionEntry(REDUCE, 290);
   _actionMap[549][ASC] = ActionEntry(REDUCE, 290);
   _actionMap[549][DESC] = ActionEntry(REDUCE, 290);
   _actionMap[549][SEMICOLON] = ActionEntry(REDUCE, 290);
   _actionMap[549][PLUS] = ActionEntry(REDUCE, 290);
   _actionMap[549][MINUS] = ActionEntry(REDUCE, 290);
   _actionMap[549][DIVISION] = ActionEntry(REDUCE, 290);
   _actionMap[549][STAR] = ActionEntry(REDUCE, 290);
   _actionMap[549][CONCAT] = ActionEntry(REDUCE, 290);
   _actionMap[550][WHEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][ELSE] = ActionEntry(REDUCE, 272);
   _actionMap[550][LEFT] = ActionEntry(REDUCE, 272);
   _actionMap[550][RIGHT] = ActionEntry(REDUCE, 272);
   _actionMap[550][INNER] = ActionEntry(REDUCE, 272);
   _actionMap[550][JOIN] = ActionEntry(REDUCE, 272);
   _actionMap[550][RETURNTOKEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][ORDER] = ActionEntry(REDUCE, 272);
   _actionMap[550][GROUP] = ActionEntry(REDUCE, 272);
   _actionMap[550][WHERE] = ActionEntry(REDUCE, 272);
   _actionMap[550][FROM] = ActionEntry(REDUCE, 272);
   _actionMap[550][AS] = ActionEntry(REDUCE, 272);
   _actionMap[550][END_TOKEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][BEGIN] = ActionEntry(REDUCE, 272);
   _actionMap[550][THEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][OR] = ActionEntry(REDUCE, 272);
   _actionMap[550][AND] = ActionEntry(REDUCE, 272);
   _actionMap[550][INTOK] = ActionEntry(REDUCE, 272);
   _actionMap[550][NOT] = ActionEntry(REDUCE, 272);
}
void Cego::loadParser109()
{
   _actionMap[550][BETWEEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][IS] = ActionEntry(REDUCE, 272);
   _actionMap[550][LIKE] = ActionEntry(REDUCE, 272);
   _actionMap[550][MT] = ActionEntry(REDUCE, 272);
   _actionMap[550][LT] = ActionEntry(REDUCE, 272);
   _actionMap[550][NEGATION] = ActionEntry(REDUCE, 272);
   _actionMap[550][EQU] = ActionEntry(REDUCE, 272);
   _actionMap[550][RB] = ActionEntry(REDUCE, 272);
   _actionMap[550][ENDTOKEN] = ActionEntry(REDUCE, 272);
   _actionMap[550][UNION] = ActionEntry(REDUCE, 272);
   _actionMap[550][ROWLIMIT] = ActionEntry(REDUCE, 272);
   _actionMap[550][KSEP] = ActionEntry(REDUCE, 272);
   _actionMap[550][ASC] = ActionEntry(REDUCE, 272);
   _actionMap[550][DESC] = ActionEntry(REDUCE, 272);
   _actionMap[550][SEMICOLON] = ActionEntry(REDUCE, 272);
   _actionMap[550][PLUS] = ActionEntry(REDUCE, 272);
   _actionMap[550][MINUS] = ActionEntry(REDUCE, 272);
   _actionMap[550][DIVISION] = ActionEntry(REDUCE, 272);
   _actionMap[550][STAR] = ActionEntry(REDUCE, 272);
   _actionMap[550][CONCAT] = ActionEntry(REDUCE, 272);
   _actionMap[551][WHEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][ELSE] = ActionEntry(REDUCE, 287);
   _actionMap[551][LEFT] = ActionEntry(REDUCE, 287);
   _actionMap[551][RIGHT] = ActionEntry(REDUCE, 287);
   _actionMap[551][INNER] = ActionEntry(REDUCE, 287);
   _actionMap[551][JOIN] = ActionEntry(REDUCE, 287);
   _actionMap[551][RETURNTOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][ORDER] = ActionEntry(REDUCE, 287);
   _actionMap[551][GROUP] = ActionEntry(REDUCE, 287);
   _actionMap[551][WHERE] = ActionEntry(REDUCE, 287);
   _actionMap[551][FROM] = ActionEntry(REDUCE, 287);
   _actionMap[551][AS] = ActionEntry(REDUCE, 287);
   _actionMap[551][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][BEGIN] = ActionEntry(REDUCE, 287);
   _actionMap[551][THEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][OR] = ActionEntry(REDUCE, 287);
   _actionMap[551][AND] = ActionEntry(REDUCE, 287);
   _actionMap[551][INTOK] = ActionEntry(REDUCE, 287);
   _actionMap[551][NOT] = ActionEntry(REDUCE, 287);
   _actionMap[551][BETWEEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][IS] = ActionEntry(REDUCE, 287);
   _actionMap[551][LIKE] = ActionEntry(REDUCE, 287);
   _actionMap[551][MT] = ActionEntry(REDUCE, 287);
   _actionMap[551][LT] = ActionEntry(REDUCE, 287);
   _actionMap[551][NEGATION] = ActionEntry(REDUCE, 287);
   _actionMap[551][EQU] = ActionEntry(REDUCE, 287);
   _actionMap[551][RB] = ActionEntry(REDUCE, 287);
   _actionMap[551][ENDTOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[551][UNION] = ActionEntry(REDUCE, 287);
   _actionMap[551][ROWLIMIT] = ActionEntry(REDUCE, 287);
}
void Cego::loadParser110()
{
   _actionMap[551][KSEP] = ActionEntry(REDUCE, 287);
   _actionMap[551][ASC] = ActionEntry(REDUCE, 287);
   _actionMap[551][DESC] = ActionEntry(REDUCE, 287);
   _actionMap[551][SEMICOLON] = ActionEntry(REDUCE, 287);
   _actionMap[551][PLUS] = ActionEntry(REDUCE, 287);
   _actionMap[551][MINUS] = ActionEntry(REDUCE, 287);
   _actionMap[551][DIVISION] = ActionEntry(REDUCE, 287);
   _actionMap[551][STAR] = ActionEntry(REDUCE, 287);
   _actionMap[551][CONCAT] = ActionEntry(REDUCE, 287);
   _actionMap[552][WHEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][ELSE] = ActionEntry(REDUCE, 280);
   _actionMap[552][LEFT] = ActionEntry(REDUCE, 280);
   _actionMap[552][RIGHT] = ActionEntry(REDUCE, 280);
   _actionMap[552][INNER] = ActionEntry(REDUCE, 280);
   _actionMap[552][JOIN] = ActionEntry(REDUCE, 280);
   _actionMap[552][RETURNTOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][ORDER] = ActionEntry(REDUCE, 280);
   _actionMap[552][GROUP] = ActionEntry(REDUCE, 280);
   _actionMap[552][WHERE] = ActionEntry(REDUCE, 280);
   _actionMap[552][FROM] = ActionEntry(REDUCE, 280);
   _actionMap[552][AS] = ActionEntry(REDUCE, 280);
   _actionMap[552][END_TOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][BEGIN] = ActionEntry(REDUCE, 280);
   _actionMap[552][THEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][OR] = ActionEntry(REDUCE, 280);
   _actionMap[552][AND] = ActionEntry(REDUCE, 280);
   _actionMap[552][INTOK] = ActionEntry(REDUCE, 280);
   _actionMap[552][NOT] = ActionEntry(REDUCE, 280);
   _actionMap[552][BETWEEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][IS] = ActionEntry(REDUCE, 280);
   _actionMap[552][LIKE] = ActionEntry(REDUCE, 280);
   _actionMap[552][MT] = ActionEntry(REDUCE, 280);
   _actionMap[552][LT] = ActionEntry(REDUCE, 280);
   _actionMap[552][NEGATION] = ActionEntry(REDUCE, 280);
   _actionMap[552][EQU] = ActionEntry(REDUCE, 280);
   _actionMap[552][RB] = ActionEntry(REDUCE, 280);
   _actionMap[552][ENDTOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[552][UNION] = ActionEntry(REDUCE, 280);
   _actionMap[552][ROWLIMIT] = ActionEntry(REDUCE, 280);
   _actionMap[552][KSEP] = ActionEntry(REDUCE, 280);
   _actionMap[552][ASC] = ActionEntry(REDUCE, 280);
   _actionMap[552][DESC] = ActionEntry(REDUCE, 280);
   _actionMap[552][SEMICOLON] = ActionEntry(REDUCE, 280);
   _actionMap[552][PLUS] = ActionEntry(REDUCE, 280);
   _actionMap[552][MINUS] = ActionEntry(REDUCE, 280);
   _actionMap[552][DIVISION] = ActionEntry(REDUCE, 280);
   _actionMap[552][STAR] = ActionEntry(REDUCE, 280);
   _actionMap[552][CONCAT] = ActionEntry(REDUCE, 280);
   _actionMap[553][WHEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][ELSE] = ActionEntry(REDUCE, 350);
}
void Cego::loadParser111()
{
   _actionMap[553][LEFT] = ActionEntry(REDUCE, 350);
   _actionMap[553][RIGHT] = ActionEntry(REDUCE, 350);
   _actionMap[553][INNER] = ActionEntry(REDUCE, 350);
   _actionMap[553][JOIN] = ActionEntry(REDUCE, 350);
   _actionMap[553][RETURNTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][ORDER] = ActionEntry(REDUCE, 350);
   _actionMap[553][GROUP] = ActionEntry(REDUCE, 350);
   _actionMap[553][WHERE] = ActionEntry(REDUCE, 350);
   _actionMap[553][FROM] = ActionEntry(REDUCE, 350);
   _actionMap[553][AS] = ActionEntry(REDUCE, 350);
   _actionMap[553][END_TOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][BEGIN] = ActionEntry(REDUCE, 350);
   _actionMap[553][THEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][OR] = ActionEntry(REDUCE, 350);
   _actionMap[553][AND] = ActionEntry(REDUCE, 350);
   _actionMap[553][ENDTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][UNION] = ActionEntry(REDUCE, 350);
   _actionMap[553][ROWLIMIT] = ActionEntry(REDUCE, 350);
   _actionMap[553][ASC] = ActionEntry(REDUCE, 350);
   _actionMap[553][DESC] = ActionEntry(REDUCE, 350);
   _actionMap[553][INTOK] = ActionEntry(REDUCE, 350);
   _actionMap[553][BETWEEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][LIKE] = ActionEntry(REDUCE, 350);
   _actionMap[553][PLUS] = ActionEntry(REDUCE, 350);
   _actionMap[553][MINUS] = ActionEntry(REDUCE, 350);
   _actionMap[553][CONCAT] = ActionEntry(REDUCE, 350);
   _actionMap[553][DIVISION] = ActionEntry(REDUCE, 350);
   _actionMap[553][STAR] = ActionEntry(REDUCE, 350);
   _actionMap[553][MT] = ActionEntry(REDUCE, 350);
   _actionMap[553][LT] = ActionEntry(REDUCE, 350);
   _actionMap[553][NEGATION] = ActionEntry(REDUCE, 350);
   _actionMap[553][EQU] = ActionEntry(REDUCE, 350);
   _actionMap[553][IS] = ActionEntry(REDUCE, 350);
   _actionMap[553][NULLTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[553][NOT] = ActionEntry(REDUCE, 350);
   _actionMap[553][KSEP] = ActionEntry(REDUCE, 350);
   _actionMap[553][SEMICOLON] = ActionEntry(REDUCE, 350);
   _actionMap[553][RB] = ActionEntry(REDUCE, 350);
   _actionMap[554][INTVAL] = ActionEntry(SHIFT, 279);
   _actionMap[555][WHEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][ELSE] = ActionEntry(REDUCE, 356);
   _actionMap[555][LEFT] = ActionEntry(REDUCE, 356);
   _actionMap[555][RIGHT] = ActionEntry(REDUCE, 356);
   _actionMap[555][INNER] = ActionEntry(REDUCE, 356);
   _actionMap[555][JOIN] = ActionEntry(REDUCE, 356);
   _actionMap[555][RETURNTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][ORDER] = ActionEntry(REDUCE, 356);
   _actionMap[555][GROUP] = ActionEntry(REDUCE, 356);
   _actionMap[555][WHERE] = ActionEntry(REDUCE, 356);
   _actionMap[555][FROM] = ActionEntry(REDUCE, 356);
}
void Cego::loadParser112()
{
   _actionMap[555][AS] = ActionEntry(REDUCE, 356);
   _actionMap[555][END_TOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][BEGIN] = ActionEntry(REDUCE, 356);
   _actionMap[555][THEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][OR] = ActionEntry(REDUCE, 356);
   _actionMap[555][AND] = ActionEntry(REDUCE, 356);
   _actionMap[555][ENDTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][UNION] = ActionEntry(REDUCE, 356);
   _actionMap[555][ROWLIMIT] = ActionEntry(REDUCE, 356);
   _actionMap[555][ASC] = ActionEntry(REDUCE, 356);
   _actionMap[555][DESC] = ActionEntry(REDUCE, 356);
   _actionMap[555][INTOK] = ActionEntry(REDUCE, 356);
   _actionMap[555][BETWEEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][LIKE] = ActionEntry(REDUCE, 356);
   _actionMap[555][PLUS] = ActionEntry(REDUCE, 356);
   _actionMap[555][MINUS] = ActionEntry(REDUCE, 356);
   _actionMap[555][CONCAT] = ActionEntry(REDUCE, 356);
   _actionMap[555][DIVISION] = ActionEntry(REDUCE, 356);
   _actionMap[555][STAR] = ActionEntry(REDUCE, 356);
   _actionMap[555][MT] = ActionEntry(REDUCE, 356);
   _actionMap[555][LT] = ActionEntry(REDUCE, 356);
   _actionMap[555][NEGATION] = ActionEntry(REDUCE, 356);
   _actionMap[555][EQU] = ActionEntry(REDUCE, 356);
   _actionMap[555][IS] = ActionEntry(REDUCE, 356);
   _actionMap[555][NULLTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[555][NOT] = ActionEntry(REDUCE, 356);
   _actionMap[555][KSEP] = ActionEntry(REDUCE, 356);
   _actionMap[555][SEMICOLON] = ActionEntry(REDUCE, 356);
   _actionMap[555][RB] = ActionEntry(REDUCE, 356);
   _actionMap[556][FLOATVAL] = ActionEntry(SHIFT, 280);
   _actionMap[557][WHEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][ELSE] = ActionEntry(REDUCE, 355);
   _actionMap[557][LEFT] = ActionEntry(REDUCE, 355);
   _actionMap[557][RIGHT] = ActionEntry(REDUCE, 355);
   _actionMap[557][INNER] = ActionEntry(REDUCE, 355);
   _actionMap[557][JOIN] = ActionEntry(REDUCE, 355);
   _actionMap[557][RETURNTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][ORDER] = ActionEntry(REDUCE, 355);
   _actionMap[557][GROUP] = ActionEntry(REDUCE, 355);
   _actionMap[557][WHERE] = ActionEntry(REDUCE, 355);
   _actionMap[557][FROM] = ActionEntry(REDUCE, 355);
   _actionMap[557][AS] = ActionEntry(REDUCE, 355);
   _actionMap[557][END_TOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][BEGIN] = ActionEntry(REDUCE, 355);
   _actionMap[557][THEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][OR] = ActionEntry(REDUCE, 355);
   _actionMap[557][AND] = ActionEntry(REDUCE, 355);
   _actionMap[557][ENDTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][UNION] = ActionEntry(REDUCE, 355);
   _actionMap[557][ROWLIMIT] = ActionEntry(REDUCE, 355);
}
void Cego::loadParser113()
{
   _actionMap[557][ASC] = ActionEntry(REDUCE, 355);
   _actionMap[557][DESC] = ActionEntry(REDUCE, 355);
   _actionMap[557][INTOK] = ActionEntry(REDUCE, 355);
   _actionMap[557][BETWEEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][LIKE] = ActionEntry(REDUCE, 355);
   _actionMap[557][PLUS] = ActionEntry(REDUCE, 355);
   _actionMap[557][MINUS] = ActionEntry(REDUCE, 355);
   _actionMap[557][CONCAT] = ActionEntry(REDUCE, 355);
   _actionMap[557][DIVISION] = ActionEntry(REDUCE, 355);
   _actionMap[557][STAR] = ActionEntry(REDUCE, 355);
   _actionMap[557][MT] = ActionEntry(REDUCE, 355);
   _actionMap[557][LT] = ActionEntry(REDUCE, 355);
   _actionMap[557][NEGATION] = ActionEntry(REDUCE, 355);
   _actionMap[557][EQU] = ActionEntry(REDUCE, 355);
   _actionMap[557][IS] = ActionEntry(REDUCE, 355);
   _actionMap[557][NULLTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[557][NOT] = ActionEntry(REDUCE, 355);
   _actionMap[557][KSEP] = ActionEntry(REDUCE, 355);
   _actionMap[557][SEMICOLON] = ActionEntry(REDUCE, 355);
   _actionMap[557][RB] = ActionEntry(REDUCE, 355);
   _actionMap[558][WHEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][ELSE] = ActionEntry(REDUCE, 357);
   _actionMap[558][LEFT] = ActionEntry(REDUCE, 357);
   _actionMap[558][RIGHT] = ActionEntry(REDUCE, 357);
   _actionMap[558][INNER] = ActionEntry(REDUCE, 357);
   _actionMap[558][JOIN] = ActionEntry(REDUCE, 357);
   _actionMap[558][RETURNTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][ORDER] = ActionEntry(REDUCE, 357);
   _actionMap[558][GROUP] = ActionEntry(REDUCE, 357);
   _actionMap[558][WHERE] = ActionEntry(REDUCE, 357);
   _actionMap[558][FROM] = ActionEntry(REDUCE, 357);
   _actionMap[558][AS] = ActionEntry(REDUCE, 357);
   _actionMap[558][END_TOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][BEGIN] = ActionEntry(REDUCE, 357);
   _actionMap[558][THEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][OR] = ActionEntry(REDUCE, 357);
   _actionMap[558][AND] = ActionEntry(REDUCE, 357);
   _actionMap[558][ENDTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][UNION] = ActionEntry(REDUCE, 357);
   _actionMap[558][ROWLIMIT] = ActionEntry(REDUCE, 357);
   _actionMap[558][ASC] = ActionEntry(REDUCE, 357);
   _actionMap[558][DESC] = ActionEntry(REDUCE, 357);
   _actionMap[558][INTOK] = ActionEntry(REDUCE, 357);
   _actionMap[558][BETWEEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][LIKE] = ActionEntry(REDUCE, 357);
   _actionMap[558][PLUS] = ActionEntry(REDUCE, 357);
   _actionMap[558][MINUS] = ActionEntry(REDUCE, 357);
   _actionMap[558][CONCAT] = ActionEntry(REDUCE, 357);
   _actionMap[558][DIVISION] = ActionEntry(REDUCE, 357);
   _actionMap[558][STAR] = ActionEntry(REDUCE, 357);
}
void Cego::loadParser114()
{
   _actionMap[558][MT] = ActionEntry(REDUCE, 357);
   _actionMap[558][LT] = ActionEntry(REDUCE, 357);
   _actionMap[558][NEGATION] = ActionEntry(REDUCE, 357);
   _actionMap[558][EQU] = ActionEntry(REDUCE, 357);
   _actionMap[558][IS] = ActionEntry(REDUCE, 357);
   _actionMap[558][NULLTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[558][NOT] = ActionEntry(REDUCE, 357);
   _actionMap[558][KSEP] = ActionEntry(REDUCE, 357);
   _actionMap[558][SEMICOLON] = ActionEntry(REDUCE, 357);
   _actionMap[558][RB] = ActionEntry(REDUCE, 357);
   _actionMap[559][WHEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][ELSE] = ActionEntry(REDUCE, 349);
   _actionMap[559][LEFT] = ActionEntry(REDUCE, 349);
   _actionMap[559][RIGHT] = ActionEntry(REDUCE, 349);
   _actionMap[559][INNER] = ActionEntry(REDUCE, 349);
   _actionMap[559][JOIN] = ActionEntry(REDUCE, 349);
   _actionMap[559][RETURNTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][ORDER] = ActionEntry(REDUCE, 349);
   _actionMap[559][GROUP] = ActionEntry(REDUCE, 349);
   _actionMap[559][WHERE] = ActionEntry(REDUCE, 349);
   _actionMap[559][FROM] = ActionEntry(REDUCE, 349);
   _actionMap[559][AS] = ActionEntry(REDUCE, 349);
   _actionMap[559][END_TOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][BEGIN] = ActionEntry(REDUCE, 349);
   _actionMap[559][THEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][OR] = ActionEntry(REDUCE, 349);
   _actionMap[559][AND] = ActionEntry(REDUCE, 349);
   _actionMap[559][ENDTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][UNION] = ActionEntry(REDUCE, 349);
   _actionMap[559][ROWLIMIT] = ActionEntry(REDUCE, 349);
   _actionMap[559][ASC] = ActionEntry(REDUCE, 349);
   _actionMap[559][DESC] = ActionEntry(REDUCE, 349);
   _actionMap[559][INTOK] = ActionEntry(REDUCE, 349);
   _actionMap[559][BETWEEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][LIKE] = ActionEntry(REDUCE, 349);
   _actionMap[559][PLUS] = ActionEntry(REDUCE, 349);
   _actionMap[559][MINUS] = ActionEntry(REDUCE, 349);
   _actionMap[559][CONCAT] = ActionEntry(REDUCE, 349);
   _actionMap[559][DIVISION] = ActionEntry(REDUCE, 349);
   _actionMap[559][STAR] = ActionEntry(REDUCE, 349);
   _actionMap[559][MT] = ActionEntry(REDUCE, 349);
   _actionMap[559][LT] = ActionEntry(REDUCE, 349);
   _actionMap[559][NEGATION] = ActionEntry(REDUCE, 349);
   _actionMap[559][EQU] = ActionEntry(REDUCE, 349);
   _actionMap[559][IS] = ActionEntry(REDUCE, 349);
   _actionMap[559][NULLTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[559][NOT] = ActionEntry(REDUCE, 349);
   _actionMap[559][KSEP] = ActionEntry(REDUCE, 349);
   _actionMap[559][SEMICOLON] = ActionEntry(REDUCE, 349);
   _actionMap[559][RB] = ActionEntry(REDUCE, 349);
}
void Cego::loadParser115()
{
   _actionMap[560][WHEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][ELSE] = ActionEntry(REDUCE, 351);
   _actionMap[560][LEFT] = ActionEntry(REDUCE, 351);
   _actionMap[560][RIGHT] = ActionEntry(REDUCE, 351);
   _actionMap[560][INNER] = ActionEntry(REDUCE, 351);
   _actionMap[560][JOIN] = ActionEntry(REDUCE, 351);
   _actionMap[560][RETURNTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][ORDER] = ActionEntry(REDUCE, 351);
   _actionMap[560][GROUP] = ActionEntry(REDUCE, 351);
   _actionMap[560][WHERE] = ActionEntry(REDUCE, 351);
   _actionMap[560][FROM] = ActionEntry(REDUCE, 351);
   _actionMap[560][AS] = ActionEntry(REDUCE, 351);
   _actionMap[560][END_TOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][BEGIN] = ActionEntry(REDUCE, 351);
   _actionMap[560][THEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][OR] = ActionEntry(REDUCE, 351);
   _actionMap[560][AND] = ActionEntry(REDUCE, 351);
   _actionMap[560][ENDTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][UNION] = ActionEntry(REDUCE, 351);
   _actionMap[560][ROWLIMIT] = ActionEntry(REDUCE, 351);
   _actionMap[560][ASC] = ActionEntry(REDUCE, 351);
   _actionMap[560][DESC] = ActionEntry(REDUCE, 351);
   _actionMap[560][INTOK] = ActionEntry(REDUCE, 351);
   _actionMap[560][BETWEEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][LIKE] = ActionEntry(REDUCE, 351);
   _actionMap[560][PLUS] = ActionEntry(REDUCE, 351);
   _actionMap[560][MINUS] = ActionEntry(REDUCE, 351);
   _actionMap[560][CONCAT] = ActionEntry(REDUCE, 351);
   _actionMap[560][DIVISION] = ActionEntry(REDUCE, 351);
   _actionMap[560][STAR] = ActionEntry(REDUCE, 351);
   _actionMap[560][MT] = ActionEntry(REDUCE, 351);
   _actionMap[560][LT] = ActionEntry(REDUCE, 351);
   _actionMap[560][NEGATION] = ActionEntry(REDUCE, 351);
   _actionMap[560][EQU] = ActionEntry(REDUCE, 351);
   _actionMap[560][IS] = ActionEntry(REDUCE, 351);
   _actionMap[560][NULLTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[560][NOT] = ActionEntry(REDUCE, 351);
   _actionMap[560][KSEP] = ActionEntry(REDUCE, 351);
   _actionMap[560][SEMICOLON] = ActionEntry(REDUCE, 351);
   _actionMap[560][RB] = ActionEntry(REDUCE, 351);
   _actionMap[561][WHEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][ELSE] = ActionEntry(REDUCE, 352);
   _actionMap[561][LEFT] = ActionEntry(REDUCE, 352);
   _actionMap[561][RIGHT] = ActionEntry(REDUCE, 352);
   _actionMap[561][INNER] = ActionEntry(REDUCE, 352);
   _actionMap[561][JOIN] = ActionEntry(REDUCE, 352);
   _actionMap[561][RETURNTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][ORDER] = ActionEntry(REDUCE, 352);
   _actionMap[561][GROUP] = ActionEntry(REDUCE, 352);
   _actionMap[561][WHERE] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser116()
{
   _actionMap[561][FROM] = ActionEntry(REDUCE, 352);
   _actionMap[561][AS] = ActionEntry(REDUCE, 352);
   _actionMap[561][END_TOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][BEGIN] = ActionEntry(REDUCE, 352);
   _actionMap[561][THEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][OR] = ActionEntry(REDUCE, 352);
   _actionMap[561][AND] = ActionEntry(REDUCE, 352);
   _actionMap[561][ENDTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][UNION] = ActionEntry(REDUCE, 352);
   _actionMap[561][ROWLIMIT] = ActionEntry(REDUCE, 352);
   _actionMap[561][ASC] = ActionEntry(REDUCE, 352);
   _actionMap[561][DESC] = ActionEntry(REDUCE, 352);
   _actionMap[561][INTOK] = ActionEntry(REDUCE, 352);
   _actionMap[561][BETWEEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][LIKE] = ActionEntry(REDUCE, 352);
   _actionMap[561][PLUS] = ActionEntry(REDUCE, 352);
   _actionMap[561][MINUS] = ActionEntry(REDUCE, 352);
   _actionMap[561][CONCAT] = ActionEntry(REDUCE, 352);
   _actionMap[561][DIVISION] = ActionEntry(REDUCE, 352);
   _actionMap[561][STAR] = ActionEntry(REDUCE, 352);
   _actionMap[561][MT] = ActionEntry(REDUCE, 352);
   _actionMap[561][LT] = ActionEntry(REDUCE, 352);
   _actionMap[561][NEGATION] = ActionEntry(REDUCE, 352);
   _actionMap[561][EQU] = ActionEntry(REDUCE, 352);
   _actionMap[561][IS] = ActionEntry(REDUCE, 352);
   _actionMap[561][NULLTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[561][NOT] = ActionEntry(REDUCE, 352);
   _actionMap[561][KSEP] = ActionEntry(REDUCE, 352);
   _actionMap[561][SEMICOLON] = ActionEntry(REDUCE, 352);
   _actionMap[561][RB] = ActionEntry(REDUCE, 352);
   _actionMap[562][RAB] = ActionEntry(SHIFT, 670);
   _actionMap[563][SEMICOLON] = ActionEntry(REDUCE, 271);
   _actionMap[564][SEMICOLON] = ActionEntry(REDUCE, 267);
   _actionMap[565][SEMICOLON] = ActionEntry(REDUCE, 268);
   _actionMap[566][SEMICOLON] = ActionEntry(REDUCE, 269);
   _actionMap[567][SEMICOLON] = ActionEntry(REDUCE, 266);
   _actionMap[568][SEMICOLON] = ActionEntry(REDUCE, 270);
   _actionMap[569][SEMICOLON] = ActionEntry(REDUCE, 227);
   _actionMap[569][RB] = ActionEntry(REDUCE, 227);
   _actionMap[569][ENDTOKEN] = ActionEntry(REDUCE, 227);
   _actionMap[569][UNION] = ActionEntry(REDUCE, 227);
   _actionMap[569][ROWLIMIT] = ActionEntry(REDUCE, 227);
   _actionMap[569][ORDER] = ActionEntry(REDUCE, 227);
   _actionMap[569][GROUP] = ActionEntry(SHIFT, 673);
   _jumpMap[569][NoGroup] = 672;
   _jumpMap[569][GroupClause] = 671;
   _actionMap[570][LEFT] = ActionEntry(REDUCE, 210);
   _actionMap[570][RIGHT] = ActionEntry(REDUCE, 210);
   _actionMap[570][INNER] = ActionEntry(REDUCE, 210);
   _actionMap[570][JOIN] = ActionEntry(REDUCE, 210);
}
void Cego::loadParser117()
{
   _actionMap[570][RETURNTOKEN] = ActionEntry(REDUCE, 210);
   _actionMap[570][SEMICOLON] = ActionEntry(REDUCE, 210);
   _actionMap[570][RB] = ActionEntry(REDUCE, 210);
   _actionMap[570][ENDTOKEN] = ActionEntry(REDUCE, 210);
   _actionMap[570][UNION] = ActionEntry(REDUCE, 210);
   _actionMap[570][ROWLIMIT] = ActionEntry(REDUCE, 210);
   _actionMap[570][ORDER] = ActionEntry(REDUCE, 210);
   _actionMap[570][GROUP] = ActionEntry(REDUCE, 210);
   _actionMap[570][WHERE] = ActionEntry(REDUCE, 210);
   _actionMap[571][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[571][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[571][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[571][ObjSpec] = 436;
   _jumpMap[571][Table] = 674;
   _actionMap[572][JOIN] = ActionEntry(SHIFT, 675);
   _actionMap[573][IDENTIFIER] = ActionEntry(REDUCE, 216);
   _actionMap[573][QUALIFIEDOBJ] = ActionEntry(REDUCE, 216);
   _actionMap[573][QUALIFIEDTS] = ActionEntry(REDUCE, 216);
   _actionMap[574][OUTER] = ActionEntry(SHIFT, 676);
   _actionMap[575][OUTER] = ActionEntry(SHIFT, 677);
   _actionMap[576][LEFT] = ActionEntry(REDUCE, 211);
   _actionMap[576][RIGHT] = ActionEntry(REDUCE, 211);
   _actionMap[576][INNER] = ActionEntry(REDUCE, 211);
   _actionMap[576][JOIN] = ActionEntry(REDUCE, 211);
   _actionMap[576][RETURNTOKEN] = ActionEntry(REDUCE, 211);
   _actionMap[576][SEMICOLON] = ActionEntry(REDUCE, 211);
   _actionMap[576][RB] = ActionEntry(REDUCE, 211);
   _actionMap[576][ENDTOKEN] = ActionEntry(REDUCE, 211);
   _actionMap[576][UNION] = ActionEntry(REDUCE, 211);
   _actionMap[576][ROWLIMIT] = ActionEntry(REDUCE, 211);
   _actionMap[576][ORDER] = ActionEntry(REDUCE, 211);
   _actionMap[576][GROUP] = ActionEntry(REDUCE, 211);
   _actionMap[576][WHERE] = ActionEntry(REDUCE, 211);
   _actionMap[577][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[577][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[577][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[577][ObjSpec] = 436;
   _jumpMap[577][Table] = 679;
   _jumpMap[577][TableList] = 678;
   _actionMap[578][WHERE] = ActionEntry(REDUCE, 220);
   _actionMap[578][GROUP] = ActionEntry(REDUCE, 220);
   _actionMap[578][ORDER] = ActionEntry(REDUCE, 220);
   _actionMap[578][ROWLIMIT] = ActionEntry(REDUCE, 220);
   _actionMap[578][UNION] = ActionEntry(REDUCE, 220);
   _actionMap[578][ENDTOKEN] = ActionEntry(REDUCE, 220);
   _actionMap[578][RB] = ActionEntry(REDUCE, 220);
   _actionMap[578][SEMICOLON] = ActionEntry(REDUCE, 220);
   _actionMap[578][RETURNTOKEN] = ActionEntry(REDUCE, 220);
   _actionMap[578][LEFT] = ActionEntry(REDUCE, 220);
   _actionMap[578][RIGHT] = ActionEntry(REDUCE, 220);
}
void Cego::loadParser118()
{
   _actionMap[578][INNER] = ActionEntry(REDUCE, 220);
   _actionMap[578][JOIN] = ActionEntry(REDUCE, 220);
   _actionMap[578][KSEP] = ActionEntry(REDUCE, 220);
   _actionMap[578][ON] = ActionEntry(REDUCE, 220);
   _actionMap[579][FROM] = ActionEntry(REDUCE, 222);
   _actionMap[579][KSEP] = ActionEntry(REDUCE, 222);
   _actionMap[580][FROM] = ActionEntry(REDUCE, 205);
   _actionMap[580][KSEP] = ActionEntry(REDUCE, 205);
   _actionMap[581][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[581][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[581][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[581][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[582][RETURNTOKEN] = ActionEntry(SHIFT, 681);
   _actionMap[582][SEMICOLON] = ActionEntry(REDUCE, 252);
   _jumpMap[582][UpdReturnOpt] = 680;
   _actionMap[583][IDENTIFIER] = ActionEntry(SHIFT, 445);
   _jumpMap[583][Assignment] = 682;
   _actionMap[584][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[584][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[584][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[584][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[584][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[584][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[584][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[584][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[584][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[584][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[584][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[584][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[584][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[584][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[584][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[584][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[584][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[584][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[584][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[584][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[584][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[584][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[584][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[584][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[584][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[584][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[584][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[584][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[584][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[584][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[584][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[584][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[584][IDENTIFIER] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser119()
{
   _actionMap[584][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[584][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[584][LB] = ActionEntry(SHIFT, 142);
   _actionMap[584][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[584][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[584][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[584][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[584][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[584][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[584][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[584][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[584][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[584][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[584][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[584][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[584][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[584][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[584][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[584][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[584][ObjSpec] = 99;
   _jumpMap[584][Constant] = 98;
   _jumpMap[584][SignedFloat] = 97;
   _jumpMap[584][SignedInt] = 96;
   _jumpMap[584][Attribute] = 95;
   _jumpMap[584][Function] = 94;
   _jumpMap[584][CasePrepare] = 93;
   _jumpMap[584][CaseClause] = 92;
   _jumpMap[584][Factor] = 91;
   _jumpMap[584][Term] = 90;
   _jumpMap[584][Expr] = 683;
   _actionMap[585][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[585][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[585][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[585][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[585][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[585][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[585][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[585][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[585][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[585][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[585][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[585][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[585][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[585][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[585][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[585][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[585][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[585][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[585][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[585][STR2INT] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser120()
{
   _actionMap[585][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[585][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[585][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[585][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[585][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[585][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[585][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[585][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[585][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[585][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[585][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[585][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[585][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[585][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[585][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[585][LB] = ActionEntry(SHIFT, 142);
   _actionMap[585][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[585][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[585][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[585][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[585][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[585][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[585][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[585][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[585][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[585][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[585][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[585][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[585][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[585][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[585][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[585][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[585][RB] = ActionEntry(REDUCE, 117);
   _jumpMap[585][ObjSpec] = 99;
   _jumpMap[585][Constant] = 98;
   _jumpMap[585][SignedFloat] = 97;
   _jumpMap[585][SignedInt] = 96;
   _jumpMap[585][Attribute] = 95;
   _jumpMap[585][Function] = 94;
   _jumpMap[585][CasePrepare] = 93;
   _jumpMap[585][CaseClause] = 92;
   _jumpMap[585][Factor] = 91;
   _jumpMap[585][Term] = 90;
   _jumpMap[585][Expr] = 321;
   _jumpMap[585][ProcValueList] = 320;
   _jumpMap[585][ProcValueListOpt] = 684;
   _actionMap[311][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[312][SEMICOLON] = ActionEntry(REDUCE, 259);
   _actionMap[313][KSEP] = ActionEntry(SHIFT, 447);
   _actionMap[313][SEMICOLON] = ActionEntry(REDUCE, 261);
}
void Cego::loadParser121()
{
   _actionMap[314][CHECK] = ActionEntry(SHIFT, 448);
   _actionMap[314][FOREIGN] = ActionEntry(SHIFT, 450);
   _actionMap[314][COLUMN] = ActionEntry(SHIFT, 449);
   _actionMap[315][COLUMN] = ActionEntry(SHIFT, 451);
   _actionMap[316][COLUMN] = ActionEntry(SHIFT, 452);
   _actionMap[317][COLUMN] = ActionEntry(SHIFT, 453);
   _actionMap[318][STRINGVAL] = ActionEntry(SHIFT, 454);
   _actionMap[319][RB] = ActionEntry(SHIFT, 322);
   _actionMap[320][KSEP] = ActionEntry(SHIFT, 455);
   _actionMap[320][RB] = ActionEntry(REDUCE, 116);
   _actionMap[321][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[321][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[321][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[321][KSEP] = ActionEntry(REDUCE, 119);
   _actionMap[321][RB] = ActionEntry(REDUCE, 119);
   _actionMap[322][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[323][END_TOKEN] = ActionEntry(SHIFT, 456);
   _actionMap[324][EXCEPTION] = ActionEntry(REDUCE, 114);
   _actionMap[324][ELSE] = ActionEntry(REDUCE, 114);
   _actionMap[324][ELSIF] = ActionEntry(REDUCE, 114);
   _actionMap[324][END_TOKEN] = ActionEntry(REDUCE, 114);
   _actionMap[324][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[324][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[324][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[324][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[324][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[324][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[324][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[324][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[324][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[324][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[324][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[324][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[324][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[324][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[324][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[324][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[324][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[324][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[324][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[324][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[324][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[324][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[324][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[324][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[324][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[324][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[324][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[324][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[324][BITOR] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser122()
{
   _actionMap[324][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[324][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[324][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[324][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[324][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[324][LB] = ActionEntry(SHIFT, 142);
   _actionMap[324][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[324][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[324][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[324][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[324][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[324][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[324][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[324][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[324][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[324][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[324][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[324][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[324][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[324][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[324][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[324][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[324][IF] = ActionEntry(SHIFT, 338);
   _actionMap[324][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[324][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[324][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[324][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[324][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[324][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[324][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[324][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[324][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[324][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[324][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[324][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[324][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[324][ObjSpec] = 99;
   _jumpMap[324][Constant] = 98;
   _jumpMap[324][SignedFloat] = 97;
   _jumpMap[324][SignedInt] = 96;
   _jumpMap[324][Attribute] = 95;
   _jumpMap[324][Function] = 94;
   _jumpMap[324][DeleteStatement] = 334;
   _jumpMap[324][UpdateStatement] = 333;
   _jumpMap[324][InsertStatement] = 332;
   _jumpMap[324][RollbackStatement] = 331;
   _jumpMap[324][CommitStatement] = 330;
   _jumpMap[324][StartStatement] = 329;
   _jumpMap[324][CasePrepare] = 93;
}
void Cego::loadParser123()
{
   _jumpMap[324][CaseClause] = 92;
   _jumpMap[324][Factor] = 91;
   _jumpMap[324][Term] = 90;
   _jumpMap[324][Expr] = 328;
   _jumpMap[324][ProcStatement] = 458;
   _jumpMap[324][ProcIfPart] = 326;
   _jumpMap[324][ProcExceptionList] = 457;
   _jumpMap[324][ProcBlockStart] = 325;
   _actionMap[325][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[325][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[325][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[325][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[325][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[325][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[325][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[325][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[325][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[325][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[325][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[325][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[325][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[325][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[325][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[325][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[325][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[325][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[325][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[325][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[325][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[325][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[325][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[325][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[325][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[325][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[325][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[325][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[325][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[325][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[325][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[325][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[325][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[325][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[325][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[325][LB] = ActionEntry(SHIFT, 142);
   _actionMap[325][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[325][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[325][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[325][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[325][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[325][FALSEVAL] = ActionEntry(SHIFT, 111);
}
void Cego::loadParser124()
{
   _actionMap[325][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[325][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[325][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[325][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[325][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[325][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[325][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[325][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[325][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[325][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[325][IF] = ActionEntry(SHIFT, 338);
   _actionMap[325][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[325][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[325][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[325][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[325][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[325][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[325][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[325][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[325][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[325][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[325][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[325][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[325][WHILE] = ActionEntry(SHIFT, 342);
   _jumpMap[325][ObjSpec] = 99;
   _jumpMap[325][Constant] = 98;
   _jumpMap[325][SignedFloat] = 97;
   _jumpMap[325][SignedInt] = 96;
   _jumpMap[325][Attribute] = 95;
   _jumpMap[325][Function] = 94;
   _jumpMap[325][DeleteStatement] = 334;
   _jumpMap[325][UpdateStatement] = 333;
   _jumpMap[325][InsertStatement] = 332;
   _jumpMap[325][RollbackStatement] = 331;
   _jumpMap[325][CommitStatement] = 330;
   _jumpMap[325][StartStatement] = 329;
   _jumpMap[325][CasePrepare] = 93;
   _jumpMap[325][CaseClause] = 92;
   _jumpMap[325][Factor] = 91;
   _jumpMap[325][Term] = 90;
   _jumpMap[325][Expr] = 328;
   _jumpMap[325][ProcStatement] = 327;
   _jumpMap[325][ProcIfPart] = 326;
   _jumpMap[325][ProcBlockStart] = 325;
   _jumpMap[325][ProcStatementList] = 324;
   _jumpMap[325][ProcStmtBlock] = 459;
   _actionMap[326][ELSIF] = ActionEntry(SHIFT, 462);
   _actionMap[326][END_TOKEN] = ActionEntry(REDUCE, 124);
   _actionMap[326][ELSE] = ActionEntry(REDUCE, 124);
   _jumpMap[326][ProcElsIfOpt] = 461;
}
void Cego::loadParser125()
{
   _jumpMap[326][ProcElsIfList] = 460;
   _actionMap[327][SEMICOLON] = ActionEntry(SHIFT, 463);
   _actionMap[328][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[328][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[328][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[328][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[329][SEMICOLON] = ActionEntry(REDUCE, 106);
   _actionMap[330][SEMICOLON] = ActionEntry(REDUCE, 107);
   _actionMap[331][SEMICOLON] = ActionEntry(REDUCE, 108);
   _actionMap[332][SEMICOLON] = ActionEntry(REDUCE, 103);
   _actionMap[333][SEMICOLON] = ActionEntry(REDUCE, 105);
   _actionMap[334][SEMICOLON] = ActionEntry(REDUCE, 104);
   _actionMap[335][VAR] = ActionEntry(REDUCE, 112);
   _actionMap[335][CURSOR] = ActionEntry(REDUCE, 112);
   _actionMap[335][CLOSE] = ActionEntry(REDUCE, 112);
   _actionMap[335][VARREF] = ActionEntry(REDUCE, 112);
   _actionMap[335][NOOP] = ActionEntry(REDUCE, 112);
   _actionMap[335][RETURNTOKEN] = ActionEntry(REDUCE, 112);
   _actionMap[335][WHILE] = ActionEntry(REDUCE, 112);
   _actionMap[335][IF] = ActionEntry(REDUCE, 112);
   _actionMap[335][BEGIN] = ActionEntry(REDUCE, 112);
   _actionMap[335][ROLLBACK] = ActionEntry(REDUCE, 112);
   _actionMap[335][COMMIT] = ActionEntry(REDUCE, 112);
   _actionMap[335][START_TOKEN] = ActionEntry(REDUCE, 112);
   _actionMap[335][UPDATE] = ActionEntry(REDUCE, 112);
   _actionMap[335][DELETETOK] = ActionEntry(REDUCE, 112);
   _actionMap[335][INSERT] = ActionEntry(REDUCE, 112);
   _actionMap[335][FETCH] = ActionEntry(REDUCE, 112);
   _actionMap[335][LB] = ActionEntry(REDUCE, 112);
   _actionMap[335][COUNT] = ActionEntry(REDUCE, 112);
   _actionMap[335][SUM] = ActionEntry(REDUCE, 112);
   _actionMap[335][AVG] = ActionEntry(REDUCE, 112);
   _actionMap[335][MIN] = ActionEntry(REDUCE, 112);
   _actionMap[335][MAX] = ActionEntry(REDUCE, 112);
   _actionMap[335][CASE] = ActionEntry(REDUCE, 112);
   _actionMap[335][TRIM] = ActionEntry(REDUCE, 112);
   _actionMap[335][RTRIM] = ActionEntry(REDUCE, 112);
   _actionMap[335][LTRIM] = ActionEntry(REDUCE, 112);
   _actionMap[335][ROUND] = ActionEntry(REDUCE, 112);
   _actionMap[335][DATE2STR] = ActionEntry(REDUCE, 112);
   _actionMap[335][DATE2INT] = ActionEntry(REDUCE, 112);
   _actionMap[335][INT2DATE] = ActionEntry(REDUCE, 112);
   _actionMap[335][LOWER] = ActionEntry(REDUCE, 112);
   _actionMap[335][UPPER] = ActionEntry(REDUCE, 112);
   _actionMap[335][LEFT] = ActionEntry(REDUCE, 112);
   _actionMap[335][RIGHT] = ActionEntry(REDUCE, 112);
   _actionMap[335][GETPOS] = ActionEntry(REDUCE, 112);
   _actionMap[335][SUBSTR] = ActionEntry(REDUCE, 112);
   _actionMap[335][REPLACE] = ActionEntry(REDUCE, 112);
   _actionMap[335][LENGTH] = ActionEntry(REDUCE, 112);
}
void Cego::loadParser126()
{
   _actionMap[335][TRUNC] = ActionEntry(REDUCE, 112);
   _actionMap[335][STR2INT] = ActionEntry(REDUCE, 112);
   _actionMap[335][STR2LONG] = ActionEntry(REDUCE, 112);
   _actionMap[335][STR2DATE] = ActionEntry(REDUCE, 112);
   _actionMap[335][RANDSTR] = ActionEntry(REDUCE, 112);
   _actionMap[335][RANDINT] = ActionEntry(REDUCE, 112);
   _actionMap[335][MOD] = ActionEntry(REDUCE, 112);
   _actionMap[335][DIV] = ActionEntry(REDUCE, 112);
   _actionMap[335][POWER] = ActionEntry(REDUCE, 112);
   _actionMap[335][BITAND] = ActionEntry(REDUCE, 112);
   _actionMap[335][BITOR] = ActionEntry(REDUCE, 112);
   _actionMap[335][BITXOR] = ActionEntry(REDUCE, 112);
   _actionMap[335][NEXTCOUNT] = ActionEntry(REDUCE, 112);
   _actionMap[335][SETCOUNT] = ActionEntry(REDUCE, 112);
   _actionMap[335][IDENTIFIER] = ActionEntry(REDUCE, 112);
   _actionMap[335][QUALIFIEDOBJ] = ActionEntry(REDUCE, 112);
   _actionMap[335][QUALIFIEDTS] = ActionEntry(REDUCE, 112);
   _actionMap[335][QUALIFIEDPRE] = ActionEntry(REDUCE, 112);
   _actionMap[335][STRINGVAL] = ActionEntry(REDUCE, 112);
   _actionMap[335][DATE] = ActionEntry(REDUCE, 112);
   _actionMap[335][SYSDATE] = ActionEntry(REDUCE, 112);
   _actionMap[335][NULLTOKEN] = ActionEntry(REDUCE, 112);
   _actionMap[335][TRUEVAL] = ActionEntry(REDUCE, 112);
   _actionMap[335][FALSEVAL] = ActionEntry(REDUCE, 112);
   _actionMap[335][LAB] = ActionEntry(REDUCE, 112);
   _actionMap[335][FLOATVAL] = ActionEntry(REDUCE, 112);
   _actionMap[335][MINUS] = ActionEntry(REDUCE, 112);
   _actionMap[335][INTVAL] = ActionEntry(REDUCE, 112);
   _actionMap[336][IDENTIFIER] = ActionEntry(SHIFT, 464);
   _actionMap[337][IDENTIFIER] = ActionEntry(SHIFT, 465);
   _actionMap[338][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[338][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[338][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[338][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[338][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[338][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[338][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[338][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[338][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[338][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[338][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[338][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[338][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[338][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[338][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[338][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[338][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[338][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[338][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[338][STR2INT] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser127()
{
   _actionMap[338][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[338][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[338][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[338][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[338][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[338][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[338][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[338][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[338][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[338][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[338][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[338][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[338][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[338][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[338][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[338][LB] = ActionEntry(SHIFT, 470);
   _actionMap[338][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[338][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[338][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[338][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[338][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[338][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[338][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[338][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[338][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[338][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[338][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[338][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[338][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[338][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[338][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[338][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[338][ObjSpec] = 99;
   _jumpMap[338][Constant] = 98;
   _jumpMap[338][SignedFloat] = 97;
   _jumpMap[338][SignedInt] = 96;
   _jumpMap[338][Attribute] = 95;
   _jumpMap[338][Function] = 94;
   _jumpMap[338][CasePrepare] = 93;
   _jumpMap[338][CaseClause] = 92;
   _jumpMap[338][Factor] = 91;
   _jumpMap[338][Term] = 90;
   _jumpMap[338][Expr] = 469;
   _jumpMap[338][ProcPredicate] = 468;
   _jumpMap[338][ProcCondition] = 467;
   _jumpMap[338][ProcIfCondition] = 466;
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[340][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[340][MINUS] = ActionEntry(SHIFT, 144);
}
void Cego::loadParser128()
{
   _actionMap[340][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[340][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[340][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[340][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[340][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[340][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[340][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[340][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[340][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[340][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[340][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[340][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[340][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[340][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[340][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[340][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[340][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[340][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[340][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[340][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[340][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[340][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[340][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[340][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[340][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[340][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[340][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[340][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[340][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[340][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[340][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[340][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[340][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[340][LB] = ActionEntry(SHIFT, 142);
   _actionMap[340][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[340][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[340][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[340][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[340][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[340][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[340][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[340][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[340][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[340][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[340][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[340][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[340][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[340][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[340][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[340][MAX] = ActionEntry(SHIFT, 120);
}
void Cego::loadParser129()
{
   _jumpMap[340][ObjSpec] = 99;
   _jumpMap[340][Constant] = 98;
   _jumpMap[340][SignedFloat] = 97;
   _jumpMap[340][SignedInt] = 96;
   _jumpMap[340][Attribute] = 95;
   _jumpMap[340][Function] = 94;
   _jumpMap[340][CasePrepare] = 93;
   _jumpMap[340][CaseClause] = 92;
   _jumpMap[340][Factor] = 91;
   _jumpMap[340][Term] = 90;
   _jumpMap[340][Expr] = 471;
   _actionMap[341][IDENTIFIER] = ActionEntry(SHIFT, 472);
   _actionMap[342][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[342][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[342][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[342][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[342][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[342][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[342][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[342][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[342][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[342][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[342][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[342][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[342][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[342][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[342][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[342][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[342][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[342][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[342][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[342][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[342][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[342][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[342][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[342][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[342][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[342][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[342][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[342][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[342][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[342][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[342][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[342][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[342][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[342][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[342][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[342][LB] = ActionEntry(SHIFT, 470);
   _actionMap[342][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[342][DATE] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser130()
{
   _actionMap[342][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[342][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[342][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[342][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[342][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[342][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[342][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[342][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[342][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[342][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[342][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[342][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[342][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[342][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[342][ObjSpec] = 99;
   _jumpMap[342][Constant] = 98;
   _jumpMap[342][SignedFloat] = 97;
   _jumpMap[342][SignedInt] = 96;
   _jumpMap[342][Attribute] = 95;
   _jumpMap[342][Function] = 94;
   _jumpMap[342][CasePrepare] = 93;
   _jumpMap[342][CaseClause] = 92;
   _jumpMap[342][Factor] = 91;
   _jumpMap[342][Term] = 90;
   _jumpMap[342][Expr] = 469;
   _jumpMap[342][ProcPredicate] = 468;
   _jumpMap[342][ProcCondition] = 474;
   _jumpMap[342][ProcWhileCondition] = 473;
   _actionMap[343][CONCAT] = ActionEntry(REDUCE, 147);
   _actionMap[343][STAR] = ActionEntry(REDUCE, 147);
   _actionMap[343][DIVISION] = ActionEntry(REDUCE, 147);
   _actionMap[343][MINUS] = ActionEntry(REDUCE, 147);
   _actionMap[343][PLUS] = ActionEntry(REDUCE, 147);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[343][EQU] = ActionEntry(SHIFT, 475);
   _actionMap[344][ON] = ActionEntry(SHIFT, 476);
   _actionMap[345][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[345][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[345][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[345][ObjSpec] = 477;
   _actionMap[346][IDENTIFIER] = ActionEntry(SHIFT, 482);
   _actionMap[346][RB] = ActionEntry(REDUCE, 86);
   _jumpMap[346][ProcArg] = 480;
   _jumpMap[346][ProcArgList] = 479;
   _jumpMap[346][ProcArgOpt] = 478;
   _actionMap[347][IDENTIFIER] = ActionEntry(SHIFT, 487);
   _actionMap[347][PRIMARY] = ActionEntry(SHIFT, 486);
   _jumpMap[347][ColumnDesc] = 485;
   _jumpMap[347][KeyColumn] = 484;
   _jumpMap[347][ColumnList] = 483;
}
void Cego::loadParser131()
{
   _actionMap[348][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[348][SelectStatement] = 488;
   _actionMap[349][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[349][WHERE] = ActionEntry(SHIFT, 352);
   _jumpMap[349][NoWhere] = 351;
   _jumpMap[349][WhereClause] = 350;
   _actionMap[350][SEMICOLON] = ActionEntry(REDUCE, 256);
   _actionMap[351][RETURNTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[351][GROUP] = ActionEntry(REDUCE, 306);
   _actionMap[351][ORDER] = ActionEntry(REDUCE, 306);
   _actionMap[351][ROWLIMIT] = ActionEntry(REDUCE, 306);
   _actionMap[351][UNION] = ActionEntry(REDUCE, 306);
   _actionMap[351][ENDTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[351][RB] = ActionEntry(REDUCE, 306);
   _actionMap[351][SEMICOLON] = ActionEntry(REDUCE, 306);
   _actionMap[352][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[352][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[352][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[352][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[352][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[352][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[352][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[352][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[352][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[352][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[352][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[352][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[352][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[352][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[352][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[352][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[352][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[352][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[352][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[352][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[352][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[352][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[352][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[352][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[352][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[352][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[352][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[352][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[352][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[352][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[352][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[352][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[352][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[352][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[352][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser132()
{
   _actionMap[352][LB] = ActionEntry(SHIFT, 373);
   _actionMap[352][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[352][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[352][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[352][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[352][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[352][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[352][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[352][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[352][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[352][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[352][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[352][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[352][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[352][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[352][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[352][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[352][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[352][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[352][ObjSpec] = 99;
   _jumpMap[352][Constant] = 98;
   _jumpMap[352][SignedFloat] = 97;
   _jumpMap[352][SignedInt] = 96;
   _jumpMap[352][Attribute] = 95;
   _jumpMap[352][QueryPredicate] = 370;
   _jumpMap[352][QueryCondition] = 489;
   _jumpMap[352][Function] = 94;
   _jumpMap[352][CasePrepare] = 93;
   _jumpMap[352][CaseClause] = 92;
   _jumpMap[352][Factor] = 91;
   _jumpMap[352][Term] = 90;
   _jumpMap[352][Expr] = 368;
   _actionMap[353][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[354][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[354][VALUES] = ActionEntry(SHIFT, 357);
   _jumpMap[354][SelectStatement] = 356;
   _jumpMap[354][InsertPrepare] = 355;
   _actionMap[355][LB] = ActionEntry(SHIFT, 492);
   _jumpMap[355][InsertValueSpec] = 491;
   _jumpMap[355][InsertValueSpecList] = 490;
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 191);
   _actionMap[357][LB] = ActionEntry(REDUCE, 194);
   _actionMap[358][IDENTIFIER] = ActionEntry(SHIFT, 494);
   _jumpMap[358][InsertArgList] = 493;
   _actionMap[359][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[360][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[360][SelectStatement] = 495;
   _actionMap[361][STAR] = ActionEntry(SHIFT, 227);
   _actionMap[361][DIVISION] = ActionEntry(SHIFT, 228);
   _actionMap[361][WHEN] = ActionEntry(REDUCE, 143);
}
void Cego::loadParser133()
{
   _actionMap[361][ELSE] = ActionEntry(REDUCE, 143);
   _actionMap[361][LEFT] = ActionEntry(REDUCE, 143);
   _actionMap[361][RIGHT] = ActionEntry(REDUCE, 143);
   _actionMap[361][INNER] = ActionEntry(REDUCE, 143);
   _actionMap[361][JOIN] = ActionEntry(REDUCE, 143);
   _actionMap[361][RETURNTOKEN] = ActionEntry(REDUCE, 143);
   _actionMap[361][ORDER] = ActionEntry(REDUCE, 143);
   _actionMap[361][GROUP] = ActionEntry(REDUCE, 143);
   _actionMap[361][WHERE] = ActionEntry(REDUCE, 143);
   _actionMap[361][BEGIN] = ActionEntry(REDUCE, 143);
   _actionMap[361][THEN] = ActionEntry(REDUCE, 143);
   _actionMap[361][OR] = ActionEntry(REDUCE, 143);
   _actionMap[361][AS] = ActionEntry(REDUCE, 143);
   _actionMap[361][FROM] = ActionEntry(REDUCE, 143);
   _actionMap[361][LIKE] = ActionEntry(REDUCE, 143);
   _actionMap[361][BETWEEN] = ActionEntry(REDUCE, 143);
   _actionMap[361][NOT] = ActionEntry(REDUCE, 143);
   _actionMap[361][INTOK] = ActionEntry(REDUCE, 143);
   _actionMap[361][END_TOKEN] = ActionEntry(REDUCE, 143);
   _actionMap[361][AND] = ActionEntry(REDUCE, 143);
   _actionMap[361][IS] = ActionEntry(REDUCE, 143);
   _actionMap[361][EQU] = ActionEntry(REDUCE, 143);
   _actionMap[361][NEGATION] = ActionEntry(REDUCE, 143);
   _actionMap[361][LT] = ActionEntry(REDUCE, 143);
   _actionMap[361][MT] = ActionEntry(REDUCE, 143);
   _actionMap[361][DESC] = ActionEntry(REDUCE, 143);
   _actionMap[361][ASC] = ActionEntry(REDUCE, 143);
   _actionMap[361][KSEP] = ActionEntry(REDUCE, 143);
   _actionMap[361][ROWLIMIT] = ActionEntry(REDUCE, 143);
   _actionMap[361][UNION] = ActionEntry(REDUCE, 143);
   _actionMap[361][ENDTOKEN] = ActionEntry(REDUCE, 143);
   _actionMap[361][RB] = ActionEntry(REDUCE, 143);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 143);
   _actionMap[361][CONCAT] = ActionEntry(REDUCE, 143);
   _actionMap[361][MINUS] = ActionEntry(REDUCE, 143);
   _actionMap[361][PLUS] = ActionEntry(REDUCE, 143);
   _actionMap[362][STAR] = ActionEntry(SHIFT, 227);
   _actionMap[362][DIVISION] = ActionEntry(SHIFT, 228);
   _actionMap[362][WHEN] = ActionEntry(REDUCE, 141);
   _actionMap[362][ELSE] = ActionEntry(REDUCE, 141);
   _actionMap[362][LEFT] = ActionEntry(REDUCE, 141);
   _actionMap[362][RIGHT] = ActionEntry(REDUCE, 141);
   _actionMap[362][INNER] = ActionEntry(REDUCE, 141);
   _actionMap[362][JOIN] = ActionEntry(REDUCE, 141);
   _actionMap[362][RETURNTOKEN] = ActionEntry(REDUCE, 141);
   _actionMap[362][ORDER] = ActionEntry(REDUCE, 141);
   _actionMap[362][GROUP] = ActionEntry(REDUCE, 141);
   _actionMap[362][WHERE] = ActionEntry(REDUCE, 141);
   _actionMap[362][BEGIN] = ActionEntry(REDUCE, 141);
   _actionMap[362][THEN] = ActionEntry(REDUCE, 141);
}
void Cego::loadParser134()
{
   _actionMap[362][OR] = ActionEntry(REDUCE, 141);
   _actionMap[362][AS] = ActionEntry(REDUCE, 141);
   _actionMap[362][FROM] = ActionEntry(REDUCE, 141);
   _actionMap[362][LIKE] = ActionEntry(REDUCE, 141);
   _actionMap[362][BETWEEN] = ActionEntry(REDUCE, 141);
   _actionMap[362][NOT] = ActionEntry(REDUCE, 141);
   _actionMap[362][INTOK] = ActionEntry(REDUCE, 141);
   _actionMap[362][END_TOKEN] = ActionEntry(REDUCE, 141);
   _actionMap[362][AND] = ActionEntry(REDUCE, 141);
   _actionMap[362][IS] = ActionEntry(REDUCE, 141);
   _actionMap[362][EQU] = ActionEntry(REDUCE, 141);
   _actionMap[362][NEGATION] = ActionEntry(REDUCE, 141);
   _actionMap[362][LT] = ActionEntry(REDUCE, 141);
   _actionMap[362][MT] = ActionEntry(REDUCE, 141);
   _actionMap[362][DESC] = ActionEntry(REDUCE, 141);
   _actionMap[362][ASC] = ActionEntry(REDUCE, 141);
   _actionMap[362][KSEP] = ActionEntry(REDUCE, 141);
   _actionMap[362][ROWLIMIT] = ActionEntry(REDUCE, 141);
   _actionMap[362][UNION] = ActionEntry(REDUCE, 141);
   _actionMap[362][ENDTOKEN] = ActionEntry(REDUCE, 141);
   _actionMap[362][RB] = ActionEntry(REDUCE, 141);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[362][CONCAT] = ActionEntry(REDUCE, 141);
   _actionMap[362][MINUS] = ActionEntry(REDUCE, 141);
   _actionMap[362][PLUS] = ActionEntry(REDUCE, 141);
   _actionMap[363][STAR] = ActionEntry(SHIFT, 227);
   _actionMap[363][DIVISION] = ActionEntry(SHIFT, 228);
   _actionMap[363][WHEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][ELSE] = ActionEntry(REDUCE, 140);
   _actionMap[363][LEFT] = ActionEntry(REDUCE, 140);
   _actionMap[363][RIGHT] = ActionEntry(REDUCE, 140);
   _actionMap[363][INNER] = ActionEntry(REDUCE, 140);
   _actionMap[363][JOIN] = ActionEntry(REDUCE, 140);
   _actionMap[363][RETURNTOKEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][ORDER] = ActionEntry(REDUCE, 140);
   _actionMap[363][GROUP] = ActionEntry(REDUCE, 140);
   _actionMap[363][WHERE] = ActionEntry(REDUCE, 140);
   _actionMap[363][BEGIN] = ActionEntry(REDUCE, 140);
   _actionMap[363][THEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][OR] = ActionEntry(REDUCE, 140);
   _actionMap[363][AS] = ActionEntry(REDUCE, 140);
   _actionMap[363][FROM] = ActionEntry(REDUCE, 140);
   _actionMap[363][LIKE] = ActionEntry(REDUCE, 140);
   _actionMap[363][BETWEEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][NOT] = ActionEntry(REDUCE, 140);
   _actionMap[363][INTOK] = ActionEntry(REDUCE, 140);
   _actionMap[363][END_TOKEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][AND] = ActionEntry(REDUCE, 140);
   _actionMap[363][IS] = ActionEntry(REDUCE, 140);
   _actionMap[363][EQU] = ActionEntry(REDUCE, 140);
}
void Cego::loadParser135()
{
   _actionMap[363][NEGATION] = ActionEntry(REDUCE, 140);
   _actionMap[363][LT] = ActionEntry(REDUCE, 140);
   _actionMap[363][MT] = ActionEntry(REDUCE, 140);
   _actionMap[363][DESC] = ActionEntry(REDUCE, 140);
   _actionMap[363][ASC] = ActionEntry(REDUCE, 140);
   _actionMap[363][KSEP] = ActionEntry(REDUCE, 140);
   _actionMap[363][ROWLIMIT] = ActionEntry(REDUCE, 140);
   _actionMap[363][UNION] = ActionEntry(REDUCE, 140);
   _actionMap[363][ENDTOKEN] = ActionEntry(REDUCE, 140);
   _actionMap[363][RB] = ActionEntry(REDUCE, 140);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[363][CONCAT] = ActionEntry(REDUCE, 140);
   _actionMap[363][MINUS] = ActionEntry(REDUCE, 140);
   _actionMap[363][PLUS] = ActionEntry(REDUCE, 140);
   _actionMap[364][WHEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][ELSE] = ActionEntry(REDUCE, 144);
   _actionMap[364][LEFT] = ActionEntry(REDUCE, 144);
   _actionMap[364][RIGHT] = ActionEntry(REDUCE, 144);
   _actionMap[364][INNER] = ActionEntry(REDUCE, 144);
   _actionMap[364][JOIN] = ActionEntry(REDUCE, 144);
   _actionMap[364][RETURNTOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][ORDER] = ActionEntry(REDUCE, 144);
   _actionMap[364][GROUP] = ActionEntry(REDUCE, 144);
   _actionMap[364][WHERE] = ActionEntry(REDUCE, 144);
   _actionMap[364][BEGIN] = ActionEntry(REDUCE, 144);
   _actionMap[364][THEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][OR] = ActionEntry(REDUCE, 144);
   _actionMap[364][FROM] = ActionEntry(REDUCE, 144);
   _actionMap[364][AS] = ActionEntry(REDUCE, 144);
   _actionMap[364][END_TOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][AND] = ActionEntry(REDUCE, 144);
   _actionMap[364][INTOK] = ActionEntry(REDUCE, 144);
   _actionMap[364][NOT] = ActionEntry(REDUCE, 144);
   _actionMap[364][BETWEEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][IS] = ActionEntry(REDUCE, 144);
   _actionMap[364][LIKE] = ActionEntry(REDUCE, 144);
   _actionMap[364][MT] = ActionEntry(REDUCE, 144);
   _actionMap[364][LT] = ActionEntry(REDUCE, 144);
   _actionMap[364][NEGATION] = ActionEntry(REDUCE, 144);
   _actionMap[364][EQU] = ActionEntry(REDUCE, 144);
   _actionMap[364][RB] = ActionEntry(REDUCE, 144);
   _actionMap[364][ENDTOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[364][UNION] = ActionEntry(REDUCE, 144);
   _actionMap[364][ROWLIMIT] = ActionEntry(REDUCE, 144);
   _actionMap[364][KSEP] = ActionEntry(REDUCE, 144);
   _actionMap[364][ASC] = ActionEntry(REDUCE, 144);
   _actionMap[364][DESC] = ActionEntry(REDUCE, 144);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 144);
   _actionMap[364][PLUS] = ActionEntry(REDUCE, 144);
   _actionMap[364][MINUS] = ActionEntry(REDUCE, 144);
}
void Cego::loadParser136()
{
   _actionMap[364][CONCAT] = ActionEntry(REDUCE, 144);
   _actionMap[364][DIVISION] = ActionEntry(REDUCE, 144);
   _actionMap[364][STAR] = ActionEntry(REDUCE, 144);
   _actionMap[365][WHEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][ELSE] = ActionEntry(REDUCE, 145);
   _actionMap[365][LEFT] = ActionEntry(REDUCE, 145);
   _actionMap[365][RIGHT] = ActionEntry(REDUCE, 145);
   _actionMap[365][INNER] = ActionEntry(REDUCE, 145);
   _actionMap[365][JOIN] = ActionEntry(REDUCE, 145);
   _actionMap[365][RETURNTOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][ORDER] = ActionEntry(REDUCE, 145);
   _actionMap[365][GROUP] = ActionEntry(REDUCE, 145);
   _actionMap[365][WHERE] = ActionEntry(REDUCE, 145);
   _actionMap[365][BEGIN] = ActionEntry(REDUCE, 145);
   _actionMap[365][THEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][OR] = ActionEntry(REDUCE, 145);
   _actionMap[365][FROM] = ActionEntry(REDUCE, 145);
   _actionMap[365][AS] = ActionEntry(REDUCE, 145);
   _actionMap[365][END_TOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][AND] = ActionEntry(REDUCE, 145);
   _actionMap[365][INTOK] = ActionEntry(REDUCE, 145);
   _actionMap[365][NOT] = ActionEntry(REDUCE, 145);
   _actionMap[365][BETWEEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][IS] = ActionEntry(REDUCE, 145);
   _actionMap[365][LIKE] = ActionEntry(REDUCE, 145);
   _actionMap[365][MT] = ActionEntry(REDUCE, 145);
   _actionMap[365][LT] = ActionEntry(REDUCE, 145);
   _actionMap[365][NEGATION] = ActionEntry(REDUCE, 145);
   _actionMap[365][EQU] = ActionEntry(REDUCE, 145);
   _actionMap[365][RB] = ActionEntry(REDUCE, 145);
   _actionMap[365][ENDTOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[365][UNION] = ActionEntry(REDUCE, 145);
   _actionMap[365][ROWLIMIT] = ActionEntry(REDUCE, 145);
   _actionMap[365][KSEP] = ActionEntry(REDUCE, 145);
   _actionMap[365][ASC] = ActionEntry(REDUCE, 145);
   _actionMap[365][DESC] = ActionEntry(REDUCE, 145);
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 145);
   _actionMap[365][PLUS] = ActionEntry(REDUCE, 145);
   _actionMap[365][MINUS] = ActionEntry(REDUCE, 145);
   _actionMap[365][CONCAT] = ActionEntry(REDUCE, 145);
   _actionMap[365][DIVISION] = ActionEntry(REDUCE, 145);
   _actionMap[365][STAR] = ActionEntry(REDUCE, 145);
   _actionMap[366][WHEN] = ActionEntry(REDUCE, 162);
   _actionMap[366][ELSE] = ActionEntry(REDUCE, 162);
   _actionMap[367][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[367][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[367][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[367][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[367][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[367][LTRIM] = ActionEntry(SHIFT, 118);
}
void Cego::loadParser137()
{
   _actionMap[367][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[367][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[367][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[367][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[367][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[367][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[367][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[367][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[367][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[367][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[367][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[367][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[367][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[367][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[367][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[367][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[367][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[367][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[367][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[367][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[367][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[367][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[367][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[367][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[367][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[367][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[367][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[367][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[367][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[367][LB] = ActionEntry(SHIFT, 142);
   _actionMap[367][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[367][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[367][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[367][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[367][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[367][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[367][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[367][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[367][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[367][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[367][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[367][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[367][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[367][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[367][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[367][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[367][ObjSpec] = 99;
   _jumpMap[367][Constant] = 98;
   _jumpMap[367][SignedFloat] = 97;
   _jumpMap[367][SignedInt] = 96;
}
void Cego::loadParser138()
{
   _jumpMap[367][Attribute] = 95;
   _jumpMap[367][Function] = 94;
   _jumpMap[367][CasePrepare] = 93;
   _jumpMap[367][CaseClause] = 92;
   _jumpMap[367][Factor] = 91;
   _jumpMap[367][Term] = 90;
   _jumpMap[367][Expr] = 496;
   _actionMap[368][INTOK] = ActionEntry(SHIFT, 499);
   _actionMap[368][NOT] = ActionEntry(SHIFT, 502);
   _actionMap[368][BETWEEN] = ActionEntry(SHIFT, 498);
   _actionMap[368][IS] = ActionEntry(SHIFT, 500);
   _actionMap[368][LIKE] = ActionEntry(SHIFT, 501);
   _actionMap[368][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[368][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[368][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[368][EQU] = ActionEntry(SHIFT, 503);
   _actionMap[368][NEGATION] = ActionEntry(SHIFT, 506);
   _actionMap[368][LT] = ActionEntry(SHIFT, 504);
   _actionMap[368][MT] = ActionEntry(SHIFT, 505);
   _jumpMap[368][Comparison] = 497;
   _actionMap[369][THEN] = ActionEntry(SHIFT, 509);
   _actionMap[369][AND] = ActionEntry(SHIFT, 507);
   _actionMap[369][OR] = ActionEntry(SHIFT, 508);
   _actionMap[370][THEN] = ActionEntry(REDUCE, 310);
   _actionMap[370][LEFT] = ActionEntry(REDUCE, 310);
   _actionMap[370][RIGHT] = ActionEntry(REDUCE, 310);
   _actionMap[370][INNER] = ActionEntry(REDUCE, 310);
   _actionMap[370][JOIN] = ActionEntry(REDUCE, 310);
   _actionMap[370][RETURNTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[370][SEMICOLON] = ActionEntry(REDUCE, 310);
   _actionMap[370][RB] = ActionEntry(REDUCE, 310);
   _actionMap[370][ENDTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[370][UNION] = ActionEntry(REDUCE, 310);
   _actionMap[370][ROWLIMIT] = ActionEntry(REDUCE, 310);
   _actionMap[370][ORDER] = ActionEntry(REDUCE, 310);
   _actionMap[370][GROUP] = ActionEntry(REDUCE, 310);
   _actionMap[370][WHERE] = ActionEntry(REDUCE, 310);
   _actionMap[370][OR] = ActionEntry(REDUCE, 310);
   _actionMap[370][AND] = ActionEntry(REDUCE, 310);
   _actionMap[371][LB] = ActionEntry(SHIFT, 510);
   _actionMap[372][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[372][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[372][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[372][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[372][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[372][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[372][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[372][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[372][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[372][INT2DATE] = ActionEntry(SHIFT, 114);
}
void Cego::loadParser139()
{
   _actionMap[372][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[372][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[372][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[372][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[372][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[372][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[372][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[372][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[372][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[372][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[372][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[372][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[372][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[372][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[372][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[372][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[372][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[372][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[372][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[372][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[372][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[372][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[372][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[372][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[372][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[372][LB] = ActionEntry(SHIFT, 373);
   _actionMap[372][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[372][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[372][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[372][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[372][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[372][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[372][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[372][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[372][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[372][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[372][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[372][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[372][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[372][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[372][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[372][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[372][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[372][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[372][ObjSpec] = 99;
   _jumpMap[372][Constant] = 98;
   _jumpMap[372][SignedFloat] = 97;
   _jumpMap[372][SignedInt] = 96;
   _jumpMap[372][Attribute] = 95;
   _jumpMap[372][QueryPredicate] = 511;
}
void Cego::loadParser140()
{
   _jumpMap[372][Function] = 94;
   _jumpMap[372][CasePrepare] = 93;
   _jumpMap[372][CaseClause] = 92;
   _jumpMap[372][Factor] = 91;
   _jumpMap[372][Term] = 90;
   _jumpMap[372][Expr] = 368;
   _actionMap[373][LONG] = ActionEntry(SHIFT, 275);
   _actionMap[373][BIGINT] = ActionEntry(SHIFT, 271);
   _actionMap[373][SMALLINT] = ActionEntry(SHIFT, 276);
   _actionMap[373][TINYINT] = ActionEntry(SHIFT, 277);
   _actionMap[373][DOUBLE] = ActionEntry(SHIFT, 273);
   _actionMap[373][DECIMAL] = ActionEntry(SHIFT, 272);
   _actionMap[373][FIXED] = ActionEntry(SHIFT, 274);
   _actionMap[373][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[373][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[373][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[373][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[373][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[373][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[373][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[373][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[373][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[373][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[373][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[373][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[373][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[373][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[373][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[373][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[373][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[373][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[373][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[373][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[373][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[373][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[373][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[373][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[373][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[373][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[373][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[373][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[373][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[373][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[373][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[373][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[373][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[373][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[373][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[373][LB] = ActionEntry(SHIFT, 373);
   _actionMap[373][STRINGVAL] = ActionEntry(SHIFT, 100);
}
void Cego::loadParser141()
{
   _actionMap[373][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[373][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[373][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[373][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[373][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[373][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[373][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[373][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[373][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[373][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[373][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[373][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[373][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[373][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[373][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[373][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[373][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[373][NOT] = ActionEntry(SHIFT, 372);
   _jumpMap[373][ObjSpec] = 99;
   _jumpMap[373][Constant] = 98;
   _jumpMap[373][SignedFloat] = 97;
   _jumpMap[373][SignedInt] = 96;
   _jumpMap[373][Attribute] = 95;
   _jumpMap[373][QueryPredicate] = 370;
   _jumpMap[373][QueryCondition] = 513;
   _jumpMap[373][Function] = 94;
   _jumpMap[373][SelectStatement] = 270;
   _jumpMap[373][CasePrepare] = 93;
   _jumpMap[373][CaseClause] = 92;
   _jumpMap[373][Factor] = 91;
   _jumpMap[373][Term] = 90;
   _jumpMap[373][Expr] = 512;
   _actionMap[374][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[374][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[374][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[374][KSEP] = ActionEntry(REDUCE, 304);
   _actionMap[374][RB] = ActionEntry(REDUCE, 304);
   _actionMap[375][RB] = ActionEntry(SHIFT, 515);
   _actionMap[375][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[376][WHEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][ELSE] = ActionEntry(REDUCE, 302);
   _actionMap[376][LEFT] = ActionEntry(REDUCE, 302);
   _actionMap[376][RIGHT] = ActionEntry(REDUCE, 302);
   _actionMap[376][INNER] = ActionEntry(REDUCE, 302);
   _actionMap[376][JOIN] = ActionEntry(REDUCE, 302);
   _actionMap[376][RETURNTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][ORDER] = ActionEntry(REDUCE, 302);
   _actionMap[376][GROUP] = ActionEntry(REDUCE, 302);
   _actionMap[376][WHERE] = ActionEntry(REDUCE, 302);
   _actionMap[376][FROM] = ActionEntry(REDUCE, 302);
}
void Cego::loadParser142()
{
   _actionMap[376][AS] = ActionEntry(REDUCE, 302);
   _actionMap[376][END_TOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][BEGIN] = ActionEntry(REDUCE, 302);
   _actionMap[376][THEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][OR] = ActionEntry(REDUCE, 302);
   _actionMap[376][AND] = ActionEntry(REDUCE, 302);
   _actionMap[376][INTOK] = ActionEntry(REDUCE, 302);
   _actionMap[376][NOT] = ActionEntry(REDUCE, 302);
   _actionMap[376][BETWEEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][IS] = ActionEntry(REDUCE, 302);
   _actionMap[376][LIKE] = ActionEntry(REDUCE, 302);
   _actionMap[376][MT] = ActionEntry(REDUCE, 302);
   _actionMap[376][LT] = ActionEntry(REDUCE, 302);
   _actionMap[376][NEGATION] = ActionEntry(REDUCE, 302);
   _actionMap[376][EQU] = ActionEntry(REDUCE, 302);
   _actionMap[376][RB] = ActionEntry(REDUCE, 302);
   _actionMap[376][ENDTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[376][UNION] = ActionEntry(REDUCE, 302);
   _actionMap[376][ROWLIMIT] = ActionEntry(REDUCE, 302);
   _actionMap[376][KSEP] = ActionEntry(REDUCE, 302);
   _actionMap[376][ASC] = ActionEntry(REDUCE, 302);
   _actionMap[376][DESC] = ActionEntry(REDUCE, 302);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 302);
   _actionMap[376][PLUS] = ActionEntry(REDUCE, 302);
   _actionMap[376][MINUS] = ActionEntry(REDUCE, 302);
   _actionMap[376][DIVISION] = ActionEntry(REDUCE, 302);
   _actionMap[376][STAR] = ActionEntry(REDUCE, 302);
   _actionMap[376][CONCAT] = ActionEntry(REDUCE, 302);
   _actionMap[377][RB] = ActionEntry(SHIFT, 516);
   _actionMap[377][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[377][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[377][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[378][RB] = ActionEntry(SHIFT, 517);
   _actionMap[378][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[379][RB] = ActionEntry(SHIFT, 518);
   _actionMap[379][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[380][RB] = ActionEntry(SHIFT, 519);
   _actionMap[380][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[381][RB] = ActionEntry(SHIFT, 520);
   _actionMap[381][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[381][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[381][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[382][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[382][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[382][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[382][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[382][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[382][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[382][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[382][DATE2STR] = ActionEntry(SHIFT, 108);
}
void Cego::loadParser143()
{
   _actionMap[382][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[382][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[382][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[382][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[382][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[382][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[382][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[382][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[382][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[382][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[382][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[382][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[382][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[382][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[382][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[382][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[382][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[382][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[382][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[382][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[382][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[382][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[382][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[382][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[382][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[382][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[382][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[382][LB] = ActionEntry(SHIFT, 142);
   _actionMap[382][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[382][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[382][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[382][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[382][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[382][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[382][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[382][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[382][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[382][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[382][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[382][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[382][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[382][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[382][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[382][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[382][ObjSpec] = 99;
   _jumpMap[382][Constant] = 98;
   _jumpMap[382][SignedFloat] = 97;
   _jumpMap[382][SignedInt] = 96;
   _jumpMap[382][Attribute] = 95;
   _jumpMap[382][Function] = 94;
}
void Cego::loadParser144()
{
   _jumpMap[382][CasePrepare] = 93;
   _jumpMap[382][CaseClause] = 92;
   _jumpMap[382][Factor] = 91;
   _jumpMap[382][Term] = 90;
   _jumpMap[382][Expr] = 381;
   _actionMap[383][RB] = ActionEntry(SHIFT, 521);
   _actionMap[384][KSEP] = ActionEntry(SHIFT, 522);
   _actionMap[385][KSEP] = ActionEntry(REDUCE, 364);
   _actionMap[386][RB] = ActionEntry(SHIFT, 523);
   _actionMap[386][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[387][RB] = ActionEntry(SHIFT, 524);
   _actionMap[387][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[388][RB] = ActionEntry(SHIFT, 525);
   _actionMap[388][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[389][LB] = ActionEntry(SHIFT, 526);
   _actionMap[390][RB] = ActionEntry(SHIFT, 527);
   _actionMap[390][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[391][RB] = ActionEntry(SHIFT, 528);
   _actionMap[391][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[392][RB] = ActionEntry(SHIFT, 529);
   _actionMap[392][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[393][RB] = ActionEntry(SHIFT, 530);
   _actionMap[393][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[394][RB] = ActionEntry(SHIFT, 531);
   _actionMap[394][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[395][RB] = ActionEntry(SHIFT, 532);
   _actionMap[395][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[396][RB] = ActionEntry(SHIFT, 533);
   _actionMap[396][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[396][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[396][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[397][RB] = ActionEntry(SHIFT, 534);
   _actionMap[397][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[397][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[397][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[398][RB] = ActionEntry(SHIFT, 535);
   _actionMap[398][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[399][RB] = ActionEntry(SHIFT, 536);
   _actionMap[400][RB] = ActionEntry(SHIFT, 537);
   _actionMap[400][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[401][RB] = ActionEntry(SHIFT, 538);
   _actionMap[401][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[402][RB] = ActionEntry(SHIFT, 539);
   _actionMap[402][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[403][RB] = ActionEntry(SHIFT, 540);
   _actionMap[403][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[404][RB] = ActionEntry(SHIFT, 541);
   _actionMap[404][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[405][RB] = ActionEntry(SHIFT, 542);
   _actionMap[405][KSEP] = ActionEntry(SHIFT, 514);
}
void Cego::loadParser145()
{
   _actionMap[406][RB] = ActionEntry(SHIFT, 543);
   _actionMap[406][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[407][KSEP] = ActionEntry(SHIFT, 544);
   _actionMap[408][RB] = ActionEntry(SHIFT, 545);
   _actionMap[408][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[409][RB] = ActionEntry(SHIFT, 546);
   _actionMap[409][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[409][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[409][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[410][RB] = ActionEntry(SHIFT, 547);
   _actionMap[410][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[411][RB] = ActionEntry(SHIFT, 548);
   _actionMap[411][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[412][RB] = ActionEntry(SHIFT, 549);
   _actionMap[412][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[413][RB] = ActionEntry(SHIFT, 550);
   _actionMap[413][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[414][RB] = ActionEntry(SHIFT, 551);
   _actionMap[414][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[415][RB] = ActionEntry(SHIFT, 552);
   _actionMap[415][KSEP] = ActionEntry(SHIFT, 514);
   _actionMap[416][WHEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][ELSE] = ActionEntry(REDUCE, 152);
   _actionMap[416][LEFT] = ActionEntry(REDUCE, 152);
   _actionMap[416][RIGHT] = ActionEntry(REDUCE, 152);
   _actionMap[416][INNER] = ActionEntry(REDUCE, 152);
   _actionMap[416][JOIN] = ActionEntry(REDUCE, 152);
   _actionMap[416][RETURNTOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][ORDER] = ActionEntry(REDUCE, 152);
   _actionMap[416][GROUP] = ActionEntry(REDUCE, 152);
   _actionMap[416][WHERE] = ActionEntry(REDUCE, 152);
   _actionMap[416][AS] = ActionEntry(REDUCE, 152);
   _actionMap[416][FROM] = ActionEntry(REDUCE, 152);
   _actionMap[416][END_TOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][BEGIN] = ActionEntry(REDUCE, 152);
   _actionMap[416][THEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][OR] = ActionEntry(REDUCE, 152);
   _actionMap[416][AND] = ActionEntry(REDUCE, 152);
   _actionMap[416][DESC] = ActionEntry(REDUCE, 152);
   _actionMap[416][ASC] = ActionEntry(REDUCE, 152);
   _actionMap[416][KSEP] = ActionEntry(REDUCE, 152);
   _actionMap[416][ROWLIMIT] = ActionEntry(REDUCE, 152);
   _actionMap[416][UNION] = ActionEntry(REDUCE, 152);
   _actionMap[416][ENDTOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][SEMICOLON] = ActionEntry(REDUCE, 152);
   _actionMap[416][LIKE] = ActionEntry(REDUCE, 152);
   _actionMap[416][BETWEEN] = ActionEntry(REDUCE, 152);
   _actionMap[416][NOT] = ActionEntry(REDUCE, 152);
   _actionMap[416][INTOK] = ActionEntry(REDUCE, 152);
   _actionMap[416][RB] = ActionEntry(REDUCE, 152);
}
void Cego::loadParser146()
{
   _actionMap[416][STAR] = ActionEntry(REDUCE, 152);
   _actionMap[416][DIVISION] = ActionEntry(REDUCE, 152);
   _actionMap[416][CONCAT] = ActionEntry(REDUCE, 152);
   _actionMap[416][MINUS] = ActionEntry(REDUCE, 152);
   _actionMap[416][PLUS] = ActionEntry(REDUCE, 152);
   _actionMap[416][IS] = ActionEntry(REDUCE, 152);
   _actionMap[416][EQU] = ActionEntry(REDUCE, 152);
   _actionMap[416][NEGATION] = ActionEntry(REDUCE, 152);
   _actionMap[416][LT] = ActionEntry(REDUCE, 152);
   _actionMap[416][MT] = ActionEntry(REDUCE, 152);
   _actionMap[417][WHEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][ELSE] = ActionEntry(REDUCE, 153);
   _actionMap[417][LEFT] = ActionEntry(REDUCE, 153);
   _actionMap[417][RIGHT] = ActionEntry(REDUCE, 153);
   _actionMap[417][INNER] = ActionEntry(REDUCE, 153);
   _actionMap[417][JOIN] = ActionEntry(REDUCE, 153);
   _actionMap[417][RETURNTOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][ORDER] = ActionEntry(REDUCE, 153);
   _actionMap[417][GROUP] = ActionEntry(REDUCE, 153);
   _actionMap[417][WHERE] = ActionEntry(REDUCE, 153);
   _actionMap[417][AS] = ActionEntry(REDUCE, 153);
   _actionMap[417][FROM] = ActionEntry(REDUCE, 153);
   _actionMap[417][END_TOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][BEGIN] = ActionEntry(REDUCE, 153);
   _actionMap[417][THEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][OR] = ActionEntry(REDUCE, 153);
   _actionMap[417][AND] = ActionEntry(REDUCE, 153);
   _actionMap[417][DESC] = ActionEntry(REDUCE, 153);
   _actionMap[417][ASC] = ActionEntry(REDUCE, 153);
   _actionMap[417][KSEP] = ActionEntry(REDUCE, 153);
   _actionMap[417][ROWLIMIT] = ActionEntry(REDUCE, 153);
   _actionMap[417][UNION] = ActionEntry(REDUCE, 153);
   _actionMap[417][ENDTOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][SEMICOLON] = ActionEntry(REDUCE, 153);
   _actionMap[417][LIKE] = ActionEntry(REDUCE, 153);
   _actionMap[417][BETWEEN] = ActionEntry(REDUCE, 153);
   _actionMap[417][NOT] = ActionEntry(REDUCE, 153);
   _actionMap[417][INTOK] = ActionEntry(REDUCE, 153);
   _actionMap[417][RB] = ActionEntry(REDUCE, 153);
   _actionMap[417][STAR] = ActionEntry(REDUCE, 153);
   _actionMap[417][DIVISION] = ActionEntry(REDUCE, 153);
   _actionMap[417][CONCAT] = ActionEntry(REDUCE, 153);
   _actionMap[417][MINUS] = ActionEntry(REDUCE, 153);
   _actionMap[417][PLUS] = ActionEntry(REDUCE, 153);
   _actionMap[417][IS] = ActionEntry(REDUCE, 153);
   _actionMap[417][EQU] = ActionEntry(REDUCE, 153);
   _actionMap[417][NEGATION] = ActionEntry(REDUCE, 153);
   _actionMap[417][LT] = ActionEntry(REDUCE, 153);
   _actionMap[417][MT] = ActionEntry(REDUCE, 153);
   _actionMap[418][INTVAL] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser147()
{
   _actionMap[418][MINUS] = ActionEntry(SHIFT, 554);
   _jumpMap[418][SignedInt] = 553;
   _actionMap[419][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[419][MINUS] = ActionEntry(SHIFT, 556);
   _jumpMap[419][SignedFloat] = 555;
   _actionMap[420][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[420][MINUS] = ActionEntry(SHIFT, 556);
   _jumpMap[420][SignedFloat] = 557;
   _actionMap[421][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[421][MINUS] = ActionEntry(SHIFT, 556);
   _jumpMap[421][SignedFloat] = 558;
   _actionMap[422][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[422][MINUS] = ActionEntry(SHIFT, 554);
   _jumpMap[422][SignedInt] = 559;
   _actionMap[423][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[423][MINUS] = ActionEntry(SHIFT, 554);
   _jumpMap[423][SignedInt] = 560;
   _actionMap[424][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[424][MINUS] = ActionEntry(SHIFT, 554);
   _jumpMap[424][SignedInt] = 561;
   _actionMap[425][INTVAL] = ActionEntry(SHIFT, 562);
   _actionMap[426][IDENTIFIER] = ActionEntry(SHIFT, 563);
   _actionMap[427][IDENTIFIER] = ActionEntry(SHIFT, 564);
   _actionMap[428][IDENTIFIER] = ActionEntry(SHIFT, 565);
   _actionMap[429][IDENTIFIER] = ActionEntry(SHIFT, 566);
   _actionMap[430][IDENTIFIER] = ActionEntry(SHIFT, 567);
   _actionMap[431][IDENTIFIER] = ActionEntry(SHIFT, 568);
   _actionMap[432][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[432][RB] = ActionEntry(REDUCE, 307);
   _actionMap[432][ENDTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[432][UNION] = ActionEntry(REDUCE, 307);
   _actionMap[432][ROWLIMIT] = ActionEntry(REDUCE, 307);
   _actionMap[432][ORDER] = ActionEntry(REDUCE, 307);
   _actionMap[432][GROUP] = ActionEntry(REDUCE, 307);
   _actionMap[432][WHERE] = ActionEntry(SHIFT, 352);
   _jumpMap[432][NoWhere] = 351;
   _jumpMap[432][WhereClause] = 569;
   _actionMap[433][WHERE] = ActionEntry(REDUCE, 209);
   _actionMap[433][GROUP] = ActionEntry(REDUCE, 209);
   _actionMap[433][ORDER] = ActionEntry(REDUCE, 209);
   _actionMap[433][ROWLIMIT] = ActionEntry(REDUCE, 209);
   _actionMap[433][UNION] = ActionEntry(REDUCE, 209);
   _actionMap[433][ENDTOKEN] = ActionEntry(REDUCE, 209);
   _actionMap[433][RB] = ActionEntry(REDUCE, 209);
   _actionMap[433][SEMICOLON] = ActionEntry(REDUCE, 209);
   _actionMap[433][RETURNTOKEN] = ActionEntry(REDUCE, 209);
   _actionMap[433][INNER] = ActionEntry(SHIFT, 572);
   _actionMap[433][JOIN] = ActionEntry(SHIFT, 573);
   _actionMap[433][LEFT] = ActionEntry(SHIFT, 574);
   _actionMap[433][RIGHT] = ActionEntry(SHIFT, 575);
}
void Cego::loadParser148()
{
   _jumpMap[433][InnerJoin] = 571;
   _jumpMap[433][JoinSpec] = 570;
   _actionMap[434][WHERE] = ActionEntry(REDUCE, 208);
   _actionMap[434][GROUP] = ActionEntry(REDUCE, 208);
   _actionMap[434][ORDER] = ActionEntry(REDUCE, 208);
   _actionMap[434][ROWLIMIT] = ActionEntry(REDUCE, 208);
   _actionMap[434][UNION] = ActionEntry(REDUCE, 208);
   _actionMap[434][ENDTOKEN] = ActionEntry(REDUCE, 208);
   _actionMap[434][RB] = ActionEntry(REDUCE, 208);
   _actionMap[434][SEMICOLON] = ActionEntry(REDUCE, 208);
   _actionMap[434][RETURNTOKEN] = ActionEntry(REDUCE, 208);
   _actionMap[435][KSEP] = ActionEntry(SHIFT, 577);
   _actionMap[435][RETURNTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[435][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[435][RB] = ActionEntry(REDUCE, 218);
   _actionMap[435][ENDTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[435][UNION] = ActionEntry(REDUCE, 218);
   _actionMap[435][ROWLIMIT] = ActionEntry(REDUCE, 218);
   _actionMap[435][ORDER] = ActionEntry(REDUCE, 218);
   _actionMap[435][GROUP] = ActionEntry(REDUCE, 218);
   _actionMap[435][WHERE] = ActionEntry(REDUCE, 218);
   _actionMap[435][INNER] = ActionEntry(SHIFT, 572);
   _actionMap[435][JOIN] = ActionEntry(SHIFT, 573);
   _actionMap[435][LEFT] = ActionEntry(SHIFT, 574);
   _actionMap[435][RIGHT] = ActionEntry(SHIFT, 575);
   _jumpMap[435][InnerJoin] = 571;
   _jumpMap[435][JoinSpec] = 576;
   _actionMap[436][WHERE] = ActionEntry(REDUCE, 219);
   _actionMap[436][IDENTIFIER] = ActionEntry(SHIFT, 578);
   _actionMap[436][GROUP] = ActionEntry(REDUCE, 219);
   _actionMap[436][ORDER] = ActionEntry(REDUCE, 219);
   _actionMap[436][ROWLIMIT] = ActionEntry(REDUCE, 219);
   _actionMap[436][UNION] = ActionEntry(REDUCE, 219);
   _actionMap[436][ENDTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[436][RB] = ActionEntry(REDUCE, 219);
   _actionMap[436][SEMICOLON] = ActionEntry(REDUCE, 219);
   _actionMap[436][RETURNTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[436][LEFT] = ActionEntry(REDUCE, 219);
   _actionMap[436][RIGHT] = ActionEntry(REDUCE, 219);
   _actionMap[436][INNER] = ActionEntry(REDUCE, 219);
   _actionMap[436][JOIN] = ActionEntry(REDUCE, 219);
   _actionMap[436][KSEP] = ActionEntry(REDUCE, 219);
   _actionMap[436][ON] = ActionEntry(REDUCE, 219);
   _actionMap[437][FROM] = ActionEntry(REDUCE, 207);
   _actionMap[437][KSEP] = ActionEntry(REDUCE, 207);
   _actionMap[438][FROM] = ActionEntry(REDUCE, 223);
   _actionMap[438][KSEP] = ActionEntry(REDUCE, 223);
   _actionMap[439][IDENTIFIER] = ActionEntry(SHIFT, 579);
   _actionMap[440][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[440][MINUS] = ActionEntry(SHIFT, 144);
}
void Cego::loadParser149()
{
   _actionMap[440][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[440][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[440][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[440][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[440][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[440][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[440][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[440][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[440][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[440][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[440][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[440][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[440][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[440][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[440][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[440][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[440][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[440][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[440][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[440][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[440][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[440][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[440][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[440][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[440][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[440][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[440][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[440][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[440][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[440][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[440][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[440][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[440][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[440][LB] = ActionEntry(SHIFT, 142);
   _actionMap[440][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[440][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[440][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[440][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[440][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[440][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[440][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[440][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[440][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[440][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[440][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[440][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[440][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[440][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[440][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[440][MAX] = ActionEntry(SHIFT, 120);
}
void Cego::loadParser150()
{
   _jumpMap[440][ObjSpec] = 99;
   _jumpMap[440][Constant] = 98;
   _jumpMap[440][SignedFloat] = 97;
   _jumpMap[440][SignedInt] = 96;
   _jumpMap[440][Attribute] = 95;
   _jumpMap[440][Function] = 94;
   _jumpMap[440][SelectItem] = 580;
   _jumpMap[440][CasePrepare] = 93;
   _jumpMap[440][CaseClause] = 92;
   _jumpMap[440][Factor] = 91;
   _jumpMap[440][Term] = 90;
   _jumpMap[440][Expr] = 291;
   _actionMap[441][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[441][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[441][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[441][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[441][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[441][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[441][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[441][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[441][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[441][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[441][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[441][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[441][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[441][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[441][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[441][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[441][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[441][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[441][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[441][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[441][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[441][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[441][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[441][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[441][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[441][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[441][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[441][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[441][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[441][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[441][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[441][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[441][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[441][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[441][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[441][LB] = ActionEntry(SHIFT, 142);
   _actionMap[441][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[441][DATE] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser151()
{
   _actionMap[441][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[441][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[441][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[441][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[441][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[441][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[441][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[441][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[441][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[441][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[441][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[441][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[441][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[441][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[441][ObjSpec] = 99;
   _jumpMap[441][Constant] = 98;
   _jumpMap[441][SignedFloat] = 97;
   _jumpMap[441][SignedInt] = 96;
   _jumpMap[441][Attribute] = 95;
   _jumpMap[441][Function] = 94;
   _jumpMap[441][CasePrepare] = 93;
   _jumpMap[441][CaseClause] = 92;
   _jumpMap[441][Factor] = 91;
   _jumpMap[441][Term] = 90;
   _jumpMap[441][Expr] = 581;
   _actionMap[442][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[442][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[442][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[442][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[443][KSEP] = ActionEntry(SHIFT, 583);
   _actionMap[443][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[443][RETURNTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[443][WHERE] = ActionEntry(SHIFT, 352);
   _jumpMap[443][NoWhere] = 351;
   _jumpMap[443][WhereClause] = 582;
   _actionMap[444][KSEP] = ActionEntry(REDUCE, 249);
   _actionMap[444][WHERE] = ActionEntry(REDUCE, 249);
   _actionMap[444][GROUP] = ActionEntry(REDUCE, 249);
   _actionMap[444][ORDER] = ActionEntry(REDUCE, 249);
   _actionMap[444][ROWLIMIT] = ActionEntry(REDUCE, 249);
   _actionMap[444][UNION] = ActionEntry(REDUCE, 249);
   _actionMap[444][ENDTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[444][RB] = ActionEntry(REDUCE, 249);
   _actionMap[444][SEMICOLON] = ActionEntry(REDUCE, 249);
   _actionMap[444][RETURNTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[445][EQU] = ActionEntry(SHIFT, 584);
   _actionMap[446][LB] = ActionEntry(SHIFT, 585);
   _actionMap[179][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[181][SEMICOLON] = ActionEntry(REDUCE, 73);
}
void Cego::loadParser152()
{
   _actionMap[182][TO] = ActionEntry(REDUCE, 75);
   _actionMap[182][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[183][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[183][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[183][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[183][ObjSpec] = 311;
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[185][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[186][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[187][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[188][ADD] = ActionEntry(SHIFT, 314);
   _actionMap[188][DROP] = ActionEntry(SHIFT, 315);
   _actionMap[188][MODIFY] = ActionEntry(SHIFT, 316);
   _actionMap[188][RENAME] = ActionEntry(SHIFT, 317);
   _jumpMap[188][AlterOption] = 313;
   _jumpMap[188][AlterList] = 312;
   _actionMap[189][BY] = ActionEntry(SHIFT, 318);
   _actionMap[190][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[190][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[190][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[190][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[190][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[190][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[190][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[190][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[190][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[190][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[190][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[190][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[190][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[190][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[190][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[190][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[190][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[190][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[190][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[190][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[190][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[190][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[190][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[190][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[190][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[190][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[190][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[190][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[190][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[190][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[190][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[190][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser153()
{
   _actionMap[190][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[190][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[190][LB] = ActionEntry(SHIFT, 142);
   _actionMap[190][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[190][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[190][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[190][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[190][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[190][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[190][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[190][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[190][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[190][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[190][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[190][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[190][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[190][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[190][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[190][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[190][RB] = ActionEntry(REDUCE, 117);
   _jumpMap[190][ObjSpec] = 99;
   _jumpMap[190][Constant] = 98;
   _jumpMap[190][SignedFloat] = 97;
   _jumpMap[190][SignedInt] = 96;
   _jumpMap[190][Attribute] = 95;
   _jumpMap[190][Function] = 94;
   _jumpMap[190][CasePrepare] = 93;
   _jumpMap[190][CaseClause] = 92;
   _jumpMap[190][Factor] = 91;
   _jumpMap[190][Term] = 90;
   _jumpMap[190][Expr] = 321;
   _jumpMap[190][ProcValueList] = 320;
   _jumpMap[190][ProcValueListOpt] = 319;
   _actionMap[191][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[192][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[192][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[192][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[192][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[192][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[192][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[192][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[192][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[192][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[192][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[192][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[192][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[192][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[192][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[192][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[192][SUBSTR] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser154()
{
   _actionMap[192][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[192][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[192][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[192][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[192][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[192][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[192][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[192][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[192][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[192][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[192][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[192][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[192][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[192][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[192][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[192][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[192][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[192][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[192][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[192][LB] = ActionEntry(SHIFT, 142);
   _actionMap[192][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[192][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[192][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[192][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[192][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[192][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[192][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[192][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[192][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[192][VARREF] = ActionEntry(SHIFT, 343);
   _actionMap[192][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[192][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[192][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[192][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[192][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[192][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[192][IF] = ActionEntry(SHIFT, 338);
   _actionMap[192][BEGIN] = ActionEntry(SHIFT, 335);
   _actionMap[192][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[192][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[192][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[192][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[192][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[192][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[192][VAR] = ActionEntry(SHIFT, 341);
   _actionMap[192][CURSOR] = ActionEntry(SHIFT, 337);
   _actionMap[192][CLOSE] = ActionEntry(SHIFT, 336);
   _actionMap[192][NOOP] = ActionEntry(SHIFT, 339);
   _actionMap[192][RETURNTOKEN] = ActionEntry(SHIFT, 340);
   _actionMap[192][WHILE] = ActionEntry(SHIFT, 342);
}
void Cego::loadParser155()
{
   _jumpMap[192][ObjSpec] = 99;
   _jumpMap[192][Constant] = 98;
   _jumpMap[192][SignedFloat] = 97;
   _jumpMap[192][SignedInt] = 96;
   _jumpMap[192][Attribute] = 95;
   _jumpMap[192][Function] = 94;
   _jumpMap[192][DeleteStatement] = 334;
   _jumpMap[192][UpdateStatement] = 333;
   _jumpMap[192][InsertStatement] = 332;
   _jumpMap[192][RollbackStatement] = 331;
   _jumpMap[192][CommitStatement] = 330;
   _jumpMap[192][StartStatement] = 329;
   _jumpMap[192][CasePrepare] = 93;
   _jumpMap[192][CaseClause] = 92;
   _jumpMap[192][Factor] = 91;
   _jumpMap[192][Term] = 90;
   _jumpMap[192][Expr] = 328;
   _jumpMap[192][ProcStatement] = 327;
   _jumpMap[192][ProcIfPart] = 326;
   _jumpMap[192][ProcBlockStart] = 325;
   _jumpMap[192][ProcStatementList] = 324;
   _jumpMap[192][ProcStmtBlock] = 323;
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 344);
   _actionMap[194][ON] = ActionEntry(REDUCE, 186);
   _actionMap[194][IDENTIFIER] = ActionEntry(REDUCE, 186);
   _actionMap[195][ON] = ActionEntry(REDUCE, 185);
   _actionMap[195][IDENTIFIER] = ActionEntry(REDUCE, 185);
   _actionMap[196][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[197][ON] = ActionEntry(SHIFT, 345);
   _actionMap[198][LB] = ActionEntry(SHIFT, 346);
   _actionMap[199][LB] = ActionEntry(SHIFT, 347);
   _actionMap[200][AS] = ActionEntry(SHIFT, 348);
   _actionMap[201][IDENTIFIER] = ActionEntry(SHIFT, 309);
   _actionMap[201][WHERE] = ActionEntry(REDUCE, 258);
   _actionMap[201][GROUP] = ActionEntry(REDUCE, 258);
   _actionMap[201][ORDER] = ActionEntry(REDUCE, 258);
   _actionMap[201][ROWLIMIT] = ActionEntry(REDUCE, 258);
   _actionMap[201][UNION] = ActionEntry(REDUCE, 258);
   _actionMap[201][ENDTOKEN] = ActionEntry(REDUCE, 258);
   _actionMap[201][RB] = ActionEntry(REDUCE, 258);
   _actionMap[201][SEMICOLON] = ActionEntry(REDUCE, 258);
   _actionMap[201][RETURNTOKEN] = ActionEntry(REDUCE, 258);
   _jumpMap[201][NoWhere] = 351;
   _jumpMap[201][WhereClause] = 350;
   _jumpMap[201][UpdDelAlias] = 349;
   _actionMap[202][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[203][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[204][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[204][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[204][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
}
void Cego::loadParser156()
{
   _jumpMap[204][ObjSpec] = 353;
   _actionMap[205][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[206][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[207][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[208][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[209][COUNTER] = ActionEntry(REDUCE, 66);
   _actionMap[209][BTREE] = ActionEntry(REDUCE, 66);
   _actionMap[209][CHECK] = ActionEntry(REDUCE, 66);
   _actionMap[209][FOREIGN] = ActionEntry(REDUCE, 66);
   _actionMap[209][PROCEDURE] = ActionEntry(REDUCE, 66);
   _actionMap[209][VIEW] = ActionEntry(REDUCE, 66);
   _actionMap[209][INDEX] = ActionEntry(REDUCE, 66);
   _actionMap[209][TABLE] = ActionEntry(REDUCE, 66);
   _actionMap[210][LB] = ActionEntry(SHIFT, 358);
   _actionMap[210][VALUES] = ActionEntry(REDUCE, 193);
   _actionMap[210][SELECT] = ActionEntry(REDUCE, 193);
   _jumpMap[210][SelectStatement] = 356;
   _jumpMap[210][InsertPrepare] = 355;
   _jumpMap[210][InsertArgSpec] = 354;
   _actionMap[211][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[211][IDENTIFIER] = ActionEntry(REDUCE, 77);
   _actionMap[212][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[213][IDENTIFIER] = ActionEntry(SHIFT, 359);
   _actionMap[214][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[215][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[216][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[217][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[218][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[219][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[223][AS] = ActionEntry(SHIFT, 360);
   _actionMap[224][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[224][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[224][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[224][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[224][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[224][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[224][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[224][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[224][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[224][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[224][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[224][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[224][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[224][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[224][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[224][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[224][LEFT] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser157()
{
   _actionMap[224][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[224][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[224][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[224][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[224][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[224][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[224][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[224][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[224][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[224][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[224][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[224][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[224][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[224][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[224][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[224][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[224][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[224][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[224][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[224][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[224][LB] = ActionEntry(SHIFT, 142);
   _actionMap[224][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[224][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[224][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[224][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[224][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[224][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[224][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[224][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[224][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[224][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[224][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[224][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[224][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[224][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[224][ObjSpec] = 99;
   _jumpMap[224][Constant] = 98;
   _jumpMap[224][SignedFloat] = 97;
   _jumpMap[224][SignedInt] = 96;
   _jumpMap[224][Attribute] = 95;
   _jumpMap[224][Function] = 94;
   _jumpMap[224][CasePrepare] = 93;
   _jumpMap[224][CaseClause] = 92;
   _jumpMap[224][Factor] = 91;
   _jumpMap[224][Term] = 361;
   _actionMap[225][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[225][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[225][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[225][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[225][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
}
void Cego::loadParser158()
{
   _actionMap[225][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[225][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[225][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[225][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[225][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[225][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[225][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[225][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[225][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[225][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[225][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[225][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[225][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[225][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[225][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[225][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[225][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[225][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[225][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[225][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[225][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[225][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[225][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[225][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[225][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[225][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[225][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[225][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[225][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[225][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[225][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[225][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[225][LB] = ActionEntry(SHIFT, 142);
   _actionMap[225][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[225][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[225][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[225][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[225][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[225][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[225][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[225][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[225][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[225][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[225][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[225][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[225][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[225][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[225][ObjSpec] = 99;
   _jumpMap[225][Constant] = 98;
   _jumpMap[225][SignedFloat] = 97;
}
void Cego::loadParser159()
{
   _jumpMap[225][SignedInt] = 96;
   _jumpMap[225][Attribute] = 95;
   _jumpMap[225][Function] = 94;
   _jumpMap[225][CasePrepare] = 93;
   _jumpMap[225][CaseClause] = 92;
   _jumpMap[225][Factor] = 91;
   _jumpMap[225][Term] = 362;
   _actionMap[226][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[226][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[226][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[226][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[226][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[226][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[226][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[226][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[226][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[226][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[226][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[226][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[226][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[226][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[226][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[226][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[226][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[226][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[226][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[226][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[226][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[226][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[226][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[226][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[226][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[226][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[226][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[226][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[226][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[226][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[226][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[226][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[226][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[226][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[226][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[226][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[226][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[226][LB] = ActionEntry(SHIFT, 142);
   _actionMap[226][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[226][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[226][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[226][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[226][TRUEVAL] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser160()
{
   _actionMap[226][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[226][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[226][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[226][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[226][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[226][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[226][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[226][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[226][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[226][ObjSpec] = 99;
   _jumpMap[226][Constant] = 98;
   _jumpMap[226][SignedFloat] = 97;
   _jumpMap[226][SignedInt] = 96;
   _jumpMap[226][Attribute] = 95;
   _jumpMap[226][Function] = 94;
   _jumpMap[226][CasePrepare] = 93;
   _jumpMap[226][CaseClause] = 92;
   _jumpMap[226][Factor] = 91;
   _jumpMap[226][Term] = 363;
   _actionMap[227][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[227][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[227][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[227][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[227][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[227][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[227][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[227][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[227][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[227][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[227][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[227][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[227][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[227][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[227][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[227][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[227][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[227][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[227][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[227][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[227][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[227][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[227][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[227][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[227][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[227][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[227][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[227][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[227][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[227][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[227][POWER] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser161()
{
   _actionMap[227][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[227][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[227][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[227][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[227][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[227][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[227][LB] = ActionEntry(SHIFT, 142);
   _actionMap[227][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[227][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[227][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[227][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[227][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[227][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[227][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[227][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[227][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[227][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[227][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[227][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[227][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[227][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[227][ObjSpec] = 99;
   _jumpMap[227][Constant] = 98;
   _jumpMap[227][SignedFloat] = 97;
   _jumpMap[227][SignedInt] = 96;
   _jumpMap[227][Attribute] = 95;
   _jumpMap[227][Function] = 94;
   _jumpMap[227][CasePrepare] = 93;
   _jumpMap[227][CaseClause] = 92;
   _jumpMap[227][Factor] = 364;
   _actionMap[228][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[228][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[228][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[228][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[228][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[228][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[228][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[228][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[228][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[228][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[228][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[228][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[228][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[228][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[228][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[228][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[228][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[228][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[228][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[228][SUBSTR] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser162()
{
   _actionMap[228][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[228][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[228][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[228][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[228][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[228][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[228][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[228][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[228][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[228][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[228][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[228][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[228][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[228][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[228][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[228][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[228][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[228][LB] = ActionEntry(SHIFT, 142);
   _actionMap[228][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[228][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[228][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[228][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[228][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[228][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[228][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[228][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[228][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[228][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[228][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[228][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[228][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[228][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[228][ObjSpec] = 99;
   _jumpMap[228][Constant] = 98;
   _jumpMap[228][SignedFloat] = 97;
   _jumpMap[228][SignedInt] = 96;
   _jumpMap[228][Attribute] = 95;
   _jumpMap[228][Function] = 94;
   _jumpMap[228][CasePrepare] = 93;
   _jumpMap[228][CaseClause] = 92;
   _jumpMap[228][Factor] = 365;
   _actionMap[229][ELSE] = ActionEntry(SHIFT, 367);
   _actionMap[229][WHEN] = ActionEntry(SHIFT, 231);
   _jumpMap[229][CaseCondition] = 366;
   _actionMap[230][WHEN] = ActionEntry(REDUCE, 163);
   _actionMap[230][ELSE] = ActionEntry(REDUCE, 163);
   _actionMap[231][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[231][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[231][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[231][TRIM] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser163()
{
   _actionMap[231][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[231][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[231][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[231][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[231][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[231][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[231][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[231][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[231][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[231][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[231][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[231][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[231][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[231][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[231][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[231][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[231][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[231][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[231][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[231][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[231][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[231][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[231][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[231][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[231][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[231][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[231][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[231][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[231][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[231][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[231][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[231][LB] = ActionEntry(SHIFT, 373);
   _actionMap[231][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[231][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[231][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[231][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[231][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[231][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[231][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[231][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[231][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[231][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[231][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[231][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[231][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[231][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[231][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[231][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[231][EXISTS] = ActionEntry(SHIFT, 371);
   _actionMap[231][NOT] = ActionEntry(SHIFT, 372);
}
void Cego::loadParser164()
{
   _jumpMap[231][ObjSpec] = 99;
   _jumpMap[231][Constant] = 98;
   _jumpMap[231][SignedFloat] = 97;
   _jumpMap[231][SignedInt] = 96;
   _jumpMap[231][Attribute] = 95;
   _jumpMap[231][QueryPredicate] = 370;
   _jumpMap[231][QueryCondition] = 369;
   _jumpMap[231][Function] = 94;
   _jumpMap[231][CasePrepare] = 93;
   _jumpMap[231][CaseClause] = 92;
   _jumpMap[231][Factor] = 91;
   _jumpMap[231][Term] = 90;
   _jumpMap[231][Expr] = 368;
   _actionMap[232][RB] = ActionEntry(SHIFT, 376);
   _actionMap[232][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[232][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[232][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[232][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[232][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[232][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[232][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[232][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[232][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[232][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[232][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[232][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[232][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[232][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[232][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[232][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[232][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[232][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[232][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[232][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[232][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[232][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[232][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[232][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[232][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[232][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[232][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[232][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[232][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[232][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[232][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[232][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[232][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[232][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[232][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[232][LB] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser165()
{
   _actionMap[232][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[232][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[232][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[232][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[232][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[232][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[232][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[232][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[232][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[232][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[232][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[232][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[232][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[232][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[232][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[232][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[232][ObjSpec] = 99;
   _jumpMap[232][Constant] = 98;
   _jumpMap[232][SignedFloat] = 97;
   _jumpMap[232][SignedInt] = 96;
   _jumpMap[232][Attribute] = 95;
   _jumpMap[232][ExpressionList] = 375;
   _jumpMap[232][Function] = 94;
   _jumpMap[232][CasePrepare] = 93;
   _jumpMap[232][CaseClause] = 92;
   _jumpMap[232][Factor] = 91;
   _jumpMap[232][Term] = 90;
   _jumpMap[232][Expr] = 374;
   _actionMap[233][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[233][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[233][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[233][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[233][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[233][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[233][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[233][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[233][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[233][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[233][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[233][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[233][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[233][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[233][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[233][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[233][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[233][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[233][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[233][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[233][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[233][STR2DATE] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser166()
{
   _actionMap[233][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[233][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[233][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[233][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[233][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[233][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[233][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[233][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[233][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[233][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[233][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[233][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[233][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[233][LB] = ActionEntry(SHIFT, 142);
   _actionMap[233][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[233][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[233][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[233][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[233][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[233][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[233][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[233][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[233][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[233][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[233][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[233][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[233][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[233][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[233][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[233][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[233][ObjSpec] = 99;
   _jumpMap[233][Constant] = 98;
   _jumpMap[233][SignedFloat] = 97;
   _jumpMap[233][SignedInt] = 96;
   _jumpMap[233][Attribute] = 95;
   _jumpMap[233][Function] = 94;
   _jumpMap[233][CasePrepare] = 93;
   _jumpMap[233][CaseClause] = 92;
   _jumpMap[233][Factor] = 91;
   _jumpMap[233][Term] = 90;
   _jumpMap[233][Expr] = 377;
   _actionMap[234][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[234][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[234][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[234][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[234][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[234][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[234][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[234][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[234][DATE2INT] = ActionEntry(SHIFT, 109);
}
void Cego::loadParser167()
{
   _actionMap[234][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[234][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[234][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[234][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[234][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[234][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[234][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[234][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[234][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[234][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[234][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[234][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[234][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[234][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[234][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[234][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[234][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[234][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[234][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[234][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[234][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[234][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[234][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[234][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[234][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[234][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[234][LB] = ActionEntry(SHIFT, 142);
   _actionMap[234][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[234][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[234][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[234][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[234][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[234][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[234][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[234][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[234][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[234][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[234][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[234][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[234][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[234][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[234][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[234][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[234][ObjSpec] = 99;
   _jumpMap[234][Constant] = 98;
   _jumpMap[234][SignedFloat] = 97;
   _jumpMap[234][SignedInt] = 96;
   _jumpMap[234][Attribute] = 95;
   _jumpMap[234][ExpressionList] = 378;
   _jumpMap[234][Function] = 94;
}
void Cego::loadParser168()
{
   _jumpMap[234][CasePrepare] = 93;
   _jumpMap[234][CaseClause] = 92;
   _jumpMap[234][Factor] = 91;
   _jumpMap[234][Term] = 90;
   _jumpMap[234][Expr] = 374;
   _actionMap[235][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[235][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[235][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[235][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[235][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[235][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[235][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[235][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[235][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[235][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[235][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[235][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[235][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[235][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[235][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[235][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[235][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[235][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[235][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[235][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[235][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[235][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[235][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[235][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[235][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[235][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[235][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[235][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[235][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[235][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[235][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[235][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[235][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[235][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[235][LB] = ActionEntry(SHIFT, 142);
   _actionMap[235][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[235][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[235][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[235][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[235][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[235][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[235][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[235][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[235][CASE] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser169()
{
   _actionMap[235][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[235][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[235][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[235][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[235][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[235][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[235][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[235][ObjSpec] = 99;
   _jumpMap[235][Constant] = 98;
   _jumpMap[235][SignedFloat] = 97;
   _jumpMap[235][SignedInt] = 96;
   _jumpMap[235][Attribute] = 95;
   _jumpMap[235][ExpressionList] = 379;
   _jumpMap[235][Function] = 94;
   _jumpMap[235][CasePrepare] = 93;
   _jumpMap[235][CaseClause] = 92;
   _jumpMap[235][Factor] = 91;
   _jumpMap[235][Term] = 90;
   _jumpMap[235][Expr] = 374;
   _actionMap[236][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[236][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[236][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[236][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[236][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[236][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[236][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[236][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[236][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[236][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[236][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[236][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[236][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[236][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[236][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[236][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[236][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[236][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[236][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[236][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[236][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[236][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[236][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[236][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[236][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[236][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[236][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[236][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[236][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[236][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[236][NEXTCOUNT] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser170()
{
   _actionMap[236][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[236][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[236][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[236][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[236][LB] = ActionEntry(SHIFT, 142);
   _actionMap[236][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[236][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[236][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[236][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[236][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[236][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[236][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[236][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[236][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[236][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[236][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[236][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[236][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[236][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[236][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[236][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[236][ObjSpec] = 99;
   _jumpMap[236][Constant] = 98;
   _jumpMap[236][SignedFloat] = 97;
   _jumpMap[236][SignedInt] = 96;
   _jumpMap[236][Attribute] = 95;
   _jumpMap[236][ExpressionList] = 380;
   _jumpMap[236][Function] = 94;
   _jumpMap[236][CasePrepare] = 93;
   _jumpMap[236][CaseClause] = 92;
   _jumpMap[236][Factor] = 91;
   _jumpMap[236][Term] = 90;
   _jumpMap[236][Expr] = 374;
   _actionMap[237][STAR] = ActionEntry(SHIFT, 383);
   _actionMap[237][DISTINCT] = ActionEntry(SHIFT, 161);
   _actionMap[237][VARREF] = ActionEntry(REDUCE, 243);
   _actionMap[237][FETCH] = ActionEntry(REDUCE, 243);
   _actionMap[237][LB] = ActionEntry(REDUCE, 243);
   _actionMap[237][COUNT] = ActionEntry(REDUCE, 243);
   _actionMap[237][SUM] = ActionEntry(REDUCE, 243);
   _actionMap[237][AVG] = ActionEntry(REDUCE, 243);
   _actionMap[237][MIN] = ActionEntry(REDUCE, 243);
   _actionMap[237][MAX] = ActionEntry(REDUCE, 243);
   _actionMap[237][CASE] = ActionEntry(REDUCE, 243);
   _actionMap[237][TRIM] = ActionEntry(REDUCE, 243);
   _actionMap[237][RTRIM] = ActionEntry(REDUCE, 243);
   _actionMap[237][LTRIM] = ActionEntry(REDUCE, 243);
   _actionMap[237][ROUND] = ActionEntry(REDUCE, 243);
   _actionMap[237][DATE2STR] = ActionEntry(REDUCE, 243);
   _actionMap[237][DATE2INT] = ActionEntry(REDUCE, 243);
}
void Cego::loadParser171()
{
   _actionMap[237][INT2DATE] = ActionEntry(REDUCE, 243);
   _actionMap[237][LOWER] = ActionEntry(REDUCE, 243);
   _actionMap[237][UPPER] = ActionEntry(REDUCE, 243);
   _actionMap[237][LEFT] = ActionEntry(REDUCE, 243);
   _actionMap[237][RIGHT] = ActionEntry(REDUCE, 243);
   _actionMap[237][GETPOS] = ActionEntry(REDUCE, 243);
   _actionMap[237][SUBSTR] = ActionEntry(REDUCE, 243);
   _actionMap[237][REPLACE] = ActionEntry(REDUCE, 243);
   _actionMap[237][LENGTH] = ActionEntry(REDUCE, 243);
   _actionMap[237][TRUNC] = ActionEntry(REDUCE, 243);
   _actionMap[237][STR2INT] = ActionEntry(REDUCE, 243);
   _actionMap[237][STR2LONG] = ActionEntry(REDUCE, 243);
   _actionMap[237][STR2DATE] = ActionEntry(REDUCE, 243);
   _actionMap[237][RANDSTR] = ActionEntry(REDUCE, 243);
   _actionMap[237][RANDINT] = ActionEntry(REDUCE, 243);
   _actionMap[237][MOD] = ActionEntry(REDUCE, 243);
   _actionMap[237][DIV] = ActionEntry(REDUCE, 243);
   _actionMap[237][POWER] = ActionEntry(REDUCE, 243);
   _actionMap[237][BITAND] = ActionEntry(REDUCE, 243);
   _actionMap[237][BITOR] = ActionEntry(REDUCE, 243);
   _actionMap[237][BITXOR] = ActionEntry(REDUCE, 243);
   _actionMap[237][NEXTCOUNT] = ActionEntry(REDUCE, 243);
   _actionMap[237][SETCOUNT] = ActionEntry(REDUCE, 243);
   _actionMap[237][IDENTIFIER] = ActionEntry(REDUCE, 243);
   _actionMap[237][QUALIFIEDOBJ] = ActionEntry(REDUCE, 243);
   _actionMap[237][QUALIFIEDTS] = ActionEntry(REDUCE, 243);
   _actionMap[237][QUALIFIEDPRE] = ActionEntry(REDUCE, 243);
   _actionMap[237][STRINGVAL] = ActionEntry(REDUCE, 243);
   _actionMap[237][DATE] = ActionEntry(REDUCE, 243);
   _actionMap[237][SYSDATE] = ActionEntry(REDUCE, 243);
   _actionMap[237][NULLTOKEN] = ActionEntry(REDUCE, 243);
   _actionMap[237][TRUEVAL] = ActionEntry(REDUCE, 243);
   _actionMap[237][FALSEVAL] = ActionEntry(REDUCE, 243);
   _actionMap[237][LAB] = ActionEntry(REDUCE, 243);
   _actionMap[237][FLOATVAL] = ActionEntry(REDUCE, 243);
   _actionMap[237][MINUS] = ActionEntry(REDUCE, 243);
   _actionMap[237][INTVAL] = ActionEntry(REDUCE, 243);
   _jumpMap[237][ObjSpec] = 99;
   _jumpMap[237][Constant] = 98;
   _jumpMap[237][SignedFloat] = 97;
   _jumpMap[237][SignedInt] = 96;
   _jumpMap[237][Attribute] = 95;
   _jumpMap[237][Function] = 94;
   _jumpMap[237][DistinctOpt] = 382;
   _jumpMap[237][CasePrepare] = 93;
   _jumpMap[237][CaseClause] = 92;
   _jumpMap[237][Factor] = 91;
   _jumpMap[237][Term] = 90;
   _jumpMap[237][Expr] = 381;
   _actionMap[238][STRINGVAL] = ActionEntry(SHIFT, 385);
}
void Cego::loadParser172()
{
   _jumpMap[238][DateFormat] = 384;
   _actionMap[239][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[239][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[239][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[239][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[239][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[239][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[239][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[239][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[239][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[239][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[239][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[239][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[239][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[239][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[239][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[239][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[239][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[239][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[239][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[239][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[239][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[239][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[239][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[239][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[239][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[239][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[239][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[239][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[239][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[239][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[239][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[239][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[239][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[239][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[239][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[239][LB] = ActionEntry(SHIFT, 142);
   _actionMap[239][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[239][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[239][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[239][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[239][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[239][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[239][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[239][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[239][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[239][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[239][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[239][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[239][SUM] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser173()
{
   _actionMap[239][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[239][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[239][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[239][ObjSpec] = 99;
   _jumpMap[239][Constant] = 98;
   _jumpMap[239][SignedFloat] = 97;
   _jumpMap[239][SignedInt] = 96;
   _jumpMap[239][Attribute] = 95;
   _jumpMap[239][ExpressionList] = 386;
   _jumpMap[239][Function] = 94;
   _jumpMap[239][CasePrepare] = 93;
   _jumpMap[239][CaseClause] = 92;
   _jumpMap[239][Factor] = 91;
   _jumpMap[239][Term] = 90;
   _jumpMap[239][Expr] = 374;
   _actionMap[240][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[240][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[240][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[240][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[240][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[240][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[240][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[240][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[240][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[240][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[240][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[240][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[240][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[240][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[240][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[240][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[240][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[240][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[240][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[240][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[240][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[240][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[240][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[240][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[240][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[240][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[240][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[240][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[240][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[240][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[240][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[240][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[240][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[240][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[240][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser174()
{
   _actionMap[240][LB] = ActionEntry(SHIFT, 142);
   _actionMap[240][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[240][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[240][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[240][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[240][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[240][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[240][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[240][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[240][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[240][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[240][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[240][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[240][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[240][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[240][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[240][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[240][ObjSpec] = 99;
   _jumpMap[240][Constant] = 98;
   _jumpMap[240][SignedFloat] = 97;
   _jumpMap[240][SignedInt] = 96;
   _jumpMap[240][Attribute] = 95;
   _jumpMap[240][ExpressionList] = 387;
   _jumpMap[240][Function] = 94;
   _jumpMap[240][CasePrepare] = 93;
   _jumpMap[240][CaseClause] = 92;
   _jumpMap[240][Factor] = 91;
   _jumpMap[240][Term] = 90;
   _jumpMap[240][Expr] = 374;
   _actionMap[241][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[241][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[241][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[241][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[241][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[241][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[241][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[241][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[241][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[241][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[241][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[241][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[241][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[241][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[241][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[241][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[241][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[241][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[241][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[241][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[241][STR2LONG] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser175()
{
   _actionMap[241][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[241][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[241][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[241][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[241][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[241][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[241][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[241][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[241][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[241][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[241][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[241][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[241][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[241][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[241][LB] = ActionEntry(SHIFT, 142);
   _actionMap[241][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[241][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[241][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[241][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[241][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[241][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[241][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[241][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[241][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[241][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[241][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[241][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[241][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[241][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[241][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[241][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[241][ObjSpec] = 99;
   _jumpMap[241][Constant] = 98;
   _jumpMap[241][SignedFloat] = 97;
   _jumpMap[241][SignedInt] = 96;
   _jumpMap[241][Attribute] = 95;
   _jumpMap[241][ExpressionList] = 388;
   _jumpMap[241][Function] = 94;
   _jumpMap[241][CasePrepare] = 93;
   _jumpMap[241][CaseClause] = 92;
   _jumpMap[241][Factor] = 91;
   _jumpMap[241][Term] = 90;
   _jumpMap[241][Expr] = 374;
   _actionMap[242][INTO] = ActionEntry(SHIFT, 389);
   _actionMap[243][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[243][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[243][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[243][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[243][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[243][LTRIM] = ActionEntry(SHIFT, 118);
}
void Cego::loadParser176()
{
   _actionMap[243][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[243][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[243][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[243][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[243][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[243][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[243][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[243][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[243][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[243][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[243][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[243][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[243][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[243][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[243][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[243][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[243][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[243][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[243][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[243][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[243][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[243][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[243][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[243][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[243][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[243][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[243][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[243][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[243][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[243][LB] = ActionEntry(SHIFT, 142);
   _actionMap[243][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[243][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[243][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[243][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[243][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[243][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[243][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[243][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[243][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[243][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[243][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[243][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[243][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[243][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[243][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[243][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[243][ObjSpec] = 99;
   _jumpMap[243][Constant] = 98;
   _jumpMap[243][SignedFloat] = 97;
   _jumpMap[243][SignedInt] = 96;
}
void Cego::loadParser177()
{
   _jumpMap[243][Attribute] = 95;
   _jumpMap[243][ExpressionList] = 390;
   _jumpMap[243][Function] = 94;
   _jumpMap[243][CasePrepare] = 93;
   _jumpMap[243][CaseClause] = 92;
   _jumpMap[243][Factor] = 91;
   _jumpMap[243][Term] = 90;
   _jumpMap[243][Expr] = 374;
   _actionMap[244][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[244][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[244][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[244][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[244][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[244][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[244][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[244][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[244][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[244][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[244][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[244][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[244][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[244][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[244][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[244][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[244][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[244][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[244][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[244][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[244][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[244][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[244][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[244][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[244][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[244][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[244][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[244][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[244][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[244][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[244][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[244][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[244][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[244][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[244][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[244][LB] = ActionEntry(SHIFT, 142);
   _actionMap[244][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[244][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[244][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[244][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[244][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[244][FALSEVAL] = ActionEntry(SHIFT, 111);
}
void Cego::loadParser178()
{
   _actionMap[244][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[244][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[244][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[244][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[244][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[244][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[244][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[244][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[244][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[244][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[244][ObjSpec] = 99;
   _jumpMap[244][Constant] = 98;
   _jumpMap[244][SignedFloat] = 97;
   _jumpMap[244][SignedInt] = 96;
   _jumpMap[244][Attribute] = 95;
   _jumpMap[244][ExpressionList] = 391;
   _jumpMap[244][Function] = 94;
   _jumpMap[244][CasePrepare] = 93;
   _jumpMap[244][CaseClause] = 92;
   _jumpMap[244][Factor] = 91;
   _jumpMap[244][Term] = 90;
   _jumpMap[244][Expr] = 374;
   _actionMap[245][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[245][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[245][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[245][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[245][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[245][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[245][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[245][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[245][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[245][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[245][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[245][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[245][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[245][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[245][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[245][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[245][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[245][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[245][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[245][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[245][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[245][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[245][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[245][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[245][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[245][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[245][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[245][BITAND] = ActionEntry(SHIFT, 102);
}
void Cego::loadParser179()
{
   _actionMap[245][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[245][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[245][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[245][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[245][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[245][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[245][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[245][LB] = ActionEntry(SHIFT, 142);
   _actionMap[245][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[245][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[245][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[245][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[245][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[245][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[245][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[245][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[245][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[245][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[245][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[245][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[245][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[245][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[245][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[245][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[245][ObjSpec] = 99;
   _jumpMap[245][Constant] = 98;
   _jumpMap[245][SignedFloat] = 97;
   _jumpMap[245][SignedInt] = 96;
   _jumpMap[245][Attribute] = 95;
   _jumpMap[245][ExpressionList] = 392;
   _jumpMap[245][Function] = 94;
   _jumpMap[245][CasePrepare] = 93;
   _jumpMap[245][CaseClause] = 92;
   _jumpMap[245][Factor] = 91;
   _jumpMap[245][Term] = 90;
   _jumpMap[245][Expr] = 374;
   _actionMap[246][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[246][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[246][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[246][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[246][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[246][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[246][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[246][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[246][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[246][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[246][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[246][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[246][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[246][RIGHT] = ActionEntry(SHIFT, 128);
}
void Cego::loadParser180()
{
   _actionMap[246][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[246][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[246][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[246][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[246][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[246][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[246][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[246][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[246][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[246][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[246][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[246][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[246][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[246][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[246][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[246][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[246][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[246][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[246][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[246][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[246][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[246][LB] = ActionEntry(SHIFT, 142);
   _actionMap[246][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[246][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[246][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[246][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[246][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[246][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[246][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[246][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[246][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[246][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[246][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[246][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[246][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[246][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[246][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[246][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[246][ObjSpec] = 99;
   _jumpMap[246][Constant] = 98;
   _jumpMap[246][SignedFloat] = 97;
   _jumpMap[246][SignedInt] = 96;
   _jumpMap[246][Attribute] = 95;
   _jumpMap[246][ExpressionList] = 393;
   _jumpMap[246][Function] = 94;
   _jumpMap[246][CasePrepare] = 93;
   _jumpMap[246][CaseClause] = 92;
   _jumpMap[246][Factor] = 91;
   _jumpMap[246][Term] = 90;
   _jumpMap[246][Expr] = 374;
}
void Cego::loadParser181()
{
   _actionMap[247][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[247][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[247][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[247][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[247][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[247][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[247][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[247][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[247][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[247][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[247][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[247][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[247][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[247][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[247][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[247][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[247][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[247][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[247][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[247][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[247][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[247][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[247][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[247][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[247][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[247][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[247][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[247][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[247][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[247][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[247][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[247][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[247][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[247][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[247][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[247][LB] = ActionEntry(SHIFT, 142);
   _actionMap[247][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[247][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[247][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[247][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[247][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[247][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[247][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[247][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[247][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[247][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[247][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[247][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[247][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[247][AVG] = ActionEntry(SHIFT, 101);
}
void Cego::loadParser182()
{
   _actionMap[247][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[247][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[247][ObjSpec] = 99;
   _jumpMap[247][Constant] = 98;
   _jumpMap[247][SignedFloat] = 97;
   _jumpMap[247][SignedInt] = 96;
   _jumpMap[247][Attribute] = 95;
   _jumpMap[247][ExpressionList] = 394;
   _jumpMap[247][Function] = 94;
   _jumpMap[247][CasePrepare] = 93;
   _jumpMap[247][CaseClause] = 92;
   _jumpMap[247][Factor] = 91;
   _jumpMap[247][Term] = 90;
   _jumpMap[247][Expr] = 374;
   _actionMap[248][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[248][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[248][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[248][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[248][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[248][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[248][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[248][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[248][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[248][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[248][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[248][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[248][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[248][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[248][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[248][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[248][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[248][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[248][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[248][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[248][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[248][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[248][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[248][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[248][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[248][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[248][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[248][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[248][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[248][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[248][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[248][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[248][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[248][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[248][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[248][LB] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser183()
{
   _actionMap[248][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[248][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[248][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[248][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[248][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[248][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[248][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[248][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[248][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[248][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[248][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[248][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[248][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[248][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[248][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[248][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[248][ObjSpec] = 99;
   _jumpMap[248][Constant] = 98;
   _jumpMap[248][SignedFloat] = 97;
   _jumpMap[248][SignedInt] = 96;
   _jumpMap[248][Attribute] = 95;
   _jumpMap[248][ExpressionList] = 395;
   _jumpMap[248][Function] = 94;
   _jumpMap[248][CasePrepare] = 93;
   _jumpMap[248][CaseClause] = 92;
   _jumpMap[248][Factor] = 91;
   _jumpMap[248][Term] = 90;
   _jumpMap[248][Expr] = 374;
   _actionMap[249][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[249][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[249][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[249][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[249][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[249][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[249][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[249][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[249][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[249][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[249][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[249][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[249][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[249][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[249][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[249][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[249][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[249][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[249][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[249][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[249][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[249][STR2DATE] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser184()
{
   _actionMap[249][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[249][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[249][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[249][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[249][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[249][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[249][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[249][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[249][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[249][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[249][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[249][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[249][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[249][LB] = ActionEntry(SHIFT, 142);
   _actionMap[249][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[249][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[249][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[249][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[249][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[249][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[249][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[249][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[249][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[249][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[249][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[249][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[249][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[249][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[249][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[249][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[249][ObjSpec] = 99;
   _jumpMap[249][Constant] = 98;
   _jumpMap[249][SignedFloat] = 97;
   _jumpMap[249][SignedInt] = 96;
   _jumpMap[249][Attribute] = 95;
   _jumpMap[249][Function] = 94;
   _jumpMap[249][CasePrepare] = 93;
   _jumpMap[249][CaseClause] = 92;
   _jumpMap[249][Factor] = 91;
   _jumpMap[249][Term] = 90;
   _jumpMap[249][Expr] = 396;
   _actionMap[250][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[250][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[250][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[250][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[250][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[250][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[250][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[250][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[250][DATE2INT] = ActionEntry(SHIFT, 109);
}
void Cego::loadParser185()
{
   _actionMap[250][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[250][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[250][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[250][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[250][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[250][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[250][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[250][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[250][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[250][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[250][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[250][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[250][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[250][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[250][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[250][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[250][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[250][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[250][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[250][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[250][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[250][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[250][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[250][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[250][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[250][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[250][LB] = ActionEntry(SHIFT, 142);
   _actionMap[250][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[250][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[250][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[250][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[250][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[250][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[250][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[250][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[250][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[250][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[250][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[250][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[250][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[250][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[250][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[250][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[250][ObjSpec] = 99;
   _jumpMap[250][Constant] = 98;
   _jumpMap[250][SignedFloat] = 97;
   _jumpMap[250][SignedInt] = 96;
   _jumpMap[250][Attribute] = 95;
   _jumpMap[250][Function] = 94;
   _jumpMap[250][CasePrepare] = 93;
}
void Cego::loadParser186()
{
   _jumpMap[250][CaseClause] = 92;
   _jumpMap[250][Factor] = 91;
   _jumpMap[250][Term] = 90;
   _jumpMap[250][Expr] = 397;
   _actionMap[251][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[251][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[251][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[251][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[251][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[251][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[251][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[251][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[251][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[251][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[251][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[251][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[251][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[251][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[251][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[251][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[251][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[251][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[251][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[251][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[251][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[251][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[251][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[251][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[251][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[251][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[251][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[251][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[251][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[251][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[251][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[251][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[251][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[251][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[251][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[251][LB] = ActionEntry(SHIFT, 142);
   _actionMap[251][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[251][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[251][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[251][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[251][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[251][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[251][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[251][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[251][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[251][VARREF] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser187()
{
   _actionMap[251][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[251][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[251][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[251][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[251][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[251][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[251][ObjSpec] = 99;
   _jumpMap[251][Constant] = 98;
   _jumpMap[251][SignedFloat] = 97;
   _jumpMap[251][SignedInt] = 96;
   _jumpMap[251][Attribute] = 95;
   _jumpMap[251][ExpressionList] = 398;
   _jumpMap[251][Function] = 94;
   _jumpMap[251][CasePrepare] = 93;
   _jumpMap[251][CaseClause] = 92;
   _jumpMap[251][Factor] = 91;
   _jumpMap[251][Term] = 90;
   _jumpMap[251][Expr] = 374;
   _actionMap[252][IDENTIFIER] = ActionEntry(SHIFT, 399);
   _actionMap[253][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[253][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[253][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[253][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[253][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[253][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[253][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[253][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[253][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[253][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[253][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[253][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[253][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[253][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[253][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[253][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[253][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[253][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[253][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[253][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[253][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[253][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[253][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[253][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[253][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[253][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[253][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[253][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[253][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[253][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[253][NEXTCOUNT] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser188()
{
   _actionMap[253][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[253][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[253][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[253][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[253][LB] = ActionEntry(SHIFT, 142);
   _actionMap[253][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[253][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[253][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[253][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[253][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[253][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[253][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[253][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[253][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[253][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[253][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[253][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[253][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[253][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[253][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[253][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[253][ObjSpec] = 99;
   _jumpMap[253][Constant] = 98;
   _jumpMap[253][SignedFloat] = 97;
   _jumpMap[253][SignedInt] = 96;
   _jumpMap[253][Attribute] = 95;
   _jumpMap[253][ExpressionList] = 400;
   _jumpMap[253][Function] = 94;
   _jumpMap[253][CasePrepare] = 93;
   _jumpMap[253][CaseClause] = 92;
   _jumpMap[253][Factor] = 91;
   _jumpMap[253][Term] = 90;
   _jumpMap[253][Expr] = 374;
   _actionMap[254][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[254][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[254][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[254][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[254][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[254][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[254][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[254][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[254][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[254][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[254][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[254][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[254][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[254][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[254][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[254][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[254][REPLACE] = ActionEntry(SHIFT, 127);
}
void Cego::loadParser189()
{
   _actionMap[254][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[254][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[254][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[254][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[254][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[254][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[254][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[254][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[254][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[254][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[254][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[254][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[254][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[254][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[254][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[254][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[254][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[254][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[254][LB] = ActionEntry(SHIFT, 142);
   _actionMap[254][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[254][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[254][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[254][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[254][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[254][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[254][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[254][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[254][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[254][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[254][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[254][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[254][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[254][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[254][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[254][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[254][ObjSpec] = 99;
   _jumpMap[254][Constant] = 98;
   _jumpMap[254][SignedFloat] = 97;
   _jumpMap[254][SignedInt] = 96;
   _jumpMap[254][Attribute] = 95;
   _jumpMap[254][ExpressionList] = 401;
   _jumpMap[254][Function] = 94;
   _jumpMap[254][CasePrepare] = 93;
   _jumpMap[254][CaseClause] = 92;
   _jumpMap[254][Factor] = 91;
   _jumpMap[254][Term] = 90;
   _jumpMap[254][Expr] = 374;
   _actionMap[255][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[255][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[255][INTVAL] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser190()
{
   _actionMap[255][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[255][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[255][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[255][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[255][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[255][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[255][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[255][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[255][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[255][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[255][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[255][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[255][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[255][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[255][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[255][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[255][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[255][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[255][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[255][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[255][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[255][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[255][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[255][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[255][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[255][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[255][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[255][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[255][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[255][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[255][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[255][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[255][LB] = ActionEntry(SHIFT, 142);
   _actionMap[255][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[255][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[255][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[255][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[255][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[255][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[255][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[255][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[255][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[255][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[255][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[255][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[255][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[255][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[255][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[255][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[255][ObjSpec] = 99;
}
void Cego::loadParser191()
{
   _jumpMap[255][Constant] = 98;
   _jumpMap[255][SignedFloat] = 97;
   _jumpMap[255][SignedInt] = 96;
   _jumpMap[255][Attribute] = 95;
   _jumpMap[255][ExpressionList] = 402;
   _jumpMap[255][Function] = 94;
   _jumpMap[255][CasePrepare] = 93;
   _jumpMap[255][CaseClause] = 92;
   _jumpMap[255][Factor] = 91;
   _jumpMap[255][Term] = 90;
   _jumpMap[255][Expr] = 374;
   _actionMap[256][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[256][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[256][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[256][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[256][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[256][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[256][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[256][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[256][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[256][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[256][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[256][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[256][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[256][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[256][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[256][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[256][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[256][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[256][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[256][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[256][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[256][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[256][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[256][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[256][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[256][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[256][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[256][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[256][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[256][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[256][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[256][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[256][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[256][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[256][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[256][LB] = ActionEntry(SHIFT, 142);
   _actionMap[256][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[256][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[256][SYSDATE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser192()
{
   _actionMap[256][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[256][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[256][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[256][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[256][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[256][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[256][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[256][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[256][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[256][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[256][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[256][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[256][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[256][ObjSpec] = 99;
   _jumpMap[256][Constant] = 98;
   _jumpMap[256][SignedFloat] = 97;
   _jumpMap[256][SignedInt] = 96;
   _jumpMap[256][Attribute] = 95;
   _jumpMap[256][ExpressionList] = 403;
   _jumpMap[256][Function] = 94;
   _jumpMap[256][CasePrepare] = 93;
   _jumpMap[256][CaseClause] = 92;
   _jumpMap[256][Factor] = 91;
   _jumpMap[256][Term] = 90;
   _jumpMap[256][Expr] = 374;
   _actionMap[257][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[257][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[257][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[257][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[257][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[257][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[257][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[257][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[257][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[257][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[257][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[257][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[257][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[257][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[257][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[257][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[257][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[257][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[257][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[257][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[257][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[257][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[257][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[257][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[257][MOD] = ActionEntry(SHIFT, 121);
}
void Cego::loadParser193()
{
   _actionMap[257][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[257][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[257][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[257][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[257][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[257][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[257][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[257][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[257][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[257][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[257][LB] = ActionEntry(SHIFT, 142);
   _actionMap[257][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[257][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[257][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[257][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[257][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[257][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[257][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[257][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[257][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[257][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[257][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[257][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[257][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[257][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[257][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[257][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[257][ObjSpec] = 99;
   _jumpMap[257][Constant] = 98;
   _jumpMap[257][SignedFloat] = 97;
   _jumpMap[257][SignedInt] = 96;
   _jumpMap[257][Attribute] = 95;
   _jumpMap[257][ExpressionList] = 404;
   _jumpMap[257][Function] = 94;
   _jumpMap[257][CasePrepare] = 93;
   _jumpMap[257][CaseClause] = 92;
   _jumpMap[257][Factor] = 91;
   _jumpMap[257][Term] = 90;
   _jumpMap[257][Expr] = 374;
   _actionMap[258][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[258][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[258][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[258][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[258][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[258][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[258][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[258][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[258][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[258][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[258][LOWER] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser194()
{
   _actionMap[258][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[258][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[258][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[258][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[258][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[258][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[258][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[258][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[258][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[258][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[258][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[258][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[258][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[258][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[258][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[258][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[258][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[258][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[258][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[258][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[258][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[258][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[258][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[258][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[258][LB] = ActionEntry(SHIFT, 142);
   _actionMap[258][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[258][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[258][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[258][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[258][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[258][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[258][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[258][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[258][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[258][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[258][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[258][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[258][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[258][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[258][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[258][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[258][ObjSpec] = 99;
   _jumpMap[258][Constant] = 98;
   _jumpMap[258][SignedFloat] = 97;
   _jumpMap[258][SignedInt] = 96;
   _jumpMap[258][Attribute] = 95;
   _jumpMap[258][ExpressionList] = 405;
   _jumpMap[258][Function] = 94;
   _jumpMap[258][CasePrepare] = 93;
   _jumpMap[258][CaseClause] = 92;
}
void Cego::loadParser195()
{
   _jumpMap[258][Factor] = 91;
   _jumpMap[258][Term] = 90;
   _jumpMap[258][Expr] = 374;
   _actionMap[259][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[259][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[259][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[259][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[259][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[259][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[259][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[259][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[259][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[259][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[259][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[259][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[259][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[259][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[259][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[259][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[259][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[259][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[259][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[259][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[259][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[259][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[259][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[259][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[259][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[259][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[259][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[259][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[259][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[259][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[259][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[259][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[259][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[259][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[259][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[259][LB] = ActionEntry(SHIFT, 142);
   _actionMap[259][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[259][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[259][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[259][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[259][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[259][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[259][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[259][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[259][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[259][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[259][FETCH] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser196()
{
   _actionMap[259][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[259][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[259][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[259][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[259][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[259][ObjSpec] = 99;
   _jumpMap[259][Constant] = 98;
   _jumpMap[259][SignedFloat] = 97;
   _jumpMap[259][SignedInt] = 96;
   _jumpMap[259][Attribute] = 95;
   _jumpMap[259][ExpressionList] = 406;
   _jumpMap[259][Function] = 94;
   _jumpMap[259][CasePrepare] = 93;
   _jumpMap[259][CaseClause] = 92;
   _jumpMap[259][Factor] = 91;
   _jumpMap[259][Term] = 90;
   _jumpMap[259][Expr] = 374;
   _actionMap[260][IDENTIFIER] = ActionEntry(SHIFT, 407);
   _actionMap[261][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[261][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[261][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[261][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[261][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[261][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[261][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[261][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[261][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[261][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[261][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[261][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[261][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[261][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[261][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[261][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[261][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[261][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[261][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[261][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[261][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[261][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[261][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[261][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[261][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[261][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[261][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[261][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[261][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[261][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[261][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[261][SETCOUNT] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser197()
{
   _actionMap[261][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[261][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[261][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[261][LB] = ActionEntry(SHIFT, 142);
   _actionMap[261][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[261][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[261][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[261][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[261][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[261][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[261][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[261][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[261][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[261][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[261][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[261][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[261][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[261][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[261][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[261][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[261][ObjSpec] = 99;
   _jumpMap[261][Constant] = 98;
   _jumpMap[261][SignedFloat] = 97;
   _jumpMap[261][SignedInt] = 96;
   _jumpMap[261][Attribute] = 95;
   _jumpMap[261][ExpressionList] = 408;
   _jumpMap[261][Function] = 94;
   _jumpMap[261][CasePrepare] = 93;
   _jumpMap[261][CaseClause] = 92;
   _jumpMap[261][Factor] = 91;
   _jumpMap[261][Term] = 90;
   _jumpMap[261][Expr] = 374;
   _actionMap[262][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[262][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[262][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[262][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[262][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[262][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[262][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[262][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[262][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[262][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[262][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[262][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[262][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[262][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[262][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[262][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[262][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[262][LENGTH] = ActionEntry(SHIFT, 116);
}
void Cego::loadParser198()
{
   _actionMap[262][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[262][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[262][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[262][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[262][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[262][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[262][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[262][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[262][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[262][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[262][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[262][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[262][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[262][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[262][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[262][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[262][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[262][LB] = ActionEntry(SHIFT, 142);
   _actionMap[262][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[262][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[262][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[262][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[262][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[262][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[262][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[262][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[262][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[262][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[262][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[262][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[262][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[262][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[262][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[262][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[262][ObjSpec] = 99;
   _jumpMap[262][Constant] = 98;
   _jumpMap[262][SignedFloat] = 97;
   _jumpMap[262][SignedInt] = 96;
   _jumpMap[262][Attribute] = 95;
   _jumpMap[262][Function] = 94;
   _jumpMap[262][CasePrepare] = 93;
   _jumpMap[262][CaseClause] = 92;
   _jumpMap[262][Factor] = 91;
   _jumpMap[262][Term] = 90;
   _jumpMap[262][Expr] = 409;
   _actionMap[263][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[263][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[263][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[263][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[263][RTRIM] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser199()
{
   _actionMap[263][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[263][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[263][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[263][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[263][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[263][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[263][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[263][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[263][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[263][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[263][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[263][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[263][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[263][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[263][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[263][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[263][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[263][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[263][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[263][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[263][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[263][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[263][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[263][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[263][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[263][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[263][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[263][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[263][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[263][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[263][LB] = ActionEntry(SHIFT, 142);
   _actionMap[263][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[263][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[263][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[263][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[263][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[263][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[263][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[263][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[263][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[263][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[263][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[263][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[263][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[263][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[263][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[263][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[263][ObjSpec] = 99;
   _jumpMap[263][Constant] = 98;
   _jumpMap[263][SignedFloat] = 97;
}
void Cego::loadParser200()
{
   _jumpMap[263][SignedInt] = 96;
   _jumpMap[263][Attribute] = 95;
   _jumpMap[263][ExpressionList] = 410;
   _jumpMap[263][Function] = 94;
   _jumpMap[263][CasePrepare] = 93;
   _jumpMap[263][CaseClause] = 92;
   _jumpMap[263][Factor] = 91;
   _jumpMap[263][Term] = 90;
   _jumpMap[263][Expr] = 374;
   _actionMap[264][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[264][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[264][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[264][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[264][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[264][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[264][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[264][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[264][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[264][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[264][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[264][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[264][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[264][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[264][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[264][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[264][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[264][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[264][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[264][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[264][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[264][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[264][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[264][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[264][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[264][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[264][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[264][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[264][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[264][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[264][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[264][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[264][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[264][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[264][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[264][LB] = ActionEntry(SHIFT, 142);
   _actionMap[264][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[264][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[264][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[264][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[264][TRUEVAL] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser201()
{
   _actionMap[264][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[264][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[264][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[264][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[264][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[264][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[264][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[264][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[264][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[264][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[264][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[264][ObjSpec] = 99;
   _jumpMap[264][Constant] = 98;
   _jumpMap[264][SignedFloat] = 97;
   _jumpMap[264][SignedInt] = 96;
   _jumpMap[264][Attribute] = 95;
   _jumpMap[264][ExpressionList] = 411;
   _jumpMap[264][Function] = 94;
   _jumpMap[264][CasePrepare] = 93;
   _jumpMap[264][CaseClause] = 92;
   _jumpMap[264][Factor] = 91;
   _jumpMap[264][Term] = 90;
   _jumpMap[264][Expr] = 374;
   _actionMap[265][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[265][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[265][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[265][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[265][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[265][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[265][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[265][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[265][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[265][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[265][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[265][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[265][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[265][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[265][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[265][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[265][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[265][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[265][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[265][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[265][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[265][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[265][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[265][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[265][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[265][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[265][POWER] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser202()
{
   _actionMap[265][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[265][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[265][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[265][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[265][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[265][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[265][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[265][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[265][LB] = ActionEntry(SHIFT, 142);
   _actionMap[265][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[265][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[265][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[265][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[265][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[265][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[265][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[265][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[265][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[265][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[265][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[265][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[265][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[265][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[265][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[265][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[265][ObjSpec] = 99;
   _jumpMap[265][Constant] = 98;
   _jumpMap[265][SignedFloat] = 97;
   _jumpMap[265][SignedInt] = 96;
   _jumpMap[265][Attribute] = 95;
   _jumpMap[265][ExpressionList] = 412;
   _jumpMap[265][Function] = 94;
   _jumpMap[265][CasePrepare] = 93;
   _jumpMap[265][CaseClause] = 92;
   _jumpMap[265][Factor] = 91;
   _jumpMap[265][Term] = 90;
   _jumpMap[265][Expr] = 374;
   _actionMap[266][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[266][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[266][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[266][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[266][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[266][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[266][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[266][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[266][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[266][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[266][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[266][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[266][LEFT] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser203()
{
   _actionMap[266][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[266][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[266][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[266][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[266][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[266][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[266][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[266][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[266][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[266][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[266][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[266][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[266][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[266][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[266][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[266][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[266][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[266][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[266][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[266][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[266][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[266][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[266][LB] = ActionEntry(SHIFT, 142);
   _actionMap[266][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[266][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[266][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[266][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[266][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[266][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[266][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[266][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[266][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[266][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[266][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[266][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[266][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[266][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[266][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[266][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[266][ObjSpec] = 99;
   _jumpMap[266][Constant] = 98;
   _jumpMap[266][SignedFloat] = 97;
   _jumpMap[266][SignedInt] = 96;
   _jumpMap[266][Attribute] = 95;
   _jumpMap[266][ExpressionList] = 413;
   _jumpMap[266][Function] = 94;
   _jumpMap[266][CasePrepare] = 93;
   _jumpMap[266][CaseClause] = 92;
   _jumpMap[266][Factor] = 91;
   _jumpMap[266][Term] = 90;
}
void Cego::loadParser204()
{
   _jumpMap[266][Expr] = 374;
   _actionMap[267][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[267][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[267][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[267][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[267][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[267][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[267][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[267][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[267][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[267][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[267][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[267][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[267][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[267][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[267][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[267][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[267][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[267][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[267][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[267][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[267][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[267][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[267][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[267][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[267][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[267][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[267][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[267][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[267][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[267][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[267][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[267][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[267][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[267][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[267][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[267][LB] = ActionEntry(SHIFT, 142);
   _actionMap[267][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[267][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[267][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[267][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[267][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[267][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[267][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[267][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[267][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[267][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[267][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[267][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[267][SUM] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser205()
{
   _actionMap[267][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[267][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[267][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[267][ObjSpec] = 99;
   _jumpMap[267][Constant] = 98;
   _jumpMap[267][SignedFloat] = 97;
   _jumpMap[267][SignedInt] = 96;
   _jumpMap[267][Attribute] = 95;
   _jumpMap[267][ExpressionList] = 414;
   _jumpMap[267][Function] = 94;
   _jumpMap[267][CasePrepare] = 93;
   _jumpMap[267][CaseClause] = 92;
   _jumpMap[267][Factor] = 91;
   _jumpMap[267][Term] = 90;
   _jumpMap[267][Expr] = 374;
   _actionMap[268][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[268][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[268][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[268][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[268][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[268][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[268][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[268][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[268][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[268][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[268][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[268][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[268][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[268][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[268][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[268][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[268][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[268][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[268][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[268][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[268][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[268][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[268][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[268][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[268][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[268][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[268][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[268][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[268][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[268][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[268][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[268][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[268][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[268][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[268][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser206()
{
   _actionMap[268][LB] = ActionEntry(SHIFT, 142);
   _actionMap[268][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[268][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[268][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[268][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[268][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[268][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[268][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[268][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[268][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[268][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[268][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[268][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[268][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[268][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[268][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[268][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[268][ObjSpec] = 99;
   _jumpMap[268][Constant] = 98;
   _jumpMap[268][SignedFloat] = 97;
   _jumpMap[268][SignedInt] = 96;
   _jumpMap[268][Attribute] = 95;
   _jumpMap[268][ExpressionList] = 415;
   _jumpMap[268][Function] = 94;
   _jumpMap[268][CasePrepare] = 93;
   _jumpMap[268][CaseClause] = 92;
   _jumpMap[268][Factor] = 91;
   _jumpMap[268][Term] = 90;
   _jumpMap[268][Expr] = 374;
   _actionMap[269][RB] = ActionEntry(SHIFT, 416);
   _actionMap[269][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[269][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[269][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[270][RB] = ActionEntry(SHIFT, 417);
   _actionMap[271][RB] = ActionEntry(SHIFT, 418);
   _actionMap[272][RB] = ActionEntry(SHIFT, 419);
   _actionMap[273][RB] = ActionEntry(SHIFT, 420);
   _actionMap[274][RB] = ActionEntry(SHIFT, 421);
   _actionMap[275][RB] = ActionEntry(SHIFT, 422);
   _actionMap[276][RB] = ActionEntry(SHIFT, 423);
   _actionMap[277][RB] = ActionEntry(SHIFT, 424);
   _actionMap[278][KSEP] = ActionEntry(SHIFT, 425);
   _actionMap[279][WHEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][ELSE] = ActionEntry(REDUCE, 345);
   _actionMap[279][LEFT] = ActionEntry(REDUCE, 345);
   _actionMap[279][RIGHT] = ActionEntry(REDUCE, 345);
   _actionMap[279][INNER] = ActionEntry(REDUCE, 345);
   _actionMap[279][JOIN] = ActionEntry(REDUCE, 345);
   _actionMap[279][RETURNTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][ORDER] = ActionEntry(REDUCE, 345);
}
void Cego::loadParser207()
{
   _actionMap[279][GROUP] = ActionEntry(REDUCE, 345);
   _actionMap[279][WHERE] = ActionEntry(REDUCE, 345);
   _actionMap[279][AS] = ActionEntry(REDUCE, 345);
   _actionMap[279][FROM] = ActionEntry(REDUCE, 345);
   _actionMap[279][END_TOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][BEGIN] = ActionEntry(REDUCE, 345);
   _actionMap[279][THEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][OR] = ActionEntry(REDUCE, 345);
   _actionMap[279][AND] = ActionEntry(REDUCE, 345);
   _actionMap[279][NULLTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][LIKE] = ActionEntry(REDUCE, 345);
   _actionMap[279][IS] = ActionEntry(REDUCE, 345);
   _actionMap[279][BETWEEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][NOT] = ActionEntry(REDUCE, 345);
   _actionMap[279][INTOK] = ActionEntry(REDUCE, 345);
   _actionMap[279][EQU] = ActionEntry(REDUCE, 345);
   _actionMap[279][NEGATION] = ActionEntry(REDUCE, 345);
   _actionMap[279][LT] = ActionEntry(REDUCE, 345);
   _actionMap[279][MT] = ActionEntry(REDUCE, 345);
   _actionMap[279][DESC] = ActionEntry(REDUCE, 345);
   _actionMap[279][ASC] = ActionEntry(REDUCE, 345);
   _actionMap[279][KSEP] = ActionEntry(REDUCE, 345);
   _actionMap[279][ROWLIMIT] = ActionEntry(REDUCE, 345);
   _actionMap[279][UNION] = ActionEntry(REDUCE, 345);
   _actionMap[279][ENDTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[279][RB] = ActionEntry(REDUCE, 345);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 345);
   _actionMap[279][CONCAT] = ActionEntry(REDUCE, 345);
   _actionMap[279][STAR] = ActionEntry(REDUCE, 345);
   _actionMap[279][DIVISION] = ActionEntry(REDUCE, 345);
   _actionMap[279][MINUS] = ActionEntry(REDUCE, 345);
   _actionMap[279][PLUS] = ActionEntry(REDUCE, 345);
   _actionMap[280][WHEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][ELSE] = ActionEntry(REDUCE, 347);
   _actionMap[280][LEFT] = ActionEntry(REDUCE, 347);
   _actionMap[280][RIGHT] = ActionEntry(REDUCE, 347);
   _actionMap[280][INNER] = ActionEntry(REDUCE, 347);
   _actionMap[280][JOIN] = ActionEntry(REDUCE, 347);
   _actionMap[280][RETURNTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][ORDER] = ActionEntry(REDUCE, 347);
   _actionMap[280][GROUP] = ActionEntry(REDUCE, 347);
   _actionMap[280][WHERE] = ActionEntry(REDUCE, 347);
   _actionMap[280][AS] = ActionEntry(REDUCE, 347);
   _actionMap[280][FROM] = ActionEntry(REDUCE, 347);
   _actionMap[280][END_TOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][BEGIN] = ActionEntry(REDUCE, 347);
   _actionMap[280][THEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][OR] = ActionEntry(REDUCE, 347);
   _actionMap[280][AND] = ActionEntry(REDUCE, 347);
   _actionMap[280][NULLTOKEN] = ActionEntry(REDUCE, 347);
}
void Cego::loadParser208()
{
   _actionMap[280][LIKE] = ActionEntry(REDUCE, 347);
   _actionMap[280][IS] = ActionEntry(REDUCE, 347);
   _actionMap[280][BETWEEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][NOT] = ActionEntry(REDUCE, 347);
   _actionMap[280][INTOK] = ActionEntry(REDUCE, 347);
   _actionMap[280][EQU] = ActionEntry(REDUCE, 347);
   _actionMap[280][NEGATION] = ActionEntry(REDUCE, 347);
   _actionMap[280][LT] = ActionEntry(REDUCE, 347);
   _actionMap[280][MT] = ActionEntry(REDUCE, 347);
   _actionMap[280][DESC] = ActionEntry(REDUCE, 347);
   _actionMap[280][ASC] = ActionEntry(REDUCE, 347);
   _actionMap[280][KSEP] = ActionEntry(REDUCE, 347);
   _actionMap[280][ROWLIMIT] = ActionEntry(REDUCE, 347);
   _actionMap[280][UNION] = ActionEntry(REDUCE, 347);
   _actionMap[280][ENDTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[280][RB] = ActionEntry(REDUCE, 347);
   _actionMap[280][SEMICOLON] = ActionEntry(REDUCE, 347);
   _actionMap[280][CONCAT] = ActionEntry(REDUCE, 347);
   _actionMap[280][STAR] = ActionEntry(REDUCE, 347);
   _actionMap[280][DIVISION] = ActionEntry(REDUCE, 347);
   _actionMap[280][MINUS] = ActionEntry(REDUCE, 347);
   _actionMap[280][PLUS] = ActionEntry(REDUCE, 347);
   _actionMap[281][WHEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][ELSE] = ActionEntry(REDUCE, 343);
   _actionMap[281][LEFT] = ActionEntry(REDUCE, 343);
   _actionMap[281][RIGHT] = ActionEntry(REDUCE, 343);
   _actionMap[281][INNER] = ActionEntry(REDUCE, 343);
   _actionMap[281][JOIN] = ActionEntry(REDUCE, 343);
   _actionMap[281][RETURNTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][GROUP] = ActionEntry(REDUCE, 343);
   _actionMap[281][WHERE] = ActionEntry(REDUCE, 343);
   _actionMap[281][FROM] = ActionEntry(REDUCE, 343);
   _actionMap[281][AS] = ActionEntry(REDUCE, 343);
   _actionMap[281][END_TOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][BEGIN] = ActionEntry(REDUCE, 343);
   _actionMap[281][THEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][OR] = ActionEntry(REDUCE, 343);
   _actionMap[281][AND] = ActionEntry(REDUCE, 343);
   _actionMap[281][INTOK] = ActionEntry(REDUCE, 343);
   _actionMap[281][NOT] = ActionEntry(REDUCE, 343);
   _actionMap[281][BETWEEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][IS] = ActionEntry(REDUCE, 343);
   _actionMap[281][LIKE] = ActionEntry(REDUCE, 343);
   _actionMap[281][HAVING] = ActionEntry(REDUCE, 343);
   _actionMap[281][ORDER] = ActionEntry(REDUCE, 343);
   _actionMap[281][MT] = ActionEntry(REDUCE, 343);
   _actionMap[281][LT] = ActionEntry(REDUCE, 343);
   _actionMap[281][NEGATION] = ActionEntry(REDUCE, 343);
   _actionMap[281][EQU] = ActionEntry(REDUCE, 343);
   _actionMap[281][RB] = ActionEntry(REDUCE, 343);
}
void Cego::loadParser209()
{
   _actionMap[281][ENDTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[281][UNION] = ActionEntry(REDUCE, 343);
   _actionMap[281][ROWLIMIT] = ActionEntry(REDUCE, 343);
   _actionMap[281][KSEP] = ActionEntry(REDUCE, 343);
   _actionMap[281][ASC] = ActionEntry(REDUCE, 343);
   _actionMap[281][DESC] = ActionEntry(REDUCE, 343);
   _actionMap[281][SEMICOLON] = ActionEntry(REDUCE, 343);
   _actionMap[281][PLUS] = ActionEntry(REDUCE, 343);
   _actionMap[281][MINUS] = ActionEntry(REDUCE, 343);
   _actionMap[281][DIVISION] = ActionEntry(REDUCE, 343);
   _actionMap[281][STAR] = ActionEntry(REDUCE, 343);
   _actionMap[281][CONCAT] = ActionEntry(REDUCE, 343);
   _actionMap[282][TO] = ActionEntry(SHIFT, 426);
   _actionMap[283][TO] = ActionEntry(SHIFT, 427);
   _actionMap[284][TO] = ActionEntry(SHIFT, 428);
   _actionMap[285][TO] = ActionEntry(SHIFT, 429);
   _actionMap[286][TO] = ActionEntry(SHIFT, 430);
   _actionMap[287][TO] = ActionEntry(SHIFT, 431);
   _actionMap[288][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[289][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[290][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[290][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[290][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[290][ObjSpec] = 436;
   _jumpMap[290][Table] = 435;
   _jumpMap[290][TableList] = 434;
   _jumpMap[290][JoinSpecList] = 433;
   _jumpMap[290][TableSource] = 432;
   _actionMap[291][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[291][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[291][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[291][FROM] = ActionEntry(REDUCE, 224);
   _actionMap[291][AS] = ActionEntry(SHIFT, 439);
   _actionMap[291][KSEP] = ActionEntry(REDUCE, 224);
   _jumpMap[291][NoAliasOpt] = 438;
   _jumpMap[291][AliasOpt] = 437;
   _actionMap[292][KSEP] = ActionEntry(SHIFT, 440);
   _actionMap[292][FROM] = ActionEntry(REDUCE, 203);
   _actionMap[293][FROM] = ActionEntry(REDUCE, 206);
   _actionMap[293][KSEP] = ActionEntry(REDUCE, 206);
   _actionMap[294][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[295][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[296][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[297][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[298][TO] = ActionEntry(SHIFT, 441);
   _actionMap[299][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[300][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[301][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[303][FLOATVAL] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser210()
{
   _actionMap[303][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[303][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[303][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[303][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[303][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[303][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[303][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[303][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[303][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[303][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[303][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[303][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[303][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[303][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[303][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[303][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[303][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[303][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[303][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[303][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[303][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[303][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[303][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[303][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[303][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[303][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[303][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[303][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[303][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[303][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[303][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[303][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[303][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[303][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[303][LB] = ActionEntry(SHIFT, 142);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[303][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[303][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[303][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[303][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[303][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[303][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[303][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[303][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[303][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[303][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[303][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[303][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[303][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[303][MIN] = ActionEntry(SHIFT, 119);
}
void Cego::loadParser211()
{
   _actionMap[303][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[303][ObjSpec] = 99;
   _jumpMap[303][Constant] = 98;
   _jumpMap[303][SignedFloat] = 97;
   _jumpMap[303][SignedInt] = 96;
   _jumpMap[303][Attribute] = 95;
   _jumpMap[303][Function] = 94;
   _jumpMap[303][CasePrepare] = 93;
   _jumpMap[303][CaseClause] = 92;
   _jumpMap[303][Factor] = 91;
   _jumpMap[303][Term] = 90;
   _jumpMap[303][Expr] = 442;
   _actionMap[304][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[305][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[306][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[307][SET] = ActionEntry(SHIFT, 308);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 445);
   _jumpMap[308][Assignment] = 444;
   _jumpMap[308][UpdateList] = 443;
   _actionMap[309][SET] = ActionEntry(REDUCE, 257);
   _actionMap[309][WHERE] = ActionEntry(REDUCE, 257);
   _actionMap[309][GROUP] = ActionEntry(REDUCE, 257);
   _actionMap[309][ORDER] = ActionEntry(REDUCE, 257);
   _actionMap[309][ROWLIMIT] = ActionEntry(REDUCE, 257);
   _actionMap[309][UNION] = ActionEntry(REDUCE, 257);
   _actionMap[309][ENDTOKEN] = ActionEntry(REDUCE, 257);
   _actionMap[309][RB] = ActionEntry(REDUCE, 257);
   _actionMap[309][SEMICOLON] = ActionEntry(REDUCE, 257);
   _actionMap[309][RETURNTOKEN] = ActionEntry(REDUCE, 257);
   _actionMap[310][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[310][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[310][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[310][ObjSpec] = 446;
   _actionMap[38][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[38][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[38][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[38][ObjSpec] = 179;
   _actionMap[39][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[39][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[39][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[39][ObjSpec] = 180;
   _actionMap[40][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _jumpMap[40][CounterId] = 181;
   _actionMap[41][KEY] = ActionEntry(SHIFT, 183);
   _actionMap[42][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[42][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[42][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[42][ObjSpec] = 184;
   _actionMap[43][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[43][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
}
void Cego::loadParser212()
{
   _actionMap[43][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[43][ObjSpec] = 185;
   _actionMap[44][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[44][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[44][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[44][ObjSpec] = 186;
   _actionMap[45][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[45][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[45][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[45][ObjSpec] = 187;
   _actionMap[46][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[47][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[47][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[47][ObjSpec] = 188;
   _actionMap[48][IDENTIFIED] = ActionEntry(SHIFT, 189);
   _actionMap[49][LB] = ActionEntry(SHIFT, 190);
   _actionMap[50][TO] = ActionEntry(REDUCE, 366);
   _actionMap[50][VALUES] = ActionEntry(REDUCE, 366);
   _actionMap[50][SELECT] = ActionEntry(REDUCE, 366);
   _actionMap[50][SET] = ActionEntry(REDUCE, 366);
   _actionMap[50][AS] = ActionEntry(REDUCE, 366);
   _actionMap[50][DROP] = ActionEntry(REDUCE, 366);
   _actionMap[50][MODIFY] = ActionEntry(REDUCE, 366);
   _actionMap[50][RENAME] = ActionEntry(REDUCE, 366);
   _actionMap[50][ADD] = ActionEntry(REDUCE, 366);
   _actionMap[50][JOIN] = ActionEntry(REDUCE, 366);
   _actionMap[50][INNER] = ActionEntry(REDUCE, 366);
   _actionMap[50][RIGHT] = ActionEntry(REDUCE, 366);
   _actionMap[50][LEFT] = ActionEntry(REDUCE, 366);
   _actionMap[50][KSEP] = ActionEntry(REDUCE, 366);
   _actionMap[50][RETURNTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[50][SEMICOLON] = ActionEntry(REDUCE, 366);
   _actionMap[50][RB] = ActionEntry(REDUCE, 366);
   _actionMap[50][ENDTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[50][UNION] = ActionEntry(REDUCE, 366);
   _actionMap[50][ROWLIMIT] = ActionEntry(REDUCE, 366);
   _actionMap[50][ORDER] = ActionEntry(REDUCE, 366);
   _actionMap[50][GROUP] = ActionEntry(REDUCE, 366);
   _actionMap[50][WHERE] = ActionEntry(REDUCE, 366);
   _actionMap[50][LB] = ActionEntry(REDUCE, 366);
   _actionMap[50][IDENTIFIER] = ActionEntry(REDUCE, 366);
   _actionMap[50][ON] = ActionEntry(REDUCE, 366);
   _actionMap[51][TO] = ActionEntry(REDUCE, 367);
   _actionMap[51][VALUES] = ActionEntry(REDUCE, 367);
   _actionMap[51][SELECT] = ActionEntry(REDUCE, 367);
   _actionMap[51][SET] = ActionEntry(REDUCE, 367);
   _actionMap[51][AS] = ActionEntry(REDUCE, 367);
   _actionMap[51][DROP] = ActionEntry(REDUCE, 367);
   _actionMap[51][MODIFY] = ActionEntry(REDUCE, 367);
}
void Cego::loadParser213()
{
   _actionMap[51][RENAME] = ActionEntry(REDUCE, 367);
   _actionMap[51][ADD] = ActionEntry(REDUCE, 367);
   _actionMap[51][JOIN] = ActionEntry(REDUCE, 367);
   _actionMap[51][INNER] = ActionEntry(REDUCE, 367);
   _actionMap[51][RIGHT] = ActionEntry(REDUCE, 367);
   _actionMap[51][LEFT] = ActionEntry(REDUCE, 367);
   _actionMap[51][KSEP] = ActionEntry(REDUCE, 367);
   _actionMap[51][RETURNTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[51][SEMICOLON] = ActionEntry(REDUCE, 367);
   _actionMap[51][RB] = ActionEntry(REDUCE, 367);
   _actionMap[51][ENDTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[51][UNION] = ActionEntry(REDUCE, 367);
   _actionMap[51][ROWLIMIT] = ActionEntry(REDUCE, 367);
   _actionMap[51][ORDER] = ActionEntry(REDUCE, 367);
   _actionMap[51][GROUP] = ActionEntry(REDUCE, 367);
   _actionMap[51][WHERE] = ActionEntry(REDUCE, 367);
   _actionMap[51][LB] = ActionEntry(REDUCE, 367);
   _actionMap[51][IDENTIFIER] = ActionEntry(REDUCE, 367);
   _actionMap[51][ON] = ActionEntry(REDUCE, 367);
   _actionMap[52][TO] = ActionEntry(REDUCE, 368);
   _actionMap[52][VALUES] = ActionEntry(REDUCE, 368);
   _actionMap[52][SELECT] = ActionEntry(REDUCE, 368);
   _actionMap[52][SET] = ActionEntry(REDUCE, 368);
   _actionMap[52][AS] = ActionEntry(REDUCE, 368);
   _actionMap[52][DROP] = ActionEntry(REDUCE, 368);
   _actionMap[52][MODIFY] = ActionEntry(REDUCE, 368);
   _actionMap[52][RENAME] = ActionEntry(REDUCE, 368);
   _actionMap[52][ADD] = ActionEntry(REDUCE, 368);
   _actionMap[52][JOIN] = ActionEntry(REDUCE, 368);
   _actionMap[52][INNER] = ActionEntry(REDUCE, 368);
   _actionMap[52][RIGHT] = ActionEntry(REDUCE, 368);
   _actionMap[52][LEFT] = ActionEntry(REDUCE, 368);
   _actionMap[52][KSEP] = ActionEntry(REDUCE, 368);
   _actionMap[52][RETURNTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[52][SEMICOLON] = ActionEntry(REDUCE, 368);
   _actionMap[52][RB] = ActionEntry(REDUCE, 368);
   _actionMap[52][ENDTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[52][UNION] = ActionEntry(REDUCE, 368);
   _actionMap[52][ROWLIMIT] = ActionEntry(REDUCE, 368);
   _actionMap[52][ORDER] = ActionEntry(REDUCE, 368);
   _actionMap[52][GROUP] = ActionEntry(REDUCE, 368);
   _actionMap[52][WHERE] = ActionEntry(REDUCE, 368);
   _actionMap[52][IDENTIFIER] = ActionEntry(REDUCE, 368);
   _actionMap[52][ON] = ActionEntry(REDUCE, 368);
   _actionMap[52][LB] = ActionEntry(REDUCE, 368);
   _actionMap[53][IDENTIFIER] = ActionEntry(SHIFT, 191);
   _actionMap[54][BEGIN] = ActionEntry(SHIFT, 192);
   _actionMap[55][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[56][INDEX] = ActionEntry(SHIFT, 195);
   _actionMap[56][BTREE] = ActionEntry(SHIFT, 194);
}
void Cego::loadParser214()
{
   _jumpMap[56][IndexType] = 193;
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _jumpMap[57][CounterId] = 196;
   _actionMap[58][INDEX] = ActionEntry(SHIFT, 195);
   _actionMap[58][BTREE] = ActionEntry(SHIFT, 194);
   _jumpMap[58][IndexType] = 197;
   _actionMap[59][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[59][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[59][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[59][ObjSpec] = 198;
   _actionMap[60][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[60][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[60][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[60][ObjSpec] = 199;
   _actionMap[61][INDEX] = ActionEntry(REDUCE, 183);
   _actionMap[61][BTREE] = ActionEntry(REDUCE, 183);
   _actionMap[62][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[62][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[62][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[62][ObjSpec] = 200;
   _actionMap[63][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[63][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[63][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[63][ObjSpec] = 201;
   _actionMap[64][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[64][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[64][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[64][ObjSpec] = 202;
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[65][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[65][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[65][ObjSpec] = 203;
   _actionMap[66][KEY] = ActionEntry(SHIFT, 204);
   _actionMap[67][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[67][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[67][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[67][ObjSpec] = 205;
   _actionMap[68][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[68][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[68][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[68][ObjSpec] = 206;
   _actionMap[69][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[69][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[69][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[69][ObjSpec] = 207;
   _actionMap[70][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[70][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[70][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[70][ObjSpec] = 208;
   _actionMap[71][EXISTS] = ActionEntry(SHIFT, 209);
}
void Cego::loadParser215()
{
   _actionMap[72][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[72][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[72][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[72][ObjSpec] = 210;
   _actionMap[73][IDENTIFIER] = ActionEntry(SHIFT, 211);
   _actionMap[73][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[74][IDENTIFIER] = ActionEntry(REDUCE, 78);
   _actionMap[74][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[75][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[75][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[75][TableSetOpt] = 212;
   _actionMap[76][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[76][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[76][TableSetOpt] = 214;
   _actionMap[77][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[77][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[77][TableSetOpt] = 215;
   _actionMap[78][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[78][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[78][TableSetOpt] = 216;
   _actionMap[79][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[79][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[79][TableSetOpt] = 217;
   _actionMap[80][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[80][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[80][TableSetOpt] = 218;
   _actionMap[81][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[81][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[81][TableSetOpt] = 219;
   _actionMap[82][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[82][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[82][TableSetOpt] = 220;
   _actionMap[83][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[84][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[84][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[84][TableSetOpt] = 221;
   _actionMap[85][FOR] = ActionEntry(SHIFT, 213);
   _actionMap[85][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[85][TableSetOpt] = 222;
   _actionMap[86][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[87][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[87][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[87][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[87][ObjSpec] = 223;
   _actionMap[88][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[89][PLUS] = ActionEntry(SHIFT, 226);
   _actionMap[89][MINUS] = ActionEntry(SHIFT, 225);
   _actionMap[89][CONCAT] = ActionEntry(SHIFT, 224);
   _actionMap[89][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[90][STAR] = ActionEntry(SHIFT, 227);
}
void Cego::loadParser216()
{
   _actionMap[90][DIVISION] = ActionEntry(SHIFT, 228);
   _actionMap[90][WHEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][ELSE] = ActionEntry(REDUCE, 142);
   _actionMap[90][LEFT] = ActionEntry(REDUCE, 142);
   _actionMap[90][RIGHT] = ActionEntry(REDUCE, 142);
   _actionMap[90][INNER] = ActionEntry(REDUCE, 142);
   _actionMap[90][JOIN] = ActionEntry(REDUCE, 142);
   _actionMap[90][RETURNTOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][ORDER] = ActionEntry(REDUCE, 142);
   _actionMap[90][GROUP] = ActionEntry(REDUCE, 142);
   _actionMap[90][WHERE] = ActionEntry(REDUCE, 142);
   _actionMap[90][BEGIN] = ActionEntry(REDUCE, 142);
   _actionMap[90][THEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][OR] = ActionEntry(REDUCE, 142);
   _actionMap[90][AS] = ActionEntry(REDUCE, 142);
   _actionMap[90][FROM] = ActionEntry(REDUCE, 142);
   _actionMap[90][END_TOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][AND] = ActionEntry(REDUCE, 142);
   _actionMap[90][LIKE] = ActionEntry(REDUCE, 142);
   _actionMap[90][IS] = ActionEntry(REDUCE, 142);
   _actionMap[90][BETWEEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][NOT] = ActionEntry(REDUCE, 142);
   _actionMap[90][INTOK] = ActionEntry(REDUCE, 142);
   _actionMap[90][EQU] = ActionEntry(REDUCE, 142);
   _actionMap[90][NEGATION] = ActionEntry(REDUCE, 142);
   _actionMap[90][LT] = ActionEntry(REDUCE, 142);
   _actionMap[90][MT] = ActionEntry(REDUCE, 142);
   _actionMap[90][DESC] = ActionEntry(REDUCE, 142);
   _actionMap[90][ASC] = ActionEntry(REDUCE, 142);
   _actionMap[90][KSEP] = ActionEntry(REDUCE, 142);
   _actionMap[90][ROWLIMIT] = ActionEntry(REDUCE, 142);
   _actionMap[90][UNION] = ActionEntry(REDUCE, 142);
   _actionMap[90][ENDTOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[90][RB] = ActionEntry(REDUCE, 142);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 142);
   _actionMap[90][CONCAT] = ActionEntry(REDUCE, 142);
   _actionMap[90][MINUS] = ActionEntry(REDUCE, 142);
   _actionMap[90][PLUS] = ActionEntry(REDUCE, 142);
   _actionMap[91][WHEN] = ActionEntry(REDUCE, 146);
   _actionMap[91][ELSE] = ActionEntry(REDUCE, 146);
   _actionMap[91][LEFT] = ActionEntry(REDUCE, 146);
   _actionMap[91][RIGHT] = ActionEntry(REDUCE, 146);
   _actionMap[91][INNER] = ActionEntry(REDUCE, 146);
   _actionMap[91][JOIN] = ActionEntry(REDUCE, 146);
   _actionMap[91][RETURNTOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[91][ORDER] = ActionEntry(REDUCE, 146);
   _actionMap[91][GROUP] = ActionEntry(REDUCE, 146);
   _actionMap[91][WHERE] = ActionEntry(REDUCE, 146);
   _actionMap[91][BEGIN] = ActionEntry(REDUCE, 146);
   _actionMap[91][THEN] = ActionEntry(REDUCE, 146);
}
void Cego::loadParser217()
{
   _actionMap[91][OR] = ActionEntry(REDUCE, 146);
   _actionMap[91][FROM] = ActionEntry(REDUCE, 146);
   _actionMap[91][AS] = ActionEntry(REDUCE, 146);
   _actionMap[91][END_TOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[91][AND] = ActionEntry(REDUCE, 146);
   _actionMap[91][INTOK] = ActionEntry(REDUCE, 146);
   _actionMap[91][NOT] = ActionEntry(REDUCE, 146);
   _actionMap[91][BETWEEN] = ActionEntry(REDUCE, 146);
   _actionMap[91][IS] = ActionEntry(REDUCE, 146);
   _actionMap[91][LIKE] = ActionEntry(REDUCE, 146);
   _actionMap[91][MT] = ActionEntry(REDUCE, 146);
   _actionMap[91][LT] = ActionEntry(REDUCE, 146);
   _actionMap[91][NEGATION] = ActionEntry(REDUCE, 146);
   _actionMap[91][EQU] = ActionEntry(REDUCE, 146);
   _actionMap[91][RB] = ActionEntry(REDUCE, 146);
   _actionMap[91][ENDTOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[91][UNION] = ActionEntry(REDUCE, 146);
   _actionMap[91][ROWLIMIT] = ActionEntry(REDUCE, 146);
   _actionMap[91][KSEP] = ActionEntry(REDUCE, 146);
   _actionMap[91][ASC] = ActionEntry(REDUCE, 146);
   _actionMap[91][DESC] = ActionEntry(REDUCE, 146);
   _actionMap[91][SEMICOLON] = ActionEntry(REDUCE, 146);
   _actionMap[91][PLUS] = ActionEntry(REDUCE, 146);
   _actionMap[91][MINUS] = ActionEntry(REDUCE, 146);
   _actionMap[91][DIVISION] = ActionEntry(REDUCE, 146);
   _actionMap[91][STAR] = ActionEntry(REDUCE, 146);
   _actionMap[91][CONCAT] = ActionEntry(REDUCE, 146);
   _actionMap[92][WHEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][ELSE] = ActionEntry(REDUCE, 154);
   _actionMap[92][LEFT] = ActionEntry(REDUCE, 154);
   _actionMap[92][RIGHT] = ActionEntry(REDUCE, 154);
   _actionMap[92][INNER] = ActionEntry(REDUCE, 154);
   _actionMap[92][JOIN] = ActionEntry(REDUCE, 154);
   _actionMap[92][RETURNTOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][ORDER] = ActionEntry(REDUCE, 154);
   _actionMap[92][GROUP] = ActionEntry(REDUCE, 154);
   _actionMap[92][WHERE] = ActionEntry(REDUCE, 154);
   _actionMap[92][BEGIN] = ActionEntry(REDUCE, 154);
   _actionMap[92][THEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][OR] = ActionEntry(REDUCE, 154);
   _actionMap[92][AS] = ActionEntry(REDUCE, 154);
   _actionMap[92][FROM] = ActionEntry(REDUCE, 154);
   _actionMap[92][END_TOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][AND] = ActionEntry(REDUCE, 154);
   _actionMap[92][LIKE] = ActionEntry(REDUCE, 154);
   _actionMap[92][IS] = ActionEntry(REDUCE, 154);
   _actionMap[92][BETWEEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][NOT] = ActionEntry(REDUCE, 154);
   _actionMap[92][INTOK] = ActionEntry(REDUCE, 154);
   _actionMap[92][EQU] = ActionEntry(REDUCE, 154);
}
void Cego::loadParser218()
{
   _actionMap[92][NEGATION] = ActionEntry(REDUCE, 154);
   _actionMap[92][LT] = ActionEntry(REDUCE, 154);
   _actionMap[92][MT] = ActionEntry(REDUCE, 154);
   _actionMap[92][DESC] = ActionEntry(REDUCE, 154);
   _actionMap[92][ASC] = ActionEntry(REDUCE, 154);
   _actionMap[92][KSEP] = ActionEntry(REDUCE, 154);
   _actionMap[92][ROWLIMIT] = ActionEntry(REDUCE, 154);
   _actionMap[92][UNION] = ActionEntry(REDUCE, 154);
   _actionMap[92][ENDTOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[92][RB] = ActionEntry(REDUCE, 154);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 154);
   _actionMap[92][CONCAT] = ActionEntry(REDUCE, 154);
   _actionMap[92][STAR] = ActionEntry(REDUCE, 154);
   _actionMap[92][DIVISION] = ActionEntry(REDUCE, 154);
   _actionMap[92][MINUS] = ActionEntry(REDUCE, 154);
   _actionMap[92][PLUS] = ActionEntry(REDUCE, 154);
   _actionMap[93][WHEN] = ActionEntry(SHIFT, 231);
   _jumpMap[93][CaseCondition] = 230;
   _jumpMap[93][CaseConditionList] = 229;
   _actionMap[94][WHEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][ELSE] = ActionEntry(REDUCE, 151);
   _actionMap[94][LEFT] = ActionEntry(REDUCE, 151);
   _actionMap[94][RIGHT] = ActionEntry(REDUCE, 151);
   _actionMap[94][INNER] = ActionEntry(REDUCE, 151);
   _actionMap[94][JOIN] = ActionEntry(REDUCE, 151);
   _actionMap[94][RETURNTOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][ORDER] = ActionEntry(REDUCE, 151);
   _actionMap[94][GROUP] = ActionEntry(REDUCE, 151);
   _actionMap[94][WHERE] = ActionEntry(REDUCE, 151);
   _actionMap[94][BEGIN] = ActionEntry(REDUCE, 151);
   _actionMap[94][THEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][OR] = ActionEntry(REDUCE, 151);
   _actionMap[94][AS] = ActionEntry(REDUCE, 151);
   _actionMap[94][FROM] = ActionEntry(REDUCE, 151);
   _actionMap[94][END_TOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][AND] = ActionEntry(REDUCE, 151);
   _actionMap[94][LIKE] = ActionEntry(REDUCE, 151);
   _actionMap[94][IS] = ActionEntry(REDUCE, 151);
   _actionMap[94][BETWEEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][NOT] = ActionEntry(REDUCE, 151);
   _actionMap[94][INTOK] = ActionEntry(REDUCE, 151);
   _actionMap[94][EQU] = ActionEntry(REDUCE, 151);
   _actionMap[94][NEGATION] = ActionEntry(REDUCE, 151);
   _actionMap[94][LT] = ActionEntry(REDUCE, 151);
   _actionMap[94][MT] = ActionEntry(REDUCE, 151);
   _actionMap[94][DESC] = ActionEntry(REDUCE, 151);
   _actionMap[94][ASC] = ActionEntry(REDUCE, 151);
   _actionMap[94][KSEP] = ActionEntry(REDUCE, 151);
   _actionMap[94][ROWLIMIT] = ActionEntry(REDUCE, 151);
   _actionMap[94][UNION] = ActionEntry(REDUCE, 151);
}
void Cego::loadParser219()
{
   _actionMap[94][ENDTOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[94][RB] = ActionEntry(REDUCE, 151);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 151);
   _actionMap[94][CONCAT] = ActionEntry(REDUCE, 151);
   _actionMap[94][STAR] = ActionEntry(REDUCE, 151);
   _actionMap[94][DIVISION] = ActionEntry(REDUCE, 151);
   _actionMap[94][MINUS] = ActionEntry(REDUCE, 151);
   _actionMap[94][PLUS] = ActionEntry(REDUCE, 151);
   _actionMap[95][WHEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][ELSE] = ActionEntry(REDUCE, 150);
   _actionMap[95][LEFT] = ActionEntry(REDUCE, 150);
   _actionMap[95][RIGHT] = ActionEntry(REDUCE, 150);
   _actionMap[95][INNER] = ActionEntry(REDUCE, 150);
   _actionMap[95][JOIN] = ActionEntry(REDUCE, 150);
   _actionMap[95][RETURNTOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][ORDER] = ActionEntry(REDUCE, 150);
   _actionMap[95][GROUP] = ActionEntry(REDUCE, 150);
   _actionMap[95][WHERE] = ActionEntry(REDUCE, 150);
   _actionMap[95][AS] = ActionEntry(REDUCE, 150);
   _actionMap[95][FROM] = ActionEntry(REDUCE, 150);
   _actionMap[95][END_TOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][BEGIN] = ActionEntry(REDUCE, 150);
   _actionMap[95][THEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][OR] = ActionEntry(REDUCE, 150);
   _actionMap[95][AND] = ActionEntry(REDUCE, 150);
   _actionMap[95][LIKE] = ActionEntry(REDUCE, 150);
   _actionMap[95][IS] = ActionEntry(REDUCE, 150);
   _actionMap[95][BETWEEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][NOT] = ActionEntry(REDUCE, 150);
   _actionMap[95][INTOK] = ActionEntry(REDUCE, 150);
   _actionMap[95][EQU] = ActionEntry(REDUCE, 150);
   _actionMap[95][NEGATION] = ActionEntry(REDUCE, 150);
   _actionMap[95][LT] = ActionEntry(REDUCE, 150);
   _actionMap[95][MT] = ActionEntry(REDUCE, 150);
   _actionMap[95][DESC] = ActionEntry(REDUCE, 150);
   _actionMap[95][ASC] = ActionEntry(REDUCE, 150);
   _actionMap[95][KSEP] = ActionEntry(REDUCE, 150);
   _actionMap[95][ROWLIMIT] = ActionEntry(REDUCE, 150);
   _actionMap[95][UNION] = ActionEntry(REDUCE, 150);
   _actionMap[95][ENDTOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[95][RB] = ActionEntry(REDUCE, 150);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 150);
   _actionMap[95][CONCAT] = ActionEntry(REDUCE, 150);
   _actionMap[95][STAR] = ActionEntry(REDUCE, 150);
   _actionMap[95][DIVISION] = ActionEntry(REDUCE, 150);
   _actionMap[95][MINUS] = ActionEntry(REDUCE, 150);
   _actionMap[95][PLUS] = ActionEntry(REDUCE, 150);
   _actionMap[96][WHEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][ELSE] = ActionEntry(REDUCE, 348);
   _actionMap[96][LEFT] = ActionEntry(REDUCE, 348);
}
void Cego::loadParser220()
{
   _actionMap[96][RIGHT] = ActionEntry(REDUCE, 348);
   _actionMap[96][INNER] = ActionEntry(REDUCE, 348);
   _actionMap[96][JOIN] = ActionEntry(REDUCE, 348);
   _actionMap[96][RETURNTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][ORDER] = ActionEntry(REDUCE, 348);
   _actionMap[96][GROUP] = ActionEntry(REDUCE, 348);
   _actionMap[96][WHERE] = ActionEntry(REDUCE, 348);
   _actionMap[96][NULLTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][FROM] = ActionEntry(REDUCE, 348);
   _actionMap[96][AS] = ActionEntry(REDUCE, 348);
   _actionMap[96][END_TOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][BEGIN] = ActionEntry(REDUCE, 348);
   _actionMap[96][THEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][OR] = ActionEntry(REDUCE, 348);
   _actionMap[96][AND] = ActionEntry(REDUCE, 348);
   _actionMap[96][INTOK] = ActionEntry(REDUCE, 348);
   _actionMap[96][NOT] = ActionEntry(REDUCE, 348);
   _actionMap[96][BETWEEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][IS] = ActionEntry(REDUCE, 348);
   _actionMap[96][LIKE] = ActionEntry(REDUCE, 348);
   _actionMap[96][MT] = ActionEntry(REDUCE, 348);
   _actionMap[96][LT] = ActionEntry(REDUCE, 348);
   _actionMap[96][NEGATION] = ActionEntry(REDUCE, 348);
   _actionMap[96][EQU] = ActionEntry(REDUCE, 348);
   _actionMap[96][RB] = ActionEntry(REDUCE, 348);
   _actionMap[96][ENDTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[96][UNION] = ActionEntry(REDUCE, 348);
   _actionMap[96][ROWLIMIT] = ActionEntry(REDUCE, 348);
   _actionMap[96][KSEP] = ActionEntry(REDUCE, 348);
   _actionMap[96][ASC] = ActionEntry(REDUCE, 348);
   _actionMap[96][DESC] = ActionEntry(REDUCE, 348);
   _actionMap[96][SEMICOLON] = ActionEntry(REDUCE, 348);
   _actionMap[96][PLUS] = ActionEntry(REDUCE, 348);
   _actionMap[96][MINUS] = ActionEntry(REDUCE, 348);
   _actionMap[96][DIVISION] = ActionEntry(REDUCE, 348);
   _actionMap[96][STAR] = ActionEntry(REDUCE, 348);
   _actionMap[96][CONCAT] = ActionEntry(REDUCE, 348);
   _actionMap[97][WHEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][ELSE] = ActionEntry(REDUCE, 354);
   _actionMap[97][LEFT] = ActionEntry(REDUCE, 354);
   _actionMap[97][RIGHT] = ActionEntry(REDUCE, 354);
   _actionMap[97][INNER] = ActionEntry(REDUCE, 354);
   _actionMap[97][JOIN] = ActionEntry(REDUCE, 354);
   _actionMap[97][RETURNTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[97][GROUP] = ActionEntry(REDUCE, 354);
   _actionMap[97][WHERE] = ActionEntry(REDUCE, 354);
   _actionMap[97][NULLTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][FROM] = ActionEntry(REDUCE, 354);
   _actionMap[97][AS] = ActionEntry(REDUCE, 354);
}
void Cego::loadParser221()
{
   _actionMap[97][END_TOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][BEGIN] = ActionEntry(REDUCE, 354);
   _actionMap[97][THEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][OR] = ActionEntry(REDUCE, 354);
   _actionMap[97][AND] = ActionEntry(REDUCE, 354);
   _actionMap[97][INTOK] = ActionEntry(REDUCE, 354);
   _actionMap[97][NOT] = ActionEntry(REDUCE, 354);
   _actionMap[97][BETWEEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][IS] = ActionEntry(REDUCE, 354);
   _actionMap[97][LIKE] = ActionEntry(REDUCE, 354);
   _actionMap[97][MT] = ActionEntry(REDUCE, 354);
   _actionMap[97][LT] = ActionEntry(REDUCE, 354);
   _actionMap[97][NEGATION] = ActionEntry(REDUCE, 354);
   _actionMap[97][EQU] = ActionEntry(REDUCE, 354);
   _actionMap[97][RB] = ActionEntry(REDUCE, 354);
   _actionMap[97][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[97][UNION] = ActionEntry(REDUCE, 354);
   _actionMap[97][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[97][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[97][ASC] = ActionEntry(REDUCE, 354);
   _actionMap[97][DESC] = ActionEntry(REDUCE, 354);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[97][PLUS] = ActionEntry(REDUCE, 354);
   _actionMap[97][MINUS] = ActionEntry(REDUCE, 354);
   _actionMap[97][DIVISION] = ActionEntry(REDUCE, 354);
   _actionMap[97][STAR] = ActionEntry(REDUCE, 354);
   _actionMap[97][CONCAT] = ActionEntry(REDUCE, 354);
   _actionMap[98][WHEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][ELSE] = ActionEntry(REDUCE, 148);
   _actionMap[98][LEFT] = ActionEntry(REDUCE, 148);
   _actionMap[98][RIGHT] = ActionEntry(REDUCE, 148);
   _actionMap[98][INNER] = ActionEntry(REDUCE, 148);
   _actionMap[98][JOIN] = ActionEntry(REDUCE, 148);
   _actionMap[98][RETURNTOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][ORDER] = ActionEntry(REDUCE, 148);
   _actionMap[98][GROUP] = ActionEntry(REDUCE, 148);
   _actionMap[98][WHERE] = ActionEntry(REDUCE, 148);
   _actionMap[98][AS] = ActionEntry(REDUCE, 148);
   _actionMap[98][FROM] = ActionEntry(REDUCE, 148);
   _actionMap[98][END_TOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][BEGIN] = ActionEntry(REDUCE, 148);
   _actionMap[98][THEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][OR] = ActionEntry(REDUCE, 148);
   _actionMap[98][AND] = ActionEntry(REDUCE, 148);
   _actionMap[98][LIKE] = ActionEntry(REDUCE, 148);
   _actionMap[98][IS] = ActionEntry(REDUCE, 148);
   _actionMap[98][BETWEEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][NOT] = ActionEntry(REDUCE, 148);
   _actionMap[98][INTOK] = ActionEntry(REDUCE, 148);
   _actionMap[98][EQU] = ActionEntry(REDUCE, 148);
}
void Cego::loadParser222()
{
   _actionMap[98][NEGATION] = ActionEntry(REDUCE, 148);
   _actionMap[98][LT] = ActionEntry(REDUCE, 148);
   _actionMap[98][MT] = ActionEntry(REDUCE, 148);
   _actionMap[98][DESC] = ActionEntry(REDUCE, 148);
   _actionMap[98][ASC] = ActionEntry(REDUCE, 148);
   _actionMap[98][KSEP] = ActionEntry(REDUCE, 148);
   _actionMap[98][ROWLIMIT] = ActionEntry(REDUCE, 148);
   _actionMap[98][UNION] = ActionEntry(REDUCE, 148);
   _actionMap[98][ENDTOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[98][RB] = ActionEntry(REDUCE, 148);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 148);
   _actionMap[98][CONCAT] = ActionEntry(REDUCE, 148);
   _actionMap[98][STAR] = ActionEntry(REDUCE, 148);
   _actionMap[98][DIVISION] = ActionEntry(REDUCE, 148);
   _actionMap[98][MINUS] = ActionEntry(REDUCE, 148);
   _actionMap[98][PLUS] = ActionEntry(REDUCE, 148);
   _actionMap[99][LB] = ActionEntry(SHIFT, 232);
   _actionMap[100][WHEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][ELSE] = ActionEntry(REDUCE, 353);
   _actionMap[100][LEFT] = ActionEntry(REDUCE, 353);
   _actionMap[100][RIGHT] = ActionEntry(REDUCE, 353);
   _actionMap[100][INNER] = ActionEntry(REDUCE, 353);
   _actionMap[100][JOIN] = ActionEntry(REDUCE, 353);
   _actionMap[100][RETURNTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[100][GROUP] = ActionEntry(REDUCE, 353);
   _actionMap[100][WHERE] = ActionEntry(REDUCE, 353);
   _actionMap[100][NULLTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][FROM] = ActionEntry(REDUCE, 353);
   _actionMap[100][AS] = ActionEntry(REDUCE, 353);
   _actionMap[100][END_TOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][BEGIN] = ActionEntry(REDUCE, 353);
   _actionMap[100][THEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][OR] = ActionEntry(REDUCE, 353);
   _actionMap[100][AND] = ActionEntry(REDUCE, 353);
   _actionMap[100][INTOK] = ActionEntry(REDUCE, 353);
   _actionMap[100][NOT] = ActionEntry(REDUCE, 353);
   _actionMap[100][BETWEEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][IS] = ActionEntry(REDUCE, 353);
   _actionMap[100][LIKE] = ActionEntry(REDUCE, 353);
   _actionMap[100][MT] = ActionEntry(REDUCE, 353);
   _actionMap[100][LT] = ActionEntry(REDUCE, 353);
   _actionMap[100][NEGATION] = ActionEntry(REDUCE, 353);
   _actionMap[100][EQU] = ActionEntry(REDUCE, 353);
   _actionMap[100][RB] = ActionEntry(REDUCE, 353);
   _actionMap[100][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[100][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[100][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[100][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[100][ASC] = ActionEntry(REDUCE, 353);
}
void Cego::loadParser223()
{
   _actionMap[100][DESC] = ActionEntry(REDUCE, 353);
   _actionMap[100][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[100][PLUS] = ActionEntry(REDUCE, 353);
   _actionMap[100][MINUS] = ActionEntry(REDUCE, 353);
   _actionMap[100][DIVISION] = ActionEntry(REDUCE, 353);
   _actionMap[100][STAR] = ActionEntry(REDUCE, 353);
   _actionMap[100][CONCAT] = ActionEntry(REDUCE, 353);
   _actionMap[101][LB] = ActionEntry(SHIFT, 233);
   _actionMap[102][LB] = ActionEntry(SHIFT, 234);
   _actionMap[103][LB] = ActionEntry(SHIFT, 235);
   _actionMap[104][LB] = ActionEntry(SHIFT, 236);
   _actionMap[105][WHEN] = ActionEntry(REDUCE, 165);
   _actionMap[106][LB] = ActionEntry(SHIFT, 237);
   _actionMap[107][LB] = ActionEntry(SHIFT, 238);
   _actionMap[108][LB] = ActionEntry(SHIFT, 239);
   _actionMap[109][LB] = ActionEntry(SHIFT, 240);
   _actionMap[110][LB] = ActionEntry(SHIFT, 241);
   _actionMap[111][WHEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][ELSE] = ActionEntry(REDUCE, 362);
   _actionMap[111][LEFT] = ActionEntry(REDUCE, 362);
   _actionMap[111][RIGHT] = ActionEntry(REDUCE, 362);
   _actionMap[111][INNER] = ActionEntry(REDUCE, 362);
   _actionMap[111][JOIN] = ActionEntry(REDUCE, 362);
   _actionMap[111][RETURNTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][ORDER] = ActionEntry(REDUCE, 362);
   _actionMap[111][GROUP] = ActionEntry(REDUCE, 362);
   _actionMap[111][WHERE] = ActionEntry(REDUCE, 362);
   _actionMap[111][FROM] = ActionEntry(REDUCE, 362);
   _actionMap[111][AS] = ActionEntry(REDUCE, 362);
   _actionMap[111][END_TOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][BEGIN] = ActionEntry(REDUCE, 362);
   _actionMap[111][THEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][OR] = ActionEntry(REDUCE, 362);
   _actionMap[111][AND] = ActionEntry(REDUCE, 362);
   _actionMap[111][NULLTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][INTOK] = ActionEntry(REDUCE, 362);
   _actionMap[111][NOT] = ActionEntry(REDUCE, 362);
   _actionMap[111][BETWEEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][IS] = ActionEntry(REDUCE, 362);
   _actionMap[111][LIKE] = ActionEntry(REDUCE, 362);
   _actionMap[111][MT] = ActionEntry(REDUCE, 362);
   _actionMap[111][LT] = ActionEntry(REDUCE, 362);
   _actionMap[111][NEGATION] = ActionEntry(REDUCE, 362);
   _actionMap[111][EQU] = ActionEntry(REDUCE, 362);
   _actionMap[111][RB] = ActionEntry(REDUCE, 362);
   _actionMap[111][ENDTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[111][UNION] = ActionEntry(REDUCE, 362);
   _actionMap[111][ROWLIMIT] = ActionEntry(REDUCE, 362);
   _actionMap[111][KSEP] = ActionEntry(REDUCE, 362);
   _actionMap[111][ASC] = ActionEntry(REDUCE, 362);
}
void Cego::loadParser224()
{
   _actionMap[111][DESC] = ActionEntry(REDUCE, 362);
   _actionMap[111][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[111][PLUS] = ActionEntry(REDUCE, 362);
   _actionMap[111][MINUS] = ActionEntry(REDUCE, 362);
   _actionMap[111][DIVISION] = ActionEntry(REDUCE, 362);
   _actionMap[111][STAR] = ActionEntry(REDUCE, 362);
   _actionMap[111][CONCAT] = ActionEntry(REDUCE, 362);
   _actionMap[112][IDENTIFIER] = ActionEntry(SHIFT, 242);
   _actionMap[113][LB] = ActionEntry(SHIFT, 243);
   _actionMap[114][LB] = ActionEntry(SHIFT, 244);
   _actionMap[115][LB] = ActionEntry(SHIFT, 245);
   _actionMap[116][LB] = ActionEntry(SHIFT, 246);
   _actionMap[117][LB] = ActionEntry(SHIFT, 247);
   _actionMap[118][LB] = ActionEntry(SHIFT, 248);
   _actionMap[119][LB] = ActionEntry(SHIFT, 249);
   _actionMap[120][LB] = ActionEntry(SHIFT, 250);
   _actionMap[121][LB] = ActionEntry(SHIFT, 251);
   _actionMap[122][LB] = ActionEntry(SHIFT, 252);
   _actionMap[123][WHEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][ELSE] = ActionEntry(REDUCE, 360);
   _actionMap[123][LEFT] = ActionEntry(REDUCE, 360);
   _actionMap[123][RIGHT] = ActionEntry(REDUCE, 360);
   _actionMap[123][INNER] = ActionEntry(REDUCE, 360);
   _actionMap[123][JOIN] = ActionEntry(REDUCE, 360);
   _actionMap[123][RETURNTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][ORDER] = ActionEntry(REDUCE, 360);
   _actionMap[123][GROUP] = ActionEntry(REDUCE, 360);
   _actionMap[123][WHERE] = ActionEntry(REDUCE, 360);
   _actionMap[123][FROM] = ActionEntry(REDUCE, 360);
   _actionMap[123][AS] = ActionEntry(REDUCE, 360);
   _actionMap[123][END_TOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][BEGIN] = ActionEntry(REDUCE, 360);
   _actionMap[123][THEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][OR] = ActionEntry(REDUCE, 360);
   _actionMap[123][AND] = ActionEntry(REDUCE, 360);
   _actionMap[123][NULLTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][INTOK] = ActionEntry(REDUCE, 360);
   _actionMap[123][NOT] = ActionEntry(REDUCE, 360);
   _actionMap[123][BETWEEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][IS] = ActionEntry(REDUCE, 360);
   _actionMap[123][LIKE] = ActionEntry(REDUCE, 360);
   _actionMap[123][MT] = ActionEntry(REDUCE, 360);
   _actionMap[123][LT] = ActionEntry(REDUCE, 360);
   _actionMap[123][NEGATION] = ActionEntry(REDUCE, 360);
   _actionMap[123][EQU] = ActionEntry(REDUCE, 360);
   _actionMap[123][RB] = ActionEntry(REDUCE, 360);
   _actionMap[123][ENDTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[123][UNION] = ActionEntry(REDUCE, 360);
   _actionMap[123][ROWLIMIT] = ActionEntry(REDUCE, 360);
   _actionMap[123][KSEP] = ActionEntry(REDUCE, 360);
}
void Cego::loadParser225()
{
   _actionMap[123][ASC] = ActionEntry(REDUCE, 360);
   _actionMap[123][DESC] = ActionEntry(REDUCE, 360);
   _actionMap[123][SEMICOLON] = ActionEntry(REDUCE, 360);
   _actionMap[123][PLUS] = ActionEntry(REDUCE, 360);
   _actionMap[123][MINUS] = ActionEntry(REDUCE, 360);
   _actionMap[123][DIVISION] = ActionEntry(REDUCE, 360);
   _actionMap[123][STAR] = ActionEntry(REDUCE, 360);
   _actionMap[123][CONCAT] = ActionEntry(REDUCE, 360);
   _actionMap[124][LB] = ActionEntry(SHIFT, 253);
   _actionMap[125][LB] = ActionEntry(SHIFT, 254);
   _actionMap[126][LB] = ActionEntry(SHIFT, 255);
   _actionMap[127][LB] = ActionEntry(SHIFT, 256);
   _actionMap[128][LB] = ActionEntry(SHIFT, 257);
   _actionMap[129][LB] = ActionEntry(SHIFT, 258);
   _actionMap[130][LB] = ActionEntry(SHIFT, 259);
   _actionMap[131][LB] = ActionEntry(SHIFT, 260);
   _actionMap[132][LB] = ActionEntry(SHIFT, 261);
   _actionMap[133][LB] = ActionEntry(SHIFT, 262);
   _actionMap[134][WHEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][ELSE] = ActionEntry(REDUCE, 359);
   _actionMap[134][LEFT] = ActionEntry(REDUCE, 359);
   _actionMap[134][RIGHT] = ActionEntry(REDUCE, 359);
   _actionMap[134][INNER] = ActionEntry(REDUCE, 359);
   _actionMap[134][JOIN] = ActionEntry(REDUCE, 359);
   _actionMap[134][RETURNTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][ORDER] = ActionEntry(REDUCE, 359);
   _actionMap[134][GROUP] = ActionEntry(REDUCE, 359);
   _actionMap[134][WHERE] = ActionEntry(REDUCE, 359);
   _actionMap[134][FROM] = ActionEntry(REDUCE, 359);
   _actionMap[134][AS] = ActionEntry(REDUCE, 359);
   _actionMap[134][END_TOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][BEGIN] = ActionEntry(REDUCE, 359);
   _actionMap[134][THEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][OR] = ActionEntry(REDUCE, 359);
   _actionMap[134][AND] = ActionEntry(REDUCE, 359);
   _actionMap[134][NULLTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][INTOK] = ActionEntry(REDUCE, 359);
   _actionMap[134][NOT] = ActionEntry(REDUCE, 359);
   _actionMap[134][BETWEEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][IS] = ActionEntry(REDUCE, 359);
   _actionMap[134][LIKE] = ActionEntry(REDUCE, 359);
   _actionMap[134][MT] = ActionEntry(REDUCE, 359);
   _actionMap[134][LT] = ActionEntry(REDUCE, 359);
   _actionMap[134][NEGATION] = ActionEntry(REDUCE, 359);
   _actionMap[134][EQU] = ActionEntry(REDUCE, 359);
   _actionMap[134][RB] = ActionEntry(REDUCE, 359);
   _actionMap[134][ENDTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[134][UNION] = ActionEntry(REDUCE, 359);
   _actionMap[134][ROWLIMIT] = ActionEntry(REDUCE, 359);
   _actionMap[134][KSEP] = ActionEntry(REDUCE, 359);
}
void Cego::loadParser226()
{
   _actionMap[134][ASC] = ActionEntry(REDUCE, 359);
   _actionMap[134][DESC] = ActionEntry(REDUCE, 359);
   _actionMap[134][SEMICOLON] = ActionEntry(REDUCE, 359);
   _actionMap[134][PLUS] = ActionEntry(REDUCE, 359);
   _actionMap[134][MINUS] = ActionEntry(REDUCE, 359);
   _actionMap[134][DIVISION] = ActionEntry(REDUCE, 359);
   _actionMap[134][STAR] = ActionEntry(REDUCE, 359);
   _actionMap[134][CONCAT] = ActionEntry(REDUCE, 359);
   _actionMap[135][LB] = ActionEntry(SHIFT, 263);
   _actionMap[136][LB] = ActionEntry(SHIFT, 264);
   _actionMap[137][LB] = ActionEntry(SHIFT, 265);
   _actionMap[138][LB] = ActionEntry(SHIFT, 266);
   _actionMap[139][WHEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][ELSE] = ActionEntry(REDUCE, 361);
   _actionMap[139][LEFT] = ActionEntry(REDUCE, 361);
   _actionMap[139][RIGHT] = ActionEntry(REDUCE, 361);
   _actionMap[139][INNER] = ActionEntry(REDUCE, 361);
   _actionMap[139][JOIN] = ActionEntry(REDUCE, 361);
   _actionMap[139][RETURNTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][ORDER] = ActionEntry(REDUCE, 361);
   _actionMap[139][GROUP] = ActionEntry(REDUCE, 361);
   _actionMap[139][WHERE] = ActionEntry(REDUCE, 361);
   _actionMap[139][FROM] = ActionEntry(REDUCE, 361);
   _actionMap[139][AS] = ActionEntry(REDUCE, 361);
   _actionMap[139][END_TOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][BEGIN] = ActionEntry(REDUCE, 361);
   _actionMap[139][THEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][OR] = ActionEntry(REDUCE, 361);
   _actionMap[139][AND] = ActionEntry(REDUCE, 361);
   _actionMap[139][NULLTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][INTOK] = ActionEntry(REDUCE, 361);
   _actionMap[139][NOT] = ActionEntry(REDUCE, 361);
   _actionMap[139][BETWEEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][IS] = ActionEntry(REDUCE, 361);
   _actionMap[139][LIKE] = ActionEntry(REDUCE, 361);
   _actionMap[139][MT] = ActionEntry(REDUCE, 361);
   _actionMap[139][LT] = ActionEntry(REDUCE, 361);
   _actionMap[139][NEGATION] = ActionEntry(REDUCE, 361);
   _actionMap[139][EQU] = ActionEntry(REDUCE, 361);
   _actionMap[139][RB] = ActionEntry(REDUCE, 361);
   _actionMap[139][ENDTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[139][UNION] = ActionEntry(REDUCE, 361);
   _actionMap[139][ROWLIMIT] = ActionEntry(REDUCE, 361);
   _actionMap[139][KSEP] = ActionEntry(REDUCE, 361);
   _actionMap[139][ASC] = ActionEntry(REDUCE, 361);
   _actionMap[139][DESC] = ActionEntry(REDUCE, 361);
   _actionMap[139][SEMICOLON] = ActionEntry(REDUCE, 361);
   _actionMap[139][PLUS] = ActionEntry(REDUCE, 361);
   _actionMap[139][MINUS] = ActionEntry(REDUCE, 361);
   _actionMap[139][DIVISION] = ActionEntry(REDUCE, 361);
}
void Cego::loadParser227()
{
   _actionMap[139][STAR] = ActionEntry(REDUCE, 361);
   _actionMap[139][CONCAT] = ActionEntry(REDUCE, 361);
   _actionMap[140][LB] = ActionEntry(SHIFT, 267);
   _actionMap[141][LB] = ActionEntry(SHIFT, 268);
   _actionMap[142][LONG] = ActionEntry(SHIFT, 275);
   _actionMap[142][BIGINT] = ActionEntry(SHIFT, 271);
   _actionMap[142][SMALLINT] = ActionEntry(SHIFT, 276);
   _actionMap[142][TINYINT] = ActionEntry(SHIFT, 277);
   _actionMap[142][DOUBLE] = ActionEntry(SHIFT, 273);
   _actionMap[142][DECIMAL] = ActionEntry(SHIFT, 272);
   _actionMap[142][FIXED] = ActionEntry(SHIFT, 274);
   _actionMap[142][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[142][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[142][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[142][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[142][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[142][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[142][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[142][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[142][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[142][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[142][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[142][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[142][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[142][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[142][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[142][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[142][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[142][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[142][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[142][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[142][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[142][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[142][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[142][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[142][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[142][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[142][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[142][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[142][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[142][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[142][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[142][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[142][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[142][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[142][LB] = ActionEntry(SHIFT, 142);
   _actionMap[142][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[142][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[142][SYSDATE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser228()
{
   _actionMap[142][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[142][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[142][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[142][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[142][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[142][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[142][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[142][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[142][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[142][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[142][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[142][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[142][MAX] = ActionEntry(SHIFT, 120);
   _actionMap[142][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[142][ObjSpec] = 99;
   _jumpMap[142][Constant] = 98;
   _jumpMap[142][SignedFloat] = 97;
   _jumpMap[142][SignedInt] = 96;
   _jumpMap[142][Attribute] = 95;
   _jumpMap[142][Function] = 94;
   _jumpMap[142][SelectStatement] = 270;
   _jumpMap[142][CasePrepare] = 93;
   _jumpMap[142][CaseClause] = 92;
   _jumpMap[142][Factor] = 91;
   _jumpMap[142][Term] = 90;
   _jumpMap[142][Expr] = 269;
   _actionMap[143][INTVAL] = ActionEntry(SHIFT, 278);
   _actionMap[144][FLOATVAL] = ActionEntry(SHIFT, 280);
   _actionMap[144][INTVAL] = ActionEntry(SHIFT, 279);
   _actionMap[145][WHEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][ELSE] = ActionEntry(REDUCE, 344);
   _actionMap[145][LEFT] = ActionEntry(REDUCE, 344);
   _actionMap[145][RIGHT] = ActionEntry(REDUCE, 344);
   _actionMap[145][INNER] = ActionEntry(REDUCE, 344);
   _actionMap[145][JOIN] = ActionEntry(REDUCE, 344);
   _actionMap[145][RETURNTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][ORDER] = ActionEntry(REDUCE, 344);
   _actionMap[145][GROUP] = ActionEntry(REDUCE, 344);
   _actionMap[145][WHERE] = ActionEntry(REDUCE, 344);
   _actionMap[145][AS] = ActionEntry(REDUCE, 344);
   _actionMap[145][FROM] = ActionEntry(REDUCE, 344);
   _actionMap[145][END_TOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][BEGIN] = ActionEntry(REDUCE, 344);
   _actionMap[145][THEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][OR] = ActionEntry(REDUCE, 344);
   _actionMap[145][AND] = ActionEntry(REDUCE, 344);
   _actionMap[145][NULLTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][LIKE] = ActionEntry(REDUCE, 344);
   _actionMap[145][IS] = ActionEntry(REDUCE, 344);
   _actionMap[145][BETWEEN] = ActionEntry(REDUCE, 344);
}
void Cego::loadParser229()
{
   _actionMap[145][NOT] = ActionEntry(REDUCE, 344);
   _actionMap[145][INTOK] = ActionEntry(REDUCE, 344);
   _actionMap[145][EQU] = ActionEntry(REDUCE, 344);
   _actionMap[145][NEGATION] = ActionEntry(REDUCE, 344);
   _actionMap[145][LT] = ActionEntry(REDUCE, 344);
   _actionMap[145][MT] = ActionEntry(REDUCE, 344);
   _actionMap[145][DESC] = ActionEntry(REDUCE, 344);
   _actionMap[145][ASC] = ActionEntry(REDUCE, 344);
   _actionMap[145][KSEP] = ActionEntry(REDUCE, 344);
   _actionMap[145][ROWLIMIT] = ActionEntry(REDUCE, 344);
   _actionMap[145][UNION] = ActionEntry(REDUCE, 344);
   _actionMap[145][ENDTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[145][RB] = ActionEntry(REDUCE, 344);
   _actionMap[145][SEMICOLON] = ActionEntry(REDUCE, 344);
   _actionMap[145][CONCAT] = ActionEntry(REDUCE, 344);
   _actionMap[145][STAR] = ActionEntry(REDUCE, 344);
   _actionMap[145][DIVISION] = ActionEntry(REDUCE, 344);
   _actionMap[145][MINUS] = ActionEntry(REDUCE, 344);
   _actionMap[145][PLUS] = ActionEntry(REDUCE, 344);
   _actionMap[146][WHEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][ELSE] = ActionEntry(REDUCE, 346);
   _actionMap[146][LEFT] = ActionEntry(REDUCE, 346);
   _actionMap[146][RIGHT] = ActionEntry(REDUCE, 346);
   _actionMap[146][INNER] = ActionEntry(REDUCE, 346);
   _actionMap[146][JOIN] = ActionEntry(REDUCE, 346);
   _actionMap[146][RETURNTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][ORDER] = ActionEntry(REDUCE, 346);
   _actionMap[146][GROUP] = ActionEntry(REDUCE, 346);
   _actionMap[146][WHERE] = ActionEntry(REDUCE, 346);
   _actionMap[146][AS] = ActionEntry(REDUCE, 346);
   _actionMap[146][FROM] = ActionEntry(REDUCE, 346);
   _actionMap[146][END_TOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][BEGIN] = ActionEntry(REDUCE, 346);
   _actionMap[146][THEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][OR] = ActionEntry(REDUCE, 346);
   _actionMap[146][AND] = ActionEntry(REDUCE, 346);
   _actionMap[146][NULLTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][LIKE] = ActionEntry(REDUCE, 346);
   _actionMap[146][IS] = ActionEntry(REDUCE, 346);
   _actionMap[146][BETWEEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][NOT] = ActionEntry(REDUCE, 346);
   _actionMap[146][INTOK] = ActionEntry(REDUCE, 346);
   _actionMap[146][EQU] = ActionEntry(REDUCE, 346);
   _actionMap[146][NEGATION] = ActionEntry(REDUCE, 346);
   _actionMap[146][LT] = ActionEntry(REDUCE, 346);
   _actionMap[146][MT] = ActionEntry(REDUCE, 346);
   _actionMap[146][DESC] = ActionEntry(REDUCE, 346);
   _actionMap[146][ASC] = ActionEntry(REDUCE, 346);
   _actionMap[146][KSEP] = ActionEntry(REDUCE, 346);
   _actionMap[146][ROWLIMIT] = ActionEntry(REDUCE, 346);
}
void Cego::loadParser230()
{
   _actionMap[146][UNION] = ActionEntry(REDUCE, 346);
   _actionMap[146][ENDTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[146][RB] = ActionEntry(REDUCE, 346);
   _actionMap[146][SEMICOLON] = ActionEntry(REDUCE, 346);
   _actionMap[146][CONCAT] = ActionEntry(REDUCE, 346);
   _actionMap[146][STAR] = ActionEntry(REDUCE, 346);
   _actionMap[146][DIVISION] = ActionEntry(REDUCE, 346);
   _actionMap[146][MINUS] = ActionEntry(REDUCE, 346);
   _actionMap[146][PLUS] = ActionEntry(REDUCE, 346);
   _actionMap[147][WHEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][ELSE] = ActionEntry(REDUCE, 341);
   _actionMap[147][LEFT] = ActionEntry(REDUCE, 341);
   _actionMap[147][RIGHT] = ActionEntry(REDUCE, 341);
   _actionMap[147][INNER] = ActionEntry(REDUCE, 341);
   _actionMap[147][JOIN] = ActionEntry(REDUCE, 341);
   _actionMap[147][RETURNTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][ORDER] = ActionEntry(REDUCE, 341);
   _actionMap[147][GROUP] = ActionEntry(REDUCE, 341);
   _actionMap[147][WHERE] = ActionEntry(REDUCE, 341);
   _actionMap[147][FROM] = ActionEntry(REDUCE, 341);
   _actionMap[147][AS] = ActionEntry(REDUCE, 341);
   _actionMap[147][END_TOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][BEGIN] = ActionEntry(REDUCE, 341);
   _actionMap[147][THEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][OR] = ActionEntry(REDUCE, 341);
   _actionMap[147][AND] = ActionEntry(REDUCE, 341);
   _actionMap[147][INTOK] = ActionEntry(REDUCE, 341);
   _actionMap[147][NOT] = ActionEntry(REDUCE, 341);
   _actionMap[147][BETWEEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][IS] = ActionEntry(REDUCE, 341);
   _actionMap[147][LIKE] = ActionEntry(REDUCE, 341);
   _actionMap[147][MT] = ActionEntry(REDUCE, 341);
   _actionMap[147][LT] = ActionEntry(REDUCE, 341);
   _actionMap[147][NEGATION] = ActionEntry(REDUCE, 341);
   _actionMap[147][EQU] = ActionEntry(REDUCE, 341);
   _actionMap[147][RB] = ActionEntry(REDUCE, 341);
   _actionMap[147][ENDTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[147][UNION] = ActionEntry(REDUCE, 341);
   _actionMap[147][ROWLIMIT] = ActionEntry(REDUCE, 341);
   _actionMap[147][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[147][ASC] = ActionEntry(REDUCE, 341);
   _actionMap[147][DESC] = ActionEntry(REDUCE, 341);
   _actionMap[147][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[147][PLUS] = ActionEntry(REDUCE, 341);
   _actionMap[147][MINUS] = ActionEntry(REDUCE, 341);
   _actionMap[147][LB] = ActionEntry(REDUCE, 366);
   _actionMap[147][DIVISION] = ActionEntry(REDUCE, 341);
   _actionMap[147][STAR] = ActionEntry(REDUCE, 341);
   _actionMap[147][CONCAT] = ActionEntry(REDUCE, 341);
   _actionMap[148][WHEN] = ActionEntry(REDUCE, 147);
}
void Cego::loadParser231()
{
   _actionMap[148][ELSE] = ActionEntry(REDUCE, 147);
   _actionMap[148][LEFT] = ActionEntry(REDUCE, 147);
   _actionMap[148][RIGHT] = ActionEntry(REDUCE, 147);
   _actionMap[148][INNER] = ActionEntry(REDUCE, 147);
   _actionMap[148][JOIN] = ActionEntry(REDUCE, 147);
   _actionMap[148][RETURNTOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[148][ORDER] = ActionEntry(REDUCE, 147);
   _actionMap[148][GROUP] = ActionEntry(REDUCE, 147);
   _actionMap[148][WHERE] = ActionEntry(REDUCE, 147);
   _actionMap[148][AS] = ActionEntry(REDUCE, 147);
   _actionMap[148][FROM] = ActionEntry(REDUCE, 147);
   _actionMap[148][END_TOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[148][BEGIN] = ActionEntry(REDUCE, 147);
   _actionMap[148][THEN] = ActionEntry(REDUCE, 147);
   _actionMap[148][OR] = ActionEntry(REDUCE, 147);
   _actionMap[148][AND] = ActionEntry(REDUCE, 147);
   _actionMap[148][LIKE] = ActionEntry(REDUCE, 147);
   _actionMap[148][IS] = ActionEntry(REDUCE, 147);
   _actionMap[148][BETWEEN] = ActionEntry(REDUCE, 147);
   _actionMap[148][NOT] = ActionEntry(REDUCE, 147);
   _actionMap[148][INTOK] = ActionEntry(REDUCE, 147);
   _actionMap[148][EQU] = ActionEntry(REDUCE, 147);
   _actionMap[148][NEGATION] = ActionEntry(REDUCE, 147);
   _actionMap[148][LT] = ActionEntry(REDUCE, 147);
   _actionMap[148][MT] = ActionEntry(REDUCE, 147);
   _actionMap[148][DESC] = ActionEntry(REDUCE, 147);
   _actionMap[148][ASC] = ActionEntry(REDUCE, 147);
   _actionMap[148][KSEP] = ActionEntry(REDUCE, 147);
   _actionMap[148][ROWLIMIT] = ActionEntry(REDUCE, 147);
   _actionMap[148][UNION] = ActionEntry(REDUCE, 147);
   _actionMap[148][ENDTOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[148][RB] = ActionEntry(REDUCE, 147);
   _actionMap[148][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[148][CONCAT] = ActionEntry(REDUCE, 147);
   _actionMap[148][STAR] = ActionEntry(REDUCE, 147);
   _actionMap[148][DIVISION] = ActionEntry(REDUCE, 147);
   _actionMap[148][MINUS] = ActionEntry(REDUCE, 147);
   _actionMap[148][PLUS] = ActionEntry(REDUCE, 147);
   _actionMap[149][WHEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][ELSE] = ActionEntry(REDUCE, 342);
   _actionMap[149][LEFT] = ActionEntry(REDUCE, 342);
   _actionMap[149][RIGHT] = ActionEntry(REDUCE, 342);
   _actionMap[149][INNER] = ActionEntry(REDUCE, 342);
   _actionMap[149][JOIN] = ActionEntry(REDUCE, 342);
   _actionMap[149][RETURNTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][ORDER] = ActionEntry(REDUCE, 342);
   _actionMap[149][GROUP] = ActionEntry(REDUCE, 342);
   _actionMap[149][WHERE] = ActionEntry(REDUCE, 342);
   _actionMap[149][FROM] = ActionEntry(REDUCE, 342);
   _actionMap[149][AS] = ActionEntry(REDUCE, 342);
}
void Cego::loadParser232()
{
   _actionMap[149][END_TOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][BEGIN] = ActionEntry(REDUCE, 342);
   _actionMap[149][THEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][OR] = ActionEntry(REDUCE, 342);
   _actionMap[149][AND] = ActionEntry(REDUCE, 342);
   _actionMap[149][INTOK] = ActionEntry(REDUCE, 342);
   _actionMap[149][NOT] = ActionEntry(REDUCE, 342);
   _actionMap[149][BETWEEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][IS] = ActionEntry(REDUCE, 342);
   _actionMap[149][LIKE] = ActionEntry(REDUCE, 342);
   _actionMap[149][MT] = ActionEntry(REDUCE, 342);
   _actionMap[149][LT] = ActionEntry(REDUCE, 342);
   _actionMap[149][NEGATION] = ActionEntry(REDUCE, 342);
   _actionMap[149][EQU] = ActionEntry(REDUCE, 342);
   _actionMap[149][RB] = ActionEntry(REDUCE, 342);
   _actionMap[149][ENDTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[149][UNION] = ActionEntry(REDUCE, 342);
   _actionMap[149][ROWLIMIT] = ActionEntry(REDUCE, 342);
   _actionMap[149][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[149][ASC] = ActionEntry(REDUCE, 342);
   _actionMap[149][DESC] = ActionEntry(REDUCE, 342);
   _actionMap[149][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[149][PLUS] = ActionEntry(REDUCE, 342);
   _actionMap[149][MINUS] = ActionEntry(REDUCE, 342);
   _actionMap[149][LB] = ActionEntry(REDUCE, 367);
   _actionMap[149][DIVISION] = ActionEntry(REDUCE, 342);
   _actionMap[149][STAR] = ActionEntry(REDUCE, 342);
   _actionMap[149][CONCAT] = ActionEntry(REDUCE, 342);
   _actionMap[150][STAR] = ActionEntry(SHIFT, 281);
   _actionMap[151][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[151][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[151][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[151][ObjSpec] = 282;
   _actionMap[152][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[152][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[152][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[152][ObjSpec] = 283;
   _actionMap[153][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[153][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[153][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[153][ObjSpec] = 284;
   _actionMap[154][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[154][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[154][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[154][ObjSpec] = 285;
   _actionMap[155][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[155][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[155][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[155][ObjSpec] = 286;
   _actionMap[156][IDENTIFIER] = ActionEntry(SHIFT, 50);
}
void Cego::loadParser233()
{
   _actionMap[156][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[156][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[156][ObjSpec] = 287;
   _actionMap[157][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[157][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[157][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[157][ObjSpec] = 288;
   _actionMap[158][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[158][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[158][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[158][ObjSpec] = 289;
   _actionMap[159][FROM] = ActionEntry(SHIFT, 290);
   _actionMap[160][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[160][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[160][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[160][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[160][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[160][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[160][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[160][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[160][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[160][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[160][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[160][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[160][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[160][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[160][GETPOS] = ActionEntry(SHIFT, 113);
   _actionMap[160][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[160][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[160][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[160][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[160][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[160][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[160][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[160][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[160][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[160][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[160][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[160][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[160][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[160][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[160][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[160][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[160][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[160][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[160][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[160][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[160][LB] = ActionEntry(SHIFT, 142);
   _actionMap[160][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[160][DATE] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser234()
{
   _actionMap[160][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[160][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[160][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[160][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[160][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[160][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[160][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[160][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[160][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[160][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[160][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[160][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[160][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[160][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[160][ObjSpec] = 99;
   _jumpMap[160][Constant] = 98;
   _jumpMap[160][SignedFloat] = 97;
   _jumpMap[160][SignedInt] = 96;
   _jumpMap[160][Attribute] = 95;
   _jumpMap[160][Function] = 94;
   _jumpMap[160][SelectItem] = 293;
   _jumpMap[160][SelectionList] = 292;
   _jumpMap[160][CasePrepare] = 93;
   _jumpMap[160][CaseClause] = 92;
   _jumpMap[160][Factor] = 91;
   _jumpMap[160][Term] = 90;
   _jumpMap[160][Expr] = 291;
   _actionMap[161][VARREF] = ActionEntry(REDUCE, 242);
   _actionMap[161][FETCH] = ActionEntry(REDUCE, 242);
   _actionMap[161][LB] = ActionEntry(REDUCE, 242);
   _actionMap[161][COUNT] = ActionEntry(REDUCE, 242);
   _actionMap[161][SUM] = ActionEntry(REDUCE, 242);
   _actionMap[161][AVG] = ActionEntry(REDUCE, 242);
   _actionMap[161][MIN] = ActionEntry(REDUCE, 242);
   _actionMap[161][MAX] = ActionEntry(REDUCE, 242);
   _actionMap[161][CASE] = ActionEntry(REDUCE, 242);
   _actionMap[161][TRIM] = ActionEntry(REDUCE, 242);
   _actionMap[161][RTRIM] = ActionEntry(REDUCE, 242);
   _actionMap[161][LTRIM] = ActionEntry(REDUCE, 242);
   _actionMap[161][ROUND] = ActionEntry(REDUCE, 242);
   _actionMap[161][DATE2STR] = ActionEntry(REDUCE, 242);
   _actionMap[161][DATE2INT] = ActionEntry(REDUCE, 242);
   _actionMap[161][INT2DATE] = ActionEntry(REDUCE, 242);
   _actionMap[161][LOWER] = ActionEntry(REDUCE, 242);
   _actionMap[161][UPPER] = ActionEntry(REDUCE, 242);
   _actionMap[161][LEFT] = ActionEntry(REDUCE, 242);
   _actionMap[161][RIGHT] = ActionEntry(REDUCE, 242);
   _actionMap[161][GETPOS] = ActionEntry(REDUCE, 242);
   _actionMap[161][SUBSTR] = ActionEntry(REDUCE, 242);
   _actionMap[161][REPLACE] = ActionEntry(REDUCE, 242);
}
void Cego::loadParser235()
{
   _actionMap[161][LENGTH] = ActionEntry(REDUCE, 242);
   _actionMap[161][TRUNC] = ActionEntry(REDUCE, 242);
   _actionMap[161][STR2INT] = ActionEntry(REDUCE, 242);
   _actionMap[161][STR2LONG] = ActionEntry(REDUCE, 242);
   _actionMap[161][STR2DATE] = ActionEntry(REDUCE, 242);
   _actionMap[161][RANDSTR] = ActionEntry(REDUCE, 242);
   _actionMap[161][RANDINT] = ActionEntry(REDUCE, 242);
   _actionMap[161][MOD] = ActionEntry(REDUCE, 242);
   _actionMap[161][DIV] = ActionEntry(REDUCE, 242);
   _actionMap[161][POWER] = ActionEntry(REDUCE, 242);
   _actionMap[161][BITAND] = ActionEntry(REDUCE, 242);
   _actionMap[161][BITOR] = ActionEntry(REDUCE, 242);
   _actionMap[161][BITXOR] = ActionEntry(REDUCE, 242);
   _actionMap[161][NEXTCOUNT] = ActionEntry(REDUCE, 242);
   _actionMap[161][SETCOUNT] = ActionEntry(REDUCE, 242);
   _actionMap[161][IDENTIFIER] = ActionEntry(REDUCE, 242);
   _actionMap[161][QUALIFIEDOBJ] = ActionEntry(REDUCE, 242);
   _actionMap[161][QUALIFIEDTS] = ActionEntry(REDUCE, 242);
   _actionMap[161][QUALIFIEDPRE] = ActionEntry(REDUCE, 242);
   _actionMap[161][STRINGVAL] = ActionEntry(REDUCE, 242);
   _actionMap[161][DATE] = ActionEntry(REDUCE, 242);
   _actionMap[161][SYSDATE] = ActionEntry(REDUCE, 242);
   _actionMap[161][NULLTOKEN] = ActionEntry(REDUCE, 242);
   _actionMap[161][TRUEVAL] = ActionEntry(REDUCE, 242);
   _actionMap[161][FALSEVAL] = ActionEntry(REDUCE, 242);
   _actionMap[161][LAB] = ActionEntry(REDUCE, 242);
   _actionMap[161][FLOATVAL] = ActionEntry(REDUCE, 242);
   _actionMap[161][MINUS] = ActionEntry(REDUCE, 242);
   _actionMap[161][INTVAL] = ActionEntry(REDUCE, 242);
   _actionMap[162][FROM] = ActionEntry(REDUCE, 204);
   _actionMap[163][OFF] = ActionEntry(SHIFT, 294);
   _actionMap[163][ON] = ActionEntry(SHIFT, 295);
   _actionMap[164][OFF] = ActionEntry(SHIFT, 296);
   _actionMap[164][ON] = ActionEntry(SHIFT, 297);
   _actionMap[165][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _jumpMap[165][CounterId] = 298;
   _actionMap[166][IDENTIFIER] = ActionEntry(SHIFT, 299);
   _actionMap[167][OFF] = ActionEntry(SHIFT, 300);
   _actionMap[167][ON] = ActionEntry(SHIFT, 301);
   _actionMap[168][IDENTIFIER] = ActionEntry(SHIFT, 302);
   _actionMap[169][EQU] = ActionEntry(SHIFT, 303);
   _actionMap[170][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[170][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[170][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[170][ObjSpec] = 304;
   _actionMap[171][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[172][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[172][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[172][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[172][ObjSpec] = 305;
}
void Cego::loadParser236()
{
   _actionMap[173][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[174][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[174][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[174][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[174][ObjSpec] = 306;
   _actionMap[175][SEMICOLON] = ActionEntry(REDUCE, 187);
   _actionMap[176][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[177][IDENTIFIER] = ActionEntry(SHIFT, 309);
   _actionMap[177][SET] = ActionEntry(REDUCE, 258);
   _jumpMap[177][UpdDelAlias] = 307;
   _actionMap[178][CALL] = ActionEntry(SHIFT, 310);
   _actionMap[1][TABLE] = ActionEntry(SHIFT, 44);
   _actionMap[1][INDEX] = ActionEntry(SHIFT, 42);
   _actionMap[1][VIEW] = ActionEntry(SHIFT, 45);
   _actionMap[1][PROCEDURE] = ActionEntry(SHIFT, 43);
   _actionMap[1][FOREIGN] = ActionEntry(SHIFT, 41);
   _actionMap[1][CHECK] = ActionEntry(SHIFT, 39);
   _actionMap[1][BTREE] = ActionEntry(SHIFT, 38);
   _actionMap[1][COUNTER] = ActionEntry(SHIFT, 40);
   _actionMap[2][SEMICOLON] = ActionEntry(SHIFT, 46);
   _actionMap[3][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[4][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[5][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[6][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[7][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[8][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[9][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[10][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[11][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[12][TABLE] = ActionEntry(SHIFT, 47);
   _actionMap[13][IDENTIFIER] = ActionEntry(SHIFT, 48);
   _actionMap[14][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[14][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[14][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[14][ObjSpec] = 49;
   _actionMap[15][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[16][SEMICOLON] = ActionEntry(REDUCE, 188);
   _actionMap[17][VIEW] = ActionEntry(SHIFT, 62);
   _actionMap[17][TABLE] = ActionEntry(SHIFT, 60);
   _actionMap[17][PRIMARY] = ActionEntry(SHIFT, 58);
   _actionMap[17][COUNTER] = ActionEntry(SHIFT, 57);
   _actionMap[17][PROCEDURE] = ActionEntry(SHIFT, 59);
   _actionMap[17][UNIQUE] = ActionEntry(SHIFT, 61);
   _actionMap[17][INDEX] = ActionEntry(REDUCE, 184);
   _actionMap[17][BTREE] = ActionEntry(REDUCE, 184);
   _jumpMap[17][IndexOption] = 56;
   _jumpMap[17][ProcDef] = 55;
   _jumpMap[17][ProcHead] = 54;
   _actionMap[18][FROM] = ActionEntry(SHIFT, 63);
   _actionMap[19][TABLE] = ActionEntry(SHIFT, 69);
}
void Cego::loadParser237()
{
   _actionMap[19][INDEX] = ActionEntry(SHIFT, 67);
   _actionMap[19][BTREE] = ActionEntry(SHIFT, 64);
   _actionMap[19][VIEW] = ActionEntry(SHIFT, 70);
   _actionMap[19][FOREIGN] = ActionEntry(SHIFT, 66);
   _actionMap[19][CHECK] = ActionEntry(SHIFT, 65);
   _actionMap[19][PROCEDURE] = ActionEntry(SHIFT, 68);
   _actionMap[20][COUNTER] = ActionEntry(REDUCE, 65);
   _actionMap[20][IF] = ActionEntry(SHIFT, 71);
   _actionMap[20][BTREE] = ActionEntry(REDUCE, 65);
   _actionMap[20][CHECK] = ActionEntry(REDUCE, 65);
   _actionMap[20][FOREIGN] = ActionEntry(REDUCE, 65);
   _actionMap[20][PROCEDURE] = ActionEntry(REDUCE, 65);
   _actionMap[20][VIEW] = ActionEntry(REDUCE, 65);
   _actionMap[20][INDEX] = ActionEntry(REDUCE, 65);
   _actionMap[20][TABLE] = ActionEntry(REDUCE, 65);
   _actionMap[21][INTO] = ActionEntry(SHIFT, 72);
   _actionMap[22][IDENTIFIER] = ActionEntry(SHIFT, 74);
   _jumpMap[22][JdbcArgList] = 73;
   _actionMap[23][TABLESET] = ActionEntry(SHIFT, 83);
   _actionMap[23][TABLE] = ActionEntry(SHIFT, 82);
   _actionMap[23][PROCEDURE] = ActionEntry(SHIFT, 80);
   _actionMap[23][VIEW] = ActionEntry(SHIFT, 85);
   _actionMap[23][INDEX] = ActionEntry(SHIFT, 78);
   _actionMap[23][BTREE] = ActionEntry(SHIFT, 75);
   _actionMap[23][KEY] = ActionEntry(SHIFT, 79);
   _actionMap[23][COUNTER] = ActionEntry(SHIFT, 77);
   _actionMap[23][SYSOBJ] = ActionEntry(SHIFT, 81);
   _actionMap[23][TMPOBJ] = ActionEntry(SHIFT, 84);
   _actionMap[23][CHECK] = ActionEntry(SHIFT, 76);
   _actionMap[24][VIEW] = ActionEntry(SHIFT, 87);
   _actionMap[24][PROCEDURE] = ActionEntry(SHIFT, 59);
   _jumpMap[24][ProcDef] = 86;
   _jumpMap[24][ProcHead] = 54;
   _actionMap[25][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[25][SelectStatement] = 88;
   _actionMap[26][FLOATVAL] = ActionEntry(SHIFT, 146);
   _actionMap[26][MINUS] = ActionEntry(SHIFT, 144);
   _actionMap[26][INTVAL] = ActionEntry(SHIFT, 145);
   _actionMap[26][TRIM] = ActionEntry(SHIFT, 138);
   _actionMap[26][RTRIM] = ActionEntry(SHIFT, 130);
   _actionMap[26][LTRIM] = ActionEntry(SHIFT, 118);
   _actionMap[26][ROUND] = ActionEntry(SHIFT, 129);
   _actionMap[26][DATE2STR] = ActionEntry(SHIFT, 108);
   _actionMap[26][DATE2INT] = ActionEntry(SHIFT, 109);
   _actionMap[26][INT2DATE] = ActionEntry(SHIFT, 114);
   _actionMap[26][LOWER] = ActionEntry(SHIFT, 117);
   _actionMap[26][UPPER] = ActionEntry(SHIFT, 141);
   _actionMap[26][LEFT] = ActionEntry(SHIFT, 115);
   _actionMap[26][RIGHT] = ActionEntry(SHIFT, 128);
   _actionMap[26][GETPOS] = ActionEntry(SHIFT, 113);
}
void Cego::loadParser238()
{
   _actionMap[26][SUBSTR] = ActionEntry(SHIFT, 132);
   _actionMap[26][REPLACE] = ActionEntry(SHIFT, 127);
   _actionMap[26][LENGTH] = ActionEntry(SHIFT, 116);
   _actionMap[26][TRUNC] = ActionEntry(SHIFT, 140);
   _actionMap[26][STR2INT] = ActionEntry(SHIFT, 135);
   _actionMap[26][STR2LONG] = ActionEntry(SHIFT, 136);
   _actionMap[26][STR2DATE] = ActionEntry(SHIFT, 137);
   _actionMap[26][RANDSTR] = ActionEntry(SHIFT, 125);
   _actionMap[26][RANDINT] = ActionEntry(SHIFT, 126);
   _actionMap[26][MOD] = ActionEntry(SHIFT, 121);
   _actionMap[26][DIV] = ActionEntry(SHIFT, 110);
   _actionMap[26][POWER] = ActionEntry(SHIFT, 124);
   _actionMap[26][BITAND] = ActionEntry(SHIFT, 102);
   _actionMap[26][BITOR] = ActionEntry(SHIFT, 103);
   _actionMap[26][BITXOR] = ActionEntry(SHIFT, 104);
   _actionMap[26][NEXTCOUNT] = ActionEntry(SHIFT, 122);
   _actionMap[26][SETCOUNT] = ActionEntry(SHIFT, 131);
   _actionMap[26][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[26][QUALIFIEDOBJ] = ActionEntry(SHIFT, 149);
   _actionMap[26][QUALIFIEDPRE] = ActionEntry(SHIFT, 150);
   _actionMap[26][LB] = ActionEntry(SHIFT, 142);
   _actionMap[26][STRINGVAL] = ActionEntry(SHIFT, 100);
   _actionMap[26][DATE] = ActionEntry(SHIFT, 107);
   _actionMap[26][SYSDATE] = ActionEntry(SHIFT, 134);
   _actionMap[26][NULLTOKEN] = ActionEntry(SHIFT, 123);
   _actionMap[26][TRUEVAL] = ActionEntry(SHIFT, 139);
   _actionMap[26][FALSEVAL] = ActionEntry(SHIFT, 111);
   _actionMap[26][LAB] = ActionEntry(SHIFT, 143);
   _actionMap[26][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _actionMap[26][CASE] = ActionEntry(SHIFT, 105);
   _actionMap[26][VARREF] = ActionEntry(SHIFT, 148);
   _actionMap[26][FETCH] = ActionEntry(SHIFT, 112);
   _actionMap[26][COUNT] = ActionEntry(SHIFT, 106);
   _actionMap[26][SUM] = ActionEntry(SHIFT, 133);
   _actionMap[26][AVG] = ActionEntry(SHIFT, 101);
   _actionMap[26][MIN] = ActionEntry(SHIFT, 119);
   _actionMap[26][MAX] = ActionEntry(SHIFT, 120);
   _jumpMap[26][ObjSpec] = 99;
   _jumpMap[26][Constant] = 98;
   _jumpMap[26][SignedFloat] = 97;
   _jumpMap[26][SignedInt] = 96;
   _jumpMap[26][Attribute] = 95;
   _jumpMap[26][Function] = 94;
   _jumpMap[26][CasePrepare] = 93;
   _jumpMap[26][CaseClause] = 92;
   _jumpMap[26][Factor] = 91;
   _jumpMap[26][Term] = 90;
   _jumpMap[26][Expr] = 89;
   _actionMap[27][TABLE] = ActionEntry(SHIFT, 155);
   _actionMap[27][INDEX] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser239()
{
   _actionMap[27][KEY] = ActionEntry(SHIFT, 153);
   _actionMap[27][PROCEDURE] = ActionEntry(SHIFT, 154);
   _actionMap[27][VIEW] = ActionEntry(SHIFT, 156);
   _actionMap[27][CHECK] = ActionEntry(SHIFT, 151);
   _actionMap[28][TABLE] = ActionEntry(SHIFT, 158);
   _actionMap[28][INDEX] = ActionEntry(SHIFT, 157);
   _actionMap[29][SEMICOLON] = ActionEntry(REDUCE, 189);
   _actionMap[30][DISTINCT] = ActionEntry(SHIFT, 161);
   _actionMap[30][VARREF] = ActionEntry(REDUCE, 243);
   _actionMap[30][FETCH] = ActionEntry(REDUCE, 243);
   _actionMap[30][LB] = ActionEntry(REDUCE, 243);
   _actionMap[30][COUNT] = ActionEntry(REDUCE, 243);
   _actionMap[30][SUM] = ActionEntry(REDUCE, 243);
   _actionMap[30][AVG] = ActionEntry(REDUCE, 243);
   _actionMap[30][MIN] = ActionEntry(REDUCE, 243);
   _actionMap[30][MAX] = ActionEntry(REDUCE, 243);
   _actionMap[30][CASE] = ActionEntry(REDUCE, 243);
   _actionMap[30][TRIM] = ActionEntry(REDUCE, 243);
   _actionMap[30][RTRIM] = ActionEntry(REDUCE, 243);
   _actionMap[30][LTRIM] = ActionEntry(REDUCE, 243);
   _actionMap[30][ROUND] = ActionEntry(REDUCE, 243);
   _actionMap[30][DATE2STR] = ActionEntry(REDUCE, 243);
   _actionMap[30][DATE2INT] = ActionEntry(REDUCE, 243);
   _actionMap[30][INT2DATE] = ActionEntry(REDUCE, 243);
   _actionMap[30][LOWER] = ActionEntry(REDUCE, 243);
   _actionMap[30][UPPER] = ActionEntry(REDUCE, 243);
   _actionMap[30][LEFT] = ActionEntry(REDUCE, 243);
   _actionMap[30][RIGHT] = ActionEntry(REDUCE, 243);
   _actionMap[30][GETPOS] = ActionEntry(REDUCE, 243);
   _actionMap[30][SUBSTR] = ActionEntry(REDUCE, 243);
   _actionMap[30][REPLACE] = ActionEntry(REDUCE, 243);
   _actionMap[30][LENGTH] = ActionEntry(REDUCE, 243);
   _actionMap[30][TRUNC] = ActionEntry(REDUCE, 243);
   _actionMap[30][STR2INT] = ActionEntry(REDUCE, 243);
   _actionMap[30][STR2LONG] = ActionEntry(REDUCE, 243);
   _actionMap[30][STR2DATE] = ActionEntry(REDUCE, 243);
   _actionMap[30][RANDSTR] = ActionEntry(REDUCE, 243);
   _actionMap[30][RANDINT] = ActionEntry(REDUCE, 243);
   _actionMap[30][MOD] = ActionEntry(REDUCE, 243);
   _actionMap[30][DIV] = ActionEntry(REDUCE, 243);
   _actionMap[30][POWER] = ActionEntry(REDUCE, 243);
   _actionMap[30][BITAND] = ActionEntry(REDUCE, 243);
   _actionMap[30][BITOR] = ActionEntry(REDUCE, 243);
   _actionMap[30][BITXOR] = ActionEntry(REDUCE, 243);
   _actionMap[30][NEXTCOUNT] = ActionEntry(REDUCE, 243);
   _actionMap[30][SETCOUNT] = ActionEntry(REDUCE, 243);
   _actionMap[30][IDENTIFIER] = ActionEntry(REDUCE, 243);
   _actionMap[30][QUALIFIEDOBJ] = ActionEntry(REDUCE, 243);
   _actionMap[30][QUALIFIEDTS] = ActionEntry(REDUCE, 243);
   _actionMap[30][QUALIFIEDPRE] = ActionEntry(REDUCE, 243);
}
void Cego::loadParser240()
{
   _actionMap[30][STRINGVAL] = ActionEntry(REDUCE, 243);
   _actionMap[30][DATE] = ActionEntry(REDUCE, 243);
   _actionMap[30][SYSDATE] = ActionEntry(REDUCE, 243);
   _actionMap[30][NULLTOKEN] = ActionEntry(REDUCE, 243);
   _actionMap[30][TRUEVAL] = ActionEntry(REDUCE, 243);
   _actionMap[30][FALSEVAL] = ActionEntry(REDUCE, 243);
   _actionMap[30][LAB] = ActionEntry(REDUCE, 243);
   _actionMap[30][FLOATVAL] = ActionEntry(REDUCE, 243);
   _actionMap[30][MINUS] = ActionEntry(REDUCE, 243);
   _actionMap[30][INTVAL] = ActionEntry(REDUCE, 243);
   _actionMap[30][STAR] = ActionEntry(SHIFT, 162);
   _jumpMap[30][DistinctOpt] = 160;
   _jumpMap[30][Selection] = 159;
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 168);
   _actionMap[31][APPEND] = ActionEntry(SHIFT, 163);
   _actionMap[31][AUTOCOMMIT] = ActionEntry(SHIFT, 164);
   _actionMap[31][ISOLATION] = ActionEntry(SHIFT, 166);
   _actionMap[31][QUERYCACHE] = ActionEntry(SHIFT, 167);
   _actionMap[31][IDENTIFIER] = ActionEntry(SHIFT, 169);
   _actionMap[31][COUNTER] = ActionEntry(SHIFT, 165);
   _actionMap[32][POOL] = ActionEntry(SHIFT, 171);
   _actionMap[32][SYSTEMSPACE] = ActionEntry(SHIFT, 173);
   _actionMap[32][PROCEDURE] = ActionEntry(SHIFT, 172);
   _actionMap[32][VIEW] = ActionEntry(SHIFT, 174);
   _actionMap[32][CHECK] = ActionEntry(SHIFT, 170);
   _actionMap[33][TRANSACTION] = ActionEntry(SHIFT, 175);
   _actionMap[34][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[35][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[35][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[35][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[35][ObjSpec] = 176;
   _actionMap[36][IDENTIFIER] = ActionEntry(SHIFT, 50);
   _actionMap[36][QUALIFIEDOBJ] = ActionEntry(SHIFT, 51);
   _actionMap[36][QUALIFIEDTS] = ActionEntry(SHIFT, 52);
   _jumpMap[36][ObjSpec] = 177;
   _actionMap[37][EQU] = ActionEntry(SHIFT, 178);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 20);
   _actionMap[0][RENAME] = ActionEntry(SHIFT, 27);
   _actionMap[0][ALTER] = ActionEntry(SHIFT, 12);
   _actionMap[0][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[0][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[0][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[0][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[0][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[0][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[0][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 34);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 23);
   _actionMap[0][TABLEINFO] = ActionEntry(SHIFT, 35);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 32);
}
void Cego::loadParser241()
{
   _actionMap[0][DESC] = ActionEntry(SHIFT, 19);
   _actionMap[0][SET] = ActionEntry(SHIFT, 31);
   _actionMap[0][AUTHORIZE] = ActionEntry(SHIFT, 13);
   _actionMap[0][REORGANIZE] = ActionEntry(SHIFT, 28);
   _actionMap[0][PLAN] = ActionEntry(SHIFT, 25);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 17);
   _actionMap[0][LOAD] = ActionEntry(SHIFT, 24);
   _actionMap[0][CALL] = ActionEntry(SHIFT, 14);
   _actionMap[0][VARREF] = ActionEntry(SHIFT, 37);
   _actionMap[0][PRINT] = ActionEntry(SHIFT, 26);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 15);
   _actionMap[0][JDBC] = ActionEntry(SHIFT, 22);
   _jumpMap[0][RenameStatement] = 11;
   _jumpMap[0][AlterStatement] = 10;
   _jumpMap[0][DeleteStatement] = 9;
   _jumpMap[0][UpdateStatement] = 8;
   _jumpMap[0][SelectStatement] = 7;
   _jumpMap[0][InsertStatement] = 6;
   _jumpMap[0][RollbackStatement] = 5;
   _jumpMap[0][CommitStatement] = 4;
   _jumpMap[0][StartStatement] = 3;
   _jumpMap[0][Statement] = 2;
   _jumpMap[0][DropOpt] = 1;
}
void Cego::loadParser242()
{
   _prodInfo.Insert(ProdEntry(368, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(367, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(366, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(365, DateValue, 1));
   _prodInfo.Insert(ProdEntry(364, DateFormat, 1));
   _prodInfo.Insert(ProdEntry(363, Constant, 5));
   _prodInfo.Insert(ProdEntry(362, Constant, 1));
   _prodInfo.Insert(ProdEntry(361, Constant, 1));
   _prodInfo.Insert(ProdEntry(360, Constant, 1));
   _prodInfo.Insert(ProdEntry(359, Constant, 1));
   _prodInfo.Insert(ProdEntry(358, Constant, 6));
   _prodInfo.Insert(ProdEntry(357, Constant, 4));
   _prodInfo.Insert(ProdEntry(356, Constant, 4));
   _prodInfo.Insert(ProdEntry(355, Constant, 4));
   _prodInfo.Insert(ProdEntry(354, Constant, 1));
   _prodInfo.Insert(ProdEntry(353, Constant, 1));
   _prodInfo.Insert(ProdEntry(352, Constant, 4));
   _prodInfo.Insert(ProdEntry(351, Constant, 4));
   _prodInfo.Insert(ProdEntry(350, Constant, 4));
   _prodInfo.Insert(ProdEntry(349, Constant, 4));
   _prodInfo.Insert(ProdEntry(348, Constant, 1));
   _prodInfo.Insert(ProdEntry(347, SignedFloat, 2));
   _prodInfo.Insert(ProdEntry(346, SignedFloat, 1));
   _prodInfo.Insert(ProdEntry(345, SignedInt, 2));
   _prodInfo.Insert(ProdEntry(344, SignedInt, 1));
   _prodInfo.Insert(ProdEntry(343, Attribute, 2));
   _prodInfo.Insert(ProdEntry(342, Attribute, 1));
   _prodInfo.Insert(ProdEntry(341, Attribute, 1));
   _prodInfo.Insert(ProdEntry(340, Comparison, 2));
   _prodInfo.Insert(ProdEntry(339, Comparison, 2));
   _prodInfo.Insert(ProdEntry(338, Comparison, 1));
   _prodInfo.Insert(ProdEntry(337, Comparison, 1));
   _prodInfo.Insert(ProdEntry(336, Comparison, 2));
   _prodInfo.Insert(ProdEntry(335, Comparison, 1));
   _prodInfo.Insert(ProdEntry(334, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(333, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(332, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(331, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(330, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(329, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(328, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(327, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(326, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(325, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(324, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(323, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(322, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(321, QueryPredicate, 2));
   _prodInfo.Insert(ProdEntry(320, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(319, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(318, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(317, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(316, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(315, QueryPredicate, 5));
   _prodInfo.Insert(ProdEntry(314, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(313, QueryPredicate, 6));
   _prodInfo.Insert(ProdEntry(312, QueryPredicate, 5));
   _prodInfo.Insert(ProdEntry(311, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(310, QueryCondition, 1));
   _prodInfo.Insert(ProdEntry(309, QueryCondition, 3));
   _prodInfo.Insert(ProdEntry(308, QueryCondition, 3));
   _prodInfo.Insert(ProdEntry(307, NoWhere, 0));
   _prodInfo.Insert(ProdEntry(306, WhereClause, 1));
   _prodInfo.Insert(ProdEntry(305, WhereClause, 2));
   _prodInfo.Insert(ProdEntry(304, ExpressionList, 1));
   _prodInfo.Insert(ProdEntry(303, ExpressionList, 3));
   _prodInfo.Insert(ProdEntry(302, Function, 3));
   _prodInfo.Insert(ProdEntry(301, Function, 4));
   _prodInfo.Insert(ProdEntry(300, Function, 6));
   _prodInfo.Insert(ProdEntry(299, Function, 4));
   _prodInfo.Insert(ProdEntry(298, Function, 4));
   _prodInfo.Insert(ProdEntry(297, Function, 4));
   _prodInfo.Insert(ProdEntry(296, Function, 4));
   _prodInfo.Insert(ProdEntry(295, Function, 4));
   _prodInfo.Insert(ProdEntry(294, Function, 4));
   _prodInfo.Insert(ProdEntry(293, Function, 4));
   _prodInfo.Insert(ProdEntry(292, Function, 4));
   _prodInfo.Insert(ProdEntry(291, Function, 4));
   _prodInfo.Insert(ProdEntry(290, Function, 4));
   _prodInfo.Insert(ProdEntry(289, Function, 4));
   _prodInfo.Insert(ProdEntry(288, Function, 4));
   _prodInfo.Insert(ProdEntry(287, Function, 4));
   _prodInfo.Insert(ProdEntry(286, Function, 4));
   _prodInfo.Insert(ProdEntry(285, Function, 4));
   _prodInfo.Insert(ProdEntry(284, Function, 4));
   _prodInfo.Insert(ProdEntry(283, Function, 4));
   _prodInfo.Insert(ProdEntry(282, Function, 4));
   _prodInfo.Insert(ProdEntry(281, Function, 4));
   _prodInfo.Insert(ProdEntry(280, Function, 4));
   _prodInfo.Insert(ProdEntry(279, Function, 4));
   _prodInfo.Insert(ProdEntry(278, Function, 4));
   _prodInfo.Insert(ProdEntry(277, Function, 4));
   _prodInfo.Insert(ProdEntry(276, Function, 4));
   _prodInfo.Insert(ProdEntry(275, Function, 4));
   _prodInfo.Insert(ProdEntry(274, Function, 4));
   _prodInfo.Insert(ProdEntry(273, Function, 4));
   _prodInfo.Insert(ProdEntry(272, Function, 4));
   _prodInfo.Insert(ProdEntry(271, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(270, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(269, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(268, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(267, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(266, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(265, AlterOption, 5));
   _prodInfo.Insert(ProdEntry(264, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(263, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(262, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(261, AlterList, 1));
   _prodInfo.Insert(ProdEntry(260, AlterList, 3));
   _prodInfo.Insert(ProdEntry(259, AlterStatement, 4));
   _prodInfo.Insert(ProdEntry(258, UpdDelAlias, 0));
   _prodInfo.Insert(ProdEntry(257, UpdDelAlias, 1));
   _prodInfo.Insert(ProdEntry(256, DeleteStatement, 5));
   _prodInfo.Insert(ProdEntry(255, ReturnVar, 3));
   _prodInfo.Insert(ProdEntry(254, ReturnVarList, 1));
   _prodInfo.Insert(ProdEntry(253, ReturnVarList, 3));
   _prodInfo.Insert(ProdEntry(252, UpdReturnOpt, 0));
   _prodInfo.Insert(ProdEntry(251, UpdReturnOpt, 2));
   _prodInfo.Insert(ProdEntry(250, Assignment, 3));
   _prodInfo.Insert(ProdEntry(249, UpdateList, 1));
   _prodInfo.Insert(ProdEntry(248, UpdateList, 3));
   _prodInfo.Insert(ProdEntry(247, UpdateStatement, 7));
   _prodInfo.Insert(ProdEntry(246, NoLimit, 0));
   _prodInfo.Insert(ProdEntry(245, LimitOpt, 1));
   _prodInfo.Insert(ProdEntry(244, LimitOpt, 2));
   _prodInfo.Insert(ProdEntry(243, DistinctOpt, 0));
   _prodInfo.Insert(ProdEntry(242, DistinctOpt, 1));
   _prodInfo.Insert(ProdEntry(241, DefaultOrderOpt, 0));
   _prodInfo.Insert(ProdEntry(240, DefaultOrderOpt, 1));
   _prodInfo.Insert(ProdEntry(239, OrderingOpt, 1));
   _prodInfo.Insert(ProdEntry(238, OrderingOpt, 1));
   _prodInfo.Insert(ProdEntry(237, OrderingList, 2));
   _prodInfo.Insert(ProdEntry(236, OrderingList, 4));
   _prodInfo.Insert(ProdEntry(235, NoOrdering, 0));
   _prodInfo.Insert(ProdEntry(234, OrderingClause, 1));
   _prodInfo.Insert(ProdEntry(233, OrderingClause, 3));
   _prodInfo.Insert(ProdEntry(232, NoHaving, 0));
   _prodInfo.Insert(ProdEntry(231, HavingClause, 1));
   _prodInfo.Insert(ProdEntry(230, HavingClause, 4));
   _prodInfo.Insert(ProdEntry(229, GroupList, 1));
   _prodInfo.Insert(ProdEntry(228, GroupList, 3));
   _prodInfo.Insert(ProdEntry(227, NoGroup, 0));
   _prodInfo.Insert(ProdEntry(226, GroupClause, 1));
   _prodInfo.Insert(ProdEntry(225, GroupClause, 4));
   _prodInfo.Insert(ProdEntry(224, NoAliasOpt, 0));
   _prodInfo.Insert(ProdEntry(223, AliasOpt, 1));
   _prodInfo.Insert(ProdEntry(222, AliasOpt, 2));
   _prodInfo.Insert(ProdEntry(221, JoinTableOn, 1));
   _prodInfo.Insert(ProdEntry(220, Table, 2));
   _prodInfo.Insert(ProdEntry(219, Table, 1));
   _prodInfo.Insert(ProdEntry(218, TableList, 1));
   _prodInfo.Insert(ProdEntry(217, TableList, 3));
   _prodInfo.Insert(ProdEntry(216, InnerJoin, 1));
   _prodInfo.Insert(ProdEntry(215, InnerJoin, 2));
   _prodInfo.Insert(ProdEntry(214, JoinSpec, 6));
   _prodInfo.Insert(ProdEntry(213, JoinSpec, 6));
   _prodInfo.Insert(ProdEntry(212, JoinSpec, 4));
   _prodInfo.Insert(ProdEntry(211, JoinSpecList, 2));
   _prodInfo.Insert(ProdEntry(210, JoinSpecList, 2));
   _prodInfo.Insert(ProdEntry(209, TableSource, 1));
   _prodInfo.Insert(ProdEntry(208, TableSource, 1));
   _prodInfo.Insert(ProdEntry(207, SelectItem, 2));
   _prodInfo.Insert(ProdEntry(206, SelectionList, 1));
   _prodInfo.Insert(ProdEntry(205, SelectionList, 3));
   _prodInfo.Insert(ProdEntry(204, Selection, 1));
   _prodInfo.Insert(ProdEntry(203, Selection, 2));
   _prodInfo.Insert(ProdEntry(202, SelectStatement, 9));
   _prodInfo.Insert(ProdEntry(201, InsertValueList, 1));
   _prodInfo.Insert(ProdEntry(200, InsertValueList, 3));
   _prodInfo.Insert(ProdEntry(199, InsertArgList, 1));
   _prodInfo.Insert(ProdEntry(198, InsertArgList, 3));
   _prodInfo.Insert(ProdEntry(197, InsertValueSpec, 3));
   _prodInfo.Insert(ProdEntry(196, InsertValueSpecList, 1));
   _prodInfo.Insert(ProdEntry(195, InsertValueSpecList, 3));
   _prodInfo.Insert(ProdEntry(194, InsertPrepare, 1));
   _prodInfo.Insert(ProdEntry(193, InsertArgSpec, 0));
   _prodInfo.Insert(ProdEntry(192, InsertArgSpec, 3));
   _prodInfo.Insert(ProdEntry(191, InsertStatement, 5));
   _prodInfo.Insert(ProdEntry(190, InsertStatement, 6));
   _prodInfo.Insert(ProdEntry(189, RollbackStatement, 1));
   _prodInfo.Insert(ProdEntry(188, CommitStatement, 1));
   _prodInfo.Insert(ProdEntry(187, StartStatement, 2));
   _prodInfo.Insert(ProdEntry(186, IndexType, 1));
   _prodInfo.Insert(ProdEntry(185, IndexType, 1));
   _prodInfo.Insert(ProdEntry(184, IndexOption, 0));
   _prodInfo.Insert(ProdEntry(183, IndexOption, 1));
   _prodInfo.Insert(ProdEntry(182, SimpleAttr, 1));
   _prodInfo.Insert(ProdEntry(181, SimpleAttrList, 1));
   _prodInfo.Insert(ProdEntry(180, SimpleAttrList, 3));
   _prodInfo.Insert(ProdEntry(179, DefaultDefOpt, 0));
   _prodInfo.Insert(ProdEntry(178, DefaultOpt, 1));
   _prodInfo.Insert(ProdEntry(177, DefaultOpt, 2));
   _prodInfo.Insert(ProdEntry(176, DefaultNullOpt, 0));
   _prodInfo.Insert(ProdEntry(175, NullOpt, 1));
   _prodInfo.Insert(ProdEntry(174, NullOpt, 2));
   _prodInfo.Insert(ProdEntry(173, NullOpt, 1));
   _prodInfo.Insert(ProdEntry(172, ColumnDesc, 4));
   _prodInfo.Insert(ProdEntry(171, KeyColumn, 1));
   _prodInfo.Insert(ProdEntry(170, KeyColumn, 2));
   _prodInfo.Insert(ProdEntry(169, ColumnList, 1));
   _prodInfo.Insert(ProdEntry(168, ColumnList, 3));
   _prodInfo.Insert(ProdEntry(167, FetchArgList, 1));
   _prodInfo.Insert(ProdEntry(166, FetchArgList, 3));
   _prodInfo.Insert(ProdEntry(165, CasePrepare, 1));
   _prodInfo.Insert(ProdEntry(164, CaseCondition, 4));
   _prodInfo.Insert(ProdEntry(163, CaseConditionList, 1));
   _prodInfo.Insert(ProdEntry(162, CaseConditionList, 2));
   _prodInfo.Insert(ProdEntry(161, CaseClause, 5));
   _prodInfo.Insert(ProdEntry(160, Factor, 4));
   _prodInfo.Insert(ProdEntry(159, Factor, 4));
   _prodInfo.Insert(ProdEntry(158, Factor, 5));
   _prodInfo.Insert(ProdEntry(157, Factor, 4));
   _prodInfo.Insert(ProdEntry(156, Factor, 4));
   _prodInfo.Insert(ProdEntry(155, Factor, 4));
   _prodInfo.Insert(ProdEntry(154, Factor, 1));
   _prodInfo.Insert(ProdEntry(153, Factor, 3));
   _prodInfo.Insert(ProdEntry(152, Factor, 3));
   _prodInfo.Insert(ProdEntry(151, Factor, 1));
   _prodInfo.Insert(ProdEntry(150, Factor, 1));
   _prodInfo.Insert(ProdEntry(149, Factor, 6));
   _prodInfo.Insert(ProdEntry(148, Factor, 1));
   _prodInfo.Insert(ProdEntry(147, Factor, 1));
   _prodInfo.Insert(ProdEntry(146, Term, 1));
   _prodInfo.Insert(ProdEntry(145, Term, 3));
   _prodInfo.Insert(ProdEntry(144, Term, 3));
   _prodInfo.Insert(ProdEntry(143, Expr, 3));
   _prodInfo.Insert(ProdEntry(142, Expr, 1));
   _prodInfo.Insert(ProdEntry(141, Expr, 3));
   _prodInfo.Insert(ProdEntry(140, Expr, 3));
   _prodInfo.Insert(ProdEntry(139, ProcPredicate, 4));
   _prodInfo.Insert(ProdEntry(138, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(137, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(136, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(135, ProcCondition, 1));
   _prodInfo.Insert(ProdEntry(134, ProcCondition, 3));
   _prodInfo.Insert(ProdEntry(133, ProcCondition, 3));
   _prodInfo.Insert(ProdEntry(132, ProcWhileCondition, 1));
   _prodInfo.Insert(ProdEntry(131, ProcStatement, 5));
   _prodInfo.Insert(ProdEntry(130, ProcElsIfCondition, 1));
   _prodInfo.Insert(ProdEntry(129, ProcIfCondition, 1));
   _prodInfo.Insert(ProdEntry(128, ProcElsePart, 1));
   _prodInfo.Insert(ProdEntry(127, ProcElseOpt, 0));
   _prodInfo.Insert(ProdEntry(126, ProcElseOpt, 2));
   _prodInfo.Insert(ProdEntry(125, ProcElsIfOpt, 4));
   _prodInfo.Insert(ProdEntry(124, ProcElsIfList, 0));
   _prodInfo.Insert(ProdEntry(123, ProcElsIfList, 2));
   _prodInfo.Insert(ProdEntry(122, ProcIfPart, 4));
   _prodInfo.Insert(ProdEntry(121, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(120, ProcExceptionType, 1));
   _prodInfo.Insert(ProdEntry(119, ProcValueList, 1));
   _prodInfo.Insert(ProdEntry(118, ProcValueList, 3));
   _prodInfo.Insert(ProdEntry(117, ProcValueListOpt, 0));
   _prodInfo.Insert(ProdEntry(116, ProcValueListOpt, 1));
   _prodInfo.Insert(ProdEntry(115, ProcExceptionStmt, 5));
   _prodInfo.Insert(ProdEntry(114, ProcExceptionList, 0));
   _prodInfo.Insert(ProdEntry(113, ProcExceptionList, 2));
   _prodInfo.Insert(ProdEntry(112, ProcBlockStart, 1));
   _prodInfo.Insert(ProdEntry(111, ProcStatement, 3));
   _prodInfo.Insert(ProdEntry(110, ProcStatement, 2));
   _prodInfo.Insert(ProdEntry(109, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(108, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(107, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(106, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(105, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(104, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(103, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(102, ProcNoAssignment, 0));
   _prodInfo.Insert(ProdEntry(101, ProcInitialAssignment, 1));
   _prodInfo.Insert(ProdEntry(100, ProcInitialAssignment, 2));
   _prodInfo.Insert(ProdEntry(99, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(98, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(97, ProcStatement, 3));
   _prodInfo.Insert(ProdEntry(96, ProcStatement, 2));
   _prodInfo.Insert(ProdEntry(95, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(94, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(93, ProcStatementList, 2));
   _prodInfo.Insert(ProdEntry(92, ProcStatementList, 3));
   _prodInfo.Insert(ProdEntry(91, ProcStmtBlock, 2));
   _prodInfo.Insert(ProdEntry(90, ProcArg, 3));
   _prodInfo.Insert(ProdEntry(89, ProcArg, 3));
   _prodInfo.Insert(ProdEntry(88, ProcArgList, 1));
   _prodInfo.Insert(ProdEntry(87, ProcArgList, 3));
   _prodInfo.Insert(ProdEntry(86, ProcArgOpt, 0));
   _prodInfo.Insert(ProdEntry(85, ProcArgOpt, 1));
   _prodInfo.Insert(ProdEntry(84, ReturnOpt, 0));
   _prodInfo.Insert(ProdEntry(83, ReturnOpt, 2));
   _prodInfo.Insert(ProdEntry(82, ProcDef, 4));
   _prodInfo.Insert(ProdEntry(81, ProcHead, 6));
   _prodInfo.Insert(ProdEntry(80, UnionAllOpt, 0));
   _prodInfo.Insert(ProdEntry(79, UnionAllOpt, 3));
   _prodInfo.Insert(ProdEntry(78, JdbcArgList, 1));
   _prodInfo.Insert(ProdEntry(77, JdbcArgList, 2));
   _prodInfo.Insert(ProdEntry(76, Statement, 2));
   _prodInfo.Insert(ProdEntry(75, CounterId, 1));
   _prodInfo.Insert(ProdEntry(74, Statement, 5));
   _prodInfo.Insert(ProdEntry(73, Statement, 3));
   _prodInfo.Insert(ProdEntry(72, Statement, 3));
   _prodInfo.Insert(ProdEntry(71, Statement, 3));
   _prodInfo.Insert(ProdEntry(70, Statement, 2));
   _prodInfo.Insert(ProdEntry(69, Statement, 4));
   _prodInfo.Insert(ProdEntry(68, Statement, 8));
   _prodInfo.Insert(ProdEntry(67, Statement, 15));
   _prodInfo.Insert(ProdEntry(66, DropOpt, 3));
   _prodInfo.Insert(ProdEntry(65, DropOpt, 1));
   _prodInfo.Insert(ProdEntry(64, Statement, 3));
   _prodInfo.Insert(ProdEntry(63, Statement, 3));
   _prodInfo.Insert(ProdEntry(62, Statement, 4));
   _prodInfo.Insert(ProdEntry(61, Statement, 3));
   _prodInfo.Insert(ProdEntry(60, Statement, 3));
   _prodInfo.Insert(ProdEntry(59, Statement, 3));
   _prodInfo.Insert(ProdEntry(58, Statement, 3));
   _prodInfo.Insert(ProdEntry(57, Statement, 9));
   _prodInfo.Insert(ProdEntry(56, Statement, 8));
   _prodInfo.Insert(ProdEntry(55, Statement, 6));
   _prodInfo.Insert(ProdEntry(54, Statement, 7));
   _prodInfo.Insert(ProdEntry(53, Statement, 5));
   _prodInfo.Insert(ProdEntry(52, Statement, 2));
   _prodInfo.Insert(ProdEntry(51, Statement, 2));
   _prodInfo.Insert(ProdEntry(50, Statement, 5));
   _prodInfo.Insert(ProdEntry(49, Statement, 5));
   _prodInfo.Insert(ProdEntry(48, Statement, 1));
   _prodInfo.Insert(ProdEntry(47, Statement, 1));
   _prodInfo.Insert(ProdEntry(46, Statement, 1));
   _prodInfo.Insert(ProdEntry(45, Statement, 1));
   _prodInfo.Insert(ProdEntry(44, Statement, 1));
   _prodInfo.Insert(ProdEntry(43, Statement, 2));
   _prodInfo.Insert(ProdEntry(42, Statement, 1));
   _prodInfo.Insert(ProdEntry(41, Statement, 3));
   _prodInfo.Insert(ProdEntry(40, Statement, 3));
   _prodInfo.Insert(ProdEntry(39, Statement, 3));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 3));
   _prodInfo.Insert(ProdEntry(36, Statement, 3));
   _prodInfo.Insert(ProdEntry(35, Statement, 3));
   _prodInfo.Insert(ProdEntry(34, Statement, 3));
   _prodInfo.Insert(ProdEntry(33, Statement, 3));
   _prodInfo.Insert(ProdEntry(32, Statement, 1));
   _prodInfo.Insert(ProdEntry(31, Statement, 1));
   _prodInfo.Insert(ProdEntry(30, Statement, 1));
   _prodInfo.Insert(ProdEntry(29, Statement, 7));
   _prodInfo.Insert(ProdEntry(28, Statement, 3));
   _prodInfo.Insert(ProdEntry(27, Statement, 3));
   _prodInfo.Insert(ProdEntry(26, Statement, 3));
   _prodInfo.Insert(ProdEntry(25, Statement, 3));
   _prodInfo.Insert(ProdEntry(24, Statement, 3));
   _prodInfo.Insert(ProdEntry(23, Statement, 3));
   _prodInfo.Insert(ProdEntry(22, Statement, 4));
   _prodInfo.Insert(ProdEntry(21, Statement, 3));
   _prodInfo.Insert(ProdEntry(20, Statement, 3));
   _prodInfo.Insert(ProdEntry(19, Statement, 3));
   _prodInfo.Insert(ProdEntry(18, Statement, 3));
   _prodInfo.Insert(ProdEntry(17, Statement, 2));
   _prodInfo.Insert(ProdEntry(16, Statement, 2));
   _prodInfo.Insert(ProdEntry(15, Statement, 2));
   _prodInfo.Insert(ProdEntry(14, TableSetOpt, 0));
   _prodInfo.Insert(ProdEntry(13, TableSetOpt, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 3));
   _prodInfo.Insert(ProdEntry(11, Statement, 3));
   _prodInfo.Insert(ProdEntry(10, Statement, 3));
   _prodInfo.Insert(ProdEntry(9, Statement, 3));
   _prodInfo.Insert(ProdEntry(8, Statement, 3));
   _prodInfo.Insert(ProdEntry(7, Statement, 3));
   _prodInfo.Insert(ProdEntry(6, Statement, 3));
   _prodInfo.Insert(ProdEntry(5, Statement, 3));
   _prodInfo.Insert(ProdEntry(4, Statement, 3));
   _prodInfo.Insert(ProdEntry(3, Statement, 3));
   _prodInfo.Insert(ProdEntry(2, Statement, 2));
   _prodInfo.Insert(ProdEntry(1, Statement, 1));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

Cego::Cego()
{
   loadScanner();
   for ( int i=0; i < 831; i++)
   {
      int j;
      for ( j = 0; j < 178; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 117; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   loadParser15();
   loadParser16();
   loadParser17();
   loadParser18();
   loadParser19();
   loadParser20();
   loadParser21();
   loadParser22();
   loadParser23();
   loadParser24();
   loadParser25();
   loadParser26();
   loadParser27();
   loadParser28();
   loadParser29();
   loadParser30();
   loadParser31();
   loadParser32();
   loadParser33();
   loadParser34();
   loadParser35();
   loadParser36();
   loadParser37();
   loadParser38();
   loadParser39();
   loadParser40();
   loadParser41();
   loadParser42();
   loadParser43();
   loadParser44();
   loadParser45();
   loadParser46();
   loadParser47();
   loadParser48();
   loadParser49();
   loadParser50();
   loadParser51();
   loadParser52();
   loadParser53();
   loadParser54();
   loadParser55();
   loadParser56();
   loadParser57();
   loadParser58();
   loadParser59();
   loadParser60();
   loadParser61();
   loadParser62();
   loadParser63();
   loadParser64();
   loadParser65();
   loadParser66();
   loadParser67();
   loadParser68();
   loadParser69();
   loadParser70();
   loadParser71();
   loadParser72();
   loadParser73();
   loadParser74();
   loadParser75();
   loadParser76();
   loadParser77();
   loadParser78();
   loadParser79();
   loadParser80();
   loadParser81();
   loadParser82();
   loadParser83();
   loadParser84();
   loadParser85();
   loadParser86();
   loadParser87();
   loadParser88();
   loadParser89();
   loadParser90();
   loadParser91();
   loadParser92();
   loadParser93();
   loadParser94();
   loadParser95();
   loadParser96();
   loadParser97();
   loadParser98();
   loadParser99();
   loadParser100();
   loadParser101();
   loadParser102();
   loadParser103();
   loadParser104();
   loadParser105();
   loadParser106();
   loadParser107();
   loadParser108();
   loadParser109();
   loadParser110();
   loadParser111();
   loadParser112();
   loadParser113();
   loadParser114();
   loadParser115();
   loadParser116();
   loadParser117();
   loadParser118();
   loadParser119();
   loadParser120();
   loadParser121();
   loadParser122();
   loadParser123();
   loadParser124();
   loadParser125();
   loadParser126();
   loadParser127();
   loadParser128();
   loadParser129();
   loadParser130();
   loadParser131();
   loadParser132();
   loadParser133();
   loadParser134();
   loadParser135();
   loadParser136();
   loadParser137();
   loadParser138();
   loadParser139();
   loadParser140();
   loadParser141();
   loadParser142();
   loadParser143();
   loadParser144();
   loadParser145();
   loadParser146();
   loadParser147();
   loadParser148();
   loadParser149();
   loadParser150();
   loadParser151();
   loadParser152();
   loadParser153();
   loadParser154();
   loadParser155();
   loadParser156();
   loadParser157();
   loadParser158();
   loadParser159();
   loadParser160();
   loadParser161();
   loadParser162();
   loadParser163();
   loadParser164();
   loadParser165();
   loadParser166();
   loadParser167();
   loadParser168();
   loadParser169();
   loadParser170();
   loadParser171();
   loadParser172();
   loadParser173();
   loadParser174();
   loadParser175();
   loadParser176();
   loadParser177();
   loadParser178();
   loadParser179();
   loadParser180();
   loadParser181();
   loadParser182();
   loadParser183();
   loadParser184();
   loadParser185();
   loadParser186();
   loadParser187();
   loadParser188();
   loadParser189();
   loadParser190();
   loadParser191();
   loadParser192();
   loadParser193();
   loadParser194();
   loadParser195();
   loadParser196();
   loadParser197();
   loadParser198();
   loadParser199();
   loadParser200();
   loadParser201();
   loadParser202();
   loadParser203();
   loadParser204();
   loadParser205();
   loadParser206();
   loadParser207();
   loadParser208();
   loadParser209();
   loadParser210();
   loadParser211();
   loadParser212();
   loadParser213();
   loadParser214();
   loadParser215();
   loadParser216();
   loadParser217();
   loadParser218();
   loadParser219();
   loadParser220();
   loadParser221();
   loadParser222();
   loadParser223();
   loadParser224();
   loadParser225();
   loadParser226();
   loadParser227();
   loadParser228();
   loadParser229();
   loadParser230();
   loadParser231();
   loadParser232();
   loadParser233();
   loadParser234();
   loadParser235();
   loadParser236();
   loadParser237();
   loadParser238();
   loadParser239();
   loadParser240();
   loadParser241();
   loadParser242();
   _isReserved = false;
}

Cego::~Cego()
{
}

void Cego::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 368:
                     setObject3();
                     break;
                  case 367:
                     setObject2();
                     break;
                  case 366:
                     setObject1();
                     break;
                  case 365:
                     miscDateValue();
                     break;
                  case 364:
                     miscDateFormat();
                     break;
                  case 363:
                     miscBlobRef();
                     break;
                  case 362:
                     miscFalseValue();
                     break;
                  case 361:
                     miscTrueValue();
                     break;
                  case 360:
                     miscNull();
                     break;
                  case 359:
                     miscSysDate();
                     break;
                  case 358:
                     miscFormatDate();
                     break;
                  case 357:
                     miscFixedValue();
                     break;
                  case 356:
                     miscDecimalValue();
                     break;
                  case 355:
                     miscDoubleValue();
                     break;
                  case 354:
                     miscFloatValue();
                     break;
                  case 353:
                     miscStringValue();
                     break;
                  case 352:
                     miscTinyIntValue();
                     break;
                  case 351:
                     miscSmallIntValue();
                     break;
                  case 350:
                     miscBigIntValue();
                     break;
                  case 349:
                     miscLongValue();
                     break;
                  case 348:
                     miscIntValue();
                     break;
                  case 347:
                     miscNegatedFloatString();
                     break;
                  case 346:
                     miscFloatString();
                     break;
                  case 345:
                     miscNegatedIntString();
                     break;
                  case 344:
                     miscIntString();
                     break;
                  case 343:
                     miscAttribute3();
                     break;
                  case 342:
                     miscAttribute2();
                     break;
                  case 341:
                     miscAttribute1();
                     break;
                  case 340:
                     miscMoreEqualComp();
                     break;
                  case 339:
                     miscLessEqualComp();
                     break;
                  case 338:
                     miscMoreComp();
                     break;
                  case 337:
                     miscLessComp();
                     break;
                  case 336:
                     miscNotEqualComp();
                     break;
                  case 335:
                     miscEqualComp();
                     break;
                  case 334:
                     miscBlobType();
                     break;
                  case 333:
                     miscFixedType();
                     break;
                  case 332:
                     miscDecimalType();
                     break;
                  case 331:
                     miscTinyIntType();
                     break;
                  case 330:
                     miscSmallIntType();
                     break;
                  case 329:
                     miscDoubleType();
                     break;
                  case 328:
                     miscFloatType();
                     break;
                  case 327:
                     miscBigIntType();
                     break;
                  case 326:
                     miscBoolType();
                     break;
                  case 325:
                     miscDateTimeType();
                     break;
                  case 324:
                     miscStringType();
                     break;
                  case 323:
                     miscLongType();
                     break;
                  case 322:
                     miscIntType();
                     break;
                  case 321:
                     wcPredicateNotPredicate();
                     break;
                  case 320:
                     wcPredicateCondition();
                     break;
                  case 319:
                     wcPredicateNotLikeComp();
                     break;
                  case 318:
                     wcPredicateLikeComp();
                     break;
                  case 317:
                     wcPredicateNotNullComp();
                     break;
                  case 316:
                     wcPredicateNullComp();
                     break;
                  case 315:
                     wcPredicateBetween();
                     break;
                  case 314:
                     wcPredicateExprComp();
                     break;
                  case 313:
                     wcPredicateQueryNotIn();
                     break;
                  case 312:
                     wcPredicateQueryIn();
                     break;
                  case 311:
                     wcPredicateQueryExists();
                     break;
                  case 310:
                     wcConditionPredicate();
                     break;
                  case 309:
                     wcConditionOr();
                     break;
                  case 308:
                     wcConditionAnd();
                     break;
                  case 306:
                     wcEmptyClause();
                     break;
                  case 305:
                     wcWhereClause();
                     break;
                  case 304:
                     functionExprList2();
                     break;
                  case 303:
                     functionExprList1();
                     break;
                  case 302:
                     functionUserDef2();
                     break;
                  case 301:
                     functionUserDef1();
                     break;
                  case 300:
                     functionSetCount();
                     break;
                  case 299:
                     functionNextCount();
                     break;
                  case 298:
                     functionNative();
                     break;
                  case 297:
                     functionNative();
                     break;
                  case 296:
                     functionNative();
                     break;
                  case 295:
                     functionNative();
                     break;
                  case 294:
                     functionNative();
                     break;
                  case 293:
                     functionNative();
                     break;
                  case 292:
                     functionNative();
                     break;
                  case 291:
                     functionNative();
                     break;
                  case 290:
                     functionNative();
                     break;
                  case 289:
                     functionNative();
                     break;
                  case 288:
                     functionNative();
                     break;
                  case 287:
                     functionNative();
                     break;
                  case 286:
                     functionNative();
                     break;
                  case 285:
                     functionNative();
                     break;
                  case 284:
                     functionNative();
                     break;
                  case 283:
                     functionNative();
                     break;
                  case 282:
                     functionNative();
                     break;
                  case 281:
                     functionNative();
                     break;
                  case 280:
                     functionNative();
                     break;
                  case 279:
                     functionNative();
                     break;
                  case 278:
                     functionNative();
                     break;
                  case 277:
                     functionNative();
                     break;
                  case 276:
                     functionNative();
                     break;
                  case 275:
                     functionNative();
                     break;
                  case 274:
                     functionNative();
                     break;
                  case 273:
                     functionNative();
                     break;
                  case 272:
                     functionNative();
                     break;
                  case 271:
                     renameCheck();
                     break;
                  case 270:
                     renameView();
                     break;
                  case 269:
                     renameProcedure();
                     break;
                  case 268:
                     renameKey();
                     break;
                  case 267:
                     renameIndex();
                     break;
                  case 266:
                     renameTable();
                     break;
                  case 265:
                     alterRenameCol();
                     break;
                  case 264:
                     alterModCol();
                     break;
                  case 263:
                     alterAddCol();
                     break;
                  case 262:
                     alterDropCol();
                     break;
                  case 259:
                     alterStore();
                     break;
                  case 257:
                     setUpdDelAlias();
                     break;
                  case 256:
                     deleteStore();
                     break;
                  case 255:
                     returnVarAssignment();
                     break;
                  case 250:
                     updateAssignment();
                     break;
                  case 247:
                     updateStore();
                     break;
                  case 245:
                     selectLimitOpt2();
                     break;
                  case 244:
                     selectLimitOpt1();
                     break;
                  case 242:
                     selectDistinctOpt();
                     break;
                  case 239:
                     selectOrderingDesc();
                     break;
                  case 238:
                     selectOrderingAsc();
                     break;
                  case 237:
                     selectOrderingList2();
                     break;
                  case 236:
                     selectOrderingList1();
                     break;
                  case 234:
                     selectEmptyOrderingClause();
                     break;
                  case 233:
                     selectOrderingClause();
                     break;
                  case 231:
                     selectEmptyHavingClause();
                     break;
                  case 230:
                     selectHavingClause();
                     break;
                  case 229:
                     selectGroupList2();
                     break;
                  case 228:
                     selectGroupList1();
                     break;
                  case 226:
                     selectEmptyGroupClause();
                     break;
                  case 225:
                     selectGroupClause();
                     break;
                  case 223:
                     noAliasOpt();
                     break;
                  case 222:
                     aliasOpt();
                     break;
                  case 221:
                     selectStackJoinTable();
                     break;
                  case 220:
                     selectTable2();
                     break;
                  case 219:
                     selectTable1();
                     break;
                  case 214:
                     selectRightOuterJoinStore();
                     break;
                  case 213:
                     selectLeftOuterJoinStore();
                     break;
                  case 212:
                     selectInnerJoinStore();
                     break;
                  case 209:
                     selectJoinSpecStore();
                     break;
                  case 208:
                     selectTableListStore();
                     break;
                  case 207:
                     selectItem();
                     break;
                  case 206:
                     selectionList2();
                     break;
                  case 205:
                     selectionList1();
                     break;
                  case 204:
                     selectSelectionStore2();
                     break;
                  case 203:
                     selectSelectionStore1();
                     break;
                  case 202:
                     selectStore();
                     break;
                  case 201:
                     insertExprValue();
                     break;
                  case 200:
                     insertExprValue();
                     break;
                  case 199:
                     insertArg();
                     break;
                  case 198:
                     insertArg();
                     break;
                  case 197:
                     insertValueSpecStoreExecute();
                     break;
                  case 194:
                     insertPrepare();
                     break;
                  case 191:
                     insertBySelectStore();
                     break;
                  case 190:
                     insertStore();
                     break;
                  case 189:
                     rollbackStore();
                     break;
                  case 188:
                     commitStore();
                     break;
                  case 187:
                     startStore();
                     break;
                  case 186:
                     setBTreeIndex();
                     break;
                  case 185:
                     setAVLIndex();
                     break;
                  case 183:
                     setUniqueIndex();
                     break;
                  case 182:
                     createSimpleAttr();
                     break;
                  case 181:
                     createSimpleAttrList();
                     break;
                  case 178:
                     defaultNullOpt();
                     break;
                  case 177:
                     defaultOpt();
                     break;
                  case 175:
                     setNullOpt();
                     break;
                  case 174:
                     setNotNullOpt();
                     break;
                  case 173:
                     setNullOpt();
                     break;
                  case 172:
                     setColumnDesc();
                     break;
                  case 171:
                     setOrdinaryColumn();
                     break;
                  case 170:
                     setPrimaryColumn();
                     break;
                  case 167:
                     procStoreFetchArg2();
                     break;
                  case 166:
                     procStoreFetchArg1();
                     break;
                  case 165:
                     casePrepare();
                     break;
                  case 164:
                     caseCondition();
                     break;
                  case 163:
                     caseConditionList2();
                     break;
                  case 162:
                     caseConditionList1();
                     break;
                  case 161:
                     caseClause();
                     break;
                  case 160:
                     procFactor14();
                     break;
                  case 159:
                     procFactor13();
                     break;
                  case 158:
                     procFactor12();
                     break;
                  case 157:
                     procFactor11();
                     break;
                  case 156:
                     procFactor10();
                     break;
                  case 155:
                     procFactor9();
                     break;
                  case 154:
                     procFactor8();
                     break;
                  case 153:
                     procFactor7();
                     break;
                  case 152:
                     procFactor6();
                     break;
                  case 151:
                     procFactor5();
                     break;
                  case 150:
                     procFactor4();
                     break;
                  case 149:
                     procFactor3();
                     break;
                  case 148:
                     procFactor2();
                     break;
                  case 147:
                     procFactor1();
                     break;
                  case 146:
                     procTerm3();
                     break;
                  case 145:
                     procTerm2();
                     break;
                  case 144:
                     procTerm1();
                     break;
                  case 143:
                     procExpr4();
                     break;
                  case 142:
                     procExpr3();
                     break;
                  case 141:
                     procExpr2();
                     break;
                  case 140:
                     procExpr1();
                     break;
                  case 139:
                     procPredicate4();
                     break;
                  case 138:
                     procPredicate3();
                     break;
                  case 137:
                     procPredicate2();
                     break;
                  case 136:
                     procPredicate1();
                     break;
                  case 135:
                     procCondition3();
                     break;
                  case 134:
                     procCondition2();
                     break;
                  case 133:
                     procCondition1();
                     break;
                  case 132:
                     procWhileCondition();
                     break;
                  case 131:
                     procWhileStatement();
                     break;
                  case 130:
                     procElsIfCondition();
                     break;
                  case 129:
                     procIfCondition();
                     break;
                  case 128:
                     procElsePart();
                     break;
                  case 126:
                     procStoreElseBlock();
                     break;
                  case 125:
                     procStoreIfBlock();
                     break;
                  case 122:
                     procStoreIfBlock();
                     break;
                  case 121:
                     procIfStatement();
                     break;
                  case 120:
                     procExceptionCondition();
                     break;
                  case 119:
                     procExprValue();
                     break;
                  case 118:
                     procExprValue();
                     break;
                  case 116:
                     procValueSpec();
                     break;
                  case 115:
                     procExceptionStatement();
                     break;
                  case 112:
                     procBlockStart();
                     break;
                  case 111:
                     procBlockStatement();
                     break;
                  case 110:
                     procReturnStatement2();
                     break;
                  case 109:
                     procReturnStatement1();
                     break;
                  case 108:
                     procQueryStatement();
                     break;
                  case 107:
                     procQueryStatement();
                     break;
                  case 106:
                     procQueryStatement();
                     break;
                  case 105:
                     procQueryStatement();
                     break;
                  case 104:
                     procQueryStatement();
                     break;
                  case 103:
                     procQueryStatement();
                     break;
                  case 101:
                     procInitialAssignment2();
                     break;
                  case 100:
                     procInitialAssignment1();
                     break;
                  case 99:
                     procNoopStatement();
                     break;
                  case 98:
                     procAssign2NullStatement();
                     break;
                  case 97:
                     procAssignStatement();
                     break;
                  case 96:
                     procCursorCloseStatement();
                     break;
                  case 95:
                     procCursorCreateStatement();
                     break;
                  case 94:
                     procVarStatement();
                     break;
                  case 93:
                     procStoreBlock();
                     break;
                  case 90:
                     procArg2();
                     break;
                  case 89:
                     procArg1();
                     break;
                  case 83:
                     procReturnOpt();
                     break;
                  case 82:
                     procStore();
                     break;
                  case 81:
                     procHead();
                     break;
                  case 79:
                     unionAllStore();
                     break;
                  case 78:
                     jdbcArg2();
                     break;
                  case 77:
                     jdbcArg1();
                     break;
                  case 76:
                     jdbcInfo();
                     break;
                  case 75:
                     execCounterId();
                     break;
                  case 74:
                     execSetCounter();
                     break;
                  case 73:
                     execDropCounter();
                     break;
                  case 72:
                     execCreateCounter();
                     break;
                  case 71:
                     execIndexCheck();
                     break;
                  case 70:
                     execPrint();
                     break;
                  case 69:
                     execAssignStatement();
                     break;
                  case 68:
                     execCheckCreate();
                     break;
                  case 67:
                     execForeignKeyCreate();
                     break;
                  case 66:
                     dropOpt2();
                     break;
                  case 65:
                     dropOpt1();
                     break;
                  case 64:
                     execBTreeDrop();
                     break;
                  case 63:
                     execCheckDrop();
                     break;
                  case 62:
                     execFKeyDrop();
                     break;
                  case 61:
                     execProcDrop();
                     break;
                  case 60:
                     execViewDrop();
                     break;
                  case 59:
                     execIndexDrop();
                     break;
                  case 58:
                     execTableDrop();
                     break;
                  case 57:
                     execIndexCreate();
                     break;
                  case 56:
                     execPrimaryIndexCreate();
                     break;
                  case 55:
                     execUserTableCreate();
                     break;
                  case 54:
                     execFuncCall();
                     break;
                  case 53:
                     execProcCall();
                     break;
                  case 52:
                     execProcLoad();
                     break;
                  case 51:
                     execProcCreate();
                     break;
                  case 50:
                     execViewLoad();
                     break;
                  case 49:
                     execViewCreate();
                     break;
                  case 48:
                     execQuery();
                     break;
                  case 47:
                     execQuery();
                     break;
                  case 46:
                     execQuery();
                     break;
                  case 45:
                     execQuery();
                     break;
                  case 43:
                     execSelectPlan();
                     break;
                  case 42:
                     execSelect();
                     break;
                  case 41:
                     execIndexReorganize();
                     break;
                  case 40:
                     execTableReorganize();
                     break;
                  case 39:
                     execDisableQueryCache();
                     break;
                  case 38:
                     execEnableQueryCache();
                     break;
                  case 37:
                     execSetIsolation();
                     break;
                  case 36:
                     execDisableAutoCommit();
                     break;
                  case 35:
                     execEnableAutoCommit();
                     break;
                  case 34:
                     execDisableAppendMode();
                     break;
                  case 33:
                     execEnableAppendMode();
                     break;
                  case 32:
                     execQuery();
                     break;
                  case 31:
                     execQuery();
                     break;
                  case 30:
                     execQuery();
                     break;
                  case 29:
                     execAuthUser();
                     break;
                  case 28:
                     execSetTableSet();
                     break;
                  case 27:
                     execCheckShow();
                     break;
                  case 26:
                     execViewShow();
                     break;
                  case 25:
                     execProcShow();
                     break;
                  case 24:
                     execProcDesc();
                     break;
                  case 23:
                     execCheckDesc();
                     break;
                  case 22:
                     execKeyDesc();
                     break;
                  case 21:
                     execViewDesc();
                     break;
                  case 20:
                     execBTreeDesc();
                     break;
                  case 19:
                     execIndexDesc();
                     break;
                  case 18:
                     execTableDesc();
                     break;
                  case 17:
                     execShowSystemSpace();
                     break;
                  case 16:
                     execShowPool();
                     break;
                  case 15:
                     execTableInfo();
                     break;
                  case 13:
                     setTableSetOpt();
                     break;
                  case 12:
                     execListCheck();
                     break;
                  case 11:
                     execListTmpObj();
                     break;
                  case 10:
                     execListSysObj();
                     break;
                  case 9:
                     execListCounter();
                     break;
                  case 8:
                     execListKey();
                     break;
                  case 7:
                     execListBTree();
                     break;
                  case 6:
                     execListIndex();
                     break;
                  case 5:
                     execListView();
                     break;
                  case 4:
                     execListProc();
                     break;
                  case 3:
                     execListTable();
                     break;
                  case 2:
                     execListTableSet();
                     break;
                  case 1:
                     execSync();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               return;
            }
            default:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool Cego::getAction(int state, Cego::Token token, Cego::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool Cego::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool Cego::isSepSign(char c)
{
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   if (c == '*') return true;
   return false;
}
bool Cego::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   if (c == '\n') return true;
   return false;
}
bool Cego::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void Cego::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
