#ifndef _CEGOAVLINDEXCURSOR_H_INCLUDED_
#define _CEGOAVLINDEXCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAVLIndexCursor.h
// -----------------
// Cego AVL index cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAVLIndexCursor
// 
// Description: Traversing through index
//
// Status: QG-2.13
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoObject.h"
#include "CegoField.h"
#include "CegoAttrCond.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoQueryHelper.h"
#include "CegoAVLIndexEntry.h"

class CegoAVLIndexCursor {
    
public:
    
    CegoAVLIndexCursor();
    CegoAVLIndexCursor(CegoTableManager* pTM, int tabSetId, const Chain& indexName, CegoObject::ObjectType type, CegoAttrCond* pAttrCond, bool ignoreTouched, bool readUncommitted);
    ~CegoAVLIndexCursor();
    
    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);
    
    void reset();	
    void abort();
    
private:

    CegoComparison compValue(char* idxVal);
    
    CegoAttrCond* _pAttrCond;

    CegoTableManager* _pTM;
    CegoAVLIndexEntry _ie;
    CegoDataPointer _rdp;
    CegoDataPointer _idp;

    Chain _indexName;
    CegoObject::ObjectType _type;
    bool _rootPassed;
    
    unsigned long _rdpLockId;
    unsigned long _lockId;
    unsigned long _dataLock;

    int _tabSetId;

    bool _ignoreTouched;
    bool _readUncommitted;

    CegoQueryHelper _qh;

    bool _cursorCached;
    bool _eoc;

    int _cachedLen;
    char* _cachedPointer;

    CegoDataType _dt;
    ListT<CegoField> _idxSchema;
};

#endif




