#ifndef _CEGOAVLINDEXENTRY_H_INCLUDED_
#define _CEGOAVLINDEXENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAVLIndexEntry.h
// ----------------
// AVL Index entry class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAVLIndexEntry
// 
// Description: For any kind of index object, IndexEntry objects are used as row elements
//              to refer to further entries ( parent, left, right )
//              Cego index object provide full balancing on node level, so the index entry provides
//              the required information for the balancing algorithm 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoDataPointer.h"

class CegoAVLIndexEntry {

 public:
    
    CegoAVLIndexEntry();
    CegoAVLIndexEntry(int tid);
    ~CegoAVLIndexEntry();
    
    void initEntry(const CegoDataPointer& dp, char* p = 0, int len = 0);

    void setPtr(void* p, int len);
    void* getPtr();
    int getLen() const;
    
    void setParent(const CegoDataPointer& dp);
    CegoDataPointer getParent() const;

    void setLeftBranch(const CegoDataPointer& dp);
    CegoDataPointer getLeftBranch() const;

    void setRightBranch(const CegoDataPointer& dp);
    CegoDataPointer getRightBranch() const;

    void setHeight(char h);
    char getHeight() const;

    void setData(const CegoDataPointer& dp);
    CegoDataPointer getData() const;

    void setTID(int tid);
    int getTID() const;
        
    char* getIdxPtr();
    int getIdxLen();

    CegoAVLIndexEntry& operator = (const CegoAVLIndexEntry& ie);
    
 private:
    
    void* _pI;
    int _len;
    bool _isLocal;
    int _tid;
    char* _idxDataPtr;
};

#endif
