//
// File: CegoAdm.cc
// This code was produced by the dragon parser generator
//
#include "CegoAdm.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

CegoAdm::ScannerStateEntry::ScannerStateEntry()
{
}

CegoAdm::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

CegoAdm::ScannerStateEntry& CegoAdm::ScannerStateEntry::operator = (const CegoAdm::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool CegoAdm::ScannerStateEntry::operator == (const CegoAdm::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

CegoAdm::ScannerStateType CegoAdm::ScannerStateEntry::getType()
{
   return _type;
}
int CegoAdm::ScannerStateEntry::getState()
{
   return _state;
}


CegoAdm::ScannerTransEntry::ScannerTransEntry()
{
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

CegoAdm::ScannerTransEntry& CegoAdm::ScannerTransEntry::operator = (const CegoAdm::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool CegoAdm::ScannerTransEntry::operator == (const CegoAdm::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int CegoAdm::ScannerTransEntry::getFState()
{
   return _fstate;
}


CegoAdm::Scanner::Scanner()
{
}


CegoAdm::Scanner::Scanner(Token t)
{
   _token = t;
}

CegoAdm::Token CegoAdm::Scanner::getToken()
{
   return _token;
}

void CegoAdm::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void CegoAdm::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool CegoAdm::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
CegoAdm::StackEntry::StackEntry()
{
   _symbol = NONE;
}

CegoAdm::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

CegoAdm::StackEntry& CegoAdm::StackEntry::operator = (const CegoAdm::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int CegoAdm::StackEntry::getState()
{
   return _state;
}
CegoAdm::Symbol CegoAdm::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& CegoAdm::StackEntry::getTval()
{
   return _tval;
}

CegoAdm::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

CegoAdm::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool CegoAdm::ActionEntry::operator == (const CegoAdm::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

CegoAdm::ActionEntry& CegoAdm::ActionEntry::operator = (const CegoAdm::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

CegoAdm::Action CegoAdm::ActionEntry::getAction()
{
   return _action;
}

int CegoAdm::ActionEntry::getNum()
{
   return _num;
}

CegoAdm::ProdEntry::ProdEntry()
{
}

CegoAdm::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

CegoAdm::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool CegoAdm::ProdEntry::operator == (const CegoAdm::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

CegoAdm::ProdEntry& CegoAdm::ProdEntry::operator = (const CegoAdm::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int CegoAdm::ProdEntry::getId()
{
   return _id;
}

CegoAdm::Production CegoAdm::ProdEntry::getProd()
{
   return _prod;
}

int CegoAdm::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void CegoAdm::loadScanner()
{
   Scanner s0(ABORT);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(5 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s0.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s0.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s0);

   Scanner s1(ADD);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ADM);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(ARCHLOG);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(7 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s3.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s3.addTransition(ScannerTransEntry(6 ,'g' ,7));
   _scannerList.Insert(s3);

   Scanner s4(ASSIGN);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s4);

   Scanner s5(BACKUP);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(6 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s5.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s5);

   Scanner s6(BEGIN_TOKEN);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s6);

   Scanner s7(BINARY);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s7);

   Scanner s8(BUFILE);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s8);

   Scanner s9(BUSTAT);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s9);

   Scanner s10(TSTICKET);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(8 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'k' ,6));
   s10.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s10.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s10);

   Scanner s11(BY);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,FINAL));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s11);

   Scanner s12(CHECK);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s12);

   Scanner s13(CHECKPOINT);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(10 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s13.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s13.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s13.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s13.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s13);

   Scanner s14(CLEANUP);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(7 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s14.addTransition(ScannerTransEntry(6 ,'p' ,7));
   _scannerList.Insert(s14);

   Scanner s15(CLOSE);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s15);

   Scanner s16(CONNECT);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(7 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s16.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s16);

   Scanner s17(COPY);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'y' ,4));
   _scannerList.Insert(s17);

   Scanner s18(CORRECT);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(7 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s18.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s18);

   Scanner s19(CREATE);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(6 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s19.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s19);

   Scanner s20(DATAFILE);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(8 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s20.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s20.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s20);

   Scanner s21(DB);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,FINAL));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s21.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s21);

   Scanner s22(DEFINE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s22);

   Scanner s23(DISABLE);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(7 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s23.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s23);

   Scanner s24(DROP);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s24);

   Scanner s25(DUMP);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s25);

   Scanner s26(ENABLE);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(6 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s26.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s26.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s26);

   Scanner s27(END_TOKEN);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s27);

   Scanner s28(EXPORT);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s28);

   Scanner s29(FILE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s29);

   Scanner s30(FILTER);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(6 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s30.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s30);

   Scanner s31(FOR);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s31);

   Scanner s32(FORCELOAD);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(9 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s32.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s32);

   Scanner s33(FROM);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s33);

   Scanner s34(GETDBSPEC);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(9 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'p' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s34.addTransition(ScannerTransEntry(8 ,'c' ,9));
   _scannerList.Insert(s34);

   Scanner s35(GETTSLIST);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(9 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s35.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s35.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s35.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s35.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s35);

   Scanner s36(GETNODELIST);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(11 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s36.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s36.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s36.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s36.addTransition(ScannerTransEntry(9 ,'s' ,10));
   s36.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s36);

   Scanner s37(GETDBINFO);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(9 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s37.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s37.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s37.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s37);

   Scanner s38(IMPORT);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s38);

   Scanner s39(INITFILE);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s39);

   Scanner s40(KEEP);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'k' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s40);

   Scanner s41(LIST);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s41);

   Scanner s42(LOCK);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s42);

   Scanner s43(LOCKSTAT);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(8 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s43.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s43.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s43);

   Scanner s44(LOG);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s44);

   Scanner s45(LOGFILE);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'f' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s45);

   Scanner s46(LOGMNG);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s46);

   Scanner s47(LOGNUM);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'m' ,6));
   _scannerList.Insert(s47);

   Scanner s48(LOGSIZE);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(7 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s48.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s48.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s48);

   Scanner s49(IDENTIFIED);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(10 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s49.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s49.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s49.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s49.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s49);

   Scanner s50(UINDEX);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(6 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s50.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s50.addTransition(ScannerTransEntry(5 ,'x' ,6));
   _scannerList.Insert(s50);

   Scanner s51(MEDIATOR);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(8 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s51.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s51.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s51);

   Scanner s52(MESSAGE);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(7 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s52.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s52.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s52.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s52);

   Scanner s53(NODE);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s53);

   Scanner s54(NOLOGGING);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(9 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s54.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s54.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s54.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s54.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s54.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s54);

   Scanner s55(OBJECT);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(6 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'j' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s55.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s55);

   Scanner s56(OFF);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s56);

   Scanner s57(ON);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,FINAL));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s57.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s57);

   Scanner s58(PATH);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s58);

   Scanner s59(PASSWD);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'w' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s59);

   Scanner s60(PERMISSION);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(10 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s60.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s60.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s60.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s60.addTransition(ScannerTransEntry(8 ,'o' ,9));
   s60.addTransition(ScannerTransEntry(9 ,'n' ,10));
   _scannerList.Insert(s60);

   Scanner s61(PLAIN);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s61);

   Scanner s62(POOL);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s62);

   Scanner s63(PRIMARY);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(7 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s63.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s63.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s63);

   Scanner s64(QUIT);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s64);

   Scanner s65(RAWMODE);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s65);

   Scanner s66(RELOCATE);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(8 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s66.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s66.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s66.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s66.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s66);

   Scanner s67(REMOVE);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s67);

   Scanner s68(RECOVER);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(7 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s68.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s68);

   Scanner s69(RESET);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(5 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s69.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s69);

   Scanner s70(RETRIEVE);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(8 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s70.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s70.addTransition(ScannerTransEntry(6 ,'v' ,7));
   s70.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s70);

   Scanner s71(RIGHT);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s71);

   Scanner s72(ROLE);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s72);

   Scanner s73(SECONDARY);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(9 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s73.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s73.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s73.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s73.addTransition(ScannerTransEntry(8 ,'y' ,9));
   _scannerList.Insert(s73);

   Scanner s74(SESSION);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(7 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s74.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s74.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s74);

   Scanner s75(SET);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s75);

   Scanner s76(SETTSNODEINFO);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(12 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(13 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s76.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s76.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s76.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s76.addTransition(ScannerTransEntry(7 ,'d' ,8));
   s76.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s76.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s76.addTransition(ScannerTransEntry(10 ,'n' ,11));
   s76.addTransition(ScannerTransEntry(11 ,'f' ,12));
   s76.addTransition(ScannerTransEntry(12 ,'o' ,13));
   _scannerList.Insert(s76);

   Scanner s77(SIZE);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'z' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s77);

   Scanner s78(SORTAREASIZE);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(12 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s78.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s78.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s78.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s78.addTransition(ScannerTransEntry(8 ,'s' ,9));
   s78.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s78.addTransition(ScannerTransEntry(10 ,'z' ,11));
   s78.addTransition(ScannerTransEntry(11 ,'e' ,12));
   _scannerList.Insert(s78);

   Scanner s79(STRUCTURE);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(9 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s79.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s79.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s79);

   Scanner s80(SHOW);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s80);

   Scanner s81(START_TOK);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s81);

   Scanner s82(STOP_TOK);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s82);

   Scanner s83(SWITCH);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s83);

   Scanner s84(SYNC);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s84);

   Scanner s85(SYSSIZE);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(7 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s85.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s85.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s85.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s85);

   Scanner s86(TABLE);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s86);

   Scanner s87(TABLESET);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(8 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s87.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s87.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s87.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s87.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s87);

   Scanner s88(TIMEOUT);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(7 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s88.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s88.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s88.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s88);

   Scanner s89(THREAD);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(6 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s89.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s89.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s89);

   Scanner s90(THREADINFO);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(10 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s90.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s90.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s90.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s90.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s90.addTransition(ScannerTransEntry(8 ,'f' ,9));
   s90.addTransition(ScannerTransEntry(9 ,'o' ,10));
   _scannerList.Insert(s90);

   Scanner s91(TMPSIZE);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(7 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s91.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s91.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s91.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s91);

   Scanner s92(TO);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,FINAL));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s92.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s92);

   Scanner s93(TRACE);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(5 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s93.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s93);

   Scanner s94(TRANSACTION);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(11 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s94.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s94.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s94.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s94.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s94.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s94.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s94.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s94);

   Scanner s95(TSROOT);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(6 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s95.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s95);

   Scanner s96(USER);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'r' ,4));
   _scannerList.Insert(s96);

   Scanner s97(VERIFY);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(6 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s97.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s97);

   Scanner s98(WITH);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s98);

   Scanner s99(XML);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s99);

   Scanner s100(KSEP);
   s100.addState(ScannerStateEntry(0 ,START));
   s100.addState(ScannerStateEntry(1 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s100);

   Scanner s101(SEMICOLON);
   s101.addState(ScannerStateEntry(0 ,START));
   s101.addState(ScannerStateEntry(1 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s101);

   Scanner s102(EQU);
   s102.addState(ScannerStateEntry(0 ,START));
   s102.addState(ScannerStateEntry(1 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s102);

   Scanner s103(INTVAL);
   s103.addState(ScannerStateEntry(0 ,START));
   s103.addState(ScannerStateEntry(1 ,FINAL));
   s103.addState(ScannerStateEntry(2 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s103.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s103);

   Scanner s104(IDENTIFIER);
   s104.addState(ScannerStateEntry(0 ,START));
   s104.addState(ScannerStateEntry(1 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s104);

}
void CegoAdm::loadParser0()
{
   _actionMap[357][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[352][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[353][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[354][NOLOGGING] = ActionEntry(SHIFT, 346);
   _actionMap[354][SEMICOLON] = ActionEntry(REDUCE, 95);
   _jumpMap[354][LogOpt] = 357;
   _actionMap[355][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[330][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[331][IDENTIFIER] = ActionEntry(SHIFT, 352);
   _actionMap[332][SEMICOLON] = ActionEntry(REDUCE, 116);
   _actionMap[332][PRIMARY] = ActionEntry(REDUCE, 116);
   _actionMap[332][SECONDARY] = ActionEntry(REDUCE, 116);
   _actionMap[332][SYSSIZE] = ActionEntry(REDUCE, 116);
   _actionMap[332][TMPSIZE] = ActionEntry(REDUCE, 116);
   _actionMap[332][LOGSIZE] = ActionEntry(REDUCE, 116);
   _actionMap[332][LOGNUM] = ActionEntry(REDUCE, 116);
   _actionMap[332][SORTAREASIZE] = ActionEntry(REDUCE, 116);
   _actionMap[332][TSROOT] = ActionEntry(REDUCE, 116);
   _actionMap[332][TSTICKET] = ActionEntry(REDUCE, 116);
   _actionMap[333][SEMICOLON] = ActionEntry(REDUCE, 113);
   _actionMap[333][PRIMARY] = ActionEntry(REDUCE, 113);
   _actionMap[333][SECONDARY] = ActionEntry(REDUCE, 113);
   _actionMap[333][SYSSIZE] = ActionEntry(REDUCE, 113);
   _actionMap[333][TMPSIZE] = ActionEntry(REDUCE, 113);
   _actionMap[333][LOGSIZE] = ActionEntry(REDUCE, 113);
   _actionMap[333][LOGNUM] = ActionEntry(REDUCE, 113);
   _actionMap[333][SORTAREASIZE] = ActionEntry(REDUCE, 113);
   _actionMap[333][TSROOT] = ActionEntry(REDUCE, 113);
   _actionMap[333][TSTICKET] = ActionEntry(REDUCE, 113);
   _actionMap[334][SEMICOLON] = ActionEntry(REDUCE, 112);
   _actionMap[334][PRIMARY] = ActionEntry(REDUCE, 112);
   _actionMap[334][SECONDARY] = ActionEntry(REDUCE, 112);
   _actionMap[334][SYSSIZE] = ActionEntry(REDUCE, 112);
   _actionMap[334][TMPSIZE] = ActionEntry(REDUCE, 112);
   _actionMap[334][LOGSIZE] = ActionEntry(REDUCE, 112);
   _actionMap[334][LOGNUM] = ActionEntry(REDUCE, 112);
   _actionMap[334][SORTAREASIZE] = ActionEntry(REDUCE, 112);
   _actionMap[334][TSROOT] = ActionEntry(REDUCE, 112);
   _actionMap[334][TSTICKET] = ActionEntry(REDUCE, 112);
   _actionMap[335][SEMICOLON] = ActionEntry(REDUCE, 108);
   _actionMap[335][PRIMARY] = ActionEntry(REDUCE, 108);
   _actionMap[335][SECONDARY] = ActionEntry(REDUCE, 108);
   _actionMap[335][SYSSIZE] = ActionEntry(REDUCE, 108);
   _actionMap[335][TMPSIZE] = ActionEntry(REDUCE, 108);
   _actionMap[335][LOGSIZE] = ActionEntry(REDUCE, 108);
   _actionMap[335][LOGNUM] = ActionEntry(REDUCE, 108);
   _actionMap[335][SORTAREASIZE] = ActionEntry(REDUCE, 108);
   _actionMap[335][TSROOT] = ActionEntry(REDUCE, 108);
   _actionMap[335][TSTICKET] = ActionEntry(REDUCE, 108);
}
void CegoAdm::loadParser1()
{
   _actionMap[336][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[336][PRIMARY] = ActionEntry(REDUCE, 109);
   _actionMap[336][SECONDARY] = ActionEntry(REDUCE, 109);
   _actionMap[336][SYSSIZE] = ActionEntry(REDUCE, 109);
   _actionMap[336][TMPSIZE] = ActionEntry(REDUCE, 109);
   _actionMap[336][LOGSIZE] = ActionEntry(REDUCE, 109);
   _actionMap[336][LOGNUM] = ActionEntry(REDUCE, 109);
   _actionMap[336][SORTAREASIZE] = ActionEntry(REDUCE, 109);
   _actionMap[336][TSROOT] = ActionEntry(REDUCE, 109);
   _actionMap[336][TSTICKET] = ActionEntry(REDUCE, 109);
   _actionMap[337][SEMICOLON] = ActionEntry(REDUCE, 114);
   _actionMap[337][PRIMARY] = ActionEntry(REDUCE, 114);
   _actionMap[337][SECONDARY] = ActionEntry(REDUCE, 114);
   _actionMap[337][SYSSIZE] = ActionEntry(REDUCE, 114);
   _actionMap[337][TMPSIZE] = ActionEntry(REDUCE, 114);
   _actionMap[337][LOGSIZE] = ActionEntry(REDUCE, 114);
   _actionMap[337][LOGNUM] = ActionEntry(REDUCE, 114);
   _actionMap[337][SORTAREASIZE] = ActionEntry(REDUCE, 114);
   _actionMap[337][TSROOT] = ActionEntry(REDUCE, 114);
   _actionMap[337][TSTICKET] = ActionEntry(REDUCE, 114);
   _actionMap[338][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[338][PRIMARY] = ActionEntry(REDUCE, 110);
   _actionMap[338][SECONDARY] = ActionEntry(REDUCE, 110);
   _actionMap[338][SYSSIZE] = ActionEntry(REDUCE, 110);
   _actionMap[338][TMPSIZE] = ActionEntry(REDUCE, 110);
   _actionMap[338][LOGSIZE] = ActionEntry(REDUCE, 110);
   _actionMap[338][LOGNUM] = ActionEntry(REDUCE, 110);
   _actionMap[338][SORTAREASIZE] = ActionEntry(REDUCE, 110);
   _actionMap[338][TSROOT] = ActionEntry(REDUCE, 110);
   _actionMap[338][TSTICKET] = ActionEntry(REDUCE, 110);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[339][PRIMARY] = ActionEntry(REDUCE, 111);
   _actionMap[339][SECONDARY] = ActionEntry(REDUCE, 111);
   _actionMap[339][SYSSIZE] = ActionEntry(REDUCE, 111);
   _actionMap[339][TMPSIZE] = ActionEntry(REDUCE, 111);
   _actionMap[339][LOGSIZE] = ActionEntry(REDUCE, 111);
   _actionMap[339][LOGNUM] = ActionEntry(REDUCE, 111);
   _actionMap[339][SORTAREASIZE] = ActionEntry(REDUCE, 111);
   _actionMap[339][TSROOT] = ActionEntry(REDUCE, 111);
   _actionMap[339][TSTICKET] = ActionEntry(REDUCE, 111);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 115);
   _actionMap[340][PRIMARY] = ActionEntry(REDUCE, 115);
   _actionMap[340][SECONDARY] = ActionEntry(REDUCE, 115);
   _actionMap[340][SYSSIZE] = ActionEntry(REDUCE, 115);
   _actionMap[340][TMPSIZE] = ActionEntry(REDUCE, 115);
   _actionMap[340][LOGSIZE] = ActionEntry(REDUCE, 115);
   _actionMap[340][LOGNUM] = ActionEntry(REDUCE, 115);
   _actionMap[340][SORTAREASIZE] = ActionEntry(REDUCE, 115);
   _actionMap[340][TSROOT] = ActionEntry(REDUCE, 115);
   _actionMap[340][TSTICKET] = ActionEntry(REDUCE, 115);
}
void CegoAdm::loadParser2()
{
   _actionMap[341][STRINGVAL] = ActionEntry(SHIFT, 353);
   _actionMap[342][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[343][STRINGVAL] = ActionEntry(SHIFT, 354);
   _actionMap[344][NOLOGGING] = ActionEntry(SHIFT, 346);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 95);
   _jumpMap[344][LogOpt] = 355;
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 86);
   _actionMap[346][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[347][IDENTIFIER] = ActionEntry(SHIFT, 356);
   _actionMap[348][KSEP] = ActionEntry(REDUCE, 55);
   _actionMap[348][TO] = ActionEntry(REDUCE, 55);
   _actionMap[349][KSEP] = ActionEntry(REDUCE, 58);
   _actionMap[349][TO] = ActionEntry(REDUCE, 58);
   _actionMap[350][KSEP] = ActionEntry(REDUCE, 59);
   _actionMap[350][TO] = ActionEntry(REDUCE, 59);
   _actionMap[351][KSEP] = ActionEntry(REDUCE, 57);
   _actionMap[351][TO] = ActionEntry(REDUCE, 57);
   _actionMap[301][IDENTIFIER] = ActionEntry(SHIFT, 330);
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[303][TO] = ActionEntry(SHIFT, 331);
   _actionMap[304][STRINGVAL] = ActionEntry(SHIFT, 332);
   _actionMap[305][INTVAL] = ActionEntry(SHIFT, 333);
   _actionMap[306][INTVAL] = ActionEntry(SHIFT, 334);
   _actionMap[307][STRINGVAL] = ActionEntry(SHIFT, 335);
   _actionMap[308][STRINGVAL] = ActionEntry(SHIFT, 336);
   _actionMap[309][INTVAL] = ActionEntry(SHIFT, 337);
   _actionMap[310][INTVAL] = ActionEntry(SHIFT, 338);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 339);
   _actionMap[312][STRINGVAL] = ActionEntry(SHIFT, 340);
   _actionMap[313][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[314][TO] = ActionEntry(SHIFT, 341);
   _actionMap[315][STRINGVAL] = ActionEntry(SHIFT, 342);
   _actionMap[316][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[317][FROM] = ActionEntry(SHIFT, 343);
   _actionMap[318][STRINGVAL] = ActionEntry(SHIFT, 344);
   _actionMap[319][NOLOGGING] = ActionEntry(SHIFT, 346);
   _actionMap[319][SEMICOLON] = ActionEntry(REDUCE, 95);
   _jumpMap[319][LogOpt] = 345;
   _actionMap[320][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[321][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[322][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[323][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[324][ROLE] = ActionEntry(SHIFT, 347);
   _actionMap[325][TABLESET] = ActionEntry(SHIFT, 290);
   _actionMap[325][FILTER] = ActionEntry(SHIFT, 288);
   _actionMap[325][RIGHT] = ActionEntry(SHIFT, 289);
   _jumpMap[325][PermEntry] = 348;
   _actionMap[326][STRINGVAL] = ActionEntry(SHIFT, 349);
   _actionMap[327][IDENTIFIER] = ActionEntry(SHIFT, 350);
   _actionMap[328][IDENTIFIER] = ActionEntry(SHIFT, 351);
}
void CegoAdm::loadParser3()
{
   _actionMap[329][MESSAGE] = ActionEntry(REDUCE, 90);
   _actionMap[329][KEEP] = ActionEntry(REDUCE, 90);
   _actionMap[329][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[247][TO] = ActionEntry(SHIFT, 301);
   _actionMap[248][STRINGVAL] = ActionEntry(SHIFT, 302);
   _actionMap[249][INTVAL] = ActionEntry(SHIFT, 303);
   _actionMap[250][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[252][SEMICOLON] = ActionEntry(REDUCE, 106);
   _actionMap[252][PRIMARY] = ActionEntry(REDUCE, 106);
   _actionMap[252][SECONDARY] = ActionEntry(REDUCE, 106);
   _actionMap[252][SYSSIZE] = ActionEntry(REDUCE, 106);
   _actionMap[252][TMPSIZE] = ActionEntry(REDUCE, 106);
   _actionMap[252][LOGSIZE] = ActionEntry(REDUCE, 106);
   _actionMap[252][LOGNUM] = ActionEntry(REDUCE, 106);
   _actionMap[252][SORTAREASIZE] = ActionEntry(REDUCE, 106);
   _actionMap[252][TSROOT] = ActionEntry(REDUCE, 106);
   _actionMap[252][TSTICKET] = ActionEntry(REDUCE, 106);
   _actionMap[253][EQU] = ActionEntry(SHIFT, 304);
   _actionMap[254][EQU] = ActionEntry(SHIFT, 305);
   _actionMap[255][EQU] = ActionEntry(SHIFT, 306);
   _actionMap[256][EQU] = ActionEntry(SHIFT, 307);
   _actionMap[257][EQU] = ActionEntry(SHIFT, 308);
   _actionMap[258][EQU] = ActionEntry(SHIFT, 309);
   _actionMap[259][EQU] = ActionEntry(SHIFT, 310);
   _actionMap[260][EQU] = ActionEntry(SHIFT, 311);
   _actionMap[261][EQU] = ActionEntry(SHIFT, 312);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 123);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[265][KEEP] = ActionEntry(SHIFT, 266);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 89);
   _jumpMap[265][KeepTicketOpt] = 264;
   _actionMap[266][TSTICKET] = ActionEntry(SHIFT, 313);
   _actionMap[267][IDENTIFIER] = ActionEntry(SHIFT, 314);
   _actionMap[268][TO] = ActionEntry(SHIFT, 315);
   _actionMap[269][STRINGVAL] = ActionEntry(SHIFT, 316);
   _actionMap[270][IDENTIFIER] = ActionEntry(SHIFT, 317);
   _actionMap[271][FROM] = ActionEntry(SHIFT, 318);
   _actionMap[272][STRINGVAL] = ActionEntry(SHIFT, 319);
   _actionMap[273][STRINGVAL] = ActionEntry(SHIFT, 320);
   _actionMap[274][STRINGVAL] = ActionEntry(SHIFT, 321);
   _actionMap[275][STRINGVAL] = ActionEntry(SHIFT, 322);
   _actionMap[276][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[277][IDENTIFIER] = ActionEntry(SHIFT, 323);
   _actionMap[278][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 117);
   _actionMap[280][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[281][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[282][SEMICOLON] = ActionEntry(REDUCE, 73);
}
void CegoAdm::loadParser4()
{
   _actionMap[283][MESSAGE] = ActionEntry(REDUCE, 92);
   _actionMap[283][KEEP] = ActionEntry(REDUCE, 92);
   _actionMap[283][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[284][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[285][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[286][TO] = ActionEntry(SHIFT, 324);
   _actionMap[286][KSEP] = ActionEntry(SHIFT, 325);
   _actionMap[287][KSEP] = ActionEntry(REDUCE, 56);
   _actionMap[287][TO] = ActionEntry(REDUCE, 56);
   _actionMap[288][EQU] = ActionEntry(SHIFT, 326);
   _actionMap[289][EQU] = ActionEntry(SHIFT, 327);
   _actionMap[290][EQU] = ActionEntry(SHIFT, 328);
   _actionMap[291][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[292][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[293][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[294][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[295][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[296][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[296][CLEANUP] = ActionEntry(REDUCE, 98);
   _actionMap[296][FORCELOAD] = ActionEntry(REDUCE, 98);
   _actionMap[297][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[297][CLEANUP] = ActionEntry(REDUCE, 100);
   _actionMap[297][FORCELOAD] = ActionEntry(REDUCE, 100);
   _actionMap[298][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[298][CLEANUP] = ActionEntry(REDUCE, 101);
   _actionMap[298][FORCELOAD] = ActionEntry(REDUCE, 101);
   _actionMap[299][KEEP] = ActionEntry(REDUCE, 96);
   _actionMap[299][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[300][TIMEOUT] = ActionEntry(SHIFT, 229);
   _actionMap[300][MESSAGE] = ActionEntry(REDUCE, 93);
   _actionMap[300][KEEP] = ActionEntry(REDUCE, 93);
   _actionMap[300][SEMICOLON] = ActionEntry(REDUCE, 93);
   _jumpMap[300][TimeoutOpt] = 329;
   _actionMap[190][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[191][STRINGVAL] = ActionEntry(SHIFT, 247);
   _actionMap[192][BY] = ActionEntry(SHIFT, 248);
   _actionMap[193][SIZE] = ActionEntry(SHIFT, 249);
   _actionMap[194][IDENTIFIER] = ActionEntry(SHIFT, 250);
   _actionMap[195][MESSAGE] = ActionEntry(SHIFT, 243);
   _actionMap[195][SEMICOLON] = ActionEntry(REDUCE, 97);
   _jumpMap[195][MsgOption] = 251;
   _actionMap[196][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[196][PRIMARY] = ActionEntry(SHIFT, 256);
   _actionMap[196][SECONDARY] = ActionEntry(SHIFT, 257);
   _actionMap[196][SYSSIZE] = ActionEntry(SHIFT, 259);
   _actionMap[196][TMPSIZE] = ActionEntry(SHIFT, 260);
   _actionMap[196][LOGSIZE] = ActionEntry(SHIFT, 255);
   _actionMap[196][LOGNUM] = ActionEntry(SHIFT, 254);
   _actionMap[196][SORTAREASIZE] = ActionEntry(SHIFT, 258);
   _actionMap[196][TSROOT] = ActionEntry(SHIFT, 261);
}
void CegoAdm::loadParser5()
{
   _actionMap[196][TSTICKET] = ActionEntry(SHIFT, 253);
   _jumpMap[196][Attr] = 252;
   _actionMap[197][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[198][IDENTIFIER] = ActionEntry(SHIFT, 262);
   _actionMap[199][IDENTIFIER] = ActionEntry(SHIFT, 263);
   _actionMap[200][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[201][MESSAGE] = ActionEntry(SHIFT, 243);
   _actionMap[201][KEEP] = ActionEntry(REDUCE, 97);
   _actionMap[201][SEMICOLON] = ActionEntry(REDUCE, 97);
   _jumpMap[201][MsgOption] = 265;
   _jumpMap[201][KeepTicketOpt] = 264;
   _actionMap[202][FROM] = ActionEntry(SHIFT, 267);
   _actionMap[203][IDENTIFIER] = ActionEntry(SHIFT, 268);
   _actionMap[204][TO] = ActionEntry(SHIFT, 269);
   _actionMap[205][TO] = ActionEntry(SHIFT, 270);
   _actionMap[206][IDENTIFIER] = ActionEntry(SHIFT, 271);
   _actionMap[207][FROM] = ActionEntry(SHIFT, 272);
   _actionMap[208][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[209][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[210][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[211][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[212][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[213][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[214][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[215][BY] = ActionEntry(SHIFT, 273);
   _actionMap[216][TO] = ActionEntry(SHIFT, 274);
   _actionMap[217][TO] = ActionEntry(SHIFT, 275);
   _actionMap[218][IDENTIFIER] = ActionEntry(SHIFT, 276);
   _actionMap[219][ROLE] = ActionEntry(SHIFT, 277);
   _actionMap[220][IDENTIFIER] = ActionEntry(SHIFT, 278);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[222][STRINGVAL] = ActionEntry(SHIFT, 279);
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[224][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[225][IDENTIFIER] = ActionEntry(SHIFT, 280);
   _actionMap[226][IDENTIFIER] = ActionEntry(SHIFT, 281);
   _actionMap[227][IDENTIFIER] = ActionEntry(SHIFT, 282);
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[229][INTVAL] = ActionEntry(SHIFT, 283);
   _actionMap[230][IDENTIFIER] = ActionEntry(SHIFT, 284);
   _actionMap[231][IDENTIFIER] = ActionEntry(SHIFT, 285);
   _actionMap[232][TABLESET] = ActionEntry(SHIFT, 290);
   _actionMap[232][FILTER] = ActionEntry(SHIFT, 288);
   _actionMap[232][RIGHT] = ActionEntry(SHIFT, 289);
   _jumpMap[232][PermEntry] = 287;
   _jumpMap[232][PermList] = 286;
   _actionMap[233][IDENTIFIER] = ActionEntry(SHIFT, 291);
   _actionMap[234][IDENTIFIER] = ActionEntry(SHIFT, 292);
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 293);
   _actionMap[236][IDENTIFIER] = ActionEntry(SHIFT, 294);
}
void CegoAdm::loadParser6()
{
   _actionMap[237][IDENTIFIER] = ActionEntry(SHIFT, 295);
   _actionMap[238][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[238][CLEANUP] = ActionEntry(SHIFT, 297);
   _actionMap[238][FORCELOAD] = ActionEntry(SHIFT, 298);
   _jumpMap[238][StartOpt] = 296;
   _actionMap[239][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[240][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[241][MESSAGE] = ActionEntry(SHIFT, 243);
   _actionMap[241][SEMICOLON] = ActionEntry(REDUCE, 97);
   _jumpMap[241][MsgOption] = 242;
   _actionMap[242][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[243][STRINGVAL] = ActionEntry(SHIFT, 299);
   _actionMap[244][STRINGVAL] = ActionEntry(SHIFT, 300);
   _actionMap[245][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[246][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[122][INTVAL] = ActionEntry(SHIFT, 190);
   _actionMap[123][PATH] = ActionEntry(SHIFT, 191);
   _actionMap[124][IDENTIFIED] = ActionEntry(SHIFT, 192);
   _actionMap[125][STRINGVAL] = ActionEntry(SHIFT, 193);
   _actionMap[126][TO] = ActionEntry(SHIFT, 194);
   _actionMap[127][IDENTIFIER] = ActionEntry(SHIFT, 195);
   _actionMap[128][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[129][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[130][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[131][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[132][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[133][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[134][PRIMARY] = ActionEntry(REDUCE, 107);
   _actionMap[134][SECONDARY] = ActionEntry(REDUCE, 107);
   _actionMap[134][SYSSIZE] = ActionEntry(REDUCE, 107);
   _actionMap[134][TMPSIZE] = ActionEntry(REDUCE, 107);
   _actionMap[134][LOGSIZE] = ActionEntry(REDUCE, 107);
   _actionMap[134][LOGNUM] = ActionEntry(REDUCE, 107);
   _actionMap[134][SORTAREASIZE] = ActionEntry(REDUCE, 107);
   _actionMap[134][TSROOT] = ActionEntry(REDUCE, 107);
   _actionMap[134][TSTICKET] = ActionEntry(REDUCE, 107);
   _actionMap[134][SEMICOLON] = ActionEntry(REDUCE, 107);
   _jumpMap[134][AttrList] = 196;
   _actionMap[135][IDENTIFIER] = ActionEntry(SHIFT, 197);
   _actionMap[136][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[137][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[138][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[139][FOR] = ActionEntry(SHIFT, 198);
   _actionMap[140][FOR] = ActionEntry(SHIFT, 199);
   _actionMap[141][IDENTIFIER] = ActionEntry(SHIFT, 200);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 201);
   _actionMap[143][IDENTIFIER] = ActionEntry(SHIFT, 202);
   _actionMap[144][IDENTIFIER] = ActionEntry(SHIFT, 204);
   _actionMap[144][STRUCTURE] = ActionEntry(SHIFT, 203);
   _actionMap[145][IDENTIFIER] = ActionEntry(SHIFT, 205);
}
void CegoAdm::loadParser7()
{
   _actionMap[146][IDENTIFIER] = ActionEntry(SHIFT, 207);
   _actionMap[146][STRUCTURE] = ActionEntry(SHIFT, 206);
   _actionMap[147][IDENTIFIER] = ActionEntry(SHIFT, 208);
   _actionMap[148][IDENTIFIER] = ActionEntry(SHIFT, 209);
   _actionMap[149][IDENTIFIER] = ActionEntry(SHIFT, 210);
   _actionMap[150][IDENTIFIER] = ActionEntry(SHIFT, 211);
   _actionMap[151][IDENTIFIER] = ActionEntry(SHIFT, 212);
   _actionMap[152][IDENTIFIER] = ActionEntry(SHIFT, 213);
   _actionMap[153][IDENTIFIER] = ActionEntry(SHIFT, 214);
   _actionMap[154][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[155][IDENTIFIED] = ActionEntry(SHIFT, 215);
   _actionMap[156][IDENTIFIER] = ActionEntry(SHIFT, 216);
   _actionMap[157][IDENTIFIER] = ActionEntry(SHIFT, 217);
   _actionMap[158][FROM] = ActionEntry(SHIFT, 218);
   _actionMap[159][FROM] = ActionEntry(SHIFT, 219);
   _actionMap[160][FROM] = ActionEntry(SHIFT, 220);
   _actionMap[161][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[162][TO] = ActionEntry(SHIFT, 222);
   _actionMap[162][SEMICOLON] = ActionEntry(REDUCE, 118);
   _jumpMap[162][PitOption] = 221;
   _actionMap[163][IDENTIFIER] = ActionEntry(SHIFT, 223);
   _actionMap[164][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[165][STRINGVAL] = ActionEntry(SHIFT, 224);
   _actionMap[166][FOR] = ActionEntry(SHIFT, 225);
   _actionMap[167][FOR] = ActionEntry(SHIFT, 226);
   _actionMap[168][FOR] = ActionEntry(SHIFT, 227);
   _actionMap[169][TIMEOUT] = ActionEntry(SHIFT, 229);
   _actionMap[169][SEMICOLON] = ActionEntry(REDUCE, 93);
   _jumpMap[169][TimeoutOpt] = 228;
   _actionMap[170][FOR] = ActionEntry(SHIFT, 230);
   _actionMap[171][FOR] = ActionEntry(SHIFT, 231);
   _actionMap[172][WITH] = ActionEntry(SHIFT, 232);
   _actionMap[173][FOR] = ActionEntry(SHIFT, 233);
   _actionMap[174][FOR] = ActionEntry(SHIFT, 234);
   _actionMap[175][FOR] = ActionEntry(SHIFT, 235);
   _actionMap[176][FOR] = ActionEntry(SHIFT, 236);
   _actionMap[177][IDENTIFIER] = ActionEntry(SHIFT, 237);
   _actionMap[178][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[179][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[180][CLEANUP] = ActionEntry(REDUCE, 99);
   _actionMap[180][FORCELOAD] = ActionEntry(REDUCE, 99);
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 99);
   _jumpMap[180][StartOptList] = 238;
   _actionMap[181][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[182][IDENTIFIER] = ActionEntry(SHIFT, 239);
   _actionMap[183][IDENTIFIER] = ActionEntry(SHIFT, 240);
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[185][WITH] = ActionEntry(SHIFT, 244);
   _actionMap[185][MESSAGE] = ActionEntry(REDUCE, 91);
   _actionMap[185][KEEP] = ActionEntry(REDUCE, 91);
}
void CegoAdm::loadParser8()
{
   _actionMap[185][SEMICOLON] = ActionEntry(REDUCE, 91);
   _jumpMap[185][MsgOption] = 242;
   _jumpMap[185][SyncCmdOption] = 241;
   _actionMap[186][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 245);
   _actionMap[188][IDENTIFIER] = ActionEntry(SHIFT, 246);
   _actionMap[189][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[39][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[40][THREAD] = ActionEntry(SHIFT, 122);
   _actionMap[41][IDENTIFIER] = ActionEntry(SHIFT, 123);
   _actionMap[42][IDENTIFIER] = ActionEntry(SHIFT, 124);
   _actionMap[43][DATAFILE] = ActionEntry(SHIFT, 125);
   _actionMap[44][IDENTIFIER] = ActionEntry(SHIFT, 126);
   _actionMap[45][FOR] = ActionEntry(SHIFT, 127);
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 128);
   _actionMap[47][STRINGVAL] = ActionEntry(SHIFT, 129);
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 130);
   _actionMap[49][IDENTIFIER] = ActionEntry(SHIFT, 131);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 132);
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 133);
   _actionMap[52][IDENTIFIER] = ActionEntry(SHIFT, 134);
   _actionMap[53][FOR] = ActionEntry(SHIFT, 135);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 136);
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 137);
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 138);
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 139);
   _actionMap[58][IDENTIFIER] = ActionEntry(SHIFT, 140);
   _actionMap[59][FOR] = ActionEntry(SHIFT, 141);
   _actionMap[60][FOR] = ActionEntry(SHIFT, 142);
   _actionMap[61][TABLESET] = ActionEntry(SHIFT, 144);
   _actionMap[61][TABLE] = ActionEntry(SHIFT, 143);
   _actionMap[62][TABLESET] = ActionEntry(REDUCE, 103);
   _actionMap[62][TABLE] = ActionEntry(REDUCE, 103);
   _actionMap[63][TABLESET] = ActionEntry(REDUCE, 104);
   _actionMap[63][TABLE] = ActionEntry(REDUCE, 104);
   _actionMap[64][TABLESET] = ActionEntry(REDUCE, 102);
   _actionMap[64][TABLE] = ActionEntry(REDUCE, 102);
   _actionMap[65][TABLESET] = ActionEntry(SHIFT, 146);
   _actionMap[65][TABLE] = ActionEntry(SHIFT, 145);
   _actionMap[66][FOR] = ActionEntry(SHIFT, 147);
   _actionMap[67][FOR] = ActionEntry(SHIFT, 148);
   _actionMap[68][FOR] = ActionEntry(SHIFT, 149);
   _actionMap[69][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[70][FOR] = ActionEntry(SHIFT, 150);
   _actionMap[71][FOR] = ActionEntry(SHIFT, 151);
   _actionMap[72][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[73][FOR] = ActionEntry(SHIFT, 152);
   _actionMap[74][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[75][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[76][SEMICOLON] = ActionEntry(REDUCE, 13);
}
void CegoAdm::loadParser9()
{
   _actionMap[77][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[78][FOR] = ActionEntry(SHIFT, 153);
   _actionMap[79][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[80][LOCK] = ActionEntry(SHIFT, 154);
   _actionMap[81][IDENTIFIER] = ActionEntry(SHIFT, 155);
   _actionMap[82][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[83][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[84][FOR] = ActionEntry(SHIFT, 156);
   _actionMap[85][FOR] = ActionEntry(SHIFT, 157);
   _actionMap[86][IDENTIFIER] = ActionEntry(SHIFT, 158);
   _actionMap[87][IDENTIFIER] = ActionEntry(SHIFT, 159);
   _actionMap[88][IDENTIFIER] = ActionEntry(SHIFT, 160);
   _actionMap[89][IDENTIFIER] = ActionEntry(SHIFT, 161);
   _actionMap[90][IDENTIFIER] = ActionEntry(SHIFT, 162);
   _actionMap[91][FOR] = ActionEntry(SHIFT, 163);
   _actionMap[92][IDENTIFIER] = ActionEntry(SHIFT, 164);
   _actionMap[93][FROM] = ActionEntry(SHIFT, 165);
   _actionMap[94][STRINGVAL] = ActionEntry(SHIFT, 166);
   _actionMap[95][INTVAL] = ActionEntry(SHIFT, 167);
   _actionMap[96][STRINGVAL] = ActionEntry(SHIFT, 168);
   _actionMap[97][STRINGVAL] = ActionEntry(SHIFT, 169);
   _actionMap[98][INTVAL] = ActionEntry(SHIFT, 170);
   _actionMap[99][INTVAL] = ActionEntry(SHIFT, 171);
   _actionMap[100][IDENTIFIER] = ActionEntry(SHIFT, 172);
   _actionMap[101][INTVAL] = ActionEntry(SHIFT, 173);
   _actionMap[102][INTVAL] = ActionEntry(SHIFT, 174);
   _actionMap[103][INTVAL] = ActionEntry(SHIFT, 175);
   _actionMap[104][STRINGVAL] = ActionEntry(SHIFT, 176);
   _actionMap[105][IDENTIFIER] = ActionEntry(SHIFT, 177);
   _actionMap[106][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[107][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 178);
   _actionMap[109][IDENTIFIER] = ActionEntry(SHIFT, 179);
   _actionMap[110][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[111][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[112][FOR] = ActionEntry(SHIFT, 182);
   _actionMap[113][FOR] = ActionEntry(SHIFT, 183);
   _actionMap[114][IDENTIFIER] = ActionEntry(SHIFT, 184);
   _actionMap[115][IDENTIFIER] = ActionEntry(SHIFT, 185);
   _actionMap[116][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[117][INTVAL] = ActionEntry(SHIFT, 186);
   _actionMap[117][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[118][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[119][USER] = ActionEntry(SHIFT, 187);
   _actionMap[120][USER] = ActionEntry(SHIFT, 188);
   _actionMap[121][IDENTIFIER] = ActionEntry(SHIFT, 189);
   _actionMap[1][SEMICOLON] = ActionEntry(SHIFT, 39);
   _actionMap[2][DB] = ActionEntry(SHIFT, 40);
   _actionMap[3][IDENTIFIER] = ActionEntry(SHIFT, 43);
   _actionMap[3][USER] = ActionEntry(SHIFT, 42);
}
void CegoAdm::loadParser10()
{
   _actionMap[3][ARCHLOG] = ActionEntry(SHIFT, 41);
   _actionMap[4][ROLE] = ActionEntry(SHIFT, 44);
   _actionMap[5][BACKUP] = ActionEntry(SHIFT, 45);
   _actionMap[6][TABLESET] = ActionEntry(SHIFT, 46);
   _actionMap[7][TABLESET] = ActionEntry(SHIFT, 48);
   _actionMap[7][FILE] = ActionEntry(SHIFT, 47);
   _actionMap[8][TABLESET] = ActionEntry(SHIFT, 49);
   _actionMap[9][TABLESET] = ActionEntry(SHIFT, 51);
   _actionMap[9][ROLE] = ActionEntry(SHIFT, 50);
   _actionMap[10][TABLESET] = ActionEntry(SHIFT, 52);
   _actionMap[11][ARCHLOG] = ActionEntry(SHIFT, 53);
   _actionMap[12][TABLESET] = ActionEntry(SHIFT, 55);
   _actionMap[12][USER] = ActionEntry(SHIFT, 56);
   _actionMap[12][ROLE] = ActionEntry(SHIFT, 54);
   _actionMap[13][TABLE] = ActionEntry(SHIFT, 58);
   _actionMap[13][UINDEX] = ActionEntry(SHIFT, 57);
   _actionMap[14][ARCHLOG] = ActionEntry(SHIFT, 59);
   _actionMap[15][BACKUP] = ActionEntry(SHIFT, 60);
   _actionMap[16][XML] = ActionEntry(SHIFT, 64);
   _actionMap[16][BINARY] = ActionEntry(SHIFT, 62);
   _actionMap[16][PLAIN] = ActionEntry(SHIFT, 63);
   _actionMap[16][TABLE] = ActionEntry(REDUCE, 105);
   _actionMap[16][TABLESET] = ActionEntry(REDUCE, 105);
   _jumpMap[16][XPMode] = 61;
   _actionMap[17][SEMICOLON] = ActionEntry(REDUCE, 119);
   _actionMap[18][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[19][XML] = ActionEntry(SHIFT, 64);
   _actionMap[19][BINARY] = ActionEntry(SHIFT, 62);
   _actionMap[19][PLAIN] = ActionEntry(SHIFT, 63);
   _actionMap[19][TABLE] = ActionEntry(REDUCE, 105);
   _actionMap[19][TABLESET] = ActionEntry(REDUCE, 105);
   _jumpMap[19][XPMode] = 65;
   _actionMap[20][POOL] = ActionEntry(SHIFT, 74);
   _actionMap[20][IDENTIFIER] = ActionEntry(SHIFT, 80);
   _actionMap[20][TABLESET] = ActionEntry(SHIFT, 77);
   _actionMap[20][DATAFILE] = ActionEntry(SHIFT, 70);
   _actionMap[20][ARCHLOG] = ActionEntry(SHIFT, 66);
   _actionMap[20][LOGFILE] = ActionEntry(SHIFT, 71);
   _actionMap[20][OBJECT] = ActionEntry(SHIFT, 73);
   _actionMap[20][NODE] = ActionEntry(SHIFT, 72);
   _actionMap[20][SESSION] = ActionEntry(SHIFT, 76);
   _actionMap[20][BUFILE] = ActionEntry(SHIFT, 67);
   _actionMap[20][BUSTAT] = ActionEntry(SHIFT, 68);
   _actionMap[20][COPY] = ActionEntry(SHIFT, 69);
   _actionMap[20][TRANSACTION] = ActionEntry(SHIFT, 78);
   _actionMap[20][USER] = ActionEntry(SHIFT, 79);
   _actionMap[20][ROLE] = ActionEntry(SHIFT, 75);
   _actionMap[21][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[22][USER] = ActionEntry(SHIFT, 81);
   _actionMap[23][ON] = ActionEntry(SHIFT, 83);
}
void CegoAdm::loadParser11()
{
   _actionMap[23][OFF] = ActionEntry(SHIFT, 82);
   _actionMap[24][SECONDARY] = ActionEntry(SHIFT, 85);
   _actionMap[24][MEDIATOR] = ActionEntry(SHIFT, 84);
   _actionMap[25][TABLESET] = ActionEntry(SHIFT, 89);
   _actionMap[25][ROLE] = ActionEntry(SHIFT, 88);
   _actionMap[25][PERMISSION] = ActionEntry(SHIFT, 87);
   _actionMap[25][ARCHLOG] = ActionEntry(SHIFT, 86);
   _actionMap[26][TABLESET] = ActionEntry(SHIFT, 90);
   _actionMap[27][BUSTAT] = ActionEntry(SHIFT, 91);
   _actionMap[27][TABLESET] = ActionEntry(SHIFT, 92);
   _actionMap[28][TABLESET] = ActionEntry(SHIFT, 93);
   _actionMap[29][PERMISSION] = ActionEntry(SHIFT, 100);
   _actionMap[29][LOGMNG] = ActionEntry(SHIFT, 97);
   _actionMap[29][INITFILE] = ActionEntry(SHIFT, 96);
   _actionMap[29][CHECKPOINT] = ActionEntry(SHIFT, 95);
   _actionMap[29][SYSSIZE] = ActionEntry(SHIFT, 102);
   _actionMap[29][TMPSIZE] = ActionEntry(SHIFT, 103);
   _actionMap[29][TSROOT] = ActionEntry(SHIFT, 104);
   _actionMap[29][TSTICKET] = ActionEntry(SHIFT, 94);
   _actionMap[29][LOGNUM] = ActionEntry(SHIFT, 98);
   _actionMap[29][LOGSIZE] = ActionEntry(SHIFT, 99);
   _actionMap[29][SORTAREASIZE] = ActionEntry(SHIFT, 101);
   _actionMap[30][IDENTIFIER] = ActionEntry(SHIFT, 105);
   _actionMap[31][POOL] = ActionEntry(SHIFT, 107);
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 109);
   _actionMap[31][ROLE] = ActionEntry(SHIFT, 108);
   _actionMap[31][LOGMNG] = ActionEntry(SHIFT, 106);
   _actionMap[32][TABLESET] = ActionEntry(SHIFT, 110);
   _actionMap[33][TABLESET] = ActionEntry(SHIFT, 111);
   _actionMap[34][TABLESET] = ActionEntry(SHIFT, 114);
   _actionMap[34][SECONDARY] = ActionEntry(SHIFT, 113);
   _actionMap[34][MEDIATOR] = ActionEntry(SHIFT, 112);
   _actionMap[35][TABLESET] = ActionEntry(SHIFT, 115);
   _actionMap[36][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[36][DB] = ActionEntry(SHIFT, 117);
   _actionMap[36][ADM] = ActionEntry(SHIFT, 116);
   _actionMap[36][LOG] = ActionEntry(SHIFT, 118);
   _actionMap[37][ON] = ActionEntry(SHIFT, 120);
   _actionMap[37][OFF] = ActionEntry(SHIFT, 119);
   _actionMap[38][TABLESET] = ActionEntry(SHIFT, 121);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 31);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 20);
   _actionMap[0][RAWMODE] = ActionEntry(SHIFT, 23);
   _actionMap[0][RESET] = ActionEntry(SHIFT, 27);
   _actionMap[0][THREADINFO] = ActionEntry(SHIFT, 36);
   _actionMap[0][LOCKSTAT] = ActionEntry(SHIFT, 21);
   _actionMap[0][ABORT] = ActionEntry(SHIFT, 2);
   _actionMap[0][RETRIEVE] = ActionEntry(SHIFT, 28);
   _actionMap[0][DEFINE] = ActionEntry(SHIFT, 10);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 9);
}
void CegoAdm::loadParser12()
{
   _actionMap[0][START_TOK] = ActionEntry(SHIFT, 32);
   _actionMap[0][STOP_TOK] = ActionEntry(SHIFT, 33);
   _actionMap[0][COPY] = ActionEntry(SHIFT, 7);
   _actionMap[0][SWITCH] = ActionEntry(SHIFT, 34);
   _actionMap[0][RELOCATE] = ActionEntry(SHIFT, 24);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 12);
   _actionMap[0][REMOVE] = ActionEntry(SHIFT, 25);
   _actionMap[0][ADD] = ActionEntry(SHIFT, 3);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 6);
   _actionMap[0][VERIFY] = ActionEntry(SHIFT, 38);
   _actionMap[0][CORRECT] = ActionEntry(SHIFT, 8);
   _actionMap[0][PASSWD] = ActionEntry(SHIFT, 22);
   _actionMap[0][ASSIGN] = ActionEntry(SHIFT, 4);
   _actionMap[0][SET] = ActionEntry(SHIFT, 29);
   _actionMap[0][TRACE] = ActionEntry(SHIFT, 37);
   _actionMap[0][ENABLE] = ActionEntry(SHIFT, 14);
   _actionMap[0][DISABLE] = ActionEntry(SHIFT, 11);
   _actionMap[0][BEGIN_TOKEN] = ActionEntry(SHIFT, 5);
   _actionMap[0][END_TOKEN] = ActionEntry(SHIFT, 15);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 35);
   _actionMap[0][RECOVER] = ActionEntry(SHIFT, 26);
   _actionMap[0][EXPORT] = ActionEntry(SHIFT, 16);
   _actionMap[0][IMPORT] = ActionEntry(SHIFT, 19);
   _actionMap[0][GETDBSPEC] = ActionEntry(SHIFT, 17);
   _actionMap[0][GETDBINFO] = ActionEntry(SHIFT, 18);
   _actionMap[0][SETTSNODEINFO] = ActionEntry(SHIFT, 30);
   _actionMap[0][DUMP] = ActionEntry(SHIFT, 13);
   _jumpMap[0][Statement] = 1;
}
void CegoAdm::loadParser13()
{
   _prodInfo.Insert(ProdEntry(124, Statement, 5));
   _prodInfo.Insert(ProdEntry(123, Statement, 5));
   _prodInfo.Insert(ProdEntry(122, Statement, 3));
   _prodInfo.Insert(ProdEntry(121, Statement, 5));
   _prodInfo.Insert(ProdEntry(120, Statement, 1));
   _prodInfo.Insert(ProdEntry(119, Statement, 1));
   _prodInfo.Insert(ProdEntry(118, PitOption, 0));
   _prodInfo.Insert(ProdEntry(117, PitOption, 2));
   _prodInfo.Insert(ProdEntry(116, Attr, 3));
   _prodInfo.Insert(ProdEntry(115, Attr, 3));
   _prodInfo.Insert(ProdEntry(114, Attr, 3));
   _prodInfo.Insert(ProdEntry(113, Attr, 3));
   _prodInfo.Insert(ProdEntry(112, Attr, 3));
   _prodInfo.Insert(ProdEntry(111, Attr, 3));
   _prodInfo.Insert(ProdEntry(110, Attr, 3));
   _prodInfo.Insert(ProdEntry(109, Attr, 3));
   _prodInfo.Insert(ProdEntry(108, Attr, 3));
   _prodInfo.Insert(ProdEntry(107, AttrList, 0));
   _prodInfo.Insert(ProdEntry(106, AttrList, 2));
   _prodInfo.Insert(ProdEntry(105, XPMode, 0));
   _prodInfo.Insert(ProdEntry(104, XPMode, 1));
   _prodInfo.Insert(ProdEntry(103, XPMode, 1));
   _prodInfo.Insert(ProdEntry(102, XPMode, 1));
   _prodInfo.Insert(ProdEntry(101, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(100, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(99, StartOptList, 0));
   _prodInfo.Insert(ProdEntry(98, StartOptList, 2));
   _prodInfo.Insert(ProdEntry(97, MsgOption, 0));
   _prodInfo.Insert(ProdEntry(96, MsgOption, 2));
   _prodInfo.Insert(ProdEntry(95, LogOpt, 0));
   _prodInfo.Insert(ProdEntry(94, LogOpt, 1));
   _prodInfo.Insert(ProdEntry(93, TimeoutOpt, 0));
   _prodInfo.Insert(ProdEntry(92, TimeoutOpt, 2));
   _prodInfo.Insert(ProdEntry(91, SyncCmdOption, 0));
   _prodInfo.Insert(ProdEntry(90, SyncCmdOption, 3));
   _prodInfo.Insert(ProdEntry(89, KeepTicketOpt, 0));
   _prodInfo.Insert(ProdEntry(88, KeepTicketOpt, 2));
   _prodInfo.Insert(ProdEntry(87, Statement, 8));
   _prodInfo.Insert(ProdEntry(86, Statement, 7));
   _prodInfo.Insert(ProdEntry(85, Statement, 9));
   _prodInfo.Insert(ProdEntry(84, Statement, 7));
   _prodInfo.Insert(ProdEntry(83, Statement, 6));
   _prodInfo.Insert(ProdEntry(82, Statement, 8));
   _prodInfo.Insert(ProdEntry(81, Statement, 5));
   _prodInfo.Insert(ProdEntry(80, Statement, 5));
   _prodInfo.Insert(ProdEntry(79, Statement, 5));
   _prodInfo.Insert(ProdEntry(78, Statement, 5));
   _prodInfo.Insert(ProdEntry(77, Statement, 5));
   _prodInfo.Insert(ProdEntry(76, Statement, 5));
   _prodInfo.Insert(ProdEntry(75, Statement, 5));
   _prodInfo.Insert(ProdEntry(74, Statement, 5));
   _prodInfo.Insert(ProdEntry(73, Statement, 5));
   _prodInfo.Insert(ProdEntry(72, Statement, 2));
   _prodInfo.Insert(ProdEntry(71, Statement, 4));
   _prodInfo.Insert(ProdEntry(70, Statement, 4));
   _prodInfo.Insert(ProdEntry(69, Statement, 5));
   _prodInfo.Insert(ProdEntry(68, Statement, 6));
   _prodInfo.Insert(ProdEntry(67, Statement, 5));
   _prodInfo.Insert(ProdEntry(66, Statement, 5));
   _prodInfo.Insert(ProdEntry(65, Statement, 7));
   _prodInfo.Insert(ProdEntry(64, Statement, 4));
   _prodInfo.Insert(ProdEntry(63, Statement, 4));
   _prodInfo.Insert(ProdEntry(62, Statement, 4));
   _prodInfo.Insert(ProdEntry(61, Statement, 4));
   _prodInfo.Insert(ProdEntry(60, Statement, 6));
   _prodInfo.Insert(ProdEntry(59, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(58, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(57, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(56, PermList, 1));
   _prodInfo.Insert(ProdEntry(55, PermList, 3));
   _prodInfo.Insert(ProdEntry(54, Statement, 8));
   _prodInfo.Insert(ProdEntry(53, Statement, 3));
   _prodInfo.Insert(ProdEntry(52, Statement, 3));
   _prodInfo.Insert(ProdEntry(51, Statement, 3));
   _prodInfo.Insert(ProdEntry(50, Statement, 2));
   _prodInfo.Insert(ProdEntry(49, Statement, 5));
   _prodInfo.Insert(ProdEntry(48, Statement, 5));
   _prodInfo.Insert(ProdEntry(47, Statement, 6));
   _prodInfo.Insert(ProdEntry(46, Statement, 3));
   _prodInfo.Insert(ProdEntry(45, Statement, 2));
   _prodInfo.Insert(ProdEntry(44, Statement, 6));
   _prodInfo.Insert(ProdEntry(43, Statement, 3));
   _prodInfo.Insert(ProdEntry(42, Statement, 3));
   _prodInfo.Insert(ProdEntry(41, Statement, 3));
   _prodInfo.Insert(ProdEntry(40, Statement, 8));
   _prodInfo.Insert(ProdEntry(39, Statement, 3));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 3));
   _prodInfo.Insert(ProdEntry(36, Statement, 6));
   _prodInfo.Insert(ProdEntry(35, Statement, 6));
   _prodInfo.Insert(ProdEntry(34, Statement, 4));
   _prodInfo.Insert(ProdEntry(33, Statement, 4));
   _prodInfo.Insert(ProdEntry(32, Statement, 3));
   _prodInfo.Insert(ProdEntry(31, Statement, 3));
   _prodInfo.Insert(ProdEntry(30, Statement, 3));
   _prodInfo.Insert(ProdEntry(29, Statement, 4));
   _prodInfo.Insert(ProdEntry(28, Statement, 3));
   _prodInfo.Insert(ProdEntry(27, Statement, 4));
   _prodInfo.Insert(ProdEntry(26, Statement, 4));
   _prodInfo.Insert(ProdEntry(25, Statement, 4));
   _prodInfo.Insert(ProdEntry(24, Statement, 4));
   _prodInfo.Insert(ProdEntry(23, Statement, 2));
   _prodInfo.Insert(ProdEntry(22, Statement, 2));
   _prodInfo.Insert(ProdEntry(21, Statement, 2));
   _prodInfo.Insert(ProdEntry(20, Statement, 3));
   _prodInfo.Insert(ProdEntry(19, Statement, 2));
   _prodInfo.Insert(ProdEntry(18, Statement, 1));
   _prodInfo.Insert(ProdEntry(17, Statement, 1));
   _prodInfo.Insert(ProdEntry(16, Statement, 4));
   _prodInfo.Insert(ProdEntry(15, Statement, 4));
   _prodInfo.Insert(ProdEntry(14, Statement, 4));
   _prodInfo.Insert(ProdEntry(13, Statement, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 2));
   _prodInfo.Insert(ProdEntry(11, Statement, 4));
   _prodInfo.Insert(ProdEntry(10, Statement, 4));
   _prodInfo.Insert(ProdEntry(9, Statement, 4));
   _prodInfo.Insert(ProdEntry(8, Statement, 4));
   _prodInfo.Insert(ProdEntry(7, Statement, 2));
   _prodInfo.Insert(ProdEntry(6, Statement, 3));
   _prodInfo.Insert(ProdEntry(5, Statement, 2));
   _prodInfo.Insert(ProdEntry(4, Statement, 2));
   _prodInfo.Insert(ProdEntry(3, Statement, 2));
   _prodInfo.Insert(ProdEntry(2, Statement, 3));
   _prodInfo.Insert(ProdEntry(1, Statement, 2));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

CegoAdm::CegoAdm()
{
   loadScanner();
   for ( int i=0; i < 358; i++)
   {
      int j;
      for ( j = 0; j < 107; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 16; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   _isReserved = false;
}

CegoAdm::~CegoAdm()
{
}

void CegoAdm::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 124:
                     dumpUIndex();
                     break;
                  case 123:
                     dumpTable();
                     break;
                  case 122:
                     copyFileAction();
                     break;
                  case 121:
                     setTableSetNodeAction();
                     break;
                  case 120:
                     getDbInfoAction();
                     break;
                  case 119:
                     getDbSpecAction();
                     break;
                  case 117:
                     storePit();
                     break;
                  case 116:
                     storeTSTicketAttr();
                     break;
                  case 115:
                     storeTSRootAttr();
                     break;
                  case 114:
                     storeSortAreaAttr();
                     break;
                  case 113:
                     storeLogNumAttr();
                     break;
                  case 112:
                     storeLogSizeAttr();
                     break;
                  case 111:
                     storeTmpSizeAttr();
                     break;
                  case 110:
                     storeSysSizeAttr();
                     break;
                  case 109:
                     storeSecondaryAttr();
                     break;
                  case 108:
                     storePrimaryAttr();
                     break;
                  case 104:
                     plainModeAction();
                     break;
                  case 103:
                     binModeAction();
                     break;
                  case 102:
                     xmlModeAction();
                     break;
                  case 101:
                     forceloadAction();
                     break;
                  case 100:
                     cleanupAction();
                     break;
                  case 96:
                     msgAction();
                     break;
                  case 94:
                     nologAction();
                     break;
                  case 92:
                     timeoutAction();
                     break;
                  case 90:
                     syncCmdAction();
                     break;
                  case 88:
                     keepTicketAction();
                     break;
                  case 87:
                     importTableSetStructureAction();
                     break;
                  case 86:
                     importTableSetAction();
                     break;
                  case 85:
                     importTableAction();
                     break;
                  case 84:
                     exportTableSetStructureAction();
                     break;
                  case 83:
                     exportTableSetAction();
                     break;
                  case 82:
                     exportTableAction();
                     break;
                  case 81:
                     setTSSortAreaSizeAction();
                     break;
                  case 80:
                     setTSLogSizeAction();
                     break;
                  case 79:
                     setTSLogNumAction();
                     break;
                  case 78:
                     setTSTicketAction();
                     break;
                  case 77:
                     setTSRootPathAction();
                     break;
                  case 76:
                     setTSTmpSizeAction();
                     break;
                  case 75:
                     setTSSysSizeAction();
                     break;
                  case 74:
                     setCheckpointAction();
                     break;
                  case 73:
                     setTSInitFileAction();
                     break;
                  case 72:
                     showLogMngAction();
                     break;
                  case 71:
                     setLogMngAction();
                     break;
                  case 70:
                     recoverTableSetAction();
                     break;
                  case 69:
                     syncTableSetAction();
                     break;
                  case 68:
                     endBackupAction();
                     break;
                  case 67:
                     beginBackupAction();
                     break;
                  case 66:
                     removeArchLogAction();
                     break;
                  case 65:
                     addArchLogAction();
                     break;
                  case 64:
                     disableArchLogAction();
                     break;
                  case 63:
                     enableArchLogAction();
                     break;
                  case 62:
                     traceOffAction();
                     break;
                  case 61:
                     traceOnAction();
                     break;
                  case 60:
                     removePermAction();
                     break;
                  case 59:
                     setRightPerm();
                     break;
                  case 58:
                     setFilterPerm();
                     break;
                  case 57:
                     setTableSetPerm();
                     break;
                  case 54:
                     setPermAction();
                     break;
                  case 53:
                     dropRoleAction();
                     break;
                  case 52:
                     createRoleAction();
                     break;
                  case 51:
                     showRoleAction();
                     break;
                  case 50:
                     listRoleAction();
                     break;
                  case 49:
                     removeRoleAction();
                     break;
                  case 48:
                     assignRoleAction();
                     break;
                  case 47:
                     changePwdAction();
                     break;
                  case 46:
                     removeUserAction();
                     break;
                  case 45:
                     listUserAction();
                     break;
                  case 44:
                     addUserAction();
                     break;
                  case 43:
                     correctTableSetAction();
                     break;
                  case 42:
                     verifyTableSetAction();
                     break;
                  case 41:
                     checkTableSetAction();
                     break;
                  case 40:
                     addDataFileAction();
                     break;
                  case 39:
                     resetTableSetAction();
                     break;
                  case 38:
                     removeTableSetAction();
                     break;
                  case 37:
                     dropTableSetAction();
                     break;
                  case 36:
                     relocateMediatorAction();
                     break;
                  case 35:
                     relocateSecondaryAction();
                     break;
                  case 34:
                     switchMediatorAction();
                     break;
                  case 33:
                     switchSecondaryAction();
                     break;
                  case 32:
                     switchTableSetAction();
                     break;
                  case 31:
                     copyTableSetAction();
                     break;
                  case 30:
                     stopTableSetAction();
                     break;
                  case 29:
                     startTableSetAction();
                     break;
                  case 28:
                     createTableSetAction();
                     break;
                  case 27:
                     defineTableSetAction();
                     break;
                  case 26:
                     retrieveTableSetAction();
                     break;
                  case 25:
                     abortDbThreadAction();
                     break;
                  case 24:
                     transactionInfoAction();
                     break;
                  case 23:
                     copyInfoAction();
                     break;
                  case 22:
                     logThreadInfoAction();
                     break;
                  case 21:
                     admThreadInfoAction();
                     break;
                  case 20:
                     dbThreadLastQueryAction();
                     break;
                  case 19:
                     dbThreadInfoAction();
                     break;
                  case 18:
                     lockStatAction();
                     break;
                  case 17:
                     threadInfoAction();
                     break;
                  case 16:
                     buStatResetAction();
                     break;
                  case 15:
                     buStatInfoAction();
                     break;
                  case 14:
                     buFileInfoAction();
                     break;
                  case 13:
                     dbSessionInfoAction();
                     break;
                  case 12:
                     listNodeAction();
                     break;
                  case 11:
                     objInfoAction();
                     break;
                  case 10:
                     logInfoAction();
                     break;
                  case 9:
                     archLogInfoAction();
                     break;
                  case 8:
                     dataFileInfoAction();
                     break;
                  case 7:
                     listTableSetAction();
                     break;
                  case 6:
                     lockInfoAction();
                     break;
                  case 5:
                     rawModeOff();
                     break;
                  case 4:
                     rawModeOn();
                     break;
                  case 3:
                     poolEntryListAction();
                     break;
                  case 2:
                     tableSetInfoAction();
                     break;
                  case 1:
                     poolInfoAction();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               statementAction();
               return;
            }
            default:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool CegoAdm::getAction(int state, CegoAdm::Token token, CegoAdm::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool CegoAdm::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool CegoAdm::isSepSign(char c)
{
   if (c == '.') return true;
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '*') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   return false;
}
bool CegoAdm::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   return false;
}
bool CegoAdm::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void CegoAdm::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
