#ifndef _CEGOADMMON_H_INCLUDED_
#define _CEGOADMMON_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmMon.h  
// ---------------
// Cego admin monitor interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2011 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAdmMon
// 
// Description: The admin monitor interface
//
// Status: QS-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include <string.h>

#ifdef HAVE_MINGW32
#include <curses.h>
#else
#include <ncurses.h>
#endif

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Datetime.h>

#include "CegoAdminHandler.h"
 
class CegoAdmMon {
    
public:
    
    CegoAdmMon(CegoAdminHandler *pAH);
    ~CegoAdmMon();
        
    void showMonitor();
    void showHeader();

    void showPool();
    void showDBThread();
    void showAdmThread();
    void showLogThread();
    int showTableSetList();
    int showTableSet(const Chain& tableSet);

private:

    int showMenu(const Chain& title, const ListT<Chain>& menuList);
    void printMenu(const Chain& title, const ListT<Chain>& menuList);

    ListT<Chain> _refreshMenu;
    ListT<int> _refreshOpt;

    WINDOW * _mainwin;
    WINDOW * _menuwin;

    int _highlight;
    int _mode;
    CegoAdminHandler* _pAH;

    int _tsSelected;
    int _refInterval;
    int _nextPoolRefresh;
    int _nextTSRefresh;
    int _nextTSListRefresh;
    int _nextDBRefresh;
    int _nextAdmRefresh;
    int _nextLogRefresh;

    ListT<ListT<CegoFieldValue> > _poolinfo1;
    ListT<ListT<CegoFieldValue> > _poolinfo2;
    

    ListT<ListT<CegoFieldValue> > _dbthreadinfo;    
    ListT<ListT<CegoFieldValue> > _admthreadinfo;    
    ListT<ListT<CegoFieldValue> > _logthreadinfo;    

    ListT<ListT<CegoFieldValue> > _tsList;
    ListT<ListT<CegoFieldValue> > _tsInfo;
};

#endif














