#ifndef _CEGOADMNET_H_INCLUDED_
#define _CEGOADMNET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmNet.h
// ------------
// Cego admin client API
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAdmNet
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoModule.h"
#include "CegoAdminHandler.h"

class CegoAdmNet {

 public:

    CegoAdmNet();
    CegoAdmNet(const Chain& logFile, const Chain& logMode );
    ~CegoAdmNet();
    
    void connect(const Chain& serverName, int port, const Chain& user, const Chain& pwd);

    void getTableSetList(ListT<Chain>& tslist);
    void getTableSetInfo(const Chain& tableSet, 
			 ListT<Chain>& tsInfoList,
			 ListT<Chain>& fileInfoList,
			 ListT<Chain>& logInfoList);

    void startTableSet(const Chain& tableSet, bool doCleanup, bool forceload);
    void stopTableSet(const Chain& tableSet);

    void getThreadInfo(ListT<Chain>& threadInfoList);

    void getDbThreadInfo(ListT<Chain>& dbThreadInfoList);
    void getAdmThreadInfo(ListT<Chain>& admThreadInfoList);
    void getLogThreadInfo(ListT<Chain>& logThreadInfoList);

    void importTableSet(const Chain& tableSet, const Chain& impMode, const Chain& impFile);
    void exportTableSet(const Chain& tableSet, const Chain& expMode, const Chain& expFile);

    void addDataFile(const Chain& tableSet, const Chain& fileType, const Chain& dataFile, int numPages);
    
    void defineTableSet(const Chain& tableSet, 
			const Chain& tsRoot,
			const Chain& tsTicket,
			const Chain& primary,
			const Chain& secondary,
			int sysSize,
			int tmpSize,
			int logSize,
			int logNum, 
			long orderSize);
    
    void createTableSet(const Chain& tableSet);
    void dropTableSet(const Chain& tableSet);

    void switchSecondary(const Chain& tableSet);
    void switchMediatorAction(const Chain& tableSet);
    void relocateSecondary(const Chain& tableSet, const Chain& secondary);
    void relocateMediator(const Chain& tableSet, const Chain& mediator);

    void recoverTableSet(const Chain& tableSet, int pit);

    void disconnect();

private:

    void handleMedResult(CegoAdminHandler::ResultType res);
    
    Chain _logFile;
    Chain _logLevel;

    NetHandler* _pN;
    CegoAdminHandler* _pAH;
    CegoModule* _pModule;

};

#endif




