#ifndef _CEGOADMINTHREAD_H_INCLUDED_
#define _CEGOADMINTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminThread.h  
// -----------------
// Cego admin thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAdminThread
// 
// Description:
//
// Status: QG-2.5.5
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>
#include <lfcbase/NanoTimer.h>

#include "CegoAdminHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoDistManager.h"
#include "CegoDbThreadPool.h"
#include "CegoLogThreadPool.h"


class CegoAdminThreadPool;

class CegoAdminThread : public Thread {
    
 public:


    CegoAdminThread();
    CegoAdminThread(CegoAdminThreadPool *pPool, CegoDatabaseManager *pDBMng, CegoDbThreadPool *pDbPool, CegoLogThreadPool *pLogPool);
    ~CegoAdminThread();

    const Chain& lastAction() const;
    void* job(void* arg);

 private:

    void copyTableSet(int copyId, const Chain& tableSet, const Chain& secondary, const Chain& mediator, const Chain& user, const Chain& passwd, bool copyOnline);

    void serveSession(CegoAdminHandler *pAH);
    bool serveRequest(CegoAdminHandler *pAH, CegoAdminHandler::RequestType reqType);

    void srvRetrieveTableSet(CegoAdminHandler *pAH);
    void srvLockInfo(CegoAdminHandler *pAH);
    void srvLockStat(CegoAdminHandler *pAH);
    void srvPoolInfo(CegoAdminHandler *pAH);
    void srvPoolEntryList(CegoAdminHandler *pAH);
    void srvThreadInfo(CegoAdminHandler *pAH);

    void srvDbThreadInfo(CegoAdminHandler *pAH);
    void srvAdmThreadInfo(CegoAdminHandler *pAH);
    void srvLogThreadInfo(CegoAdminHandler *pAH);
    void srvDbThreadAbort(CegoAdminHandler *pAH);
    void srvDbSessionInfo(CegoAdminHandler *pAH);
    void srvCopyInfo(CegoAdminHandler *pAH);
    
    void srvDefineTableSet(CegoAdminHandler *pAH);
    void srvRemoveTableSet(CegoAdminHandler *pAH);
    void srvResetTableSet(CegoAdminHandler *pAH);
    void srvCreateTableSet(CegoAdminHandler *pAH);
    void srvDropTableSet(CegoAdminHandler *pAH);
    void srvStartTableSet(CegoAdminHandler *pAH);
    void srvStopTableSet(CegoAdminHandler *pAH);
    void srvVerifyTableSet(CegoAdminHandler *pAH);
    void srvCorrectTableSet(CegoAdminHandler *pAH);
    void srvDumpObject(CegoAdminHandler *pAH);
    void srvSetLogMng(CegoAdminHandler *pAH);
    void srvShowLogMng(CegoAdminHandler *pAH);
    void srvSetCheckpoint(CegoAdminHandler *pAH);
    void srvSetTSInitFile(CegoAdminHandler *pAH);
    void srvSetTSSysSize(CegoAdminHandler *pAH);
    void srvSetTSTmpSize(CegoAdminHandler *pAH);
    void srvSetTSRootPath(CegoAdminHandler *pAH);
    void srvSetTSTicket(CegoAdminHandler *pAH);
    void srvSetTSLogNum(CegoAdminHandler *pAH);
    void srvSetTSLogSize(CegoAdminHandler *pAH);
    void srvSetTSSortAreaSize(CegoAdminHandler *pAH);

    void srvStartRecovery(CegoAdminHandler *pAH);	      	
    void srvStopRecovery(CegoAdminHandler *pAH);
    void srvGetDbSpec(CegoAdminHandler *pAH);
    void srvGetDbInfo(CegoAdminHandler *pAH);
    void srvGetTSInfo(CegoAdminHandler *pAH);

    void srvGetDetailedTSInfo(CegoAdminHandler *pAH);
    void srvGetTransactionInfo(CegoAdminHandler *pAH);
    void srvGetBUStatInfo(CegoAdminHandler *pAH);

    void srvPropTSInfo(CegoAdminHandler *pAH);
    void srvCopyTableSet(CegoAdminHandler *pAH);
    void srvCopyFile(CegoAdminHandler *pAH);
    void srvGetNodeList(CegoAdminHandler *pAH);
    void srvSetTableSetNode(CegoAdminHandler *pAH);
    void srvSetLSN(CegoAdminHandler *pAH);
    void srvSetRunState(CegoAdminHandler *pAH);
    void srvSetSyncState(CegoAdminHandler *pAH);
    void srvExportTableSet(CegoAdminHandler *pAH);
    void srvImportTableSet(CegoAdminHandler *pAH);
    void srvExportTable(CegoAdminHandler *pAH);
    void srvImportTable(CegoAdminHandler *pAH);
    void srvAddDatafile(CegoAdminHandler *pAH);

    void srvUserInfo(CegoAdminHandler *pAH);
    void srvAddUser(CegoAdminHandler *pAH);
    void srvRemoveUser(CegoAdminHandler *pAH);
    void srvChangePwd(CegoAdminHandler *pAH);
    void srvListRole(CegoAdminHandler *pAH);
    void srvShowRole(CegoAdminHandler *pAH);
    void srvCreateRole(CegoAdminHandler *pAH);
    void srvDropRole(CegoAdminHandler *pAH);
    void srvAssignRole(CegoAdminHandler *pAH);
    void srvRemoveRole(CegoAdminHandler *pAH);
    void srvSetPerm(CegoAdminHandler *pAH);
    void srvRemovePerm(CegoAdminHandler *pAH);
    void srvUserTrace(CegoAdminHandler *pAH);

    void srvSyncTableSet(CegoAdminHandler *pAH);
    void srvInitLogs(CegoAdminHandler *pAH);

    void srvAddArchLog(CegoAdminHandler *pAH);
    void srvRemoveArchLog(CegoAdminHandler *pAH);

    void srvBeginBackup(CegoAdminHandler *pAH);
    void srvEndBackup(CegoAdminHandler *pAH);
    void srvRecover(CegoAdminHandler *pAH);
    void srvSecSwitch(CegoAdminHandler *pAH);

    // mediator services
    void medNotify(CegoAdminHandler *pAH);
    void medDefineTableSet(CegoAdminHandler *pAH);
    void medRemoveTableSet(CegoAdminHandler *pAH);
    void medResetTableSet(CegoAdminHandler *pAH);

    void medCreateTableSet(CegoAdminHandler *pAH);
    void medDropTableSet(CegoAdminHandler *pAH);

    void medStartTableSet(CegoAdminHandler *pAH);
    void medStopTableSet(CegoAdminHandler *pAH);

    void medCopyTableSet(CegoAdminHandler *pAH);
    void medSwitchTableSet(CegoAdminHandler *pAH);

    void medAddArchLog(CegoAdminHandler *pAH);
    void medRemoveArchLog(CegoAdminHandler *pAH);
    void medAddDatafile(CegoAdminHandler *pAH);
    void medVerifyTableSet(CegoAdminHandler *pAH);
    void medCorrectTableSet(CegoAdminHandler *pAH);

    void medGetTableSetList(CegoAdminHandler *pAH);
    void medGetDetailedTableSetInfo(CegoAdminHandler *pAH);

    void medGetObjectInfo(CegoAdminHandler *pAH);
    void medGetTransactionInfo(CegoAdminHandler *pAH);
    void medGetBUStatInfo(CegoAdminHandler *pAH);
    void medResetBUStat(CegoAdminHandler *pAH);

    void medBeginBackup(CegoAdminHandler *pAH);
    void medEndBackup(CegoAdminHandler *pAH);
    void medRecover(CegoAdminHandler *pAH);
    void medSecSwitch(CegoAdminHandler *pAH);

    void medSecRelocate(CegoAdminHandler *pAH);


    void medCheckTableSet(CegoAdminHandler *pAH);

    void medEnableArchLog(CegoAdminHandler *pAH);
    void medDisableArchLog(CegoAdminHandler *pAH);


    // secondary services
    void secMedSwitch(CegoAdminHandler *pAH);
    void secMedRelocate(CegoAdminHandler *pAH);


    CegoAdminHandler* getSession(const Chain& role, const Chain& hostname, const Chain& user, const Chain& pwd);
    void closeSession(CegoAdminHandler* pAH);

    void addTableSetUsage(Element *pTSE);

    Element* getDetailedTSInfo(const Chain& tableSet);
    Element* getObjectInfo(const Chain& tableSet);
    Element* getTransactionInfo(const Chain& tableSet);
    Element* getBUStatInfo(const Chain& tableSet);
    
    Element* checkTS(const Chain& hostType, const Chain& hostName, Element *pInfo, CegoAdminHandler *pPAH, CegoAdminHandler *pSAH);


    long _idx;

    CegoDatabaseManager* _pDBMng;
    CegoAdminThreadPool* _pPool;
    NetHandler* _pRequest;
    CegoDistManager* _pTabMng;

    CegoDbThreadPool* _pDbPool;
    CegoLogThreadPool* _pLogPool;

    Chain _lastAction;

    Chain _user;
    Chain _password;

    NanoTimer* _pTim;

    unsigned long _modId;
};

#endif






