#ifndef _CEGOAGGREGATION_H_INCLUDED_
#define _CEGOAGGREGATION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAggregation.h
// -----------------
// Cego aggregation structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke  
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAggregation
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoProcFetch.h"
#include "CegoFunction.h"

class CegoExpr;

class CegoAggregation {
    
 public:
    
    enum AggType { MIN, MAX, AVG, SUM, COUNT };
    
    CegoAggregation();
    CegoAggregation(char* buf, CegoDistManager *pGTM);
    CegoAggregation(Element* pAE, CegoDistManager *pGTM);
    CegoAggregation(AggType type, CegoExpr* pExpr, bool isDistinct = false);
    ~CegoAggregation();

    void setFieldListArray(ListT<CegoField> *fla, int size);

    void setBlock(CegoProcBlock *pBlock);

    CegoFieldValue& getFieldValue();
    void setFieldValue(const CegoFieldValue& fv);
    
    const AggType getType() const;
    CegoExpr* getExpr() const;

    void setAggregationId(int aid);
    const int getAggregationId() const;

    void clearAttrCache();
    
    CegoAggregation* clone(bool isAttrRef = false);

    CegoAggregation& operator = ( const CegoAggregation& ag);

    ListT<CegoAttrDesc*> getAttrRefList() const;

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM);
    int getEncodingLength() const;

    Element* toElement() const;
    void fromElement(Element *pAggElement, CegoDistManager *pGTM);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAggregation& ag);
      
 private:

    CegoFieldValue _fv;
   
    int _aid;
    AggType _type;    
    CegoExpr* _pExpr;
    bool _isDistinct;
};

#endif




