#ifndef _CEGOALTERDESC_H_INCLUDED_
#define _CEGOALTERDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAlterDesc.h
// ---------------
// Cego alter description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAlterDesc
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

#include <lfcxml/Element.h>

#include "CegoField.h"

class CegoAlterDesc {

 public:

    enum AlterType { ADD, DROP, MODIFY, RENAME };

    CegoAlterDesc();
    CegoAlterDesc(Element *pAlterElement);
    CegoAlterDesc(AlterType type, const CegoField& f);
    CegoAlterDesc(AlterType type, const Chain& attrName);
    CegoAlterDesc(const Chain& oldAttrName, const Chain& newAttrName);
    CegoAlterDesc(const Chain& attrName);
    ~CegoAlterDesc();

    const Chain& getAttrName() const;
    const Chain& getOldAttrName() const;

    CegoField& getField();
    AlterType getType() const;

    CegoAlterDesc& operator = ( const CegoAlterDesc& ad);
    bool operator == ( const CegoAlterDesc& ad);

    Chain toChain() const;
    Element* toElement() const;
    void fromElement(Element *pAlterElement);

    friend ostream& operator << (ostream& s, const CegoAlterDesc& a);
    
private:
    
    Chain _attrName;
    CegoField _f;
    AlterType _type;
    
};

#endif




