#ifndef _CEGOATTRCOMP_H_INCLUDED_
#define _CEGOATTRCOMP_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrComp.h
// --------------
// Cego table attribute comparison description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2011 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAttrComp
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Matcher.h>

#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoAttrDesc.h"
#include "CegoComparison.h"

class CegoAttrComp {

 public:

    enum CompMode { UNDEF, VAL, ATTR, BTWN, ISLIKE, ISNOTLIKE };

    CegoAttrComp();
    CegoAttrComp(const Chain& attrName);
    CegoAttrComp(const Chain& attrName, CegoComparison comp, const CegoFieldValue& fv);
    CegoAttrComp(const Chain& attrName, CegoComparison comp, const CegoAttrDesc& attrDesc);
    CegoAttrComp(const Chain& attrName, const CegoFieldValue& fv, const CegoFieldValue& fv2);
    CegoAttrComp(const Chain& attrName, const Chain& pattern, bool isNot);
    ~CegoAttrComp();

    CompMode getCompMode() const;

    const Chain& getAttrName() const;
    CegoComparison getComparison() const;
    void setComparison(CegoComparison comp);

    const CegoFieldValue& getFieldValue() const;
    const CegoFieldValue& getFieldValue2() const;
    const CegoAttrDesc& getAttrDesc() const;

    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>* joinBuf, int offset, int size);

    bool isSetup();

    const Chain& getPattern() const;
    Matcher* getMatcher();

    CegoAttrComp& operator = ( const CegoAttrComp& ac);
    bool operator == ( const CegoAttrComp& ac) const;

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrComp& ac);
      
 private:

    Chain _attrName;
    CegoComparison _comp;
    CegoFieldValue _fv;
    CegoFieldValue _fv2;
    CegoAttrDesc _attrDesc;
    CompMode _compMode;
    Chain _pattern;    
    Matcher* _pMatcher;

    bool _isSetup;
};

#endif




