#ifndef _CEGOATTRCOND_H_INCLUDED_
#define _CEGOATTRCOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrCond.h
// --------------
// Cego attribute condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAttrCond
// 
// Description: Attribute condition description used for index cursors
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

#include "CegoAttrComp.h"
#include "CegoPredDesc.h"

class CegoAttrCond {
    
 public:

    enum IndexMatch { FULL, PART, INAPP };
    
    CegoAttrCond();
    ~CegoAttrCond();

    void add(const CegoAttrComp& attrComp);

    int numComp() const;
    int getStrength() const;

    SetT<CegoAttrComp>& getAttrCompSet();

    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>* joinBuf, int offset, int size);

    CegoAttrCond getFilterCond(const ListT<CegoField>& fl) const;    
    CegoAttrCond getIndexCond(const ListT<CegoField>& fl) const;

    IndexMatch checkIndex(const ListT<CegoField>& schema) const;
    void setIdxSchema(ListT<CegoField>& schema);

    CegoAttrComp::CompMode getPrimaryCompMode() const;

    CegoComparison getPrimaryComparison() const;
    void setPrimaryComparison(CegoComparison comp);

    void asConjunctionList(const ListT<CegoExpr*>& exprList, ListT<CegoPredDesc*>& conjunctionList) const;

    bool diff( const CegoAttrCond& ac) const;

    CegoAttrCond& operator = ( const CegoAttrCond& ac);
    bool operator == ( const CegoAttrCond& ac) const;
    bool operator != ( const CegoAttrCond& ac) const;

    friend CegoAttrCond operator + ( const CegoAttrCond& ac1, const CegoAttrCond& ac2);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrCond& ac);
      
 private:

    CegoExpr* getExpressionForAlias(const ListT<CegoExpr*>& exprList, const Chain& alias) const;

    ListT<CegoField> _idxSchema;
    SetT<CegoAttrComp> _attrCompSet;

};

#endif




