#ifndef _CEGOATTRDESC_H_INCLUDED_
#define _CEGOATTRDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrDesc.h
// --------------
// Cego table attribute description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoAttrDesc
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include <lfcxml/Element.h>

#include "CegoContentObject.h"
#include "CegoField.h"

class CegoAttrDesc {

 public:


    CegoAttrDesc();
    CegoAttrDesc(Element *pADE);
    CegoAttrDesc(const Chain& attrName);
    CegoAttrDesc(const Chain& tableName, const Chain& attrName, bool isValid = false);
    ~CegoAttrDesc();

    void setValid(bool isValid);
    bool isValid() const;

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    CegoAttrDesc* clone() const;

    CegoAttrDesc& operator = ( const CegoAttrDesc& ad);
    bool operator == ( const CegoAttrDesc& ad);
    bool operator != ( const CegoAttrDesc& ad);

    Chain toChain() const;

    Element* toElement() const;
    void fromElement(Element *pAttrDescElement);

    void encode(char *buf);
    void decode(char *buf);
    int getEncodingLength() const;

    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    friend ostream& operator << (ostream& s, const CegoAttrDesc& a);
    
private:
    
    bool _isValid;
    Chain _tableName;
    Chain _attrName;
    
};

#endif




