#ifndef _CEGOBTREECURSOR_H_INCLUDED_
#define _CEGOBTREECURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeCursor.h
// -----------------
// Cego BTree+ cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBTreeCursor
// 
// Description: Traversing through btree
//
// Status: QG-2.13
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoObject.h"
#include "CegoField.h"
#include "CegoAttrCond.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoQueryHelper.h"
#include "CegoBufferPage.h"
#include "CegoBTreeValue.h"
#include "CegoBTreeNode.h"

class CegoBTreeCursor {
    
public:
    
    CegoBTreeCursor();
    CegoBTreeCursor(CegoTableManager* pTabMng, int tabSetId, const Chain& btreeName, CegoObject::ObjectType type, CegoAttrCond* pAttrCond, bool ignoreTouched, bool readUncommitted);
    ~CegoBTreeCursor();
    
    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);
    
    void reset();	
    void abort();
    
private:

    CegoComparison compValue(const CegoBTreeValue& val);
    
    CegoAttrCond* _pAttrCond;

    CegoTableManager* _pTabMng;
    CegoDatabaseManager* _pDBMng;

    Chain _btreeName;
    CegoObject::ObjectType _type;

    int _rootFileId;
    int _rootPageId;

    int _curFileId;
    int _curPageId;
    int _curPos;
    CegoBTreeNode _curLeaf;
    CegoBufferPage _curPage;
    
    unsigned long _dataLock;

    int _tabSetId;

    bool _ignoreTouched;
    bool _readUncommitted;

    CegoQueryHelper _qh;

    bool _cursorCached;
    bool _eoc;

    ListT<CegoField> _btreeSchema;
    int _keyLen;
    StackT<CegoBufferPage> _parentPageStack;
    StackT<CegoBufferPage> _fixedPageStack;
};

#endif




