#ifndef _CEGOBTREEMANAGER_H_INCLUDED_
#define _CEGOBTREEMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeManager.h
// ------------------
// Cego BTree+ manager class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBTreeManager
// 
// Description: This class implements the btree algorithm to be used as an alternative index object.
//
// Status: 2.16
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoDataType.h"
#include "CegoField.h"
#include "CegoDataPointer.h"
#include "CegoSystemObject.h"
#include "CegoObjectManager.h"
#include "CegoBTreeNode.h"
#include "CegoBTreeValue.h"

class CegoBTreeManager {

public:
    
  CegoBTreeManager(CegoObjectManager* pObjMng, CegoBTreeObject *pBTO);
    ~CegoBTreeManager();

    void insertBTree(const CegoDataPointer& dp,
		     const CegoBTreeValue &iv,
		     int tid);

    void fixRoot();
    void unfixRoot();

    void insertBTree(const CegoDataPointer& sysEntry,
		      const CegoDataPointer& dp, 
		      const CegoBTreeValue &iv,
		      int tid);

    void dumpBTree();
    void dumpNode(int level, int fileId, int pageId);
    
    void deleteBTree(const CegoBTreeValue &iv,
		     const CegoDataPointer& ddp);

    int getNumPages();
    void freeBTree();

    
    char checkIndex(int tabSetId, const Chain& indexName, CegoObject::ObjectType idxType);

private:

    int countNodePages(int fileId, int pageId);
    void freeNodePages(int fileId, int pageId);

    CegoBTreeObject* _pBTO;
    CegoObjectManager* _pObjMng;
    CegoDatabaseManager* _pDBMng;
    
    CegoObject::ObjectType _btreeType;
    ListT<CegoField> _btreeSchema;
    Chain _btreeName;
    int _keyLen;
    int _tabSetId;

    CegoBufferPage _rootBP;
    bool _rootFixed;

    unsigned long _modId;
};

#endif




