#ifndef _CEGOBTREEVALUE_H_INCLUDED_
#define _CEGOBTREEVALUE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeValue.h
// ----------------
// Multidimensional btree value class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBTreeValue
// 
// Description: This class handles all operations on btree values. Since the values are sequentially stored
//              in a byte array, conversion methods are required to store, retrieve and for compare these values 
//
// Status: QG-2.16
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>

// cego includes
#include "CegoDefs.h"
#include "CegoField.h"

class CegoBTreeValue {

 public:
    
    enum Comparison { LESS, EQUAL, MORE };
    
    CegoBTreeValue();
    CegoBTreeValue(char *p);
    ~CegoBTreeValue();
    
    void valueFromSchema(ListT<CegoField>* pSchema, int len);
    void valueFromSchema(const ListT<CegoField> tableSchema, const ListT<CegoField> indexSchema);

    ListT<CegoFieldValue> valueToFVL(const ListT<CegoField>& schema) const;

    void setPtr(char* p);
    char* getPtr() const;
    
    CegoBTreeValue& operator = (const CegoBTreeValue& iv);

    Comparison comp(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;

    bool isHigher(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;
    bool isEqual(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;
    bool operator > ( const CegoBTreeValue& iv) const;

    Chain toChain(ListT<CegoField>* pSchema) const;    

 private:
    
    char *_pI;
    char _idxArray[TABMNG_MAXINDEXVALUE];
};

#endif
