///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatConnection.cc
// -------------------------
// Cego mediator connection class implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoBeatConnection
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Net.h>
#include <lfcbase/Host.h>

#include "CegoBeatConnection.h"
#include "CegoXMLdef.h"

#include <stdlib.h>
#include <string.h>

CegoBeatConnection::CegoBeatConnection()
{
    _pN = 0;
    _pAdminHandle = 0;
}

CegoBeatConnection::CegoBeatConnection(const Chain& hostName)
{
    _hostName = hostName;
    _pN = 0;
    _pAdminHandle = 0;
}

CegoBeatConnection::CegoBeatConnection(const Chain& hostName, int portNo, const Chain& user, const Chain& passwd, CegoModule *pModule)
{
    _hostName = hostName;
    _portNo = portNo;
    _user = user;
    _passwd = passwd;
    _pN = 0;
    _pAdminHandle = 0;
    _pModule = pModule;
    
    _modId = _pModule->getModId("CegoBeatConnection");
}
 
CegoBeatConnection::~CegoBeatConnection()
{
    
    if ( _pN )
	delete _pN;

    if ( _pAdminHandle )
	delete _pAdminHandle;
}


void CegoBeatConnection::setHostName(const Chain& hostName)
{
    _hostName = hostName;
}

const Chain& CegoBeatConnection::getHostName() const
{
    return _hostName;
}

void CegoBeatConnection::setPortNo(int portNo)
{
    _portNo = portNo;
}

int CegoBeatConnection::getPortNo() const
{
    return _portNo;
}


void CegoBeatConnection::setUser(const Chain& user)
{
    _user = user;
}

const Chain& CegoBeatConnection::getUser() const
{
    return _user;
}

void CegoBeatConnection::setPasswd(const Chain& passwd)
{
    _passwd = passwd;
}

const Chain& CegoBeatConnection::getPasswd() const
{
    return _passwd;
}

void CegoBeatConnection::beat(const ListT<Chain>& tsList, const ListT<Chain>& runList, const ListT<Chain>& syncList)
{   
    if ( _pAdminHandle )
    {
	Host h;
	_pAdminHandle->medNotifyMediator(h.getName(), XML_ONLINE_VALUE, tsList, runList, syncList);
    }
}

void CegoBeatConnection::connect()
{
    Net n ( NETMNG_MSG_BUFLEN, NETMNG_SIZEBUFLEN );   
    _pN = n.connect(_hostName, _portNo);
    _pAdminHandle = new CegoAdminHandler(_pModule, _pN);
    _pAdminHandle->requestSession(_user, _passwd, false);
}

void CegoBeatConnection::disconnect()
{
    
    if ( _pAdminHandle )
	_pAdminHandle->closeSession();

}

CegoBeatConnection& CegoBeatConnection::operator = ( const CegoBeatConnection& mc )
{
    _hostName = mc._hostName;
    _portNo = mc._portNo;
    _user = mc._user;
    _passwd = mc._passwd;

    return (*this);
}

bool CegoBeatConnection::operator == ( const CegoBeatConnection& mc)
{    
    if (_hostName == mc._hostName)
	return true;
    return false;
}
	
ostream& operator << (ostream& s, const CegoBeatConnection& mc)
{
    s <<  mc._hostName << ":" << mc._portNo << ":" << mc._user << ":" << mc._passwd;
    return s;
}


