#ifndef _CEGOBEATCONNECTION_H_INCLUDED_
#define _CEGOBEATCONNECTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatConnection.h
// ------------------------
// Cego beat connection class defintion
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBeatConnection
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/Logger.h>
#include <lfcbase/NetHandler.h>

#include "CegoAdminHandler.h"

class CegoBeatConnection {

 public:


    CegoBeatConnection();

    CegoBeatConnection(const Chain& hostName);
    CegoBeatConnection(const Chain& hostName, int portNo, const Chain& user, const Chain& passwd, CegoModule *pModule);

    ~CegoBeatConnection();

    void setHostName(const Chain& hostName);
    const Chain& getHostName() const;

    void setPortNo(int portNo);
    int getPortNo() const;

    void setUser(const Chain& user);    
    const Chain& getUser() const;

    void setPasswd(const Chain& passwd);    
    const Chain& getPasswd() const;

    void connect();
    void disconnect();
    void beat(const ListT<Chain>& tsList, const ListT<Chain>& runList, const ListT<Chain>& syncList);

    CegoBeatConnection& operator = ( const CegoBeatConnection& mc);
    bool operator == ( const CegoBeatConnection& mc);

    friend ostream& operator << (ostream& s, const CegoBeatConnection& mc);
    
private:
    
    Chain _hostName;
    int _portNo;
    Chain _user;
    Chain _passwd;

    NetHandler* _pN;
    CegoAdminHandler* _pAdminHandle;
    CegoModule* _pModule;

    unsigned long _modId;
};

#endif




