#ifndef _CEGOBEATTHREAD_H_INCLUDED_
#define _CEGOBEATTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatThread.h  
// ----------------
// Cego heart beat thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBeatThread
// 
// Description: The Cego beat thread sends periodically a heartbeat message to all responsible 
//              mediator nodes
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>
#include <lfcbase/SigHandler.h>

#include "CegoBeatConnection.h"
#include "CegoDatabaseManager.h"

class CegoBeatThread : public SigHandler {
    
 public:

    CegoBeatThread(CegoDatabaseManager *pDBMng);
    ~CegoBeatThread();

    void beat();

    bool isTerminated();

    void sigCatch(int sig);

 private:
    
    ListT<CegoBeatConnection*> _actBeatList;

    CegoDatabaseManager* _pDBMng;
    bool _terminated;

    unsigned long _modId;
};

#endif
