#ifndef _CEGOBLOB_H_INCLUDED_
#define _CEGOBLOB_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBlob.h
// ----------
// Cego blob definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBlob
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

class CegoBlob {

public:
  
    CegoBlob();  
    CegoBlob(int fileId, int pageId);
    CegoBlob(int fileId, int pageId, unsigned char *blobBuf, long blobSize);  
    ~CegoBlob();

    void readBlob(const Chain& fileName);
    void writeBlob(const Chain& fileName);
    
    long getSize() const;
    unsigned char* getBufPtr();

    void allocate(long size);
    void reset();

    bool nextChunk(long chunkSize);
    void putChunk(unsigned char *chunkBuf, long chunkSize);
    unsigned char* getChunkPtr();
    int getChunkSize();

    void setFileId(int fileId);
    int getFileId() const;

    void setPageId(int pageId);
    int getPageId() const;

    CegoBlob& operator = ( const CegoBlob& b);
    bool operator == ( const CegoBlob& b);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoBlob& b);
    
private:

    int _fileId;
    int _pageId;

    long _size;
    unsigned char *_buf;

    long _chunkSize;
    unsigned char *_chunkPtr;

};

#endif
