#ifndef _CEGOBUFFERPAGE_H_INCLUDED_
#define _CEGOBUFFERPAGE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPage.h
// ----------------
// Cego BufferPage Class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBufferPage
// 
// Description: The description and management of a Cego database page is handled in this class
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

class CegoBufferPage {
    
public:
    
    enum PageType { TABLE, TUPLE, BLOB, BTREE_NODE, BTREE_LEAF };
    
    typedef struct PageHead {
	PageType pageType;
	int nextFileId;
	int nextPageId;
    } PageHead;
    
    CegoBufferPage();
    CegoBufferPage(const CegoBufferPage& bp);
    CegoBufferPage(void *pagePtr, int pageSize);
    ~CegoBufferPage();
    
    void initPage(PageType t);

    void setFixed(bool isFixed);
    bool isFixed();

    void setFileId(int fileId);
    int getFileId();

    void setPageId(int pageId);
    int getPageId();
    
    void setNextFileId(int fileId);
    int getNextFileId();
    
    void setNextPageId(int pageId);
    int getNextPageId();
    
    void* newEntry(int size);
    void freeEntry(void *);
  
    int getNumEntries();
    
    void* getFirstEntry();
    void* getNextEntry();

    char* getChunkEntry();
    
    int getChunkLen();
    int getEntryLen();
    int getEntryPos();
    
    void setType(PageType t);
    PageType getType();

    void setPagePtr(char* ptr);
    void setPageHead(PageHead* ptr);
    void setPageSize(int pageSize);    

    void* getPagePtr();
    
    void printPage();

    CegoBufferPage& operator = ( const CegoBufferPage& bp);  
    bool operator == ( const CegoBufferPage& bp);
    bool operator != ( const CegoBufferPage& bp);

 private:

    int _pageId;
    int _fileId;
    
    int _pageSize;
    char *_pagePtr;
    
    char *_ePtr;
    char *_blobPtr;
    
    int _entryLen;
    int _entryPos;
    
    PageHead* _pageHead;

    bool _isFixed;
};



#endif



