///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPoolEntry.cc
// ----------------------
// Cego buffer pool entry implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2011 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoBufferPoolEntry
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoBufferPoolEntry.h"

#include <lfcbase/Exception.h>
#include <lfcbase/File.h>

#include "CegoDefs.h"

#include <string.h>
#include <stdlib.h>

CegoBufferPoolEntry::CegoBufferPoolEntry()
{
}

CegoBufferPoolEntry::CegoBufferPoolEntry(int pos, const Chain& occState, bool isDirty, int numFixes, int tabSetId, int fileId, int pageId, int fixStat)
{
    _pos = pos;
    _occState = occState;
    _isDirty = isDirty;
    _numFixes = numFixes;
    _tabSetId = tabSetId;   
    _fileId = fileId;
    _pageId = pageId;
    _fixStat = fixStat;
}

CegoBufferPoolEntry::~CegoBufferPoolEntry()
{
}

int CegoBufferPoolEntry::getPos() const
{
    return _pos;
}

const Chain& CegoBufferPoolEntry::getOccState() const
{
    return _occState;
}

bool CegoBufferPoolEntry::isDirty() const
{
    return _isDirty;
}

int CegoBufferPoolEntry::getNumFixes() const
{
    return _numFixes;
}

int CegoBufferPoolEntry::getTabSetId() const
{
    return _tabSetId;
}

int CegoBufferPoolEntry::getFileId() const
{
    return _fileId;
}

int CegoBufferPoolEntry::getPageId() const
{
    return _pageId;
}

int CegoBufferPoolEntry::getFixStat() const
{
    return _fixStat;
}

CegoBufferPoolEntry& CegoBufferPoolEntry::operator = ( const CegoBufferPoolEntry& b)
{
    _pos = b._pos;
    _occState = b._occState;
    _isDirty = b._isDirty;
    _numFixes = b._numFixes;
    _tabSetId = b._tabSetId;   
    _fileId = b._fileId;
    _pageId = b._pageId;
    _fixStat = b._fixStat;

    return (*this);
}

bool CegoBufferPoolEntry::operator == ( const CegoBufferPoolEntry& b)
{
    if ( _pos == b._pos )
	return true;
    return false;
}

Chain CegoBufferPoolEntry::toChain() const
{
    Chain s;
    
    s = "N/A";
    
    return s;
}
    
ostream& operator << (ostream& s, const CegoBufferPoolEntry& qe)
{    
    s << qe.toChain();
    return s;
}
