#ifndef _CEGOBUFFERPOOLENTRY_H_INCLUDED_
#define _CEGOBUFFERPOOLENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPoolEntry.h
// ---------------------
// Cego buffer pool entry definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2011 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoBufferPoolEntry
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

class CegoBufferPoolEntry {

public:
  
    CegoBufferPoolEntry();  
    CegoBufferPoolEntry(int pos, const Chain& occState, bool isDirty, int numFixes, int tabSetId, int fileId, int pageId, int fixStat);
    ~CegoBufferPoolEntry();

    int getPos() const;
    const Chain& getOccState() const;
    bool isDirty() const;
    int getNumFixes() const;
    int getTabSetId() const;
    int getFileId() const;
    int getPageId() const;
    int getFixStat() const;

    CegoBufferPoolEntry& operator = ( const CegoBufferPoolEntry& b);
    bool operator == ( const CegoBufferPoolEntry& b);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoBufferPoolEntry& b);
    
private:

    int _pos;
    Chain _occState;
    bool _isDirty;
    int _numFixes;
    int _tabSetId;
    int _fileId;
    int _pageId;
    int _fixStat;

};

#endif
