#ifndef _CEGOCASECOND_H_INCLUDED_
#define _CEGOCASECOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCaseCond.h
// --------------
// Cego case condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoCaseCond
// 
// Description: Case condition description
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////


#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "CegoPredDesc.h"
#include "CegoExpr.h"

class CegoCaseCond {
    
 public:

    CegoCaseCond();
    CegoCaseCond(Element* pCaseElement, CegoDistManager *pGTM);
    ~CegoCaseCond();

    void addPred(CegoPredDesc *CegoPredDesc, CegoExpr* pExpr);
    void setElseExpr(CegoExpr *pExpr);

    ListT<CegoPredDesc*>& getPredList();
    ListT<CegoExpr*>& getExprList();
    CegoExpr* getElseExpr();
    
    void setBlock(CegoProcBlock *pBlock);
    void setFieldListArray(ListT<CegoField> *fla, int flaSize);

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    void clearAttrCache();

    ListT<CegoField> getFieldList() const;
    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    CegoCaseCond* clone(bool isAttrRef = false);
    
    CegoCaseCond& operator = ( const CegoCaseCond& cc);

    Chain toChain() const;
    Element* toElement() const;
    void fromElement(Element *pCaseClauseElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoCaseCond& cc);
      
 private:

    ListT<CegoPredDesc*> _predList;
    ListT<CegoExpr*> _exprList;
    CegoExpr* _elseExpr;

    ListT<CegoField> *_fla;
    int _flaSize;

    CegoProcBlock* _pBlock;
};

#endif




