#ifndef _CEGOCHECKOBJECT_H_INCLUDED_
#define _CEGOCHECKOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckObject.h
// -----------------
// Cego check object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoCheckObject
// 
// Description: Derived class from CegoDecodable to use as a container class for check objects
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

#include "CegoField.h"
#include "CegoObject.h"
#include "CegoPredDesc.h"
#include "CegoDecodableObject.h"


class CegoCheckObject : public CegoDecodableObject {

 public:


    CegoCheckObject();
    CegoCheckObject(const CegoCheckObject& co);
    CegoCheckObject(ObjectType type,  const Chain& objName, int tabSetId = 0);

    CegoCheckObject(int tabSetId, const Chain& checkName, const Chain& tabName, CegoPredDesc *pPredDesc);
	
    ~CegoCheckObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;
    
    void setPredDesc(CegoPredDesc *pPredDesc);   
    CegoPredDesc* getPredDesc();

    int getEntrySize() const;

    void encode(char *buf);
    void decode(char *buf);
    
    CegoCheckObject& operator = ( const CegoCheckObject& oe);
    bool operator == ( const CegoCheckObject& oe);
    
    Chain toChain() const;

    Element* getElement() const;
    void putElement(Element* pElement);

    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;

    Chain _tabName;
    CegoPredDesc *_pPredDesc;

};

#endif
