///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpoint.cc
// -----------------
// Cego checkpoint class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoCheckpoint
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoCheckpoint.h"
#include <lfcbase/Datetime.h>

#include <string.h>
#include <stdlib.h>

CegoCheckpoint::CegoCheckpoint()
{
}

CegoCheckpoint::~CegoCheckpoint()
{
}

bool CegoCheckpoint::checkpointReached(const Chain& tableSet, int interval)
{
    // checkpointing disabled
    if ( interval == 0 )
	return false;

    Datetime ts;
    CheckpointEntry* pCPE;
    if ( ( pCPE = _tsList.Find(CheckpointEntry(tableSet))) != 0 )
    {
	if ( pCPE->getNextCP() < ts.asInt() )
	{
	    pCPE->setNextCP(ts.asInt() + interval);
	    return true;
	}
    }
    else
    {
	_tsList.Insert(CheckpointEntry(tableSet, ts.asInt() + interval));
    }
    return false;
}
