#ifndef _CEGOCHECKPOINT_H_INCLUDED_
#define _CEGOCHECKPOINT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpoint.h
// ----------------
// Cego checkpoint class definition
//        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2011 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoCheckpoint
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////


#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

class CegoCheckpoint {

 public:
   
    CegoCheckpoint();
    ~CegoCheckpoint();

    bool checkpointReached(const Chain& tableSet, int interval);

 private:

    class CheckpointEntry {

    public:

	CheckpointEntry() { };
	CheckpointEntry(const Chain& ts) { _ts = ts; };
	CheckpointEntry(const Chain& ts, int nextCP) { _ts = ts; _nextCP = nextCP; };
	~CheckpointEntry() {};
	       
	int getNextCP() { return _nextCP; };
	void setNextCP(int nextCP) { _nextCP = nextCP; };

	CheckpointEntry& operator = ( const CheckpointEntry& cp) { 
	    _ts = cp._ts;
	    _nextCP = cp._nextCP;
	    return *this;
	};
	
	bool operator == ( const CheckpointEntry& cp) {
	    return _ts == cp._ts;
	};
	
    private:
	Chain _ts;
	int _nextCP;
    };

    ListT<CheckpointEntry> _tsList;

};

#endif




