#ifndef _CEGOCONDDESC_H_INCLUDED_
#define _CEGOCONDDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCondDesc.h
// --------------
// Cego condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoCondDesc
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoPredDesc.h"

class CegoCondDesc {

 public:

    enum CondType { AND, OR, PRED };

    CegoCondDesc(char *buf, CegoDistManager *pGTM);
    CegoCondDesc(Element *pCondElement, CegoDistManager *pGTM);
    CegoCondDesc(CondType ct);
    ~CegoCondDesc();

    void getPlanList(ListT<Element*>& planList);

    CegoPredDesc* Left();
    CegoPredDesc* Right();
    
    void setLeft(CegoPredDesc* pP);
    void setRight(CegoPredDesc* pP);

    void setCondType(CondType ct);
    CondType getCondType();

    void setBlock(CegoProcBlock* pBlock);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM);
    int getEncodingLength() const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    ListT<CegoField> getFieldList() const;

    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    Element* toElement() const;
    void fromElement(Element* pCondElement, CegoDistManager *pGTM);
    
    void cleanUp();

    CegoCondDesc* clone(bool isAttrRef = false);

 private:

    CondType _condType;

    CegoPredDesc *_pLeft;
    CegoPredDesc *_pRight;

};

#endif




