#ifndef _CEGOCONTENTOBJECT_H_INCLUDED_
#define _CEGOCONTENTOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoContentObject.h
// -------------------
// Cego content object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoContentObject
// 
// Description: Cego content object structure
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Exception.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

#include "CegoField.h"
#include "CegoDecodableObject.h"

class CegoContentObject : public CegoDecodableObject {

public:
        
    CegoContentObject();
    CegoContentObject(const CegoContentObject& co);
    CegoContentObject(int tabSetId, CegoObject::ObjectType type, const Chain& contentName);
    CegoContentObject(int tabSetId, CegoObject::ObjectType type, const Chain& contentName, const Chain& tableName, const ListT<CegoField>& schema);
    
    virtual ~CegoContentObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;

    void setTabAlias(const Chain& name);
    const Chain& getTabAlias() const;
    
    virtual void setSchema(const ListT<CegoField>& schema) = 0;   
    ListT<CegoField>& getSchema();

    ListT<CegoContentObject*>& getSubCOList();

    CegoContentObject& operator = ( const CegoContentObject& co);
    bool operator == ( const CegoContentObject& co);

    virtual Chain toChain() const = 0;
    virtual CegoContentObject* clone(bool isAttrRef) = 0;
    
protected:

    int getBaseContentSize() const;

    void encodeBaseContent(char *buf, int size);
    void decodeBaseContent(char *buf, int& size);

    void setEmpty();
    
    ListT<CegoField> _schema;
    ListT<CegoContentObject*> _subCOList;
    
private:

    int getSchemaSize() const;
    Chain _tabName;
    Chain _tabAlias;

};

#endif
