///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.cc
// ------------------
// Cego data pointer class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoDataPointer
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoDataPointer.h"

#include <string.h>
#include <stdlib.h>

CegoDataPointer::CegoDataPointer()
{
    _idArray[0] = 0;
    _idArray[1] = 0;
    _idArray[2] = 0;

    /*
    _fileId = 0;
    _pageId = 0;
    _offset = 0;
    */
}

CegoDataPointer::CegoDataPointer(int fileId, int pageId, int offset)
{

    _idArray[0] = fileId;
    _idArray[1] = pageId;
    _idArray[2] = offset;

    /*
    _fileId = fileId;
    _pageId = pageId;
    _offset = offset;
    */
}

CegoDataPointer::~CegoDataPointer()
{
}

void CegoDataPointer::setFileId(int fileId)
{
    _idArray[0] = fileId;
    // _fileId = fileId;
}

int CegoDataPointer::getFileId() const
{
    return _idArray[0];
    // return _fileId;
}

void CegoDataPointer::setPageId(int pageId)
{
    _idArray[1] = pageId;
    // _pageId = pageId;
}

int CegoDataPointer::getPageId() const
{
    return _idArray[1];
    // return _pageId;
}
 
void CegoDataPointer::setOffset(int offset)
{
    _idArray[2] = offset;
    // _offset = offset;
}

int CegoDataPointer::getOffset() const
{
    return _idArray[2];
    // return _offset;
}

int CegoDataPointer::getEncodingLength() const
{
    return ( 3 * sizeof(int) ) ;
}

void CegoDataPointer::encode(void* p) const
{
    void* ip = p;

    memcpy(ip, _idArray, 3 * sizeof(int));
    
    /*
    memcpy(ip, &_fileId, sizeof(int));
    memcpy((void*)((long)ip + sizeof(int)) , &_pageId, sizeof(int));
    memcpy((void*)((long)ip + 2 * sizeof(int)), &_offset, sizeof(int));
    */
}

void CegoDataPointer::decode(void* p)
{
    void* ip = p;

    memcpy(_idArray, ip, 3 * sizeof(int));
    
    /*
    memcpy(&_fileId, ip, sizeof(int));
    memcpy(&_pageId,(void*)((long)ip + sizeof(int)), sizeof(int));
    memcpy(&_offset,(void*) ((long) ip + 2 * sizeof(int)), sizeof(int));
    */
}

CegoDataPointer& CegoDataPointer::operator = ( const CegoDataPointer& d)
{
    memcpy(_idArray, d._idArray, 3 * sizeof(int));
    /*
    _fileId = d._fileId;
    _pageId = d._pageId;
    _offset = d._offset;
    */
    return (*this);
}

bool CegoDataPointer::operator == ( const CegoDataPointer& d) const
{
    
    if (_idArray[0] == d._idArray[0] && _idArray[1] == d._idArray[1] && _idArray[2] == d._idArray[2])
    // if (_fileId == d._fileId && _pageId == d._pageId && _offset == d._offset)
	return true;
    return false;
}

bool CegoDataPointer::operator != ( const CegoDataPointer& d) const
{
    if (_idArray[0] != d._idArray[0] || _idArray[1] != d._idArray[1] || _idArray[2] != d._idArray[2])
    // if (_fileId != d._fileId || _pageId != d._pageId || _offset != d._offset)
	return true;
    return false;
}

Chain CegoDataPointer::toChain() const
{
    Chain s;
    s = "[" + Chain(getFileId()) + "," + Chain(getPageId()) + "," + Chain(getOffset()) + "]";
    return s;
}

ostream& operator << (ostream& s, const CegoDataPointer& dp)
{
    s << "[" << dp.getFileId() << "," << dp.getPageId() << "," << dp.getOffset() << "]";
    return s;
}
