#ifndef _CEGODATAPOINTER_H_INCLUDED_
#define _CEGODATAPOINTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.h
// -----------------
// Cego Data pointer class definition
//        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDataPointer
// 
// Description: The CegoDataPointer class represents the location of a single 
//              row object inside a content object. The class provides also
//              encoding and decoding methods to store the pointer information
//              into the database. 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////


#include <lfcbase/Chain.h>

class CegoDataPointer {

 public:
   
    CegoDataPointer();
    CegoDataPointer(int fileId, int pageId, int offset);
    ~CegoDataPointer();

    int getFileId() const;
    void setFileId(int fileId);

    int getPageId() const;
    void setPageId(int pageId);

    int getOffset() const;
    void setOffset(int offset);

    int getEncodingLength() const;

    void encode(void* p) const;
    void decode(void* p);

    CegoDataPointer& operator = ( const CegoDataPointer& d);
    bool operator == ( const CegoDataPointer& d) const;
    bool operator != ( const CegoDataPointer& d) const;

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoDataPointer& dp);

 private:

    int _idArray[3];

    /*
    int _fileId;
    int _pageId;
    int _offset;
    */
};

#endif




