#ifndef _CEGODBTHREAD_H_INCLUDED_
#define _CEGODBTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDbThread.h  
// --------------
// Cego db thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDbThread
// 
// Description: This class implements a single thread instance used for a cego db session
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>
#include <lfcbase/NanoTimer.h>

#include "CegoDistDbHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoDistManager.h"
#include "CegoAction.h"

class CegoDbThreadPool;

class CegoDbThread : public Thread {
    
 public:

    CegoDbThread();
    CegoDbThread(CegoDbThreadPool *pPool, CegoDatabaseManager *pDBMng, CegoDbHandler::ProtocolType protType);
    ~CegoDbThread();

    const Chain& lastAction() const;
    long allocatedSortArea() const;
    void* job(void* arg);

    bool isTerminated();

    void abortSession();

    void loadObjects(int tabSetId);
    void unloadObjects(int tabSetId);
    void invalidateObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);
    // void loadObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);

    void addReloadRequest(int tabSetId);
    void checkReloadRequest();

    int getErrorCode() const;

 private:

    long _idx;

    CegoDbHandler::ProtocolType _protType;

    void serveSession(CegoDistDbHandler *pSH);
    bool serveRequest(CegoDistDbHandler *pSH, CegoDbHandler::RequestType reqType);

    CegoDbThreadPool* _pPool;
    CegoDatabaseManager* _pDBMng;
    
    CegoDistManager* _pTabMng;
    CegoAction* _pPA;

    NetHandler* _pRequest;

    Chain _lastAction;

    ListT<int> _loadList;

    int _errorCode;

    NanoTimer* _pTim;

    unsigned long _modId;

};

#endif














