#ifndef _CEGODBTHREADPOOL_H_INCLUDED_
#define _CEGODBTHREADPOOL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDbThreadPool.h  
// ------------------
// Cego db threadpool class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDbThreadPool
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

#include "CegoDbThread.h"
#include "CegoBufferPool.h"
#include "CegoLockHandler.h"
#include "CegoDbHandler.h"

class CegoDbThread;

class CegoDbThreadPool : public Thread {
    
 public:

    enum ThreadState { STARTING, READY, CONNECTED, BUSY };
  
    CegoDbThreadPool();
    CegoDbThreadPool(int poolLimit, CegoDatabaseManager *pDBMng, CegoDbHandler::ProtocolType protType);
    ~CegoDbThreadPool();

    void* job(void* arg);

    void syncToReady();

    void loadObjects(int tabSetId);
    void unloadObjects(int tabSetId);
    void invalidateObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);
    // void loadObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);

    int getPoolLimit() const;

    void getThreadInfo(long i, long& numRequest, long& numQueryRequest, long& threadLoad, long& allocatedSort, ThreadState& state, Chain& action);
    void setState(long t, ThreadState state);
    void incNumRequest(long i);
    void incNumQueryRequest(long i);

    void addThreadIdle(long i, long usec);

    void setTid(long i, long tid);
    void setThreadState(long i, CegoDbThreadPool::ThreadState state);
    void abortThread(long i);

    NetHandler* nextRequest();

    bool isTerminated();

    void getLockStat(Chain& lockName, long& lockCount, long &numRdLock, long &numWrLock, long &sumRdDelay, long &sumWrDelay);

    void P(int i);
    void V(int i);

 private:

    void lockQueue();
    void unlockQueue();

    long* _threadId;
    ThreadState* _threadState;
    long* _numRequest;
    long* _numQueryRequest;
    long* _threadIdle[THRMNG_NUMLOADSAMPLE];
    long* _threadLoad;
    int _samplePos;
    CegoDbThread** _threadList;


    int _poolLimit;
    int _dataPortNo;
    Chain _dataHostName;

    bool _terminated;
    bool _joined;

    ListT<NetHandler*> _requestQueue;

    CegoDatabaseManager* _pDBMng;
    CegoDbHandler::ProtocolType _protType;

    unsigned long _modId;
};

#endif
