#ifndef _CEGODECODABLEOBJECT_H_INCLUDED_
#define _CEGODECODABLEOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDecodableObject.h
// ---------------------
// Cego decodable object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDecodableObject
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////


#include <lfcbase/Chain.h>

#include <lfcxml/Element.h>

#include "CegoField.h"
#include "CegoObject.h"

class CegoDecodableObject : public CegoObject {

public:
        
    CegoDecodableObject();
    CegoDecodableObject(const CegoDecodableObject& co);
    CegoDecodableObject(CegoObject::ObjectType type, const Chain& objName, int tabSetId);
    virtual ~CegoDecodableObject();

    virtual int getEntrySize() const = 0;
    virtual void encode(char *buf) = 0;
    virtual void decode(char *buf) = 0;

    virtual Element* getElement() const = 0;
    virtual void putElement(Element *pElement) = 0;
    virtual Chain getFormatted() const = 0;

    Chain getTableSet() const { return _tableSet; } 
    void setTableSet(const Chain& tableSet ) { _tableSet = tableSet; } 
    bool isLocal() { return _isLocal; }
    void setLocal(bool il) { _isLocal = il; }

    CegoDecodableObject& operator = ( const CegoDecodableObject& deo);
    bool operator == ( const CegoDecodableObject& deo);
    
private:

    Chain _tableSet;
    bool _isLocal;

};

#endif
