#ifndef _CEGODISTCURSOR_H_INCLUDED_
#define _CEGODISTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDistCursor.h
// ----------------
// Cego distributed table cursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDistCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

#include "CegoTableCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoDistDbHandler.h"

class CegoDistManager;

class CegoDistCursor  {
    
public:
    
    CegoDistCursor();
    CegoDistCursor(CegoDistManager* pGTM, CegoContentObject *pCO); 
    ~CegoDistCursor();

    void checkType();
    void distSetup();
    void distSetup(const CegoAttrCond& attrCond);

    bool nextTuple(ListT<CegoField>& fl);
    bool nextTuple(ListT<CegoField>* flArray, int pos, int size);

    void reset();

    Element* getPlan();

 private:


    void sysSetup();
    void joinSetup(const CegoAttrCond& attrCond);
    bool evalCondition(ListT<CegoField>* flArray, int pos, int size);
    bool getTuple(ListT<CegoField>* flArray, int offset, int size);

    CegoDistManager* _pGTM;

    Chain _tableName;
    Chain _tableAlias;

    int _tabSetId;

    CegoSelect *_pSelect;
    CegoTableCursor* _pTC;
    CegoObjectCursor* _pC;

    CegoDistCursor* _pTCLeft;
    CegoDistCursor* _pTCRight;

    CegoContentObject *_pCO;
    CegoDatabaseManager *_pDBMng;
    CegoDistDbHandler* _pSH; 

    ListT<CegoField> _schema;

    unsigned long _modId;

    bool _isLocal;
    bool _moreTuple;
    bool _isFirst;
    bool _evalPredicate;
    bool _isAttrCondValid;
    bool _doEval;
    bool _moreLeft;
    bool _moreRight;

    CegoAttrCond _cursorCond;
    CegoAttrCond _innerCond;

    CegoAttrCond::IndexMatch _idxMatch;

    ListT<Chain> _sysObjList;

    
};

#endif
