#ifndef _CEGODISTDBHANDLER_H_INCLUDED_
#define _CEGODISTDBHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDistDbHandler.h
// ---------------------
// Cego distributed db handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2012 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoDistDbHandler
// 
// Description: The CegoDistDbHandler implements the XML based protocol for db client network access. 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/NetHandler.h>

#include <lfcxml/XMLSuite.h>

#include "CegoAlterDesc.h"
#include "CegoDbHandler.h"
#include "CegoPredDesc.h"
#include "CegoObject.h"
#include "CegoTableObject.h"
#include "CegoKeyObject.h"
#include "CegoCheckObject.h"
#include "CegoProcVar.h"

class CegoDistDbHandler : public CegoDbHandler {
    
public:
   

    CegoDistDbHandler(NetHandler *pN, ProtocolType pt, CegoModule *pModule);
    ~CegoDistDbHandler();

    ResultType reqInsertOp(const Chain& tableSet, const Chain& tableName, const ListT<CegoField>& fl);    

    ResultType reqUpdateOp(const Chain& tableSet, 
			   const Chain& tableName,
			   const ListT<CegoField>& updSchema, 
			   const ListT<CegoExpr*>& exprList,
			   CegoPredDesc* pPred);

    ResultType reqDeleteOp(const Chain& tableSet, const Chain& tableName, CegoPredDesc* pPred);
    ResultType reqCreateTableOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& fl, const ListT<CegoField>& idxList);


    ResultType reqAlterTableOp(const Chain& tableSet, const Chain& tableName, const ListT<CegoAlterDesc>& alterList);
    
    ResultType reqCreateIndexOp(const Chain& tableSet, const Chain& indexName, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& idxList);
    ResultType reqCreateFKeyOp(int tabSetId, const Chain& fkey, const Chain& tableName, const ListT<CegoField>& keyList, const Chain& refTable, const ListT<CegoField>& refList);

    ResultType reqDropObjectOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type);

    ResultType reqObjectInfoOp(int tabSetId, const Chain& objName, CegoObject::ObjectType type);

    ResultType reqCreateViewOp(const Chain& tableSet, const Chain& viewName, const ListT<CegoField>& fl, const Chain& viewText);
    ResultType reqCreateProcOp(const Chain& tableSet, const Chain& procName, const Chain& procText);

    ResultType reqTableDataOp(int tabSetId, const Chain& tableName, CegoObject::ObjectType type);

    ResultType reqGetObjectListOp(int tabSetId, CegoObject::ObjectType type);
    ResultType reqGetObjectByTableListOp(const Chain& tableSet, const Chain& tableName); 

    ResultType reqRenameOp(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type, const Chain& newObjName);
    ResultType reqSyncOp(const Chain& tableSet, const Chain& escCmd, int timeout);

    ResultType reqGetPageCount(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type);    

    ResultType reqReorgObjectOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type);


    ResultType reqCreateCheckOp(const Chain& tableSet, const Chain& checkName, const Chain& tableName, CegoPredDesc* pPred);

    ResultType reqStartTransactionOp(const Chain& tableSet);
    ResultType reqCommitTransactionOp(const Chain& tableSet);
    ResultType reqRollbackTransactionOp(const Chain& tableSet);
    ResultType reqGetTidOp(const Chain& tableSet);

    void getArgValue(const Chain& arg, Chain& value);

    void getInsertArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl);
    void getUpdateArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl, ListT<CegoExpr*>& exprList, CegoPredDesc*& pPred, CegoDistManager* pGTM);
    void getDeleteArg(Chain& tableSet, Chain& tableName, CegoPredDesc*& pPred, CegoDistManager* pGTM);
    void getCreateTableArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl, ListT<CegoField>& idxList);

    void getCreateViewArg(Chain& tableSet, Chain& viewName, ListT<CegoField>& fl, Chain& viewText);
    void getCreateProcedureArg(Chain& tableSet, Chain& procName, Chain& procText);
    void getCreateCheckArg(Chain& tableSet, Chain& checkName, Chain& tableName, CegoPredDesc*& pPred, CegoDistManager* pGTM);

    void getAlterTableArg(Chain& tableSet, Chain& tableName, ListT<CegoAlterDesc>& alterList);

    void getDropTableArg(Chain& tableSet, Chain& tableName, CegoObject::ObjectType& type);
    void getCreateIndexArg(Chain& tableSet, Chain& indexName, Chain& tableName, ListT<CegoField>& idxList, CegoObject::ObjectType& type);
    void getObjectInfoArg(int& tabSetId, Chain& objName, CegoObject::ObjectType& type);
    void getGetTableArg(int& tabSetId, Chain& tableName, CegoObject::ObjectType& type);

    void getRenameArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type, Chain& newObjName);

    void getReorgArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type);

    void getGetObjectListArg(int& tabSetId, CegoObject::ObjectType& type);

    void getGetObjectByTableListArg(Chain& tableSet, Chain& tableName);
    void getSyncArg(Chain& tableSet, Chain& escCmd, int& timeout);

    void getDropTableArg(Chain& tableName);
    void getPageCountArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type);

    void sendPageCount(int pageCount);
    void sendTID(int tid);
    void sendObjList(const ListT<Chain>& objList);
    void sendObjByTableList(const ListT<CegoTableObject>& idxList, const ListT<CegoKeyObject>& keyList, const ListT<CegoCheckObject>& checkList);

    void getObjectList(ListT<Chain>& objList);
    void getObjectByTableList(ListT<CegoTableObject>& idxList, ListT<CegoKeyObject>& keyList, ListT<CegoCheckObject>& checkList);
    void getPageCount(int& pageCount);    


private:

    unsigned long _modId;
};



#endif




