#ifndef _CEGOEXPR_H_INCLUDED_
#define _CEGOEXPR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoExpr.h
// ----------
// Cego expression class definition
//
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoExpr
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "CegoTerm.h"
#include "CegoProcStmt.h"

class CegoDistManager;

class CegoExpr {

 public:

    enum ExpType { ADD, SUB, TERM, CONCAT  };

    CegoExpr();
    CegoExpr(char* buf, CegoDistManager *pGTM);
    CegoExpr(Element* pExpElement, CegoDistManager *pGTM);
    CegoExpr(CegoExpr *pExpr, CegoTerm *pTerm, ExpType expType);
    CegoExpr(CegoTerm *pTerm);

    ~CegoExpr();

    void setAlias(const Chain& alias);
    const Chain& getAlias() const;

    bool getTableDesc(CegoTableDesc& td) const;

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    void setBlock(CegoProcBlock *pBlock);
    void setFieldListArray(ListT<CegoField> *fla, int size);

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    ListT<CegoField> getFieldList() const;
    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    void clearAttrCache();

    void getSelectQueryList(ListT<CegoSelect*>& queryList);

    ExpType getType() const;
    CegoTerm *getTerm() const;
    CegoExpr *getExpr() const;
   
    ListT<CegoAggregation*> getAggregationList();

    CegoExpr* clone(bool isAttrRef = false);

    CegoExpr& operator = ( const CegoExpr& e);

    Chain toChain(const Chain& indent = Chain("")) const;
    Element* toElement() const;
    void fromElement(Element *pExpElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoExpr& e);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

 private:

    ExpType _expType;

    Chain _alias;
    CegoExpr *_pExpr;
    CegoTerm *_pTerm;

};

#endif
