#ifndef _CEGOFACTOR_H_INCLUDED_
#define _CEGOFACTOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFactor.h
// ------------
// Cego factor structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoFactor
// 
// Description: Container class to describe a factor element 
//
// Status: QS-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

// cego includes
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoProcFetch.h"
#include "CegoFunction.h"
#include "CegoAggregation.h"
#include "CegoTableDesc.h"

class CegoDistManager;
class CegoExpr;
class CegoSelect;
class CegoCaseCond;

class CegoFactor {
    
 public:
    
    enum FacType { CONSTVAL, VAR, EXPR, FETCH, ATTR, FUNCTION, QUERY, AGGREGATION, CASECOND };

    CegoFactor(char* buf, CegoDistManager *pGTM);
    CegoFactor(Element* pFactorElement, CegoDistManager *pGTM);

    CegoFactor(const CegoFactor& pf);
    CegoFactor(const Chain& varName);
    CegoFactor(const CegoFieldValue& fv);
    CegoFactor(CegoAttrDesc* pAttrDesc, bool isAttrRef = false);
    CegoFactor(CegoExpr* pExpr);
    CegoFactor(CegoProcFetch* pFetch);
    CegoFactor(CegoFunction* pFunction);
    CegoFactor(CegoAggregation* pAggr);
    CegoFactor(CegoSelect* pSelect);
    CegoFactor(CegoCaseCond* pCaseCond);

    ~CegoFactor();

    void setFieldListArray(ListT<CegoField> *fla, int size);

    void setBlock(CegoProcBlock *pBlock);

    void clearAttrCache();

    bool getTableDesc(CegoTableDesc& td) const;

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    CegoAttrDesc* getAttr() const;
    CegoFunction* getFunction() const;
    CegoAggregation* getAggregation() const;
    CegoSelect* getSelect() const;
    CegoCaseCond* getCaseCond() const;

    ListT<CegoField> getFieldList() const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    CegoField evalField() const;
    CegoFieldValue evalFieldValue();

    const Chain& getVarName() const;
    const CegoFieldValue& getFieldValue() const;

    const FacType getType() const;
    CegoExpr* getExpr() const;

    CegoFactor* clone(bool isAttrRef = false);

    CegoFactor& operator = ( const CegoFactor& pf);

    Chain toChain() const;
    Element* toElement() const;
    void fromElement(Element *pFactorElement, CegoDistManager* pGTM);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager* pGTM);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

    friend ostream& operator << (ostream& s, const CegoFactor& pf);
      
 private:
    
    CegoFieldValue _fv;
    FacType _type;
    CegoAttrDesc* _pAttrDesc;
    bool _isAttrRef;
    Chain _varName;
    CegoExpr* _pExpr;
    CegoProcFetch *_pFetch;
    CegoFunction* _pFunction;
    CegoAggregation* _pAggr;
    CegoSelect* _pSelect;
    CegoCaseCond* _pCaseCond;


    ListT<CegoField>* _fla;
    int _flaSize;

    int _flaCacheArrayPos;
    int _flaCacheFieldPos;
    bool _flaCached;

    CegoProcBlock* _pBlock;
};

#endif




