#ifndef _CEGOFIELD_H_INCLUDED_
#define _CEGOFIELD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoField.h
// -----------
// Cego data Field class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//         
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoField
// 
// Description: Cego data field definition
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

// cego includes
#include "CegoDataType.h"
#include "CegoFieldValue.h"

class CegoField {
    
 public:

    CegoField();
    CegoField(const CegoField& f);
    CegoField(const Chain& tableName, const Chain& attrName);

    CegoField(const Chain& tableName, const Chain& tableAlias, const Chain& attrName, CegoDataType type, int len, const CegoFieldValue& defVal = CegoFieldValue(), bool isNullable = false, int id = 0);

    CegoField(const CegoFieldValue& fv);

    ~CegoField();

    void setNullable(bool isNullable);
    bool isNullable() const;

    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    void setTableAlias(const Chain& tableAlias);
    const Chain& getTableAlias() const;

    void setId(int id);
    int getId() const;

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    const CegoDataType getType() const;
    void setType(const CegoDataType t);

    int getLength() const;
    void setLength(int l);
    
    CegoFieldValue& getValue();
    void setValue(const CegoFieldValue& fv);
    
    CegoField& operator = ( const CegoField& f);
    bool operator == ( const CegoField& f);

    Chain typeToChain() const;

    Element* toElement() const;
    void fromElement(Element *pFieldElement);
    
 private:
    
    Chain _tableName;
    Chain _tableAlias;
    Chain _attrName;
    int _id;    
    CegoFieldValue _fv;
    bool _isNullable;
    
    CegoDataType _type;
    int _len;

};

#endif




