#ifndef _CEGOFIELDVALUE_H_INCLUDED_
#define _CEGOFIELDVALUE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFieldValue.h
// ----------------
// Cego field Value class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoFieldValue
// 
// Description: data field value description
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

#include "CegoDataType.h"

class CegoFieldValue {
    
 public:

    enum Comparison { LESS, EQUAL, MORE };

    CegoFieldValue();
    CegoFieldValue(const CegoFieldValue& fv);
    CegoFieldValue(CegoDataType type, void* pValue, int len, bool isLocalCopy = false);
    CegoFieldValue(CegoDataType type, const Chain& v);

    ~CegoFieldValue();

    const CegoDataType getType() const;
    void setType(const CegoDataType t);

    void* getValue() const;
    int getLength() const;

    bool castTo(CegoDataType t);

    void setValue(void* pV);
    void setLength(int l);

    CegoFieldValue& operator = ( const CegoFieldValue& f);
    bool operator == ( const CegoFieldValue& f) const;
    bool operator != ( const CegoFieldValue& f) const;
    bool operator < ( const CegoFieldValue& fv) const;
    bool operator > ( const CegoFieldValue& fv) const;
    bool operator <= ( const CegoFieldValue& fv) const;
    bool operator >= ( const CegoFieldValue& fv) const;

    Comparison comp(const CegoFieldValue& fv) const;

    friend CegoFieldValue operator + ( const CegoFieldValue& fv1, const CegoFieldValue& fv2);
    friend CegoFieldValue operator - ( const CegoFieldValue& fv1, const CegoFieldValue& fv2);
    friend CegoFieldValue operator * ( const CegoFieldValue& fv1, const CegoFieldValue& fv2);
    friend CegoFieldValue operator / ( const CegoFieldValue& fv1, const CegoFieldValue& fv2);
    friend CegoFieldValue operator | ( const CegoFieldValue& fv1, const CegoFieldValue& fv2);

    void setLocalCopy(bool isLocal);
    bool isLocalCopy() const;

    void getLocalCopy(const CegoFieldValue& f);

    bool isNull() const;

    friend ostream& operator << (ostream& s, const CegoFieldValue& f);

    void encode(char *buf);
    void decode(char *buf);
    int getEncodingLength() const;

    Chain toChain() const;
    Chain typeToChain() const;
    Chain valAsChain(bool doEval = true) const;

    long asLong() const;

 private:

    bool isEqual( const CegoFieldValue& fv2 ) const;
    bool isLess( const CegoFieldValue& fv2 ) const;
    bool isMore( const CegoFieldValue& fv2 ) const;
    bool isLessEqual( const CegoFieldValue& fv2 ) const;
    bool isMoreEqual( const CegoFieldValue& fv2 ) const;
    
    CegoFieldValue add( const CegoFieldValue& fv2 ) const;
    CegoFieldValue sub( const CegoFieldValue& fv2 ) const;
    CegoFieldValue mul( const CegoFieldValue& fv2 ) const;
    CegoFieldValue div( const CegoFieldValue& fv2 ) const;
    CegoFieldValue concat( const CegoFieldValue& fv2 ) const;
    CegoFieldValue negate() const;


    CegoDataType _type;
    void *_pV;
    int _len;
    bool _isLocalCopy;

};

#endif




