#ifndef _CEGOFILEHANDLER_H_INCLUDED_
#define _CEGOFILEHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFileHandler.h
// -----------------
// Cego file handler class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoFileHandler
// 
// Description: Cego database file access
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/Logger.h>

// cego includes
#include "CegoLockHandler.h"
#include "CegoDefs.h"
#include "CegoModule.h"

class CegoFileHandler : public CegoModule {
    
 public:
   
    enum FileType { DATAFILE, SYSTEMFILE, TEMP };

    CegoFileHandler(const Chain& logFile, int pageSize = 16384);
    ~CegoFileHandler();

    bool isBackup(int fileId);
    void setBackup(int fileId, bool m);
    bool isMarked(int fileId, int pageId);
        
    void cleanDataFile(int fileId, CegoLockHandler* pLockHandle);

    void initDataFile(int tabSetId, const Chain& path, int fileId, int numPages, FileType ft);
    void regDataFile(int tabSetId, const Chain& path, int fileId, CegoLockHandler* pLockHandle);

    void writePage(int fileId, int pageId, int fixStat, char* pageData, CegoLockHandler* pLockHandle);
    void readPage(int fileId, int pageId, int& tabSetId, int& fixStat, char* pageData, CegoLockHandler* pLockHandle);
    
    void claimPage(int fileId, int pageId, CegoLockHandler* pLockHandle);
    void allocatePage(int tabSetId, FileType ft, int& fileId, int& pageId, CegoLockHandler* pLockHandle, unsigned* &fbm, int& fbmSize, bool doAppend = false);
    void releasePage(int fileId, int pageId, CegoLockHandler* pLockHandle, unsigned* &fbm, int& fbmSize);

    void releaseFiles(int tabSetId);

    int getNumPages(int fileId);
    int getNumUsedPages(int fileId, CegoLockHandler* pLockHandle);

    int getFBMSize(int fileId);
    void readFBM(int fileId, unsigned *fbm, CegoLockHandler *pLockHandle);
    void writeFBM(int fileId, unsigned *fbm, CegoLockHandler *pLockHandle);

    void printBitMap(unsigned bm);

 protected:
    
    int _pageSize;

 private:

    void markPage(int fileId, int pageId);

    bool isClaimed(int fileId, int pageId, CegoLockHandler *pLockHandle);
    File* getHandle(int fileId);
    
    bool _isReg[FILMNG_MAXDATAFILE];
    int _tabSetId[FILMNG_MAXDATAFILE];
    int _fileType[FILMNG_MAXDATAFILE];
    int _numPages[FILMNG_MAXDATAFILE];

    File* _fhList[FILMNG_MAXDATAFILE];

    Chain _path[FILMNG_MAXDATAFILE];

    unsigned* _buMask[FILMNG_MAXDATAFILE];
    bool _fbmMask[FILMNG_MAXDATAFILE];

    int _appendPos[FILMNG_MAXDATAFILE];

    unsigned long _modId;
};

#endif
