#ifndef _CEGOFUNCTION_H_INCLUDED_
#define _CEGOFUNCTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFunction.h
// --------------
// Cego internal sql function class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoFunction
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "CegoAttrDesc.h"
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"

class CegoDistManager;
class CegoTableManager;

class CegoExpr;

class CegoFunction {
    
 public:
    
    enum FunctionType {  TRIM, 
			 RTRIM,
			 LTRIM,
			 ROUND,
			 DATE2STR, 
			 DATE2INT, 
			 INT2DATE, 
			 LEFT,
			 RIGHT,
			 GETPOS,
			 SUBSTR,
			 REPLACE,
			 LENGTH,
			 LOWER,
			 UPPER,
			 TRUNC,
			 STR2INT,
			 STR2LONG,
			 STR2DATE,
			 RANDSTR,
			 RANDINT,
			 MOD,
			 DIV,
			 POWER,
			 BITAND,
			 BITOR,
			 BITXOR,
			 NEXTCOUNT,
			 SETCOUNT,
			 USERDEFINED }; 

    CegoFunction(char* buf, CegoDistManager *pGTM);
    CegoFunction(FunctionType funcType);
    CegoFunction(FunctionType funcType, ListT<CegoExpr*>& exprList);

    CegoFunction(CegoDistManager* pTabMng, int tabSetId, CegoFunction::FunctionType type);
    CegoFunction(CegoDistManager* pTabMng, int tabSetId, const Chain& funcName, ListT<CegoExpr*>& exprList);
    
    CegoFunction(Element* pFunctionElement, CegoDistManager *pGTM);

    ~CegoFunction();

    ListT<CegoExpr*>& getExprList();
    ListT<CegoField> getFieldList() const;
    void setFieldListArray(ListT<CegoField> *fla, int size);
    void setBlock(CegoProcBlock *pBlock);

    const FunctionType getType() const;

    void setExprList(ListT<CegoExpr*>& exprList);

    void clearAttrCache();

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    void setCounterId(const Chain& counterId);
    void setCounterExpr(CegoExpr* pCounterExpr);
    
    CegoFieldValue evalFieldValue() const;
    Chain toChain(const Chain& indent = Chain("")) const;

    Element* toElement() const;
    void fromElement(Element *pFunctionElement, CegoDistManager *pGTM);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager* pGTM);
    int getEncodingLength() const;

    CegoFunction* clone(bool isAttrRef = false);

    CegoFunction& operator = ( const CegoFunction& f);

    friend ostream& operator << (ostream& s, const CegoFunction& f);
      
 private:

    CegoDistManager* _pTabMng;
    CegoProcBlock* _pBlock;
    Chain _funcName;

    Chain _counterId;
    
    FunctionType _type;
    ListT<CegoExpr*> _exprList;
    int _tabSetId;
};

#endif




