#ifndef _CEGOGROUPENTRY_H_INCLUDED_
#define _CEGOGROUPENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupEntry.h
// ----------------
// Cego group entry class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoGroupEntry
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoDataPointer.h"

class CegoGroupEntry {

 public:
    
    CegoGroupEntry();
    ~CegoGroupEntry();
    
    void initEntry(char* keyPtr, int keyLen, char *tupPtr, int tupLen, 
		   const CegoDataPointer& l,
		   const CegoDataPointer& r,
		   const CegoDataPointer& p);

    void* getKeyPtr();
    void* getTupPtr();

    void setKeyLen(int keyLen);
    int getKeyLen() const;

    void setTupLen(int keyLen);
    int getTupLen() const;

    void setPtr(char* p, int len);

    void* getPtr();
    int getLen() const;

    void setLeft(const CegoDataPointer& dp);
    CegoDataPointer getLeft() const;

    void setRight(const CegoDataPointer& dp);
    CegoDataPointer getRight() const;

    void setParent(const CegoDataPointer& dp);
    CegoDataPointer getParent() const;

    CegoGroupEntry& operator = (const CegoGroupEntry& oe);
    
 private:
    
    void* _pEntry;
    int _len;
    bool _isAllocated;

};

#endif
