///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupNode.cc
// -----------------
// Cego group node class implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2013 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoGroupNode
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>

// cego includes
#include "CegoGroupNode.h"

#include <string.h>
#include <stdlib.h>

CegoGroupNode::CegoGroupNode()
{
}

CegoGroupNode::CegoGroupNode(ListT<CegoField>& key)
{
    _key = key;
}

CegoGroupNode::CegoGroupNode(ListT<CegoField>& key, ListT<CegoField>& grouping)
{
    _key = key;
    _grouping = grouping;
}

CegoGroupNode::~CegoGroupNode()
{
}

ListT<CegoField>& CegoGroupNode::getKey()
{
    return _key;
}

ListT<CegoField>& CegoGroupNode::getGrouping()
{
    return _grouping;
}

void CegoGroupNode::setGrouping(ListT<CegoField>& grouping)
{
    _grouping = grouping;
}

CegoGroupNode& CegoGroupNode::operator = ( const CegoGroupNode& n)
{
    _key = n._key;
    _grouping = n._grouping;
    return (*this);
}

bool CegoGroupNode::operator == ( const CegoGroupNode& n)
{

    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {

	if ( pF1->getValue() < pF2->getValue() )
	{
	    return false;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return false;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();
	
    }

    return true;
}

bool CegoGroupNode::operator > ( const CegoGroupNode& n)
{    

    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {

	if ( pF1->getValue() < pF2->getValue() )
	{
	    return false;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return true;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();
	
    }

    return false;

}

bool CegoGroupNode::operator < ( const CegoGroupNode& n)
{

    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {

	if ( pF1->getValue() < pF2->getValue() )
	{
	    return true;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return false;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();
	
    }

    return false;
}







