#ifndef _CEGOGROUPNODE_H_INCLUDED_
#define _CEGOGROUPNODE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupNode.h
// ---------------
// Cego group node class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoGroupNode
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/ListT.h>

// cego includes
#include "CegoField.h"

class CegoGroupNode {

public:
    
    CegoGroupNode();
    CegoGroupNode(ListT<CegoField>& key);
    CegoGroupNode(ListT<CegoField>& key, ListT<CegoField>& grouping);
    ~CegoGroupNode();
    
    ListT<CegoField>& getKey();
    ListT<CegoField>& getGrouping();
    void setGrouping(ListT<CegoField>& grouping);

    CegoGroupNode& operator = ( const CegoGroupNode& n);    
    bool operator == ( const CegoGroupNode& n);
    bool operator < ( const CegoGroupNode& n);
    bool operator > ( const CegoGroupNode& n);
    

private:
    
    ListT<CegoField> _key;
    ListT<CegoField> _grouping;
    
};

#endif
