#ifndef _CEGOGROUPSPACE_H_INCLUDED_
#define _CEGOGROUPSPACE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupSpace.h
// -----------------
// Cego group space class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoGroupSpace
// 
// Description: Utility class for grouping tuples
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "CegoDefs.h"
#include "CegoAttrDesc.h"
#include "CegoTableManager.h"
#include "CegoGroupCursor.h"
#include "CegoGroupNode.h"

class CegoGroupSpace {
    
 public:

    CegoGroupSpace();
    ~CegoGroupSpace();
       
    void initGroupSpace(const ListT<CegoField>& schema, ListT<CegoAggregation*>& aggList, long maxGroupSize);

    void insertTuple(ListT<CegoField>& groupKey, ListT<CegoField>& groupTuple);

    void resetGroupSpace();

    ListT<CegoField> getSchema();

    CegoGroupCursor* getCursor();

    long numAllocated() const;

 private:

    ListT<CegoField> initGrouping(ListT<CegoField>& dataTuple);
    ListT<CegoField> aggGrouping(ListT<CegoField>& aggValues, ListT<CegoField>& dataTuple);

    CegoFieldValue getValueForAgg(CegoAggregation* pAgg, ListT<CegoField>& dataTuple);

    int _groupingOffset;

    ListT<CegoField> _groupSchema;

    CegoAggregation* _pCountAgg;

    ListT<CegoAggregation*> _aggList;
    ListT<CegoField> _aggSchema;

    AVLTreeT<CegoGroupNode>* _pAVL;

    long _maxOrderSize;
    long _orderSize;

};

#endif




