#ifndef _CEGOHAVINGDESC_H_INCLUDED_
#define _CEGOHAVINGDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoHavingDesc.h
// ----------------
// Cego having clause structure class definition
//          
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoHavingDesc
// 
// Description: The CegoHavingDesc class is a container class for the query having clause representation
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/Matcher.h>

// cego includes
#include "CegoComparison.h"
#include "CegoExpr.h"
#include "CegoField.h"

class CegoHavingDesc {
    
 public:

    CegoHavingDesc(char* buf, CegoDistManager *pGTM);
    CegoHavingDesc(Element* pHE, CegoDistManager *pGTM);
    
    CegoHavingDesc(CegoExpr* pAggExpr, CegoExpr* pExpr, const CegoComparison& comp);
    ~CegoHavingDesc();

    CegoExpr* getAggExpr();
    CegoExpr* getExpr();
    CegoComparison getComparison();

    ListT<CegoAttrDesc*> getAttrRefList() const;

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM);
    int getEncodingLength() const;
  
    Element* toElement() const;
    void fromElement(Element *pHavingElement, CegoDistManager *pGTM);
  
    Chain toChain(const Chain& indent = Chain("")) const;
    friend ostream& operator << (ostream& s, const CegoHavingDesc& p);

    CegoHavingDesc* clone(bool isAttrRef = false);

 private:

    CegoExpr* _pAggExpr;
    CegoExpr* _pExpr;
    CegoComparison _comp;
};

#endif




