#ifndef _CEGOKEYOBJECT_H_INCLUDED_
#define _CEGOKEYOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoKeyObject.h
// ---------------
// key object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoKeyObject
// 
// Description: Derived class from CegoObject to use as a container class for foreign key objects
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoObject.h"
#include "CegoDecodableObject.h"

class CegoKeyObject : public CegoDecodableObject {

 public:

    CegoKeyObject();

    CegoKeyObject(const CegoKeyObject& ko);

    CegoKeyObject(ObjectType type,
		  const Chain& objName,
		  int tabSetId = 0);

    CegoKeyObject(int tabSetId,
		  const Chain& fkey, 
		  const Chain& tabName, 
		  const ListT<CegoField>& schemaList,
		  const Chain& refTable,
		  const ListT<CegoField>& refList);	

    ~CegoKeyObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;
    
    void setKeySchema(const ListT<CegoField>& keySchema);   
    const ListT<CegoField>& getKeySchema() const;

    void setRefTable(const Chain& refTable);
    const Chain& getRefTable() const;
    
    void setRefSchema(const ListT<CegoField>& refSchema);   
    const ListT<CegoField>& getRefSchema() const;

    int getEntrySize() const;

    void encode(char *buf);
    void decode(char *buf);

    void setEmpty();
    
    CegoKeyObject& operator = ( const CegoKeyObject& oe);
    bool operator == ( const CegoKeyObject& oe);
    
    Chain toChain() const;

    Element* getElement() const;
    void putElement(Element* pElement);
    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;

    Chain _tabName;
    Chain _refTable;

    char _keyLen;
    char _refLen;

    ListT<CegoField> _keySchema;
    ListT<CegoField> _refSchema;    

};

#endif
