#ifndef _CEGOLOGHANDLER_H_INCLUDED_
#define _CEGOLOGHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogHandler.h
// ----------------
// Cego log handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoLogHandler
// 
// Description: Cego log handler
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/NetHandler.h>

// xml includes
#include <lfcxml/XMLSuite.h>

// cego includes
#include "CegoModule.h"

class CegoLogHandler {
    
public:
   
    enum RequestType { WRITE_LOG, 
		       SESSION_CLOSE,
		       UNKNOWN };

    CegoLogHandler(CegoModule *pModule, NetHandler *pN = 0);
    ~CegoLogHandler();

    void requestLogSession(const Chain& tableSet);
    bool acceptLogSession(Chain& tableSet);

    void closeSession();

    void setNetHandle(NetHandler *pN);

    //////////////////////////
    // admin client methods //
    //////////////////////////

    void getMsg(Chain& msg);

    /////////////////////////
    // server node methods //
    /////////////////////////

    void getTableSet(Chain& tableSet);

    bool sendLogEntry(char* logBuf, int len);
    bool receiveLogEntry(char* &logBuf,  int &len);

    void sendAck();
    void sendNack();

private:

    NetHandler *_pN;
    CegoModule *_pModule;
    XMLSuite _xml;

    unsigned long _modId;
};



#endif




