#ifndef _CEGOLOGMANAGER_H_INCLUDED_
#define _CEGOLOGMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogManager.h
// ----------------
// Cego database log manager class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoLogManager
// 
// Description: Cego database log management
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>

// cego includes
#include "CegoFileHandler.h"
#include "CegoLogHandler.h"
#include "CegoLogRecord.h"
#include "CegoXMLSpace.h"
#include "CegoDefs.h"

class CegoLogManager : public CegoFileHandler, public CegoXMLSpace {
    
public:
    
    enum LogResult { LOG_SUCCESS, LOG_FULL, LOG_ERROR };

    CegoLogManager(const Chain& xmlDef, const Chain& logFile);
    ~CegoLogManager();
    
    void initLog(int tabSetId, int size);
    void stopLog(int tabSetId);
    void startLog(int tabSetId);
    int getLogOffset(int tabSetId);
    void resetLog(int tabSetId);
    
    LogResult logAction(int tabSetId, CegoLogRecord& logRec);

    void allocateLogConnection(int tabSetId, const Chain& tableSet, const Chain& logHost, int logPort);
    bool hasLogConnection(int tabSetId);
    void releaseLogConnection(int tabSetId);
    void setLogFile(int tabSetId, const Chain& logFile, bool readOnly);

    long getMinLSN(int tabSetId);
    long getMaxLSN(int tabSetId);

    void seekToStart(int tabSetId);
    bool logSeek(int tabSetId, long lsn);
    bool logRead(int tabSetId, CegoLogRecord& logRec);

    void setLSN(int tabSetId, long lsn);
    long getLSN(int tabSetId);

    Chain getArchiveLogName(const Chain& tableSet, long lsn);

    bool switchLogFile(int tabSetId);
    void setActiveLogFile(const Chain& tableSet);
    
private:
    
    int getLFID();
    void switchLFID();

    File *_pLog[TABMNG_MAXTABSET];
    File *_pLFID[TABMNG_MAXTABSET];

    Chain _logFile[TABMNG_MAXTABSET];
    int _logSize[TABMNG_MAXTABSET];
    int _logOffset[TABMNG_MAXTABSET];
    
    int _numGroup[TABMNG_MAXTABSET];
	
    long _lsn[TABMNG_MAXTABSET];
    int _logPos[TABMNG_MAXTABSET];

    bool _logActive[TABMNG_MAXTABSET];

    CegoLogHandler* _pLogHandler[TABMNG_MAXTABSET];
    NetHandler* _pNetHandler[TABMNG_MAXTABSET];

    unsigned long _modId;
};

#endif




