#ifndef _CEGOLOGRECORD_H_INCLUDED_
#define _CEGOLOGRECORD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogRecord.h
// ---------------
// Cego Log Record structure definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoLogRecord
// 
// Description: log record data structure
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoObject.h"

class CegoLogRecord {

 public:
    
    enum LogAction { LOGREC_CREATE, 
		     LOGREC_DROP, 
		     LOGREC_ALTER, 
		     LOGREC_RENAME, 
		     LOGREC_INSERT,
		     LOGREC_DELETE,
		     LOGREC_DELETE_COMMIT,
		     LOGREC_UPDATE, 
		     LOGREC_UPDATE_COMMIT, 
		     LOGREC_BEGIN, 
		     LOGREC_COMMIT, 
		     LOGREC_ABORT, 
		     LOGREC_SYNC, 
		     LOGREC_BUPAGE,
		     LOGREC_BUFBM, 
		     LOGREC_BUFIN,
		     LOGREC_ADDCOUNTER,
		     LOGREC_DELCOUNTER };

    CegoLogRecord();
    ~CegoLogRecord();

    // log sequence number
    long getLSN() const;
    void setLSN(long lsn);

    // log timestamp
    int getTS() const;
    void setTS(int ts);

    // tid
    int getTID() const;
    void setTID(int tid);

    void setObjectInfo(const Chain& objName, CegoObject::ObjectType type);

    const Chain& getObjName() const;
    CegoObject::ObjectType getObjType() const;

    LogAction getAction() const;
    void setAction(LogAction a);

    char* getData() const;
    void setData(char* data);

    int getDataLen() const;
    void setDataLen(int l);

    int getFileId() const;
    void setFileId(int fileId);
    int getPageId() const;
    void setPageId(int pageId);
    
    int getEncodingLength() const;

    void encode(void* p) const;
    void decode(void* p);
    void decodeLSN(void* p);
    void decodeLogAction(void* p);

    void clean();

    CegoLogRecord& operator = ( const CegoLogRecord& d);
    
    friend ostream& operator << (ostream& s, const CegoLogRecord& logRecord);

    Chain toChain() const;

 private:
    
    long _lsn;
    int _tid;
    Chain _objName;
    CegoObject::ObjectType _objType;

    enum LogAction _logAction;
    int _dataLen;
    char* _data;
    bool _encObj;

    // for page logging 
    int _fileId;
    int _pageId;

    int _ts;
};

#endif
